<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Organization extends CI_Controller {

	function __construct()
    {
          parent::__construct();
          $this->load->database();
          $this->load->model('organization_model');
          $this->load->model('trips_model');
          $this->load->model('vehicle_model');
          $this->load->helper(array('form', 'url','string'));
          $this->load->library('form_validation');
          $this->load->library('session');
          $this->load->model('comman_model'); 
    }

	public function index()
	{  
		
		$data['organizationlist'] = $this->organization_model->getall_organization();
		$this->template->template_render('organization_management',$data);
	}
	public function addorganization()
	{
		$data['country'] = $this->organization_model->fetch_country();
		$this->template->template_render('organization_add',$data);
	}
	public function insertorganization()
	{
		
		$testxss = xssclean($_POST);
		if($testxss){
			$exist = $this->db->select('*')->from('organization')->where('org_code',$this->input->post('org_code'))->get()->result_array();
			if(count($exist)==0){
				$response = $this ->organization_model->add_organization($this->input->post());
				$org_name=$this->input->post('org_name');
				$org_name_code = substr($org_name, 0, 3);
				if($response){					
					//switch statement
					$response_len = strlen($response);
					switch ($response_len){
							case "1":
							$org_code=strtoupper($org_name_code).'-'."0000".$response;
						// echo "Your favorite color is red!";
							break;
							case "2":
							$org_code=strtoupper($org_name_code).'-'."000".$response;
							break;
							case "3":
							$org_code=strtoupper($org_name_code).'-'."00".$response;
							break;
							case "4":
							$org_code=strtoupper($org_name_code).'-'."0".$response;
							break;
							default:
							$org_code=strtoupper($org_name_code).'-'."".$response;
						}
						$where=array("org_id"=>$response);
						$data=array("org_code"=>$org_code);
						$update_response = $this->comman_model->update("organization",$where,$data);
						if($update_response){
							if (!is_dir('assets/uploads/'.$org_code)) {
								mkdir('./assets/uploads/' . $org_code, 0777, TRUE);

							}
						}
					
					$this->session->set_flashdata('successmessage', 'New Organization added successfully..');
				} else {
					$this->session->set_flashdata('warningmessage', 'Something went wrong.');
				}
			} else {
				$this->session->set_flashdata('warningmessage', 'Account already exist with same Organization Code.');
			}
			redirect('Organization');
		}else{
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('Organization');
		}
	}
	public function editorganization()
	{
		$org_id = $this->uri->segment(3);
		$data['organizationdetails'] = $this->organization_model->get_organization($org_id);
		$data['country'] = $this->organization_model->fetch_country();
		$data['state'] = $this->organization_model->fetch_states($org_id);
		$data['city'] = $this->organization_model->fetch_citys($org_id);
		$this->template->template_render('organization_add',$data);
	}

	public function updateorganization()
	{
		$testxss = xssclean($_POST);
		if($testxss){
			$response = $this->organization_model->update_organization($this->input->post());
				if($response) {
					$this->session->set_flashdata('successmessage', 'Organization updated successfully..');
				    redirect('organization');
				} else
				{
					$this->session->set_flashdata('warningmessage', 'Something went wrong..Try again');
				    redirect('organization');
				}
		} else {
			$this->session->set_flashdata('warningmessage', 'Error! Your input are not allowed.Please try again');
			redirect('organization');
		}
	}
	public function vieworganization()
	{ 
		$org_id = $this->uri->segment(3);
		$data['organizationdetails'] = $this->organization_model->get_organization($org_id);   
		$this->template->template_render('organization_view',$data);
		
	}
	public function organizations(){
		if (isset($this->session->userdata['session_data'])) {
            $url = base_url() . "dashboard";
            header("location: $url");
        } else {
            $this->load->view('organizations_login');
        }
	}
	public function fetch_state(){
	  if($this->input->post('country_id'))
	  {
	   echo $this->organization_model->fetch_state($this->input->post('country_id'));
	  }

	}

	public function fetch_city(){
	  if($this->input->post('state_id'))
	  {
	   echo $this->organization_model->fetch_city($this->input->post('state_id'));
	  }	  
	}

	public function report_organization()
		{
		if(isset($_POST['org_report'])) {
			
			$triplist = $this->trips_model->organization_reports($this->input->post('booking_from'),$this->input->post('booking_to'),$this->input->post('d_id'));
			
			if(empty($triplist)) {
				$this->session->set_flashdata('warningmessage', 'No organization found..');
				$data['triplist'] = '';
			} else {
				unset($_SESSION['warningmessage']);
				$data['triplist'] = $triplist;
			}
		}
		 
		$data['organizationlist'] = $this->vehicle_model->getall_organizations();
		$this->template->template_render('organization_reports',$data);
	}
}
