<?php 
	defined('BASEPATH') OR exit('No direct script access allowed');
	
	/*
		this is comman model for comman queries
		date:9/07-2020
		
	*/
	class Comman_model extends CI_Model {
		
		
		function __construct()
		{
			// Construct the parent class
			parent::__construct();
			//exit(); 
		} 

        function insert_record($tbl, $data)
		{
			$data=$this->security->xss_clean($data,TRUE);
			$this->db->insert($tbl, $data);	
			return $this->db->insert_id(); 
		}
		function select($tbl = '') 
		{
			$this->db->from($tbl);
			$this->db->order_by("id", "DESC");
			$query = $this->db->get(); 
			return $query->result();
		}
        //comman get data
		public function get_data_where($table,$data){
			$this->db->select('*');
			$this->db->from($table);
			$this->db->where($data); 
			 $query = $this->db->get();
			if($query->num_rows() > 0) //counting result from query
			{
				return $query->result_array(); 
			}else{
				return false;
			}
		}
		//update
		public function update($tbl, $where, $data){
			$this->db->where($where);
			$this->db->update($tbl, $data);
			$affectedRows = $this->db->affected_rows();
			if ($affectedRows) {
				return true;
				} else {
				return $this->db->error();
			}
		}
		//get data by row array
		public function get_data_by_row($table,$data){			
			$this->db->select('*');
			$this->db->from($table);
			$this->db->where($data);
			$query = $this->db->get(); 
			if($query->num_rows() > 0) //counting result from query
			{
				return $query->row_array();	
			}
		}
		public function delete_row($tbl, $where){
			$this->db->where($where);
			return $this->db->delete($tbl);
		}
		public function fcm_notification($device_id,$title,$message){
			$API_SERVER_KEY = 'AAAA0N_4VAg:APA91bEsaIfwYbpHRwaTMUJNB2cDvtiz9G1BCw64IRKmBqLigYuig8niBa8UOyYRAx6jiId3Ue3YgdRkvrHYLoW5tdCK2XCy-OSrv2nkZbdLP-hb5Y9UDDYVyFiRvkENWtjOWHhKib8z';
			$path_to_firebase_cm = 'https://fcm.googleapis.com/fcm/send';
			$sound="MyCustomeSound.wav"; 
			$fields = array(
				"registration_ids" =>array($device_id),  
				"content_available"=> true,
				'notification' => array('title' => $title,'body' => $message,"sound"=>$sound,
				"click_action"=>"FCM_PLUGIN_ACTIVITY",
				"icon"=>"notification_icon.png") ,
				"priority" => "high",	 
				"android"=> array(
						"notification"=>array(
						"icon"=>"fcm_push_icon",
						"channel_id" =>'my_id',
						"sound"=>"MyCustomeSound.wav",
						"click_action"=> "FCM_PLUGIN_ACTIVITY"
						)
					)
				); 


			$headers = array(
				'Authorization:key=' .$API_SERVER_KEY,	
				'Content-Type:application/json'
			);

			// Open connection
			$ch = curl_init();
			// Set the url, number of POST vars, POST data
			curl_setopt($ch, CURLOPT_URL, $path_to_firebase_cm);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4 );
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
			// Execute post
			$result = curl_exec($ch);
			if ($result === FALSE) {
				die('FCM Send Error: ' . curl_error($ch));
			}
			curl_close($ch);
		}

		
    }
