<?php
namespace App\Controllers;
use CodeIgniter\Controller;
use Aws\S3\S3Client;


use App\Models\User_model;
use App\Models\Employee_model;
use App\Models\Admin_model;
use App\Models\ApiModel;
use App\Libraries\Hash;
use App\Libraries\excel;

class Admin extends Controller
{
	private $EmpModel;
	private $AdminModel;
	private $ApiModel;
	public function __construct(){
		$db = \Config\Database::connect();
		$session = \CodeIgniter\Config\Services::session();
		date_default_timezone_set("Asia/Calcutta");
		helper(['url','form','Form']);  
		$this->EmpModel=new Employee_model();
		$this->AdminModel=new Admin_model();
		$this->ApiModel=new ApiModel();
		$session = session();
		
	}
    public function index()
    {
		$data=[
			'page_title'=>'Dashboard',
			'page_name'=>'Dashboard',
			'title_active'=>'dashboard-management'
		 ];
			 $where_data=[
				 "Status"=>"Approved"
			 ];
			 $table="users";
			 $data['approved_count']=$this->AdminModel->tableRowsCount($table,$where_data);
			 $where_data=[
				"Status"=>"Pending"
			];
			$data['pending_count']=$this->AdminModel->tableRowsCount($table,$where_data);
			$where_data=[
				"Status"=>"Reject"
			];
			$data['reject_count']=$this->AdminModel->tableRowsCount($table,$where_data);
			$where_data=[
				"Status"=>"Banned"
			];
			$data['banned_count']=$this->AdminModel->tableRowsCount($table,$where_data);

			//compain list
			 $where_data=[
			 	"ActivityStatus"=>"Open"
			 ];
			 $data['Open_Compaign']=$this->AdminModel->tableRowsCount('activity',$where_data);

			 $where_data=[
				"ActivityStatus"=>"Close"
			];
			$data['Open_Compaign']=$this->AdminModel->tableRowsCount('activity',$where_data);

			$parameters=array('IssueTitle','IssueDescription');
			$order_by='CadreListeningId';
			$data['topIssues']=$this->AdminModel->getQueryFromTable('cadrelisteningdetails',$parameters,$order_by); 

			$data['activitydetails']=$this->AdminModel->programActivityGrid();
			return view('dashboard',$data); 

		
		// return view('demo',$data); 
    }
	//web users login
	public function login()
    {

        $data = [];
        if ($this->request->getMethod() == 'post') {
			$session = \CodeIgniter\Config\Services::session();					
			$password = $this->request->getVar('Password');
			$rules=[
				'Email'=>[
					'rules'=>'required',
					'label'=>' Email Address',
					'errors'=>[
						'required'=>'Email Address is Required field',
						'valid_email'=>'oh, man, really?? Pls, add a valid email'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
                return view('login', ["validation" => $this->validator]);
            }else{
                $Emp = $this->EmpModel->where('Email', $this->request->getVar('Email'))->first();
				if($Emp){
					$db_password = $Emp['Password'];
					$check_password=Hash::check($password,$db_password);
					if(!$check_password){
						$session->setFlashdata('error', 'Wrong Password');						
						return redirect()->route('login');
					}else{
						$this->setUserSession($Emp); 
						// Redirecting to dashboard after login
						return redirect()->to(base_url());
					}
				}else{
					$session->setFlashdata('error', 'Invalid Email Id');
					return redirect()->route('login');
				}
                // Stroing session values
            }
        }
        return view('login');
    }

    private function setUserSession($Emp)
    {
        $data = [
			'user_details'=>$Emp,
            'u_id' => $Emp['EmployeeId'],
            'u_name' => $Emp['FirstName'],
            'isLoggedIn' => true,
        ];
        session()->set($data);
        return true;
    }
	public function logout()
    { 
		$session = \CodeIgniter\Config\Services::session();		
		$session->setFlashdata('success', 'Successfully Logout');
        session()->destroy();
		return redirect()->route('login');
    }
	//progrma activity
	public Function ProgramActivity(){ 
		$data=[
			'page_title'=>'Program Activity',
			'page_name'=>'program_activity',
			'title_active'=>'program_activity'
		 ];
		$data['activitydetails']=$this->AdminModel->programActivityGrid(); 
		$activitydetails=$this->AdminModel->programActivityGrid(); 
		$i=0;
		 foreach($activitydetails as $row){
			$where_data=['CheckView'=>1,'ActivityId'=>$row['ActivityId']];  
			$activitydetails[$i]["Views_count"]=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

			$ActivityId=$row['ActivityId'];
			$where_data=['ActivityId'=>$ActivityId,'Activity_status'=>'Completed'];
			$activitydetails[$i]['CompletedCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

			$ActivityId=$row['ActivityId'];
			$where_data=['ActivityId'=>$ActivityId];
			$activitydetails[$i]['TotalCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);



			$i++;
		 }

		


		 $data['activitydetails']=$activitydetails;
		

		return view('program_activity_management',$data);
	}

	public function AddProgramActivity(){
		$session = session();
		$data=[
			'page_title'=>'Add Program Activity',
			'page_name'=>'add_program_activity',
			'title_active'=>'program_activity'
		 ];
		 $parameters=array('ActivityGroupId','GroupName');
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTable('activitygroup',$parameters,$order_by); 
		 if($this->request->getMethod() == 'post'){
			
			//print_r($this->request->getVar());
			$rules=[
				'ActivityName'=>[
					'rules'=>'required',
					'label'=>'Activity Name',
					'errors'=>[
						'required'=>'Activity Name is a required'
					]
				],
				'file'=>[
					'rules'=>'uploaded[file]|max_size[file,1024]',
					'label'=>'file'
				]

			];
			
			$validation=$this->validate($rules); 
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_program_activity',$data);
            }else{
				$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
				if($file->isValid() && !$file->hasMoved()){ 

					$file_name=$file->getRandomName();
					$file->move('uploads/program_activity_files',$file_name);  

					//s3 uplode code
					$file_Path = base_url()."/uploads/program_activity_files/". $file_name; 
					$this->s3Upload('program_activity_files',$file_Path); 
					$url="./uploads/program_activity_files/".$file_name;
					unlink($url);

				$array_c=$this->request->getVar('AssignedGroupsId',FILTER_SANITIZE_STRING);
				$AssignedGroupsId=implode(",",$array_c);				
				foreach($array_c as $row){
					$test[]=$this->AdminModel->getUsersByGroupdIds($row);
				}
				foreach($test as $row){
					foreach($row as $r){
						$user_id[]= $r['u_id'];
					}
				}
				$user_ids=array_unique($user_id);
				// end test here
				$table_data=[
						'ActivityName'=>$this->request->getVar('ActivityName',FILTER_SANITIZE_STRING),
						'ActivityType'=>$this->request->getVar('ActivityType',FILTER_SANITIZE_STRING),
						'Instructions'=>$this->request->getVar('Instructions',FILTER_SANITIZE_STRING),
						'Links'=>$this->request->getVar('Links',FILTER_SANITIZE_STRING),
						'ActivityStatus'=>$this->request->getVar('ActivityStatus',FILTER_SANITIZE_STRING),
						'TargetCompletionDate'=>$this->request->getVar('TargetCompletionDate',FILTER_SANITIZE_STRING),
						//'Points'=>$this->request->getVar('Points',FILTER_SANITIZE_STRING),
						//'ParticipatedCount'=>$this->request->getVar('ParticipatedCount',FILTER_SANITIZE_STRING),
						'AssignedGroupsId'=>$AssignedGroupsId,
						'UploadType'=>$this->request->getVar('UploadType',FILTER_SANITIZE_STRING),
						'UploadResource'=>$file_name,
						'MediaCoverage'=>$this->request->getVar('MediaCoverage',FILTER_SANITIZE_STRING),
						'BannerDisplayed'=>$this->request->getVar('BannerDisplayed',FILTER_SANITIZE_STRING),
						'ParliamentPresidentParticipated'=>$this->request->getVar('ParliamentPresidentParticipated',FILTER_SANITIZE_STRING),
						'MlaInchargeParticipation'=>$this->request->getVar('MlaInchargeParticipation',FILTER_SANITIZE_STRING),
						'ConstituencyLeadersParticipated'=>$this->request->getVar('ConstituencyLeadersParticipated',FILTER_SANITIZE_STRING),
						'WhatsappImagesVideos'=>$this->request->getVar('WhatsappImagesVideos',FILTER_SANITIZE_STRING),


						//'MediaCovarage'=>$this->request->getVar('MediaCovarage',FILTER_SANITIZE_STRING),
					//	'InMediaCovarage'=>$this->request->getVar('InMediaCovarage',FILTER_SANITIZE_STRING),
					//	'MaterialUsageFormat'=>$this->request->getVar('MaterialUsageFormat',FILTER_SANITIZE_STRING),
					//	'InMaterialUsageFormat'=>$this->request->getVar('InMaterialUsageFormat',FILTER_SANITIZE_STRING),
					//	'PublicResponse'=>$this->request->getVar('PublicResponse',FILTER_SANITIZE_STRING),
					//	'InPublicResponse'=>$this->request->getVar('InPublicResponse',FILTER_SANITIZE_STRING),
					//	'AnySpecialActivities'=>$this->request->getVar('AnySpecialActivities',FILTER_SANITIZE_STRING),
					//	'InAnySpecialActivities'=>$this->request->getVar('InAnySpecialActivities',FILTER_SANITIZE_STRING),
					//	'SocialMediaCoverage'=>$this->request->getVar('SocialMediaCoverage',FILTER_SANITIZE_STRING),
					//	'LeadORCommittee_Participation'=>$this->request->getVar('LeadORCommittee_Participation',FILTER_SANITIZE_STRING),
					//	'InLeadORComm_Participation'=>$this->request->getVar('InLeadORComm_Participation',FILTER_SANITIZE_STRING),
					//	'SocialListingFromGround'=>$this->request->getVar('SocialListingFromGround',FILTER_SANITIZE_STRING),
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s')

					];
					$ActivityId=$this->AdminModel->insert_record('activity',$table_data); 
				if($ActivityId === false){
					$data=[
						'page_title'=>'Add Program Activity',
						'page_name'=>'add_program_activity',
						'title_active'=>'program_activity'
					]; 
					$session->setFlashdata('error', 'Unable to Added Program Activity');
					return redirect()->route('Program-Campaign');
				}else{
					//insert into activitystatus table
					foreach($user_ids as $u_id){ 
						$table_data=[
							'ActivityId'=>$ActivityId,
							'UserId'=>$u_id,
							'Activity_status'=>'Open'
						];
						$activity_id=$this->AdminModel->insert_record('activitystatus',$table_data);  
					}
					$session->setFlashdata('success', 'Successfully Update Program Compaign');
					return redirect()->route('Program-Campaign');
				}
			}else{
				$session->setFlashdata('error', 'Unable to file upload file try again');
				return redirect()->route('Program-Campaign');
			}
		 	}
		 }
		return view('add_program_activity',$data);
	}
	public function programActivityEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'Edit Program Campaign',
			'page_name'=>'add_program_activity',
			'title_active'=>'program_activity'
		 ];
		$parameters=array('ActivityGroupId','GroupName');
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTable('activitygroup',$parameters,$order_by); 
		$table="activity";
		$where_id=$id;
		$where_parameter="ActivityId";
		$data['activitydetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);		
		$data['file_path']=$this->s3GetObjects('program_activity_files',$data['activitydetails']['UploadResource']); 
		if(isset($data['activitydetails'])){
			return view('add_program_activity',$data);
		}else{
			return redirect()->route('Program-Campaign');
		}
		
	}
	public function UpdateProgramActivity(){ 
		$session = \CodeIgniter\Config\Services::session();
		if($this->request->getMethod() == 'post'){
			$rules=[
				'ActivityName'=>[
					'rules'=>'required',
					'label'=>'Activity Name',
					'errors'=>[
						'required'=>'Activity Name is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_program_activity',$data);
            }else{
				$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
				if($file->isValid() && !$file->hasMoved()){
					$old_img=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
					$file_name=$file->getRandomName();
					$file->move('uploads/program_activity_files',$file_name); 
					//s3 uplode code
					$file_Path = base_url()."/uploads/program_activity_files/". $file_name; 
					$this->s3Upload('program_activity_files',$file_Path); 
					$url="./uploads/program_activity_files/".$file_name;
					unlink($url);

					//delete old file
					$this->s3DeleteObjects('pragram_activity_files',$this->request->getVar('old_img',FILTER_SANITIZE_STRING));

				}else{
					$file_name=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
				}

				$array_c=$this->request->getVar('AssignedGroupsId',FILTER_SANITIZE_STRING);
				$AssignedGroupsId=implode(",",$array_c);
				$table_data=[
						'ActivityName'=>$this->request->getVar('ActivityName',FILTER_SANITIZE_STRING),
						'ActivityType'=>$this->request->getVar('ActivityType',FILTER_SANITIZE_STRING),
						'Instructions'=>$this->request->getVar('Instructions',FILTER_SANITIZE_STRING),
						'Links'=>$this->request->getVar('Links',FILTER_SANITIZE_STRING),
						'ActivityStatus'=>$this->request->getVar('ActivityStatus',FILTER_SANITIZE_STRING),
						'TargetCompletionDate'=>$this->request->getVar('TargetCompletionDate',FILTER_SANITIZE_STRING),
						//'Points'=>$this->request->getVar('Points',FILTER_SANITIZE_STRING),
					//	'ParticipatedCount'=>$this->request->getVar('ParticipatedCount',FILTER_SANITIZE_STRING),
						'AssignedGroupsId'=>$AssignedGroupsId,
						'UploadType'=>$this->request->getVar('UploadType',FILTER_SANITIZE_STRING),
						'UploadResource'=>$file_name,

						'MediaCoverage'=>$this->request->getVar('MediaCoverage',FILTER_SANITIZE_STRING),
						'BannerDisplayed'=>$this->request->getVar('BannerDisplayed',FILTER_SANITIZE_STRING),
						'ParliamentPresidentParticipated'=>$this->request->getVar('ParliamentPresidentParticipated',FILTER_SANITIZE_STRING),
						'MlaInchargeParticipation'=>$this->request->getVar('MlaInchargeParticipation',FILTER_SANITIZE_STRING),
						'ConstituencyLeadersParticipated'=>$this->request->getVar('ConstituencyLeadersParticipated',FILTER_SANITIZE_STRING),
						'WhatsappImagesVideos'=>$this->request->getVar('WhatsappImagesVideos',FILTER_SANITIZE_STRING),


					//'MediaCovarage'=>$this->request->getVar('MediaCovarage',FILTER_SANITIZE_STRING),
					//	'InMediaCovarage'=>$this->request->getVar('InMediaCovarage',FILTER_SANITIZE_STRING),
					//	'MaterialUsageFormat'=>$this->request->getVar('MaterialUsageFormat',FILTER_SANITIZE_STRING),
					//	'InMaterialUsageFormat'=>$this->request->getVar('InMaterialUsageFormat',FILTER_SANITIZE_STRING),
					//	'PublicResponse'=>$this->request->getVar('PublicResponse',FILTER_SANITIZE_STRING),
					//	'InPublicResponse'=>$this->request->getVar('InPublicResponse',FILTER_SANITIZE_STRING),
					//	'AnySpecialActivities'=>$this->request->getVar('AnySpecialActivities',FILTER_SANITIZE_STRING),
					//	'InAnySpecialActivities'=>$this->request->getVar('InAnySpecialActivities',FILTER_SANITIZE_STRING),
					//	'SocialMediaCoverage'=>$this->request->getVar('SocialMediaCoverage',FILTER_SANITIZE_STRING),
					//	'LeadORCommittee_Participation'=>$this->request->getVar('LeadORCommittee_Participation',FILTER_SANITIZE_STRING),
					//	'InLeadORComm_Participation'=>$this->request->getVar('InLeadORComm_Participation',FILTER_SANITIZE_STRING),
						'SocialListingFromGround'=>$this->request->getVar('SocialListingFromGround',FILTER_SANITIZE_STRING),
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s')
					];
					$table="activity";
					$where_parameter="ActivityId";
					$where_id=$this->request->getVar('ActivityId',FILTER_SANITIZE_STRING);

				if($this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id) === false){

					$data=[
						'page_title'=>'Add Program Activity',
						'page_name'=>'add_program_activity'
					]; 
					$session->setFlashdata('error', 'Unable to Added Program Campaign');
					return redirect()->route('Program-Campaign');
				}else{
					$session->setFlashdata('success', 'Successfully Added');
					return redirect()->route('Program-Campaign');
				}
		 	}
		}
	}

	public function viewProgramActivity($id=null){
		$data=[
			'page_title'=>'View Program Campaign',
			'page_name'=>'add_program_campaining',
			'title_active'=>'program_activity',
		 ];
		 $data['view']=true;
		$parameters=array('ActivityGroupId','GroupName');
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTable('activitygroup',$parameters,$order_by); 
		$table="activity"; 
		$where_id=$id;
		$where_parameter="ActivityId";
		$data['activitydetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);		
		$data['file_path']=$this->s3GetObjects('program_activity_files',$data['activitydetails']['UploadResource']); 
		if(isset($data['activitydetails'])){
			return view('add_program_activity',$data);
		}else{
			return redirect()->route('Program-Campaign');
		}
	}

	public function demo(){
		$data=[
			'page_title'=>'demo',
			'page_name'=>'demo',
			'title_active'=>'demo',
		 ];

		 return view('demo',$data); 
	}

	public function ExecutiveReports(){
		$data=[
			'page_title'=>'Executive Reports',
			'page_name'=>'Executive Reports',
			'title_active'=>'ExecutiveReports',
		 ];
	
		 $compain_details=$this->AdminModel->compainOrderbyDesc();
		 $compain_id=$compain_details['ActivityId'];
		// $compain_id=1;
		 $data['compain_id']=$compain_id;
		 //Program Compain Status
		 $where_data=[
			"ActivityStatus"=>"Open"
		];
		$data['Open_Compaign']=$this->AdminModel->tableRowsCount('activity',$where_data);

		$where_data=[
		   "ActivityStatus"=>"Close"
	   ];
	   $data['Close_Compaign']=$this->AdminModel->tableRowsCount('activity',$where_data);


	  $activitydetails=$this->AdminModel->programActivityGrid();
		foreach($activitydetails as $row){
			$activity_id=$row['ActivityId'];
		}
		//get percentage
		$where=["campaign_id"=>$compain_id];
		$data['Program_Campaign_Report_ABCD']=$this->AdminModel->getGradingByCompaingId($compain_id);
		
	

		//program conducted or not
		$data['programConductedNotConducted']=$this->AdminModel->programConductedNotConductedByCompain_id($compain_id);

		//Incharge-Participated/Not Participated
		$data['inchargeParticipatedNotParticipated']=$this->AdminModel->inchargeParticipatedNotParticipatedByCompain_id($compain_id);
		
		
		 //Top 5 Issue
		$parameters=array('IssueTitle','IssueDescription');
		$order_by='CadreListeningId';
		$data['topIssues']=$this->AdminModel->getQueryFromTable('cadrelisteningdetails',$parameters,$order_by); 

		//Top 5 Submited Data
		$data['ConstituencySubmitedData']=$this->AdminModel->constituencySubmitedData($compain_id);
		
		//get Compain Viewd or Not
		$data['CompaingViwedOrNot']=$this->AdminModel->CompaingViwedOrNot($compain_id);

		//get Overal Reports Data
		$where_data=["ActivityId"=>$compain_id];
		$data['total_const_count']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$data['ACCount']=$this->AdminModel->ParticipatedAssemblyConstituencies($compain_id);
	
		$where_data=["ActivityId"=>$compain_id,"MlaInchargeParticipation"=>"Yes"];
		$data['IncCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$where_data=["ActivityId"=>$compain_id,"ParliamentPresidentParticipated"=>"Yes"];
		$data['PPCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$where_data=["ActivityId"=>$compain_id,"BannerDisplayed"=>"Yes"];
		$data['BDCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$where_data=["ActivityId"=>$compain_id,"MediaCovarage"=>"Yes"];
		$data['MCCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$where_data=["ActivityId"=>$compain_id,"MediaCovarage"=>"Yes"];
		$data['MCCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$data['PepopleCount']=$this->AdminModel->PPCount($compain_id); 
		
		$data['GradingCount']=$this->AdminModel->GradingCount($compain_id); 

		$where_data=["ActivityId"=>$compain_id,"ConstituencyProgramConducted"=>"No"];
		$data['NonPCCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$data['NonPCNames']=$this->AdminModel->NonPCNames($compain_id);
		// print_r($data['NonPCNames']);
		$data['activitydetails']=$this->AdminModel->programActivityGrid();
		
	
		$ActivitySummeryResult=$this->AdminModel->programActvityForExecutiveDash();
		$i=0;
		foreach($ActivitySummeryResult as $row){
			$ActivityId=$row['ActivityId'];
			$where_data=['ActivityId'=>$ActivityId,'Activity_status'=>'Completed'];
			$ActivitySummeryResult[$i]['CompletedCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);
			$i++;
		}
		$data['ActivitySummeryResult']=$ActivitySummeryResult;
		//get Compainings
		$data['campaign_names']=$this->AdminModel->getTable('activity');

		 
	

		if($this->request->getMethod() == 'post'){ 
					$compain_id=$this->request->getVar('compain_id',FILTER_SANITIZE_STRING);
					$data['compain_id']=$compain_id;
					$where=["campaign_id"=>$compain_id];
					$data['Program_Campaign_Report_ABCD']=$this->AdminModel->getGradingByCompaingId($compain_id);
					//print_r($data['Program_Campaign_Report_ABCD']);

					//program conducted or not
					$data['programConductedNotConducted']=$this->AdminModel->programConductedNotConductedByCompain_id($compain_id);

					//Incharge-Participated/Not Participated
					$data['inchargeParticipatedNotParticipated']=$this->AdminModel->inchargeParticipatedNotParticipatedByCompain_id($compain_id);

					$data['ConstituencySubmitedData']=$this->AdminModel->constituencySubmitedData($compain_id);

							//get Compain Viewd or Not
				$data['CompaingViwedOrNot']=$this->AdminModel->CompaingViwedOrNot($compain_id);

				//get Overal Reports Data
				$where_data=["ActivityId"=>$compain_id];
				$data['total_const_count']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

				$data['ACCount']=$this->AdminModel->ParticipatedAssemblyConstituencies($compain_id);
			
				$where_data=["ActivityId"=>$compain_id,"MlaInchargeParticipation"=>"Yes"];
				$data['IncCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

				$where_data=["ActivityId"=>$compain_id,"ParliamentPresidentParticipated"=>"Yes"];
				$data['PPCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

				$where_data=["ActivityId"=>$compain_id,"BannerDisplayed"=>"Yes"];
				$data['BDCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

				$where_data=["ActivityId"=>$compain_id,"MediaCovarage"=>"Yes"];
				$data['MCCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

				$where_data=["ActivityId"=>$compain_id,"MediaCovarage"=>"Yes"];
				$data['MCCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

				$data['PepopleCount']=$this->AdminModel->PPCount($compain_id); 
				
				$data['GradingCount']=$this->AdminModel->GradingCount($compain_id); 

			}
		//	echo 's11sss';
		 return view('executive_reports',$data); 
	}

	public function Reports(){
		$data=[
			'page_title'=>'Executive Reports',
			'page_name'=>'Executive Reports',
			'title_active'=>'Reports',
		 ];
		 $compain_id=26;
		 $where_data=[
			"ActivityStatus"=>"Open"
		];
		$data['Open_Compaign']=$this->AdminModel->tableRowsCount('activity',$where_data);

		$where_data=[
		   "ActivityStatus"=>"Close"
	   ];
	   $data['Close_Compaign']=$this->AdminModel->tableRowsCount('activity',$where_data);

	  $activitydetails=$this->AdminModel->programActivityGrid();
		foreach($activitydetails as $row){
			$activity_id=$row['ActivityId'];
		}
		//get percentage
		$where=["campaign_id"=>$compain_id];
		$data['Program_Campaign_Report_ABCD']=$this->AdminModel->getQueryReultFromTable('percentage_campaign',$where);

		//compain conducted or not
		$data['programConductedNotConducted']=$this->AdminModel->programConductedNotConducted($compain_id);
		//print_r($data['programConductedNotConducted']);
		
		//Incharge-Participated/Not Participated
		$data['inchargeParticipatedNotParticipated']=$this->AdminModel->inchargeParticipatedNotParticipated($compain_id); 
		//print_r($data['inchargeParticipatedNotParticipated']);
		
		 //Top 5 Issue
		$parameters=array('IssueTitle','IssueDescription');
		$order_by='CadreListeningId';
		$data['topIssues']=$this->AdminModel->getQueryFromTable('cadrelisteningdetails',$parameters,$order_by); 

		//Dynamic Data
		$data['activitydetails']=$this->AdminModel->programActivityGrid();
		
	
		$ActivitySummeryResult=$this->AdminModel->programActvityForExecutiveDash();
		$i=0;
		foreach($ActivitySummeryResult as $row){
			$ActivityId=$row['ActivityId'];
			$where_data=['ActivityId'=>$ActivityId,'Activity_status'=>'Completed'];
			$ActivitySummeryResult[$i]['CompletedCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);
			$i++;
		}
		$data['ActivitySummeryResult']=$ActivitySummeryResult;
		//get Compainings
		$data['campaign_names']=$this->AdminModel->getTable('activity');
		return view('executive_reports_demo',$data); 
	}

	public function getAppUsers($id=null){
		$data=[
			'page_title'=>'App Users',
			'page_name'=>'app_users',
			'title_active'=>'app_users'
		 ];
		// echo $id;
		// exit();
		$parameters=array('u_id','FirstName','LastName','Email','Mobile','Status');
		$parameters=array('*');
		$order_by='u_id';

		$where_data=[
			"Status"=>"Approved"
		];
		$table="users";
		$data['approved_count']=$this->AdminModel->tableRowsCount($table,$where_data);

		$where_data=[
		   "Status"=>"Pending"
	   ];
	   $data['pending_count']=$this->AdminModel->tableRowsCount($table,$where_data);
	   $where_data=[
		   "Status"=>"Reject"
	   ];
	   $data['reject_count']=$this->AdminModel->tableRowsCount($table,$where_data);

	   $where_data=[
		   "Status"=>"Banned"
	   ];
	   $data['banned_count']=$this->AdminModel->tableRowsCount($table,$where_data);
	   
		$data['appuserdetails']=$this->AdminModel->getQueryData();
		
		if($id){	
			$where=["Status"=>$id];
			$data['appuserdetails']=$this->AdminModel->getQueryReultFromTables('users',$where);
		}else{
		
		}	
		

		return view('app_users_management',$data); 
	}

	public function appUserEdit($id=null){  
		$session = session();
		$data=[
			'page_title'=>'Edit App User',
			'page_name'=>'edit_app_users',
			'title_active'=>'app_users'
		 ];		
		 //activity group
		$parameters=array('ActivityGroupId','GroupName'); 
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTable('activitygroup',$parameters,$order_by); 
		 //app roles
		$parameters=array('AppRoleId','AppRoleName');
		$order_by='AppRoleId';
		$data['approles']=$this->AdminModel->getQueryFromTable('approles',$parameters,$order_by); 

		 //app roles
		 $parameters=array('CommitteeID','CName');
		 $order_by='CommitteeID';
		 $data['commitee']=$this->AdminModel->getQueryFromTable('committee',$parameters,$order_by);  

		//parliaments
		$parameters=array('ParliamentID','ParliamentName');
		$order_by='ParliamentID';
		$data['parliament']=$this->AdminModel->getQueryFromTable('parliament',$parameters,$order_by); 
		 //app users 
		$table="users";
		$where_id=$id;
		$where_parameter="u_id";
		$data['userdetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		if(isset($data['userdetails'])){
			$userdetails=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
			//get constituency data
			$where_parameter = ['ParliamentID' => $userdetails['ParliamentId']]; 
			$table="constituency";
			$data['constituency']=$this->ApiModel->getWhereQuery($table,$where_parameter); 
			
			//get mandals
			$s=$userdetails['ParliamentId'];
			$data['mandals']=$this->AdminModel->getMandalsByConstituency($s);		

			//get Villages
			$s=$userdetails['ParliamentId'];
			$data['villages']=$this->AdminModel->getMandalsByvillage($s);		
			
			//approle groups
			if(isset($userdetails['AppRoleId'])){
				$where_parameter = ['AppRoleId' => $userdetails['AppRoleId']]; 
				$table="approlegroup";
				$data['approlegroups']=$this->ApiModel->getWhereQuery($table,$where_parameter);
			}
			

			return view('edit_app_users',$data);
		}else{
			return redirect()->route('get-app-users'); 
		} 
		
	}
	//get constituncey and mondals and village
	function action()
	{
		if($this->request->getVar('action'))
		{
			$action = $this->request->getVar('action');

			if($action == 'get_constituency')
			{
				$ParliamentId=$this->request->getVar('ParliamentId');
				$where_parameter = ['ParliamentID' => $ParliamentId]; 
				$table="constituency";				
			}
			if($action == 'get_mandals')
			{
				$ConstituencyID=$this->request->getVar('ConstituencyId');
				$where_parameter = ['constituency_id' => $ConstituencyID]; 
				$table="mandals";
			}
			if($action == 'get_villages')
			{
				$MandalId=$this->request->getVar('MandalId');
				$where_parameter = ['mandal_id' => $MandalId]; 
				$table="villages"; 
			}
			if($action == 'get_role_groups'){
				$AppRoleId=$this->request->getVar('AppRoleId');
				$where_parameter = ['AppRoleId' => $AppRoleId]; 
				$table="approlegroup";
			}
			$resultData=$this->ApiModel->getWhereQuery($table,$where_parameter);
			echo json_encode($resultData);
		}
	}

	//admin approve user compaining 
	public function userCampaignApprove(){
		if($this->request->getVar('action'))
		{
			 $ActivityId=$this->request->getVar('ActivityId');
			
			$where_parameter=['ActivityId'=>$ActivityId,'Activity_status'=>"Completed"];
			$resultData=$this->ApiModel->getWhereQuery('activitystatus',$where_parameter);
			foreach($resultData as $row){ 
				$result_Data[]=$this->AdminModel->updateQueryPointsDetails($row['ActivityStatuId'],$row['UserId'],$ActivityId);
			}
		} 
		$resultData=$result_Data;
		echo json_encode($resultData);
	}

	//app users upadate
	public function updateAppUser(){ 
		$session = \CodeIgniter\Config\Services::session();
		if($this->request->getMethod() == 'post'){
			$rules = [
				"FirstName" => "required",
				'ParliamentId'=>'required',
				'ConstituencyId'=>'required',
			];   
			$messages = [
				"FirstName" => [
					"required" => "FirstName is required"
				],
				"ParliamentId" => [
					"required" => "Parliament is required"
				],
				"ConstituencyId" => [
					"required" => "Constituency is required"
				]
			];
            if (!$this->validate($rules, $messages)) {
				$data["validation"]=$this->validator;
                return view('app_users_management',$data);
            }else{
				$u_id=$this->request->getVar('u_id',FILTER_SANITIZE_STRING);
				if($this->request->getVar('ActivityCommitteeGroup',FILTER_SANITIZE_STRING)){
					$ActivityCommitteeGroup=implode(",",$this->request->getVar('ActivityCommitteeGroup',FILTER_SANITIZE_STRING));
				}else{
					$ActivityCommitteeGroup="";
				}
				if($this->request->getVar('AppRoleGroupIds',FILTER_SANITIZE_STRING)){
					$array_AppRoleGroupIds=$this->request->getVar('AppRoleGroupIds',FILTER_SANITIZE_STRING);
					$AppRoleGroupIds=implode(",",$array_AppRoleGroupIds);
				}else{
					$AppRoleGroupIds="";
				}
			
				$table_data=[
						'FirstName'=>$this->request->getVar('FirstName',FILTER_SANITIZE_STRING),
						'DisplayName'=>$this->request->getVar('DisplayName',FILTER_SANITIZE_STRING),
						'DOB'=>$this->request->getVar('DOB',FILTER_SANITIZE_STRING),
						'ActivityCommitteeGroup'=>$ActivityCommitteeGroup, 
						'ParliamentId'=>$this->request->getVar('ParliamentId',FILTER_SANITIZE_STRING),
						'AppRoleId'=>$this->request->getVar('AppRoleId',FILTER_SANITIZE_STRING),
						'ConstituencyId'=>$this->request->getVar('ConstituencyId',FILTER_SANITIZE_STRING),
						'Status'=>$this->request->getVar('Status',FILTER_SANITIZE_STRING),
						'MandalId'=>$this->request->getVar('MandalId',FILTER_SANITIZE_STRING),
						'AppRoleGroupIds'=>$AppRoleGroupIds,
						'FBLink'=>$this->request->getVar('FBLink',FILTER_SANITIZE_STRING),
						'TwitterLink'=>$this->request->getVar('TwitterLink',FILTER_SANITIZE_STRING),
						'InstaLink'=>$this->request->getVar('InstaLink',FILTER_SANITIZE_STRING),
						'YouTubeLink'=>$this->request->getVar('YouTubeLink',FILTER_SANITIZE_STRING),
						'AddressLine1'=>$this->request->getVar('AddressLine1',FILTER_SANITIZE_STRING),
						'AddressLine2'=>$this->request->getVar('AddressLine2',FILTER_SANITIZE_STRING),
						'Country'=>$this->request->getVar('Country',FILTER_SANITIZE_STRING),
						'State'=>$this->request->getVar('State',FILTER_SANITIZE_STRING),
						'City'=>$this->request->getVar('City',FILTER_SANITIZE_STRING),
						'PinCode'=>$this->request->getVar('PinCode',FILTER_SANITIZE_STRING),
						'AccountHolderName'=>$this->request->getVar('AccountHolderName',FILTER_SANITIZE_STRING),
						'AccountHolderNumber'=>$this->request->getVar('AccountHolderNumber',FILTER_SANITIZE_STRING),
						'BankName'=>$this->request->getVar('BankName',FILTER_SANITIZE_STRING),
						'BankBranch'=>$this->request->getVar('BankBranch',FILTER_SANITIZE_STRING),
						'IFSCCode'=>$this->request->getVar('IFSCCode',FILTER_SANITIZE_STRING),
						'PANNumber'=>$this->request->getVar('PANNumber',FILTER_SANITIZE_STRING),
						'GSTNumber'=>$this->request->getVar('GSTNumber',FILTER_SANITIZE_STRING),
						'Skill'=>$this->request->getVar('Skill',FILTER_SANITIZE_STRING), 
						'CommitteId'=>$this->request->getVar('CommitteeID',FILTER_SANITIZE_STRING), 
						'LastUpdatedBy'=> $session->get('u_id'),
						'LastUpdatedDate'=>date('Y-m-d H:i:s')

					];
					$table="users";
					$where_parameter="u_id";
					$where_id=$u_id;

				if($this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id) === false){

					$data=[
						'page_title'=>'Add Program Activity',
						'page_name'=>'add_program_activity'
					]; 
					$session->setFlashdata('error', 'Unable to Update User');
					return redirect()->route('get-app-users'); 
				}else{
				  	$session->setFlashdata('success', 'Successfully Updated');
					return redirect()->route('get-app-users'); 
				}
			
		 	}
		}
	}

	public function getRoles(){
		$data=[
			'page_title'=>'Roles',
			'page_name'=>'Roles',
			'title_active'=>'roles'
		 ];
		 return view('demo',$data); 
	}
	public function getPermissions(){
		$data=[
			'page_title'=>'Permissions',
			'page_name'=>'Permissions',
			'title_active'=>'permissions'
		 ];
		 return view('demo',$data); 
	}

	//user progrma activity
	public Function AppUserProgramActivity($id=null){    
		$data=[
			'page_title'=>'Program Activity',
			'page_name'=>'program_activity',
			'title_active'=>'user_program_activity'
		 ];
		 $where_parameter="ActivityId";
		 $where_id=$id;
		 $data['parent_activity_data']=$this->AdminModel->getRowTableById('activity',$where_parameter,$where_id);
		$table="activitystatus";
		$where_data='Open';
		$data['open']=$this->AdminModel->userProgramActivityCountByStatus($id,$where_data);
		$where_data='Completed';
		$data['completed']=$this->AdminModel->userProgramActivityCountByStatus($id,$where_data);
		$data['viewed']="0";
		$data['compaign_status']=false; 
		$data['ActivityId']=$id;
		$where_data=['CheckView'=>1,'ActivityId'=>$id];
		$data["Views_count"]=$this->AdminModel->tableRowsCount('activitystatus',$where_data);
		$data['activitydetails']=$this->AdminModel->userProgramActivityGrid($id); 
		return view('users_program_activity_management',$data); 
	}

	//edit user compaining
	public function userProgramActivityEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'Edit Campaign Detail Summary',
			'page_name'=>'add_program_activity',
			'title_active'=>'user_program_activity'
		 ];
		$parameters=array('ActivityGroupId','GroupName');
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTableAdmins('activitygroup',$parameters,$order_by); 
		$table="activity";
		$where_id=$id;
		$where_parameter="ActivityId";
		$data['activitydetails']=$this->AdminModel->userProgramCampainingById($id);
		$data['file_path']=$this->s3GetObjects('program_activity_files',$data['activitydetails']['UploadResource']); 
		$data['file_path1']=$this->s3GetObjects('program_activity_files',$data['activitydetails']['UploadResource']); 
		$data['file_path2']=$this->s3GetObjects('program_activity_files',$data['activitydetails']['UploadResource']); 

		if(isset($data['activitydetails'])){ 
			return view('edit_user_program_activity',$data);
		}else{
			return redirect()->route('User-Program-Campaign');
		}
	}

	//view user compaining
	public function userProgramActivityView($id=null){ 
		$data=[
			'page_title'=>'View Campaign Detail Summary',
			'page_name'=>'add_program_activity',
			'title_active'=>'user_program_activity'
		 ];
		$parameters=array('ActivityGroupId','GroupName');
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTableAdmins('activitygroup',$parameters,$order_by); 
		$data['view']=true;
		$data['activitydetails']=$this->AdminModel->userProgramCampainingById($id);
		$data['file_path']=$this->s3GetObjects('program_activity_files',$data['activitydetails']['UploadResource']); 

		if(!empty($data['activitydetails']['InMediaCovarageFile'])){ 
			//	$Feed_details[$i]['img_path']=$this->s3GetObjects('feed_files',$row['FeedFileName']);
			//	$data['file_path']=$this->s3GetObjects('feed_files',$data['feeddetails']['FeedFileName']); 
				$data['file_path1']=$this->s3GetObjects('user_uplode_activity_files',$data['activitydetails']['InMediaCovarageFile']); 
			}else{
				$data['file_path1']="";
			}

			if(!empty($data['activitydetails']['InMaterialUsageFormatFile'])){ 
				$data['file_path2']=$this->s3GetObjects('user_uplode_activity_files',$data['activitydetails']['InMaterialUsageFormatFile']);
				}else{
					$data['file_path2']="";
				}
	
	//	$data['file_path2']=$this->s3GetObjects('user_uplode_activity_files',$data['activitydetails']['InMaterialUsageFormatFile']); 

		if(isset($data['activitydetails'])){ 
			return view('edit_user_program_activity',$data);
		}else{
			return redirect()->route('User-Program-Campaign');
		}
	}

	//feeds management
	public Function Feeds(){  
		$data=[
			'page_title'=>'Feeds',
			'page_name'=>'Feeds',
			'title_active'=>'feeds'
			];
		$parameters=array('IsActive','NewsFeedId','Title','Description','FeedType','CreatedDate');
		$order_by='NewsFeedId';
		$data['feeddetails']=$this->AdminModel->getQueryFromTableAdmins('newsfeed',$parameters,$order_by); 

		$i=0;
		foreach($data['feeddetails'] as $row){ 

			$where_data=["ViewFrom"=>"feeds","ViewFromId"=>$row["NewsFeedId"] ]; 
			$ViewData=$this->AdminModel->tableRowsCount('ViewsCheck',$where_data);
			if($ViewData){
				$CheckView=$ViewData;
			}else{
				$CheckView=0;
			} 
			$data['feeddetails'][$i]['CheckView']=$CheckView; 

			$where_data=["SharedFrom"=>"feeds","SharedFromId"=>$row["NewsFeedId"] ]; 
			$ShareCount=$this->AdminModel->tableRowsCount('ShareDetails',$where_data);
			if($ShareCount){
				$ShareCount=$ShareCount;
			}else{
				$ShareCount=0;
			} 
			$data['feeddetails'][$i]['ShareCount']=$ShareCount;

			$where_data=['NewsFeedId'=>$row["NewsFeedId"]];
            $likes=$this->AdminModel->tableRowsCount('newsfeedlikes',$where_data);
			$data['feeddetails'][$i]['likes']=$likes; 
			
			$i++;
		}

		return view('feed_management',$data);
	}

	// add feed
	public function AddFeed(){
		$session = session();
		$data=[
			'page_title'=>'Add Feed',
			'page_name'=>'Add Feed',
			'title_active'=>'feeds'
		 ];
		 if($this->request->getMethod() == 'post'){
			$rules=[
				'Title'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Title is a required'
					]
				],
				'Description'=>[
					'rules'=>'required',
					'label'=>'Description',
					'errors'=>[
						'required'=>'Description is a required'
					]
				],
			];
			
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_feed',$data);
            }else{


				$FeedType=$this->request->getVar('FeedType',FILTER_SANITIZE_STRING);
				if($FeedType == "Links"){
					$Links=$this->request->getVar('Links',FILTER_SANITIZE_STRING);
					$file_name=""; 
				}else{
					$Links=""; 
					$file=$this->request->getFile('file',FILTER_SANITIZE_STRING); 
					if($file->isValid() && !$file->hasMoved()){
							$file_name=$file->getRandomName();
							$file->move('uploads/feed_files',$file_name); 
							//s3 uplode
							$file_Path = base_url()."/uploads/feed_files/". $file_name; 
							$this->s3Upload('feed_files',$file_Path); 
							$url="./uploads/feed_files/".$file_name;
							unlink($url);
					}else{
						$session->setFlashdata('error', 'Unable to file upload file try again');
						return redirect()->route('Feeds'); 
					}
				}	 		
				
				// end test here
				$table_data=[
						'Title'=>$this->request->getVar('Title'), 
						'Description'=>$this->request->getVar('Description',FILTER_SANITIZE_STRING),
						'FeedType'=>$this->request->getVar('FeedType',FILTER_SANITIZE_STRING),
						'FeedFileName'=>$file_name,
						'Links'=>$Links,
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s')

					];
					$NewsFeedId=$this->AdminModel->insert_record('newsfeed',$table_data); 
				if($NewsFeedId === false){						
					$data=[
						'page_title'=>'Add Feed',
						'page_name'=>'Add Feed',
						'title_active'=>'feeds'
					]; 
					$session->setFlashdata('error', 'Unable to Added Feed');
					return redirect()->route('Feeds');
				}else{
					$session->setFlashdata('success', 'Successfully Added Feed');
					return redirect()->route('Feeds');
				}
			
		 	}
		 }
		return view('add_feed',$data);
	}

	//edit feed
	public function feedEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'Feed Edit',
			'page_name'=>'Feed Edit',
			'title_active'=>'feeds'
		 ];
		$table="newsfeed";
		$where_id=$id;
		$where_parameter="NewsFeedId";
		$data['feeddetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		if($data['feeddetails']['FeedType']!="Links"){ 
		//	$Feed_details[$i]['img_path']=$this->s3GetObjects('feed_files',$row['FeedFileName']);
			$data['file_path']=$this->s3GetObjects('feed_files',$data['feeddetails']['FeedFileName']); 
		}
	//	$data['file_path']=$this->s3GetObjects('feed_files',$data['feeddetails']['FeedFileName']); 
		if(isset($data['feeddetails'])){
			return view('add_feed',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Feeds');
		}
	}

	//feed view
	public function feedView($id=null){
		$session = session();
		$data=[
			'page_title'=>'Feed View',
			'page_name'=>'Feed View',
			'title_active'=>'feeds'
		 ];
		 $data['view']=true;
		$table="newsfeed";
		$where_id=$id;
		$where_parameter="NewsFeedId";
		$data['feeddetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		if($data['feeddetails']['FeedType']!="Links"){ 
				$data['file_path']=$this->s3GetObjects('feed_files',$data['feeddetails']['FeedFileName']); 
			}
		if(isset($data['feeddetails'])){
			return view('add_feed',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Feeds');
		}
	}

	public function UpdateFeed(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Feed Edit',
			'page_name'=>'Feed Edit',
			'title_active'=>'feeds'
		 ];
		if($this->request->getMethod() == 'post'){
			$rules=[
				'Title'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Title is a required'
					]
				],
				'Description'=>[
					'rules'=>'required',
					'label'=>'Description',
					'errors'=>[
						'required'=>'Description is a required'
					]
				]

			];
			
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_feed',$data);
            }else{

				$FeedType=$this->request->getVar('FeedType',FILTER_SANITIZE_STRING);
				if($FeedType == "Links"){
					$Links=$this->request->getVar('Links',FILTER_SANITIZE_STRING);
					if(!empty($this->request->getVar('old_img'))){ 
						// $url="./uploads/feed_files/".$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
						// unlink($url);
						$this->s3DeleteObjects('feed_files',$this->request->getVar('old_img',FILTER_SANITIZE_STRING));
					} 
					$file_name="";
				}else{
					$Links="";
					$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
					if($file->isValid() && !$file->hasMoved()){ 
						$file_name=$file->getRandomName();						
						$file->move('uploads/feed_files',$file_name);  

						//s3 uplode
						$file_Path = base_url()."/uploads/feed_files/". $file_name; 
						$this->s3Upload('feed_files',$file_Path); 
						$url="./uploads/feed_files/".$file_name;
						unlink($url); 
	
						

						if(!empty($this->request->getVar('old_img'))){
							// $url="./uploads/feed_files/".$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
							// unlink($url);
							//delete old file
							$this->s3DeleteObjects('feed_files',$this->request->getVar('old_img',FILTER_SANITIZE_STRING));
						}
					}else{
						$file_name=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
					}
				}


				// $file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
				// if($file->isValid() && !$file->hasMoved()){
				// 	$old_img=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
				// 	$file->move('uploads/feed_files'); 
				// 	$file_name=$file->getName();
				// }else{
				// 	$file_name=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
				// }




				$table_data=[
						'Title'=>$this->request->getVar('Title',FILTER_SANITIZE_STRING),
						'Description'=>$this->request->getVar('Description',FILTER_SANITIZE_STRING),
						'FeedType'=>$this->request->getVar('FeedType',FILTER_SANITIZE_STRING),
						'FeedFileName'=>$file_name,
						'Links'=>$Links,
						'LastUpdatedBy'=>$session->get('u_id'),
						'LastUpdatedDate'=>date('Y-m-d H:i:s')
					];
					$where_parameter="NewsFeedId";
					$where_id=$this->request->getVar('NewsFeedId',FILTER_SANITIZE_STRING);
					$NewsFeedId=$this->AdminModel->updateQuery('newsfeed',$table_data,$where_parameter,$where_id); 
				if($NewsFeedId === false){						
					$data=[
						'page_title'=>'Add Feed',
						'page_name'=>'Add Feed',
						'title_active'=>'feeds'
					]; 
					$session->setFlashdata('error', 'Unable to Added Feed');
					return redirect()->route('Feeds');
				}else{
					$session->setFlashdata('success', 'Successfully Added Feed');
					return redirect()->route('Feeds');
				}
		 	}
		 }
	}

	//feeds management
	public Function ePaper(){ 
		$data=[
			'page_title'=>'E-Paper',
			'page_name'=>'E-Paper',
			'title_active'=>'E-Paper'
			];
		$parameters=array('EpaperId','Title','EpaperFileName','file_date','CreatedDate','IsActive');
		$order_by='EpaperId';
		$data['epaperdetails']=$this->AdminModel->getQueryFromTableAdmins('epaper',$parameters,$order_by); 
			$i=0;
			foreach($data['epaperdetails'] as $row){ 

				$where_data=["ViewFrom"=>"epaper","ViewFromId"=>$row["EpaperId"] ]; 
				$ViewData=$this->AdminModel->tableRowsCount('ViewsCheck',$where_data);
				if($ViewData){
					$CheckView=$ViewData;
				}else{
					$CheckView=0;
				} 
				$data['epaperdetails'][$i]['CheckView']=$CheckView; 
				$i++;
			}
		
		

		return view('epaper_management',$data);
	}

	//add e paper
	public function addEPaper(){ 
		$session = session();
		$data=[
			'page_title'=>'Add E-Paper',
			'page_name'=>'Add E-Paper',
			'title_active'=>'E-Paper'
		 ];
		 if($this->request->getMethod() == 'post'){
			$rules=[
				'Title'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Title is a required'
					]
				],
				'file_date'=>[
					'rules'=>'required',
					'label'=>'Date',
					'errors'=>[
						'required'=>'Date is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_e_paper',$data);
            }else{
				$file_image=$this->request->getFile('file_image',FILTER_SANITIZE_STRING);
			$file=$this->request->getFile('file',FILTER_SANITIZE_STRING); 
			if($file->isValid() && !$file->hasMoved()){
					$file_name=$file->getRandomName();
					$file->move('uploads/e_paper',$file_name); 

					$file_Path = base_url()."/uploads/e_paper/". $file_name; 
					$this->s3Upload('e_paper',$file_Path);  
					$url="./uploads/e_paper/".$file_name;
					unlink($url);
 

					 if($file_image->isValid() && !$file_image->hasMoved()){
					 	$file_image_name=$file_image->getRandomName();
					 	$file_image->move('uploads/e_paper',$file_image_name); 

						 $file_Path = base_url()."/uploads/e_paper/". $file_image_name;  
							$this->s3Upload('e_paper',$file_Path); 
							$url="./uploads/e_paper/".$file_image_name;
							unlink($url);

					 }else{

					 }
				// end test here
				$table_data=[
						'Title'=>$this->request->getVar('Title',FILTER_SANITIZE_STRING),
						'file_date'=>$this->request->getVar('file_date',FILTER_SANITIZE_STRING),
						'EpaperFileName'=>$file_name,
						'epaper_thumbnail'=>$file_image_name,
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s')
					];
					$EpaperId=$this->AdminModel->insert_record('epaper',$table_data); 
				if($EpaperId === false){						
					$data=[
						'page_title'=>'Add E-Paper',
						'page_name'=>'Add E-Paper',
						'title_active'=>'E-Paper'
					]; 
					$session->setFlashdata('error', 'Unable to Added E-Paper');
					return redirect()->route('E-Paper');
				}else{
					$session->setFlashdata('success', 'Successfully Added E-paper');
					return redirect()->route('E-Paper');
				}
			}else{
				$session->setFlashdata('error', 'Unable to E-Paper file upload file try again');
				return redirect()->route('E-Paper');
			}
		}
		 }
		
		return view('add_e_paper',$data);
	}

	//edit epaper
	public function ePaperEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'Edit E-Paper',
			'page_name'=>'Edit E-Paper',
			'title_active'=>'E-Paper'
		 ];
		$table="epaper";
		$where_id=$id;
		$where_parameter="EpaperId";
		$data['epaperdetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		$data['file_path']=$this->s3GetObjects('e_paper',$data['epaperdetails']['EpaperFileName']); 
		if(isset($data['epaperdetails'])){
			return view('add_e_paper',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('E-Paper');
		}
	}
  
	public function updateEPaper(){ 
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Edit E-Paper',
			'page_name'=>'Edit E-Paper',
			'title_active'=>'E-Paper'
		 ];
		if($this->request->getMethod() == 'post'){
			$rules=[
				'Title'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Title is a required'
					]
				],
				'file_date'=>[
					'rules'=>'required',
					'label'=>'Date',
					'errors'=>[
						'required'=>'Date is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_feed',$data);
            }else{
				
				$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
				if($file->isValid() && !$file->hasMoved()){
					$file_name=$file->getRandomName();
					$file->move('uploads/e_paper',$file_name); 
					// $url="./uploads/e_paper/".$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
					// unlink($url);
					
					//s3 uplode code
					$file_Path = base_url()."/uploads/e_paper/". $file_name; 
					$this->s3Upload('e_paper',$file_Path); 
					$url="./uploads/e_paper/".$file_name;
					unlink($url);

					//delete old file
					$this->s3DeleteObjects('e_paper',$this->request->getVar('old_img',FILTER_SANITIZE_STRING));

				}else{
					$file_name=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
				}
				$file_image=$this->request->getFile('file_image',FILTER_SANITIZE_STRING);
				if($file_image->isValid() && !$file_image->hasMoved()){
					$file_image_name=$file_image->getRandomName();
					 $file_image->move('uploads/e_paper',$file_image_name); 
					// $url="./uploads/e_paper/".$this->request->getVar('old_img1',FILTER_SANITIZE_STRING);
					// unlink($url);
					
					//update new file
					$file_Path = base_url()."/uploads/e_paper/". $file_image_name; 
					$this->s3Upload('e_paper',$file_Path); 
					$url="./uploads/e_paper/".$file_image_name;
					unlink($url);

					//delete old file
					$this->s3DeleteObjects('e_paper',$this->request->getVar('old_img1',FILTER_SANITIZE_STRING));

				}else{
					$file_image_name=$this->request->getVar('old_img1',FILTER_SANITIZE_STRING);
				}
				// end test here
				$table_data=[
						'Title'=>$this->request->getVar('Title',FILTER_SANITIZE_STRING),
						'file_date'=>$this->request->getVar('file_date',FILTER_SANITIZE_STRING),
						'EpaperFileName'=>$file_name,
						'epaper_thumbnail'=>$file_image_name,
						'LastUpdatedBy'=>$session->get('u_id'),
						'LastUpdatedDate'=>date('Y-m-d H:i:s')
					];
					$where_parameter="EpaperId";
					$where_id=$this->request->getVar('EpaperId',FILTER_SANITIZE_STRING);
					$EpaperId=$this->AdminModel->updateQuery('epaper',$table_data,$where_parameter,$where_id); 
				if($EpaperId === false){						
					$data=[
						'page_title'=>'Edit E-Paper',
						'page_name'=>'Edit E-Paper',
						'title_active'=>'E-Paper'
					]; 
					$session->setFlashdata('error', 'Unable to Added E-Paper');
					return redirect()->route('E-Paper');
				}else{
					$session->setFlashdata('success', 'Successfully Added  E-Paper');
					return redirect()->route('E-Paper');
				}
			
		 	}
		 }
	}
	//View epaper
	public function ePaperView($id=null){
		$session = session();
		$data=[
			'page_title'=>'View E-Paper',
			'page_name'=>'View E-Paper',
			'title_active'=>'E-Paper'
			];
		$data['view']=true;
		$table="epaper";
		$where_id=$id;
		$where_parameter="EpaperId";
		$data['epaperdetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		$data['file_path']=$this->s3GetObjects('e_paper',$data['epaperdetails']['EpaperFileName']);
		if(isset($data['epaperdetails'])){
			return view('add_e_paper',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('E-Paper');
		}
	}
	//SM Tasks
	public Function smTasks(){ 
		$session = session();
		$data=[
			'page_title'=>'Tasks',
			'page_name'=>'Social Media Tasks',
			'title_active'=>'tasks'
			];
		$data['taskdetails']=$this->AdminModel->getTasks();
		$i=0;
		foreach($data['taskdetails'] as $row){ 

			$where_data=["ViewFrom"=>"smtasks","ViewFromId"=>$row["TaskId"] ]; 
			$ViewData=$this->AdminModel->tableRowsCount('ViewsCheck',$where_data);
			if($ViewData){
				$CheckView=$ViewData;
			}else{
				$CheckView=0;
			} 
			$data['taskdetails'][$i]['CheckView']=$CheckView; 


			$where_data=["SharedFrom"=>"smtasks","SharedFromId"=>$row["TaskId"] ]; 
			$ShareCount=$this->AdminModel->tableRowsCount('ShareDetails',$where_data);
			if($ShareCount){
				$ShareCount=$ShareCount;
			}else{
				$ShareCount=0;
			} 
			$data['taskdetails'][$i]['ShareCount']=$ShareCount;

			$i++;
		}

		return view('task_management',$data); 
	}
	// add feed
	public function addSmTask(){
		$session = session();
		$data=[
			'page_title'=>'Add Task',
			'page_name'=>'Add Task',
			'title_active'=>'tasks'
			];
			if($this->request->getMethod() == 'post'){
			$rules=[
				'Title'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Title is a required'
					]
				]
			];
			$validation=$this->validate($rules);
			if (!$validation) {
				$data["validation"]=$this->validator;
				return view('add_task',$data);
			}else{
				$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
				if($file->isValid() && !$file->hasMoved()){
					//$file->move('uploads/pragram_activity_files','shekhar.'. $file->getExtension());
				
					$file_name=$file->getRandomName();
					$file->move('uploads/task_files',$file_name); 

					//s3 uplode code
					$file_Path = base_url()."/uploads/task_files/". $file_name; 
					$this->s3Upload('task_files',$file_Path); 
					$url="./uploads/task_files/".$file_name;
					unlink($url);
				}else{
					$file_name="";
				}

					$SelectedGroups_array=$this->request->getVar('SelectedGroups',FILTER_SANITIZE_STRING);
					$SelectedGroups=implode(",",$SelectedGroups_array);
				// end test here
				$table_data=[
						'ContentType'=>$this->request->getVar('ContentType',FILTER_SANITIZE_STRING),
						'Title'=>$this->request->getVar('Title',FILTER_SANITIZE_STRING),
						'Description'=>$this->request->getVar('Description',FILTER_SANITIZE_STRING),
						'Instructions'=>$this->request->getVar('Instructions',FILTER_SANITIZE_STRING),
						'URL'=>$this->request->getVar('URL',FILTER_SANITIZE_STRING),
						'Image'=>$file_name,            
						'PromoterType'=>$this->request->getVar('PromoterType',FILTER_SANITIZE_STRING),
						'SelectedGroups'=>$SelectedGroups,
						'Purpose'=>$this->request->getVar('Purpose',FILTER_SANITIZE_STRING),
						'RewardType'=>$this->request->getVar('RewardType',FILTER_SANITIZE_STRING),
						'Prizevalue'=>$this->request->getVar('Prizevalue',FILTER_SANITIZE_STRING),
						'ViewsForPrize'=>$this->request->getVar('ViewsForPrize',FILTER_SANITIZE_STRING),
						'ExpiryDate'=>$this->request->getVar('ExpiryDate',FILTER_SANITIZE_STRING),
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s')

					];
					$TaskId=$this->AdminModel->insert_record('tasks',$table_data); 
				if($TaskId === false){						
					$data=[
						'page_title'=>'Add Task',
						'page_name'=>'Add Task',
						'title_active'=>'tasks'
					]; 
					$session->setFlashdata('error', 'Unable to Added Task');
					return redirect()->route('Tasks');
				}else{
					$session->setFlashdata('success', 'Successfully Added Task');
					return redirect()->route('Tasks');
				}
			
				}
			}
		return view('add_task',$data);
	}
	
	//teask edit
	public function smTaskEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'Edit Task',
			'page_name'=>'Edit Task',
			'title_active'=>'tasks'
		 ];
		$table="tasks";
		$where_id=$id;
		$where_parameter="TaskId";
		$data['taskdetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		$data['file_path']=$this->s3GetObjects('task_files',$data['taskdetails']['Image']);
		$taskdetails=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);

		if(isset($data['taskdetails'])){
			//approle groups
			if(isset($taskdetails['TaskId'])){
				$where_parameter = ['AppRoleId' => $taskdetails['PromoterType']]; 
				$table="approlegroup";
				$data['approlegroups']=$this->ApiModel->getWhereQuery($table,$where_parameter);
			}
			return view('add_task',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('add_task');
		}
	}

	//update sm task
	public function updateSmTask(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Task Edit',
			'page_name'=>'Task Edit',
			'title_active'=>'tasks'
		 ];
		
		if($this->request->getMethod() == 'post'){
			$rules=[
				'Title'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Title is a required'
					]
				]
			];
			
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_task',$data);
            }else{
				$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
				if($file->isValid() && !$file->hasMoved()){
					$old_img=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
					$file_name=$file->getRandomName(); 
					$file->move('uploads/task_files',$file_name);  

					//s3 uplode code
					$file_Path = base_url()."/uploads/task_files/". $file_name; 
					$this->s3Upload('task_files',$file_Path); 
					$url="./uploads/task_files/".$file_name;
					unlink($url);

					//delete old file
					$this->s3DeleteObjects('task_files',$this->request->getVar('old_img',FILTER_SANITIZE_STRING));

					// $url="./uploads/task_files/".$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
					// unlink($url);
				}else{
					$file_name=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
				}
				
				$SelectedGroups_array=$this->request->getVar('SelectedGroups',FILTER_SANITIZE_STRING);
				$SelectedGroups=implode(",",$SelectedGroups_array);
				$table_data=[
					'ContentType'=>$this->request->getVar('ContentType',FILTER_SANITIZE_STRING),
					'Title'=>$this->request->getVar('Title',FILTER_SANITIZE_STRING),
					'Description'=>$this->request->getVar('Description',FILTER_SANITIZE_STRING),
					'Instructions'=>$this->request->getVar('Instructions',FILTER_SANITIZE_STRING),
					'URL'=>$this->request->getVar('URL',FILTER_SANITIZE_STRING),
					'Image'=>$file_name,            
					'PromoterType'=>$this->request->getVar('PromoterType',FILTER_SANITIZE_STRING),
					'SelectedGroups'=>$SelectedGroups,
					'Purpose'=>$this->request->getVar('Purpose',FILTER_SANITIZE_STRING),
					'RewardType'=>$this->request->getVar('RewardType',FILTER_SANITIZE_STRING),
					'Prizevalue'=>$this->request->getVar('Prizevalue',FILTER_SANITIZE_STRING),
					'ViewsForPrize'=>$this->request->getVar('ViewsForPrize',FILTER_SANITIZE_STRING),
					'ExpiryDate'=>$this->request->getVar('ExpiryDate',FILTER_SANITIZE_STRING),
					'LastUpdatedBy'=>$session->get('u_id'),
					'LastUpdatedDate'=>date('Y-m-d H:i:s')

					];
					$where_parameter="TaskId";
					$where_id=$this->request->getVar('TaskId',FILTER_SANITIZE_STRING);					
					$TaskId=$this->AdminModel->updateQuery('tasks',$table_data,$where_parameter,$where_id); 
				
				if($TaskId === false){						
					$data=[
						'page_title'=>'Task',
						'page_name'=>'Tasks',
						'title_active'=>'tasks'
					]; 
					$session->setFlashdata('error', 'Unable to Update Task');
					return redirect()->route('Tasks');
				}else{
					$session->setFlashdata('success', 'Successfully Updated Task');
					return redirect()->route('Tasks');
				}
		 	}
		 }
	}

	//teask edit
	public function smTaskView($id=null){
		$data=[
			'page_title'=>'View Task',
			'page_name'=>'View Task',
			'title_active'=>'tasks'
		 ]; 
		$table="tasks";
		$where_id=$id;
		$where_parameter="TaskId";
		$data['taskdetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		$data['file_path']=$this->s3GetObjects('task_files',$data['taskdetails']['Image']);
		$taskdetails=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
       $data['view']=true;
		if(isset($data['taskdetails'])){
			//approle groups
			if(isset($taskdetails['TaskId'])){
				$where_parameter = ['AppRoleId' => $taskdetails['PromoterType']]; 
				$table="approlegroup";
				$data['approlegroups']=$this->ApiModel->getWhereQuery($table,$where_parameter);
			}

			return view('add_task',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('add_task');
		}
	}

	//feeds management
	public Function gallery(){ 
		$data=[
			'page_title'=>'Gallery',
			'page_name'=>'Gallery',
			'title_active'=>'gallery'
			];
		$parameters=array('GalleryId','GalaryType','GalleryTitle','GalaryFileName','CreatedDate','IsActive');
		$order_by='GalleryId'; 
		$data['gallerytails']=$this->AdminModel->getQueryFromTableAdmins('gallery',$parameters,$order_by); 
		$i=0;
		foreach($data['gallerytails'] as $row){
			$where_data=['GalleryId'=>$row['GalleryId']]; 
			$Totallikes=$this->AdminModel->tableRowsCount('gallerylikes',$where_data); 
			$data['gallerytails'][$i]['GalleryLikesCount']=$Totallikes;  
			

			$where_data=["SharedFrom"=>"gallery","SharedFromId"=>$row["GalleryId"] ]; 
			$ShareCount=$this->AdminModel->tableRowsCount('ShareDetails',$where_data);
			if($ShareCount){
				$ShareCount=$ShareCount;
			}else{
				$ShareCount=0;
			} 
			$data['gallerytails'][$i]['ShareCount']=$ShareCount; 

			$i++;

		}	
		return view('gallery_management',$data);
	}
	//Add Gallery
	public function addGallery(){
		$session = session();
		$data=[
			'page_title'=>'Add Gallery',
			'page_name'=>'Add Gallery',
			'title_active'=>'gallery'
		 ];
		 if($this->request->getMethod() == 'post'){
			$rules=[
				'GalleryTitle'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Gallery Title is a required'
					]
				],
				'GalaryType'=>[
					'rules'=>'required',
					'label'=>'Galary Type',
					'errors'=>[
						'required'=>'Galary Type is a required'
					]
				]
			];
			
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_gallery',$data);
            }else{
					$GalaryType=$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING);
					if($GalaryType == "Links"){
						$Links=$this->request->getVar('Links',FILTER_SANITIZE_STRING);
						$file_name=""; 
					}else{
						$Links=""; 
						$file=$this->request->getFile('file',FILTER_SANITIZE_STRING); 
						//print_r($file);
						if($file->isValid() && !$file->hasMoved()){
							try {
								$file_name=$file->getRandomName();
								$file->move('uploads/gallery',$file_name);  
								//s3 uplode
								$file_Path = base_url()."/uploads/gallery/". $file_name; 
								$this->s3Upload('gallery',$file_Path); 
								$url="./uploads/gallery/".$file_name;
								unlink($url);
							}catch(S3Exception $e){ 
								echo $e->getAwsErrorMessage();
							}

						}else{
							$session->setFlashdata('error', 'Unable to upload file try again');
							return redirect()->route('Gallery'); 
						}
					}
					

					// end test here
					$table_data=[
							'GalaryType'=>$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING),
							'GalleryTitle'=>$this->request->getVar('GalleryTitle',FILTER_SANITIZE_STRING),
							'GalaryFileName'=>$file_name,
							'Links'=>$Links,
							'CreatedBy'=>$session->get('u_id'),
							'CreatedDate'=>date('Y-m-d H:i:s')

						];
						$GalleryId=$this->AdminModel->insert_record('gallery',$table_data); 
					if($GalleryId === false){						
						$data=[
							'page_title'=>'Add Gallery',
							'page_name'=>'Add Gallery',
							'title_active'=>'gallery'
						]; 
						$session->setFlashdata('error', 'Unable to Added Gallery');
						return redirect()->route('Gallery');
					}else{
						$session->setFlashdata('success', 'Successfully Added Gallery');
						return redirect()->route('Gallery');
					}
				
			}
		}
		return view('add_gallery',$data);
	}

	public function s3Upload($bucket,$file_Path){
		$client=$this->s3Details();
		//$file_Path = base_url()."/uploads/gallery/". $file_name; 
		$key = basename($file_Path); 
		$sha256 = hash_file("sha256", $file_Path);
		$result = $client->putObject([
			"Bucket" =>$bucket,
			"Key" => $key,
			"SourceFile" => $file_Path,
			"ACL" => "public-read",
			"ContentSHA256" => $sha256,
			"ContentLength"=>'9',
		]);
		return $result['ObjectURL'];
	}
	//get s3 object images
	public function s3GetObjects($bucket,$file_name){
		$client=$this->s3Details();
		$file_url = $client->getObjectUrl($bucket, $file_name);
		return $file_url;
	}
	
	//s3 object keys
	private function s3Details(){
		//define('AWS_KEY', 'KTL0LE9OZVCDNMXOR8Y1');
		$AWS_KEY="846UE3L4ZEPAUX7F779L";
		//define('AWS_SECRET_KEY', '6VYBOhUYiWoC1eXdZVz8ldqdfd6llBeKvJJqMXXC');
		$AWS_SECRET_KEY="ym3B0tjJIRsFNiujIFPDwABPw2fWpndfxFOE4bm5";
		$ENDPOINT = 'https://manatdp.ap-south-1.linodeobjects.com';  

		return 	$client = new S3Client([
			'region' => 'ap-south-1',
			'version' => 'latest',
			'endpoint' => $ENDPOINT,
			'credentials' => [
				'key' => $AWS_KEY,
				'secret' => $AWS_SECRET_KEY
			],
			'use_path_style_endpoint' => true
		]); 
	}

	//S3 delete function 
	public function s3DeleteObjects($bucket,$file_name){  
		$client=$this->s3Details();
		$client->deleteObject(['Bucket' =>$bucket, 'Key' =>$file_name]);
	}

	//edit epaper
	public function galleryEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'Edit Gallery',
			'page_name'=>'Edit Gallery',
			'title_active'=>'gallery'
		 ];
		$table="gallery";
		$where_id=$id;
		$where_parameter="GalleryId";
		$data['gallerydetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		$data['file_path']=$this->s3GetObjects('gallery',$data['gallerydetails']['GalaryFileName']);
		if(isset($data['gallerydetails'])){
			return view('add_gallery',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Gallery');
		}
	}

	//gallery Update
	public function updateGallery(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Add Gallery',
			'page_name'=>'Add Gallery',
			'title_active'=>'gallery'
		 ];
		if($this->request->getMethod() == 'post'){
			$rules=[
				'GalaryType'=>[
					'rules'=>'required',
					'label'=>'GalaryType',
					'errors'=>[
						'required'=>'GalaryType is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_gallery',$data);
            }else{

				$GalaryType=$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING);
					if($GalaryType == "Links"){
						$Links=$this->request->getVar('Links',FILTER_SANITIZE_STRING);
						if(!empty($this->request->getVar('old_img'))){
							$url="./uploads/gallery/".$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
							unlink($url);
						}
						$file_name="";
					}else{
						$Links="";
						$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
						if($file->isValid() && !$file->hasMoved()){ 
							$file_name=$file->getRandomName();						
							$file->move('uploads/gallery',$file_name); 

							//s3 uplode code
							$file_Path = base_url()."/uploads/gallery/". $file_name; 
							$this->s3Upload('gallery',$file_Path); 
							$url="./uploads/gallery/".$file_name;
							unlink($url);
							if(!empty($this->request->getVar('old_img'))){ 
								//delete old file
								$this->s3DeleteObjects('gallery',$this->request->getVar('old_img',FILTER_SANITIZE_STRING));

							}
							//unlink($dd);
						//	exit();
						}else{
							$file_name=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
						}
					}
				
			
				$table_data=[
					'GalaryType'=>$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING),
					'GalleryTitle'=>$this->request->getVar('GalleryTitle',FILTER_SANITIZE_STRING),
					'GalaryFileName'=>$file_name,
					'Links'=>$Links,
					'LastUpdatedBy'=>$session->get('u_id'),
					'LastUpdatedDate'=>date('Y-m-d H:i:s')
					];
					$where_parameter="GalleryId";
					$where_id=$this->request->getVar('GalleryId',FILTER_SANITIZE_STRING);
					
					$GalleryId=$this->AdminModel->updateQuery('gallery',$table_data,$where_parameter,$where_id); 
				
				if($GalleryId === false){						
					$data=[
						'page_title'=>'Edit Gallery',
						'page_name'=>'Edit Gallery',
						'title_active'=>'gallery'
					]; 
					$session->setFlashdata('error', 'Unable to Added Gallery');
					return redirect()->route('Gallery');
				}else{
					$session->setFlashdata('success', 'Successfully Added  Gallery');
					return redirect()->route('Gallery');
				}
			
		 	}
		 }
	}

	//View Gallery
	public function galleryView($id=null){
		$session = session();
		$data=[
			'page_title'=>'View Gallery',
			'page_name'=>'View Gallery',
			'title_active'=>'gallery'
		 ];
		$data["view"]=true;
		$table="gallery";
		$where_id=$id;
		$where_parameter="GalleryId";
		$data['gallerydetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		$data['file_path']=$this->s3GetObjects('gallery',$data['gallerydetails']['GalaryFileName']);
		if(isset($data['gallerydetails'])){
			return view('add_gallery',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Gallery');
		}
	}

	//
	//cadreListening
	public Function cadreListening(){ 
		$data=[
			'page_title'=>'Cadre Listening',
			'page_name'=>'Cadre Listening',
			'title_active'=>'cadrelistening'
			];
		$data['cadrelisteningetails']=$this->AdminModel->getCadreListeningGrid(); 
		return view('cadre_listening_management',$data);
	}
	//ad cadre listening
	public function addcadreListening(){
		$session = session();
		$data=[
			'page_title'=>'Add Cadre Listening',
			'page_name'=>'Add Cadre Listening',
			'title_active'=>'cadrelistening'
		 ];
		 $parameters=array('ParliamentID','ParliamentName');
		 $order_by='ParliamentID';
		 $data['parliament']=$this->AdminModel->getQueryFromTableAdmins('parliament',$parameters,$order_by);
		 if($this->request->getMethod() == 'post'){
			$rules=[
				'IssueTitle'=>[
					'rules'=>'required',
					'label'=>'IssueTitle',
					'errors'=>[
						'required'=>'Issue Title is a required'
					]
				],
				'IssueDescription'=>[
					'rules'=>'required',
					'label'=>'Issue Description',
					'errors'=>[
						'required'=>'Issue Description is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_cadre_listening',$data);
            }else{
				// Form Data
				$table_data=[
						'IssueTitle'=>$this->request->getVar('IssueTitle',FILTER_SANITIZE_STRING),
						'IssueDescription'=>$this->request->getVar('IssueDescription',FILTER_SANITIZE_STRING),
						'ParliamentId'=>$this->request->getVar('ParliamentId',FILTER_SANITIZE_STRING),
						'ConstituencyId'=>$this->request->getVar('ConstituencyId',FILTER_SANITIZE_STRING),
						'UserType'=>"Web",
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s')

					];
					$CadreListeningId=$this->AdminModel->insert_record('cadrelisteningdetails',$table_data); 
				if($CadreListeningId === false){						
						$data=[
							'page_title'=>'Add Cadre Listening',
							'page_name'=>'Add Cadre Listening',
							'title_active'=>'cadreListening'
						]; 
						$session->setFlashdata('error', 'Unable to Added Cadre Listening');
						return redirect()->route('Cadre-Listening');
				}else{
						$session->setFlashdata('success', 'Successfully Added Cadre Listening');
						return redirect()->route('Cadre-Listening');
				}
			
		 	}
		}
		return view('add_cadre_listening',$data);
	}

	//edit cadre listening
	public function cadreListeningEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'Edit Cadre Listening',
			'page_name'=>'Edit Cadre Listening',
			'title_active'=>'cadrelistening'
			];

		$parameters=array('ParliamentID','ParliamentName');
		$order_by='ParliamentID';
		$data['parliament']=$this->AdminModel->getQueryFromTableAdmins('parliament',$parameters,$order_by);
		$where_parameter="CadreListeningId";
		$where_id=$id;
		$data['cadrelisteningetails']=$this->AdminModel->getRowTableById('cadrelisteningdetails',$where_parameter,$where_id);
		if(isset($data['cadrelisteningetails'])){
			$where_parameter = ['ParliamentID' => $data['cadrelisteningetails']['ParliamentId']]; 
			$table="constituency"; 
			$data['constituency']=$this->ApiModel->getWhereQuery($table,$where_parameter); 
			return view('add_cadre_listening',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Cadre-Listening');
		}
	}
	//update cadre listening
	public function updateCadreListening(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Add Cadre Listening',
			'page_name'=>'Add Cadre Listening',
			'title_active'=>'cadrelistening'
		 ];
		if($this->request->getMethod() == 'post'){
			$rules=[
				'IssueTitle'=>[
					'rules'=>'required',
					'label'=>'IssueTitle',
					'errors'=>[
						'required'=>'Issue Title is a required'
					]
				],
				'IssueDescription'=>[
					'rules'=>'required',
					'label'=>'Issue Description',
					'errors'=>[
						'required'=>'Issue Description is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
				return view('add_cadre_listening',$data);
            }else{
				$table_data=[
						'IssueTitle'=>$this->request->getVar('IssueTitle',FILTER_SANITIZE_STRING),
						'IssueDescription'=>$this->request->getVar('IssueDescription',FILTER_SANITIZE_STRING),
						'ParliamentId'=>$this->request->getVar('ParliamentId',FILTER_SANITIZE_STRING),
						'ConstituencyId'=>$this->request->getVar('ConstituencyId',FILTER_SANITIZE_STRING),
						'UserType'=>"Web",
						'LastUpdatedBy'=>$session->get('u_id'),
						'LastUpdatedDate'=>date('Y-m-d H:i:s')
					];
					$where_parameter="CadreListeningId";
					$where_id=$this->request->getVar('CadreListeningId',FILTER_SANITIZE_STRING);
					$CadreListeningId=$this->AdminModel->updateQuery('cadrelisteningdetails',$table_data,$where_parameter,$where_id); 
				if($CadreListeningId === false){						
					$data=[
						'page_title'=>'Edit Cadre Listening',
						'page_name'=>'Edit Cadre Listening',
						'title_active'=>'cadrelistening'
					]; 
					$session->setFlashdata('error', 'Unable to Added Cadre Listening');
					return redirect()->route('Cadre-Listening');
				}else{
					$session->setFlashdata('success', 'Successfully Added Cadre-Listening');
					return redirect()->route('Cadre-Listening');
				}
		 	}
		 }
	}

	//view cadre listening
	public function cadreListeningView($id=null){
		$session = session();
		$data=[
			'page_title'=>'View Cadre Listening',
			'page_name'=>'View Cadre Listening',
			'title_active'=>'cadrelistening' 
			];
		$data['view']=true;
		$parameters=array('ParliamentID','ParliamentName');
		$order_by='ParliamentID';
		$data['parliament']=$this->AdminModel->getQueryFromTableAdmins('parliament',$parameters,$order_by);
		$where_parameter="CadreListeningId";
		$where_id=$id;
		$data['cadrelisteningetails']=$this->AdminModel->getRowTableById('cadrelisteningdetails',$where_parameter,$where_id);
		if(isset($data['cadrelisteningetails'])){
			$where_parameter = ['ParliamentID' => $data['cadrelisteningetails']['ParliamentId']]; 
			$table="constituency"; 
			$data['constituency']=$this->ApiModel->getWhereQuery($table,$where_parameter); 
			return view('add_cadre_listening',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Cadre-Listening');
		}
	}

	public function ImportExcel(){
		$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
		
		if ($file->isValid() && ! $file->hasMoved()) {
			$newName = $file->getRandomName();
				$file_name = $file->getTempName();
	
				$student = array();
	
				$csv_data = array_map('str_getcsv', file($file_name));
	
				if (count($csv_data) > 0) {
					$index = 0;
					//print_r($csv_data);
					foreach ($csv_data as $data) {
						if ($index > 0) {
							$parliamentName=$data[1];
							$ParliamentID=$this->AdminModel->checkParliament($parliamentName);
							$ConstituencyData[] = array(								
								"ConstituencyName" => $data[2],
								"ParliamentID" => $ParliamentID,
							);
						}
						$index++;
					}
					$this->AdminModel->InsertConstituency($ConstituencyData);
				}
		}
	}

	//import nithyavasara dharalu
	public function child_campaign(){
		$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
		if ($file->isValid() && ! $file->hasMoved()) {
				$newName = $file->getRandomName();
				$file_name = $file->getTempName();
				$student = array();
				$csv_data = array_map('str_getcsv', file($file_name));
				if (count($csv_data) > 0) {
					$index = 0;
					//print_r($csv_data);
					foreach ($csv_data as $data) { 
						if ($index > 0) {
							$InsertData[] = array(								
								"parent_campaign_id" =>26,
								"District" => $data[1],
								"Parliament" => $data[2],
								"Constituency" => $data[3],
								"Informed_Mla_Incharge" => $data[4],
								"campaign_conducted" => $data[5],
								"Banner_Displayed" => $data[6],
								"Parliament_President_Participated" => $data[7],
								"Mla_Incharge_Participation" => $data[8],
								"Constituency_Leaders_Participated" => $data[9],
								"No_of_Cadre_Participated_Count" => $data[10],
								"Neutral_People_Participated_Count" => $data[11],
								"Whatsapp_Images_Videos" => $data[12],
								"Media_Coverage" => $data[13],
								"Remarks" => $data[14], 
							);
						}
						$index++; 
					}
					$this->AdminModel->InsertChildData($InsertData);
				}
			}
	}

	public function markeImport(){ 
			$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
			if ($file->isValid() && ! $file->hasMoved()){
				$newName = $file->getRandomName();
				$file_name = $file->getTempName();
				$student = array();
				$csv_data = array_map('str_getcsv', file($file_name));
				if (count($csv_data) > 0) {
					$index = 0;
					//print_r($csv_data);
					foreach ($csv_data as $data) { 
						if ($index > 0) {
								$InsertData[] = array(								
									"parent_campaign_id" =>26,
									"Parliament" => $data[0],
									"Constituency" => $data[1],
									"Only_Constituency_Participation"=>$data[2],
									"Only_Constituency_Participation_percentage" => $data[3],
									"Only_Constituency_Grade" =>$data[4],
									"Incharge_Participation_Included"=> $data[5],
									"Incharge_Participation_Included_percentage"=>$data[6],
									"Incharge_Participation_Grade"=>$data[7],
								); 
						}
						$index++; 
						
					}
					//print_r($InsertData);
					$this->AdminModel->InsertMarksData($InsertData);
				}
			}
		}

		public function gradeImport(){
			$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
			if ($file->isValid() && ! $file->hasMoved()){
				$newName = $file->getRandomName();
				$file_name = $file->getTempName();
				$student = array();
				$csv_data = array_map('str_getcsv', file($file_name));
				if (count($csv_data) > 0) {
					$index = 0;
					//print_r($csv_data);
					foreach ($csv_data as $data) { 
						if ($index > 0) {
								$InsertData[] = array(								
									"grade" =>"B",
									"campaign_id"=>"26",
									"Parliament" => $data[1],
									"Constituency" => $data[2]
								); 
						}
						$index++; 
						
					}
					//print_r($InsertData);
					$this->AdminModel->InsertImportData('grading_campaign',$InsertData);
				}
			}
		}

		public function get_perctage_by_data(){  
			$percentage_campaign_id=$this->request->getVar('percentage_campaign_id');
			$where_id=$percentage_campaign_id;
			$where_parameter="percentage_campaign_id";
			$percentage_campaign_data=$this->AdminModel->getRowTableById('percentage_campaign',$where_parameter,$where_id);
			$grade=$percentage_campaign_data['Grade'];
			$campaign_id=$percentage_campaign_data['campaign_id'];
			//get parliments and costituencys
			$where=["grade"=>$grade,"campaign_id"=>$campaign_id];
			$grader_result=$this->AdminModel->getQueryReultFromTable('grading_campaign',$where);

			echo json_encode($grader_result); 
		}

		//public function 
		public function get_constituency_data_ajax(){
			$compain_id=$this->request->getVar('compain_id');
			$grade=$this->request->getVar('grade');
			$grader_result=$this->AdminModel->getConstencyParliments($compain_id,$grade);
			echo json_encode($grader_result);

		}

		public function get_constituency_data_for_incharge(){
			$compain_id=$this->request->getVar('compain_id');
			$incharge=$this->request->getVar('incharge');
			$incharge_result=$this->AdminModel->getConstencyParlimentsForIncharges($compain_id,$incharge);
			echo json_encode($incharge_result);
		}

		public function get_constituency_data_for_Viewd(){
			$compain_id=$this->request->getVar('compain_id');
			$checkView=$this->request->getVar('checkView');
			$incharge_result=$this->AdminModel->getConstencyParlimentsForViewd($compain_id,$checkView);
			echo json_encode($incharge_result);
		}
		public function get_constituencies_for_pp(){
			$compain_id=$this->request->getVar('compain_id');
			$ConstituencyProgramConducted=$this->request->getVar('ConstituencyProgramConducted');
			$pp_result=$this->AdminModel->getConstencyParlimentsForPP($compain_id,$ConstituencyProgramConducted);
			echo json_encode($pp_result);  
		}

		//insert user mla in charges
		public function importUsers(){
			$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
			if ($file->isValid() && ! $file->hasMoved()){
				$newName = $file->getRandomName();
				$file_name = $file->getTempName();
				$student = array();
				$csv_data = array_map('str_getcsv', file($file_name));
				if (count($csv_data) > 0) { 
					$index = 0;
					//print_r($csv_data);
					
					foreach ($csv_data as $data) { 
						$s[]=$data;
						
					}
					$i=0;
					foreach($s as $d=>$data){
						//echo $v[2];
						//echo $i;
						if ($i > 0) {
						if(!empty($data[2]) && !empty($data[3])){ 
								 $i;
							$InsertData[] = array( 	 
								"ParliamentId" =>$data[3],
								"ConstituencyId" =>$data[5], 
								"FirstName" =>$data[6],
								"DisplayName" =>$data[6],
								"ActivityCommitteeGroup"=>"2",
								"AppRoleId"=>"3",
								"MobileVerified"=>"1",
								"Mobile"=>$data[8],
								"Mobile2"=>$data[9],
								"Gender"=>$data[10],
								"Caste"=>$data[11],
								"SubCast"=>$data[12],
								"DOB"=>date('Y-m-d',strtotime($data[13])),
								"EmailsList"=>$data[14],
								'Password'=>password_hash("Manatdp@123", PASSWORD_DEFAULT)

							); 
							
							}else{
								echo $i;
							}
						}
						//echo $v[3];
					$i++;	
					}
					foreach($InsertData as $row){
						$table_data=[
							"ParliamentId" =>$row["ParliamentId"],
							"ConstituencyId" =>$row["ConstituencyId"], 
							"FirstName" =>$row["FirstName"],
							"DisplayName" =>$row["DisplayName"],
							"ActivityCommitteeGroup"=>"2",
							"AppRoleId"=>"3",
							"MobileVerified"=>"1",
							"Mobile"=>$row["Mobile"],
							"Mobile2"=>$row["Mobile2"],
							"Gender"=>$row["Gender"],
							"Caste"=>$row["Caste"],
							"SubCast"=>$row["SubCast"],
							"DOB"=>$row["DOB"],
							"EmailsList"=>$row["EmailsList"],
							'Password'=>password_hash("Manatdp@123", PASSWORD_DEFAULT),
							"Status"=>"Approved"
						];
						$user_id=$this->AdminModel->insert_record('users',$table_data); 
						$bUIdLength = strlen($user_id);
						switch($bUIdLength)
						{
							case 1: $MembershipId = "MANATDP00000".$user_id;
							break;
							case 2: $MembershipId = "MANATDP0000".$user_id;
							break;
							case 3: $MembershipId = "MANATDP000".$user_id;
							break;
							case 4: $MembershipId = "MANATDP00".$user_id;
							break;
							case 5: $MembershipId = "MANATDP0".$user_id;
							break;
							case 7: $MembershipId = "MANATDP".$user_id;
							break;
							default: 
							echo "Your favorite color is neither red, blue, nor green!";
							
						} 

						//update user tables
						$where_parameter="u_id";
						$table_data=["MembershipId"=>$MembershipId];
						$table="users";
						$where_id=$user_id;
						$updateQuery=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);
					}
					//print_r($InsertData);
					//$this->AdminModel->InsertImportData('users',$InsertData);
				}
			}
		}

		//insert palirment menbers
		public function importUsersParliament(){
			$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
			if ($file->isValid() && ! $file->hasMoved()){
				$newName = $file->getRandomName();
				$file_name = $file->getTempName(); 
				$student = array();
				$csv_data = array_map('str_getcsv', file($file_name));
				if (count($csv_data) > 0) { 
					$index = 0;
					//print_r($csv_data);					
					foreach ($csv_data as $data) { 
						$s[]=$data;
						
					}
					$i=0;
					foreach($s as $d=>$data){
						//echo $v[2];
						//echo $i;
						if ($i > 0) {
						if(!empty($data[4]) && !empty($data[8])){  
								 $i;
								 $where_data=["Mobile"=>$data[7]];
								$count= $this->AdminModel->tableRowsCount('users',$where_data);
								if($count){

								}else{
									$InsertData[] = array( 	 
										"ParliamentId" =>$data[3],
										"ConstituencyId" =>$data[3], 
										"FirstName" =>$data[5],
										"DisplayName" =>$data[5],
										"ActivityCommitteeGroup"=>"2",
										"AppRoleId"=>"4",
										"MobileVerified"=>"1",
										"Mobile"=>$data[7],
										"Gender"=>$data[8],
										"Caste"=>$data[9],
										"SubCast"=>$data[10],
										"DOB"=>date('Y-m-d',strtotime($data[11])),  
										"EmailsList"=>$data[12], 
										'Password'=>password_hash("Manatdp@123", PASSWORD_DEFAULT)
	
									); 
								}
								
							
							}else{
								echo $i;
							}
						}
						//echo $v[3];
						$i++;	
					}
					foreach($InsertData as $row){
						$table_data=[
							"ParliamentId" =>$row["ParliamentId"],
							"ConstituencyId" =>$row["ConstituencyId"], 
							"FirstName" =>$row["FirstName"],
							"DisplayName" =>$row["DisplayName"],
							"ActivityCommitteeGroup"=>"1",
							"AppRoleId"=>"4",
							"MobileVerified"=>"1",
							"Mobile"=>$row["Mobile"],
							"Gender"=>$row["Gender"],
							"Caste"=>$row["Caste"],
							"SubCast"=>$row["SubCast"],
							"DOB"=>$row["DOB"],
							"EmailsList"=>$row["EmailsList"],
							'Password'=>password_hash("Manatdp@123", PASSWORD_DEFAULT),
							"Status"=>"Approved"
						];
						$user_id=$this->AdminModel->insert_record('users',$table_data); 
						$bUIdLength = strlen($user_id);
						switch($bUIdLength)
						{
							case 1: $MembershipId = "MANATDP00000".$user_id;
							break;
							case 2: $MembershipId = "MANATDP0000".$user_id;
							break;
							case 3: $MembershipId = "MANATDP000".$user_id;
							break;
							case 4: $MembershipId = "MANATDP00".$user_id;
							break;
							case 5: $MembershipId = "MANATDP0".$user_id;
							break;
							case 7: $MembershipId = "MANATDP".$user_id;
							break;
							default: 
							echo "Your favorite color is neither red, blue, nor green!";
							
						} 

						//update user tables
						$where_parameter="u_id";
						$table_data=["MembershipId"=>$MembershipId];
						$table="users";
						$where_id=$user_id;
						$updateQuery=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);
					} 
					//print_r($InsertData);
					//$this->AdminModel->InsertImportData('users',$InsertData);
				}
			}
		}
		//import pc users data

		//insert palirment menbers
		public function importUsersParliamentPc(){
			$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
			if ($file->isValid() && ! $file->hasMoved()){ 
				$newName = $file->getRandomName();
				$file_name = $file->getTempName(); 
				$student = array();
				$csv_data = array_map('str_getcsv', file($file_name));
				if (count($csv_data) > 0) { 
					$index = 0;
					//print_r($csv_data);					
					foreach ($csv_data as $data) { 
						$s[]=$data;
						
					}
					$i=0;
					foreach($s as $d=>$data){
						//echo $v[2];
						//echo $i;
						if ($i > 0) {
						if(!empty($data[1]) && !empty($data[8])){  
									$i;
								$where_data=["Mobile"=>$data[8]];
								$count= $this->AdminModel->tableRowsCount('users',$where_data);
								if($count){

								}else{
									$InsertData[] = array( 	 
										"ParliamentId" =>25,
										"ConstituencyId" =>175, 
										"FirstName" =>$data[1],
										"DisplayName" =>$data[1], 
										"AppRoleId"=>"5",
										"MobileVerified"=>"1",
										"Mobile"=>$data[8],
										"Gender"=>$data[2],
										"Caste"=>$data[7],
										"DOB"=>date('Y-m-d',strtotime($data[3])),  
										'Password'=>password_hash("Manatdp@123", PASSWORD_DEFAULT)
	
									); 
								}
								
							
							}else{
								echo $i;
							}
						}
						//echo $v[3];
						$i++;	
					}
					foreach($InsertData as $row){
						$table_data=[
							"ParliamentId" =>$row["ParliamentId"],
							"ConstituencyId" =>$row["ConstituencyId"], 
							"FirstName" =>$row["FirstName"],
							"DisplayName" =>$row["DisplayName"],
							"AppRoleId"=>"5",
							"MobileVerified"=>"1",
							"Mobile"=>$row["Mobile"],
							"Gender"=>$row["Gender"],
							"Caste"=>$row["Caste"],
							"DOB"=>$row["DOB"],
							'Password'=>password_hash("Manatdp@123", PASSWORD_DEFAULT),
							"Status"=>"Approved"
						];
						$user_id=$this->AdminModel->insert_record('users',$table_data); 
						$bUIdLength = strlen($user_id);
						switch($bUIdLength)
						{
							case 1: $MembershipId = "MANATDP00000".$user_id;
							break;
							case 2: $MembershipId = "MANATDP0000".$user_id;
							break;
							case 3: $MembershipId = "MANATDP000".$user_id;
							break;
							case 4: $MembershipId = "MANATDP00".$user_id;
							break;
							case 5: $MembershipId = "MANATDP0".$user_id;
							break;
							case 7: $MembershipId = "MANATDP".$user_id;
							break;
							default: 
							echo "Your favorite color is neither red, blue, nor green!";
							
						} 

						//update user tables
						$where_parameter="u_id";
						$table_data=["MembershipId"=>$MembershipId];
						$table="users";
						$where_id=$user_id;
						$updateQuery=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);
					} 
					//print_r($InsertData);
					//$this->AdminModel->InsertImportData('users',$InsertData);
				}
			}
		}

	//Polls management
	public Function Polls(){ 
		$data=[
			'page_title'=>'Polls',
			'page_name'=>'Polls',
			'title_active'=>'Polls'
			];
		$parameters=array('p_id','Question','Option1','Option2','Option3','Option4','CreatedDate','PollsStatus');
		$order_by='p_id';
		$data['polldetails']=$this->AdminModel->getQueryFrom('poll',$parameters,$order_by); 
	
       $data['activitydetails']=$this->AdminModel->programActivityGrid();
		return view('poll_management',$data);
	}
	// add Polls
	public function AddPolls(){
		$session = session();
		$data=[
			'page_title'=>'Add Polls',
			'page_name'=>'Add Polls',
			'title_active'=>'Polls'
		 ];
		 $parameters=array('ActivityGroupId','GroupName');
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTableAdmins('activitygroup',$parameters,$order_by); 

		$parameters=array('ConstituencyID','ConstituencyName');
		$order_by='ConstituencyID';
		$data['constituency']=$this->AdminModel->getQueryFromTableAdmins('constituency',$parameters,$order_by);

		 if($this->request->getMethod() == 'post'){
			$rules=[
				'Question'=>[
					'rules'=>'required',
					'label'=>'Question',
					'errors'=>[
						'required'=>'Question is a required'
					]
				],
				'Option1'=>[
					'rules'=>'required',
					'label'=>'Option1',
					'errors'=>[
						'required'=>'Option1 is a required'
					]
				],
				'Option2'=>[
					'rules'=>'required',
					'label'=>'Option2',
					'errors'=>[
						'required'=>'Option2 is a required'
					]
				],
				'PollsStatus'=>[
					'rules'=>'required',
					'label'=>'PollsStatus',
					'errors'=>[
						'required'=>'PollsStatus is a required'
					]
				],
				
				

			];
			
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_polls',$data);
            }else{
				$array_c=$this->request->getVar('AssignedGroupsId',FILTER_SANITIZE_STRING);
				$AssignedGroupsId=implode(",",$array_c);
				
				// end test here
				$table_data=[
						'Question'=>$this->request->getVar('Question',FILTER_SANITIZE_STRING),
						'Option1'=>$this->request->getVar('Option1',FILTER_SANITIZE_STRING),
						'Option2'=>$this->request->getVar('Option2',FILTER_SANITIZE_STRING),
						'Option3'=>$this->request->getVar('Option3',FILTER_SANITIZE_STRING),
						'Option4'=>$this->request->getVar('Option4',FILTER_SANITIZE_STRING),
						'AssignedGroupsId'=>$AssignedGroupsId,

						'PollsStatus'=>$this->request->getVar('PollsStatus',FILTER_SANITIZE_STRING),
						'poll_date'=>$this->request->getVar('poll_date',FILTER_SANITIZE_STRING),
						'ConstituencyID'=>$this->request->getVar('ConstituencyID',FILTER_SANITIZE_STRING),
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s')

					];
					$NewsFeedId=$this->AdminModel->insert_record('poll',$table_data);
					
				if($NewsFeedId === false){						
					$data=[
						'page_title'=>'Add Polls',
						'page_name'=>'Add Polls',
						'title_active'=>'Polls'
					]; 
					$session->setFlashdata('error', 'Unable to Added Polls');
					return redirect()->route('Polls');
				}else{
					$session->setFlashdata('success', 'Successfully Added Polls');
					return redirect()->route('Polls');
				}
			
		 	}
		 }
		
		return view('add_polls',$data);
	}

	
//edit Polls
	public function pollsEdit($id=null){
		$data=[
			'page_title'=>'Polls Edit',
			'page_name'=>'Polls Edit',
			'title_active'=>'Polls'
		 ];
		
 $parameters=array('ActivityGroupId','GroupName');
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTableAdmins('activitygroup',$parameters,$order_by);

		$parameters=array('ConstituencyID','ConstituencyName');
		$order_by='ConstituencyID';
		$data['constituency']=$this->AdminModel->getQueryFromTableAdmins('constituency',$parameters,$order_by);
		$table="poll";
		$where_id=$id;
		$where_parameter="p_id";
		$data['polldetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		
		if(isset($data['polldetails'])){
			return view('add_polls',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Polls');
		}
	}
	//update Polls
public function UpdatePolls(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Polls Edit',
			'page_name'=>'Polls Edit',
			'title_active'=>'Polls'
		 ];
		
		if($this->request->getMethod() == 'post'){
			$rules=[
				'Question'=>[
					'rules'=>'required',
					'label'=>'Question',
					'errors'=>[
						'required'=>'Question is a required'
					]
				],
				'Option1'=>[
					'rules'=>'required',
					'label'=>'Option1',
					'errors'=>[
						'required'=>'Option1 is a required'
					]
				],
				'Option2'=>[
					'rules'=>'required',
					'label'=>'Option2',
					'errors'=>[
						'required'=>'Option2 is a required'
					]
				],
				'PollsStatus'=>[
					'rules'=>'required',
					'label'=>'PollsStatus',
					'errors'=>[
						'required'=>'PollsStatus is a required'
					]
				]
				
				

			];
			$array_c=$this->request->getVar('AssignedGroupsId',FILTER_SANITIZE_STRING);
				$AssignedGroupsId=implode(",",$array_c);
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_polls',$data);
            }else{

				// end test here
				$table_data=[
						'Question'=>$this->request->getVar('Question',FILTER_SANITIZE_STRING),
						'Option1'=>$this->request->getVar('Option1',FILTER_SANITIZE_STRING),
						'Option2'=>$this->request->getVar('Option2',FILTER_SANITIZE_STRING),
						'Option3'=>$this->request->getVar('Option3',FILTER_SANITIZE_STRING),
						'Option4'=>$this->request->getVar('Option4',FILTER_SANITIZE_STRING),
						'AssignedGroupsId'=>$AssignedGroupsId,

						'PollsStatus'=>$this->request->getVar('PollsStatus',FILTER_SANITIZE_STRING),
						'poll_date'=>$this->request->getVar('poll_date',FILTER_SANITIZE_STRING),
						'ConstituencyID'=>$this->request->getVar('ConstituencyID',FILTER_SANITIZE_STRING),
						'LastUpdatedBy'=>$session->get('u_id'),
					    'LastUpdatedDate'=>date('Y-m-d H:i:s')
					
						

					];
					$where_parameter="p_id";
					$where_id=$this->request->getVar('p_id',FILTER_SANITIZE_STRING);
					
					$NewsFeedId=$this->AdminModel->updateQuery('poll',$table_data,$where_parameter,$where_id); 
				
				if($NewsFeedId === false){						
					$data=[
						'page_title'=>'Add Polls',
						'page_name'=>'Add Polls',
						'title_active'=>'Polls'
					]; 
					$session->setFlashdata('error', 'Unable to Added Polls');
					return redirect()->route('Polls');
				}else{
					$session->setFlashdata('success', 'Successfully Added Polls');
					return redirect()->route('Polls');
				}
			
		 	}
		 }
	}


//poll reslut
	public Function pollreslut($id=null){ 	  
		$data=[
			'page_title'=>'Poll Response',
			'page_name'=>'Poll Response',
			'title_active'=>'Polls'
		 ];
		
		$where_data=[
				 "Status"=>"Approved"
			 ];
			 $table="users";
			 $data['Approved']=$this->AdminModel->tableRowsCount($table,$where_data);

		
			 $table="poll_responses";
			 $data['completed']=$this->AdminModel->tableRowsCountpoll($table);
		$data['viewed']=$data['Approved']-$data['completed'];
		$data['compaign_status']=true;
		$data['polldetails']=$this->AdminModel->pollresponse($id);
		return view('poll_response',$data); 
	}
	// table records publish and un publish
	public function RecordPublishUnPublish(){
		$resultData='shekhar test';
		$id=$this->request->getVar('id');
		$action=$this->request->getVar('action');
		$table=$this->request->getVar('table');
		$where_id=$this->request->getVar('where_id');
		if($action == "Publish"){
			$table_data=["IsActive"=>1];
		}else{
			$table_data=["IsActive"=>0];
		}
		$where_parameter=$where_id;
		$where_id=$id;
		$updateResult=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);
		if($updateResult){			
			$resultData="Successfully ".$action.'ed';
			$resultData=["message"=>$resultData,"respone"=>1];
		}else{
			$resultData="Unable to ". $action.'ed';
			$resultData=["message"=>$resultData,"respone"=>0];
		}
		echo json_encode($resultData);
	}

	public function testReaponse(){ 
		// echo 'test';
		// $url = "https://api.linode.com/v4/object-storage/buckets";

		// $curl = curl_init($url);
		// curl_setopt($curl, CURLOPT_URL, $url);
		// curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

		// $headers = array(
		// "Content-Type: application/json",
		// "Authorization:Bearer 6c952f3b50ea94a34e21ae20707249784b84ca681be70a59a576da356621a9b5"
		// );
		// curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
		// //for debug only!
		// curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		// curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

		// $resp = curl_exec($curl);
		// curl_close($curl);
		// var_dump($resp);


		define('AWS_KEY', '846UE3L4ZEPAUX7F779L');
		define('AWS_SECRET_KEY', 'ym3B0tjJIRsFNiujIFPDwABPw2fWpndfxFOE4bm5');
		$ENDPOINT = 'https://manatdp.ap-south-1.linodeobjects.com'; 

		// require the amazon sdk from your composer vendor dir
		//require __DIR__.'/vendor/autoload.php';

		// Instantiate the S3 class and point it at the desired host
		$client = new S3Client([
			'region' => 'ap-south-1',
			'version' => 'latest',
			'endpoint' => $ENDPOINT,
			'credentials' => [
				'key' => AWS_KEY,
				'secret' => AWS_SECRET_KEY
			],
			// Set the S3 class to use objects.dreamhost.com/bucket
			// instead of bucket.objects.dreamhost.com
			'use_path_style_endpoint' => true
		]);

		$listResponse = $client->listBuckets();
		$buckets = $listResponse['Buckets'];
	//	print_r($listResponse);

		// $result = $client->getObject(array(
		// 	'Bucket' => 'manatdp-dev-data',
		// 	'Key'    => '1643602817_16b14a847f449a2b3785.jpg'
		// ));1643602817_16b14a847f449a2b3785.jpg
			echo "<br/>";
			echo "<br/>";
	//	$object = $client->getObject(['Bucket' => 'e_paper', 'Key' => 'E-PAPER 05-01-2021.pdf']);
		// $object."\n";
		// echo $object->get('key');
		// https://manatdp.ap-south-1.linodeobjects.com/e_paper/E-PAPER 05-01-2021_.pdf

		//$object = $client->getObject(['Bucket' => 'e_paper', 'Key' => '1645069732_b4b1f2abc09e793db240.pdf']);
		//file_put_contents('Downloads/1643527736_69d12f724f0a03d8de8d.mp4', $object['Body']->getContents());
		//echo $object['Body'];
 
		$hello_url = $client->getObjectUrl('e_paper', 'E-PAPER 05-01-2021_.pdf');
		echo $hello_url."\n";

		echo "<br/>";
		echo "<br/>";
	//	$secret_plans_cmd = $client->getCommand('GetObject', ['Bucket' => 'gallary', 'Key' => '1645069732_b4b1f2abc09e793db240.pdf']);
	//	//$secret_plans_cmd = $client->getCommand('GetObject', ['Bucket' => 'manatdp-dev-data', 'Key' => '1643602817_16b14a847f449a2b3785.jpg']);
	//	$request = $client->createPresignedRequest($secret_plans_cmd, '+1 hour');
	//	echo $request->getUri()."\n";

		echo "<br/>";
		echo "<br/>";  
	//	src="http://172.105.53.205/yellow/uploads/gallery/1645016843_5a4ee28b35628bb6e1f1.jpg"

	//	$objInfo = $client->get_object_headers('gallery', '1643527736_69d12f724f0a03d8de8d.mp4');
	//	$obj = $client->get_object('manatdp-dev-data', '1643527893_5fc89ea81a2339fa5732.pdf');  

	//	header('Content-type: ' . $objInfo->header['_info']['content_type']);


	//	file_put_contents('/home/larry/documents/poetry.pdf', $object['Body']->getContents());

	//	echo $buckets['Name'];
		//exit();
		// $objectsListResponse = $client->listObjects(['Bucket' => 'manatdp-dev-data']);
		// $objects = $objectsListResponse['Contents'] ?? [];
		// foreach ($objects as $object) {
		// 	echo $object['Key'] . "\t" . $object['Size'] . "\t" . $object['LastModified'] . "\n";
		// }

		
	//	print_r($obj->body);
		//$obj = $client->get_object('manatdp-dev-data', 'gallery/1643527893_5fc89ea81a2339fa5732.pdf');  
		//header("Content-Type: {$result['ContentType']}");
	//	print_r($obj->body);

		//exit();
		//$objInfo = $client->get_object_headers('manatdp-dev-data', '1643527893_5fc89ea81a2339fa5732.pdf');
	//	$obj = $client->get_object('manatdp-dev-data', '1643527893_5fc89ea81a2339fa5732.pdf');  

	//	header('Content-type: ' . $objInfo->header['_info']['content_type']);
	//	echo $obj->body;


		// foreach ($buckets as $bucket) {
		// 	echo $bucket['Name'] . "\t" . $bucket['CreationDate'] . "\n";
		// }

	}
	



	


}
