<?php 
	namespace App\Models;
	use \CodeIgniter\Model;
	
	class Admin_model extends Model {		
		function __construct()
		{
			// Construct the parent class
			parent::__construct();
			$db = \Config\Database::connect();
		} 

        function insert_record($table,$table_data)
		{
			$builder=$this->db->table($table);
		    $res=$builder->insert($table_data);
			return $this->db->insertID();
		}

			//yellow code here to start
		public function getQueryFromTable($table,$parameters,$order_by){  
			$builder = $this->db->table($table); 
			$builder->select($parameters);
			$builder->where('IsActive','1');			
			$builder->orderBy($order_by,'desc');
			return $query = $builder->get()->getResultArray();;
		}
		//admin quries grid
		public function getQueryFromTableAdmins($table,$parameters,$order_by){ 
			$builder = $this->db->table($table); 
			$builder->select($parameters);		
			$builder->orderBy($order_by,'desc');
			return $query = $builder->get()->getResultArray();;
		}
		public function getQueryFromTableAsc($table,$parameters,$order_by){ 
			$builder = $this->db->table($table);
			$builder->select($parameters);
			//$builder->where('IsActive','1');			
			$builder->orderBy($order_by,'asc');
			return $query = $builder->get()->getResultArray();;
		}

		public function getQueryReultFromTable($table,$where){ 
			$builder = $this->db->table($table);
			$builder->select('*');
			$builder->where($where);	
			return $query = $builder->get()->getResultArray();;
		}
		//get all details from details 
		public function getTable($table){ 
			$builder = $this->db->table($table);
			$builder->select('*');
			return $query = $builder->get()->getResultArray();;
		}

		public function getQueryReultFromTables($table,$where){ 
			$builder = $this->db->table($table);
			$builder->select('*');
			$builder->where($where);
			$builder->orderBy('u_id','desc');	
			return $query = $builder->get()->getResultArray();;
		}

		public function getQueryData(){ 
			$query =$this->db->query("SELECT * FROM users order by u_id desc limit 0,1000");
			return $query->getResultArray(); 
		}
			// program actvity grid
		public function programActivityGrid(){  
			 $query = $this->db->query("SELECT * FROM activity order by activity.ActivityId desc");
			 return $query->getResultArray();
		}

		
		// program actvity by id
		public function programActivityByIdGrid($ActivityId){      
			//return $query = $db->query("SELECT * FROM users;");
			 $query = $this->db->query("select activity.ActivityId,activity.ActivityName,activity.ActivityType,activity.ActivityStatus,activity.TargetCompletionDate,activity.IsActive,activity.CreatedDate,activity.ActivityId, group_concat(activitygroup.GroupName) as ASSIGNEDGROUPS from activity join activitygroup on find_in_set(activitygroup.ActivityGroupId, activity.AssignedGroupsId) where activity.ActivityId='".$ActivityId."'"); 
			 return $query->getRowArray();    
			// return $this->db->getLastQuery();
		}

		public function programActvityForExecutiveDash(){
			$query = $this->db->query("select  SUM(activitystatus.CheckView) as ToatalView,COUNT(activitystatus.ActivityStatuId) as ToatalRecords,activity.ActivityId,activity.ActivityName,activity.ActivityType,activity.ActivityStatus,activity.TargetCompletionDate,activity.CreatedDate,activity.ActivityId from activity join activitystatus on activitystatus.ActivityId=activity.ActivityId group by activity.ActivityId order by activity.ActivityId desc");
			return $query->getResultArray();
		}
		//app users program activity
		public function userProgramActivityGrid($id){  
			// $query = $this->db->query("SELECT * FROM activitystatus where activitystatus.ActivityId='".$id."' group by activitystatus.ActivityId ;"); 
			$query = $this->db->query("select activitystatus.Grade,constituency.ConstituencyName,activity.ActivityId,activity.ActivityName,activity.ActivityType,activity.ActivityStatus,activity.TargetCompletionDate,activity.CreatedDate,activity.ActivityId,users.DisplayName,users.FirstName,users.Mobile,activitystatus.ActivityId,activitystatus.Activity_status as k,activitystatus.UpdatedDate,activitystatus.ActivityStatuId from activity  join activitystatus on activitystatus.ActivityId=activity.ActivityId join users on users.u_id=activitystatus.UserId join constituency on constituency.ConstituencyID=users.ConstituencyId  where activitystatus.ActivityId='".$id."'  group by users.u_id,activitystatus.ActivityId");
			return $query->getResultArray();
		}

		//app users program activity
		public function userProgramActivityCountByStatus($id,$where){ 
			//return $query = $db->query("SELECT * FROM users;");
			 $query = $this->db->query("select activity.ActivityId,activity.ActivityName,activity.ActivityType,activity.ActivityStatus,activity.TargetCompletionDate,activity.CreatedDate,activity.ActivityId,users.FirstName,users.Mobile,activitystatus.ActivityId,activitystatus.Activity_status as k,activitystatus.UpdatedDate,activitystatus.ActivityStatuId, group_concat(activitygroup.GroupName) as ASSIGNEDGROUPS from activity  join activitystatus on activitystatus.ActivityId=activity.ActivityId join users on users.u_id=activitystatus.UserId join activitygroup on find_in_set(activitygroup.ActivityGroupId, activity.AssignedGroupsId) where activitystatus.ActivityId='".$id."' and activitystatus.Activity_status='".$where."'  group by users.u_id,activitystatus.ActivityId");
			 return count($query->getResultArray());	
			// return $builder->countAllResults();
		}

		//get app users data
		public function appUserGrid(){
			$query = $this->db->query("select users.FirstName,users.Mobile,users.Email,activity.ActivityStatus,Status.TargetCompletionDate,activity.CreatedDate,activity.ActivityId, group_concat(activitygroup.GroupName) as ASSIGNEDGROUPS from activity join activitygroup on find_in_set(activitygroup.ActivityGroupId, activity.AssignedGroupsId) group by activity.ActivityId");
			 return $query->getResultArray();
		}
		public function getRowTableById($table,$where_parameter,$where_id){ 
			//$db = \Config\Database::connect();
			$builder=$this->db->table($table); 
			$builder->select('*');      
			$builder->where($where_parameter,$where_id);  
			return $query = $builder->get()->getRowArray();  
			// return $db->getLastQuery();
		}

		public function getRowSelectedParametersTableById($table,$where_parameter,$where_id,$slected_parameter){ 
			//$db = \Config\Database::connect();
			$builder=$this->db->table($table); 
			$builder->select($slected_parameter);      
			$builder->where($where_parameter,$where_id);  
			return $query = $builder->get()->getRowArray();  
			// return $db->getLastQuery();
		}

		public function getRowTableByUserId($table,$where_parameter,$where_id){
			$builder=$this->db->table('users');
            $builder->select('*'); 
            $builder->join('approles', 'approles.AppRoleId = users.AppRoleId');  
			$builder->where('users.u_id',$where_id);  
            return $query = $builder->get()->getRowArray(); 
		}

		public function updateQuery($table,$table_data,$where_parameter,$where_id){		 	
			$builder=$this->db->table($table); 
			$builder->where($where_parameter,$where_id);
			$builder->update($table_data);
			//return	$this->db->getLastQuery();
			return $affected_rows = $this->db->affectedRows();
		}

		//get mandals
		public function getMandalsByConstituency($s){ 
			$builder=$this->db->table('mandals');
            $builder->select('*'); 
            $builder->join('constituency', 'constituency.ConstituencyID = mandals.constituency_id'); 
			$builder->join('parliament', 'parliament.ParliamentID = constituency.ParliamentID'); 
			$builder->where('parliament.ParliamentID',$s);  
            return $query = $builder->get()->getResultArray(); 
		} 

		//get villages 
		public function getMandalsByvillage($s){
			$builder=$this->db->table('mandals');
            $builder->select('*'); 
            $builder->join('constituency', 'constituency.ConstituencyID = mandals.constituency_id'); 
			$builder->join('parliament', 'parliament.ParliamentID = constituency.ParliamentID'); 
			$builder->join('villages', 'villages.mandal_id = mandals.mandal_id'); 
			$builder->where('parliament.ParliamentID',$s);  
            return $query = $builder->get()->getResultArray(); 
		}
		//getUsersByGroupdIds
		public function getUsersByGroupdIds($row){
			$query = $this->db->query("SELECT u_id,ActivityCommitteeGroup FROM users where FIND_IN_SET('".$row."',ActivityCommitteeGroup)");
			 return $query->getResultArray();
		}

		//userProgramCampainingById
		public function userProgramCampainingById_old($id){
			$builder=$this->db->table('activitystatus');
            $builder->select('activitystatus.*,users.*,activity.ActivityName,activity.ActivityType,activity.Instructions,activity.Links,activity.TargetCompletionDate,activity.Points,activity.UploadType,activity.UploadResource,activity.AssignedGroupsId'); 
            $builder->join('activity', 'activity.ActivityId = activitystatus.ActivityId');  
            $builder->join('users', 'users.u_id = activitystatus.userId');  
			$builder->where('activitystatus.ActivityStatuId',$id);  
            return $query = $builder->get()->getRowArray(); 
		}

		public function userProgramCampainingById($id){  
			$query = $this->db->query("SELECT activity.*,activitystatus.*,assignedCampaigns.committeeNameId as committeeNameId,assignedCampaigns.designatedMember as designatedMember,assignedCampaigns.committeeTypeId as committeeTypeId,Group_concat(DISTINCT assigneCampaignsToAff.affiliatedCommitteeId) affiliatedCommitteeIds,Group_concat(DISTINCT assigneCampaignsToDesg.designationId) designationIds,Group_concat(DISTINCT assignedCampaigns.committeeNameId) as committeeNameIdS from activity join activitystatus ON activitystatus.ActivityId=activity.ActivityId  LEFT JOIN assignedCampaigns ON assignedCampaigns.ActivityId=activity.ActivityId LEFT JOIN assigneCampaignsToAff ON assigneCampaignsToAff.ActivityId=activity.ActivityId LEFT JOIN assigneCampaignsToDesg ON assigneCampaignsToDesg.ActivityId=activity.ActivityId  WHERE activitystatus.ActivityStatuId='".$id."' GROUP BY activity.ActivityId,assigneCampaignsToDesg.ActivityId,assigneCampaignsToAff.ActivityId,activitystatus.ActivityStatuId");
			return $query->getRowArray();
		}
		//table rows count 
		public function tableRowsCount($table,$where_data){  
			$builder=$this->db->table($table);
            $builder->select('*'); 
			$builder->where($where_data);
			return $builder->countAllResults();
			//return $this->db->getLastQuery();
		}

		public function tableAllRowsCount($table){
			$builder=$this->db->table($table);
			return $builder->countAll();
		}
		
		public function tableFilterGalleryRowsCount($table,$start,$limit){  
			$builder = $this->db->table('gallery');
			$builder->select('*');
			$builder->orderBy('gallery.GalleryId','desc');
			$builder->limit($limit,$start);
			return $result=$builder->get()->getResultArray(); 
		}

		public function tableFilterUsersRowsCount($table,$start,$limit){   
			$builder = $this->db->table('users');
			$builder->select('*');
			$builder->orderBy('users.u_id','desc');
			$builder->limit($limit,$start);
			return $result=$builder->get()->getResultArray(); 
		}

		public function tableSerchFilterGalleryRowsCount($table,$start,$limit,$query){
			$builder = $this->db->table('gallery');
			$builder->select('*');
			$builder->orLike('GalaryType', $query);
			$builder->orLike('GalleryTitle', $query);
			$builder->orLike('GalaryFileName', $query);
			$builder->orderBy('gallery.GalleryId','desc');
			$builder->limit($limit,$start);
			return $result=$builder->get()->getResultArray(); 
		}
		
		public function tableSerchFilterUsersRowsCount($table,$start,$limit,$query){
			$builder = $this->db->table('users');
			$builder->select('*');
			$builder->orLike('FirstName', $query);
			$builder->orLike('LastName', $query);
			$builder->orLike('MembershipId', $query);
			$builder->orLike('Mobile', $query);
			$builder->orLike('Status', $query);
			$builder->orderBy('users.u_id','desc');
			$builder->limit($limit,$start);
			return $result=$builder->get()->getResultArray(); 
			//echo $this->db->getLastQuery(); 
			
		}
		public function tableSerchFilterUsersRowsCountOnlyCount($table,$query){
			$query = $this->db->query("SELECT COUNT(*) as filterCount
			FROM `users`
			WHERE `FirstName` LIKE '%$query%' ESCAPE '!'
			OR  `LastName` LIKE '%$query%' ESCAPE '!'
			OR  `MembershipId` LIKE '%$query%' ESCAPE '!'
			OR  `Mobile` LIKE '%$query%' ESCAPE '!'
			OR  `Status` LIKE '%$query%' ESCAPE '!'
			ORDER BY `users`.`u_id` DESC");
			return $result_data= $query->getRowArray();
			//echo $this->db->getLastQuery(); 
		}

		//get tasks
		public function getTasks(){    
			$builder=$this->db->table('tasks');
            $builder->select('*,tasks.IsActive as TsIsActive');  
            // $builder->join('approles', 'approles.AppRoleId = tasks.PromoterType'); 
			$builder->orderBy('tasks.TaskId','desc');	
            return $query = $builder->get()->getResultArray(); 
		}

		//get Cadre Listening
		public function getCadreListeningGrid(){
			$builder=$this->db->table('cadrelisteningdetails');
            $builder->select('*,cadrelisteningdetails.IsActive as CdIsActive'); 
            $builder->join('parliament', 'parliament.ParliamentID = cadrelisteningdetails.ParliamentId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = cadrelisteningdetails.ConstituencyId'); 
			$builder->orderBy('cadrelisteningdetails.CadreListeningId','desc');	 
            return $query = $builder->get()->getResultArray(); 
		}

		//admin approve user activity
		public function updateQueryPointsDetails($ActivityStatuId,$userId,$ActivityId){
			$data = [
				'PointStatus' =>'Approved', 
			];
			$builder=$this->db->table('pointsdetails');
			$builder->where('PointFromId',$ActivityStatuId);
			$builder->where('userId',$userId);
			$builder->update($data);

			$query = $this->db->query('SELECT SUM(Points) AS total FROM pointsdetails WHERE PointFromId="'.$ActivityStatuId.'" and userId="'.$userId.'"');
			$result_data= $query->getRowArray();

			$total= $result_data['total'];
			if($total){
				$where_parameter="UserId";
				$where_id=$userId;
				$userPoints=$this->getRowTableById('points',$where_parameter,$where_id);
				if($userPoints){ 
					$query=$this->db->query("UPDATE points SET Points=Points+'".$total."' WHERE UserId='".$userId."'"); 
					$table_data1=['UsersActivityStatus'=>"Approved"];
					$this->updateQuery('activity',$table_data1,'ActivityId',$ActivityId);

					$result="success";
				}else{
				
					$table_data=['UserId'=>$userId,"Points"=>$total];
					$this->insert_record('points',$table_data);

					$table_data1=['UsersActivityStatus'=>"Approved"];
					$this->updateQuery('activity',$table_data1,'ActivityId',$ActivityId);

					$result="success";
				}
				return $result;
			}
		}


		//public function check parliments insert or nont
		public function checkParliament($parliamentName){
				$where_data=['ParliamentName'=>$parliamentName];
				$ParliamentNameCount=$this->tableRowsCount('parliament',$where_data);
				if($ParliamentNameCount){
					$where_parameter="ParliamentName";
					$where_id=$parliamentName;
					$result=$this->getRowTableById('parliament',$where_parameter,$where_id);
					return $result['ParliamentID']; 
				}else{
					$table_data=["ParliamentName"=>$parliamentName];
					return $this->insert_record('parliament',$table_data);
				}
		}

		//constituency insert 
		public function InsertConstituency($ConstituencyData){
			$builder=$this->db->table('constituency');
			return $builder->insertBatch($ConstituencyData);
		}

		//insert child data
		public function InsertChildData($InsertData){
			$builder=$this->db->table('child_campaign');
			return $builder->insertBatch($InsertData);
		}

		//insert marks
		public function InsertMarksData($InsertData){
			$builder=$this->db->table('marks');
			return $builder->insertBatch($InsertData);
		}

		//insert Grade
		public function InsertImportData($table,$InsertData){
			$builder=$this->db->table($table);
			return $builder->insertBatch($InsertData);
		}

		//Get Where In Query
		public function getCommitteeTypes($committeeNameId){ 
		//	$committeeNameIds=[$committeeNameId];
			if(is_array($committeeNameId)){
				$committeeNameId=$committeeNameId;
			}else{
				$committeeNameId=[$committeeNameId];
			}
			$builder=$this->db->table('committeeType');
            $builder->select('*'); 
			$builder->join('committeeName', 'committeeName.committeeNameId = committeeType.committeeNameId'); 
			$builder->where('committeeType.IsActive',1);  
			$builder->whereIn('committeeType.committeeNameId',$committeeNameId);
			 return $query = $builder->get()->getResultArray();  
			//return $this->db->getLastQuery(); 
		}

		//get Desginations
		public function getDesignationIds($committeeNameId){  
			
			if(is_array($committeeNameId)){
				$committeeNameId=$committeeNameId;
			}else{
				$committeeNameId=explode(",",$committeeNameId);
			}
			//$committeeNameId=[$committeeNameId];
			$builder=$this->db->table('designation');
            $builder->select('*'); 
			$builder->join('committeeName', 'committeeName.committeeNameId = designation.committeeNameId'); 
			$builder->where('designation.IsActive',1);  
			$builder->where('designation.affiliatedCommitteeId','0');
			$builder->whereIn('designation.committeeNameId',$committeeNameId);
			return  $query = $builder->get()->getResultArray();  
			//return $this->db->getLastQuery(); 
		}

		
		//get Affiliated Desgnniations
		public function getAffDesignationIds($affiliatedCommitteeId){
			if(is_array($affiliatedCommitteeId)){
				$affiliatedCommitteeId=$affiliatedCommitteeId;
			}else{
				$affiliatedCommitteeId=explode(',',$affiliatedCommitteeId);
			}
			
			$builder=$this->db->table('designation');
            $builder->select('*'); 
			$builder->join('committeeName', 'committeeName.committeeNameId = designation.committeeNameId'); 
			$builder->join('affiliatedCommittees', 'affiliatedCommittees.affiliatedCommitteeId = designation.affiliatedCommitteeId'); 
			$builder->where('designation.IsActive',1);  
			$builder->whereIn('designation.affiliatedCommitteeId',$affiliatedCommitteeId); 
			return $query = $builder->get()->getResultArray();  
			 	//  return $this->db->getLastQuery();
			 
		}
		
		//get Multiple affiliated groyups
		public function getaffiliatedCommitteeIds($committeeTypeId){ 
			if(is_array($committeeTypeId)){
				$committeeTypeId=$committeeTypeId;
			}else{
				$committeeTypeId=[$committeeTypeId];
			}
			$builder=$this->db->table('affiliatedCommittees');
            $builder->select('*'); 
			$builder->join('committeeType', 'committeeType.committeeTypeId = affiliatedCommittees.committeeTypeId'); 
			$builder->join('committeeName', 'committeeName.committeeNameId = committeeType.committeeNameId'); 
			$builder->where('affiliatedCommittees.IsActive',1);  
			$builder->whereIn('affiliatedCommittees.committeeTypeId',$committeeTypeId);
			 return $query = $builder->get()->getResultArray();  
		}
		// get Affiliated Group for SM Task
		public function getSmTaskAffliatedOrMain($committeeTypeName,$committeeNameId){ 
			if(is_array($committeeNameId)){
				$committeeNameId=$committeeNameId;
			}else{
				$committeeNameId=[$committeeNameId];
			}
			$builder=$this->db->table('affiliatedCommittees');
            $builder->select('*,affiliatedCommittees.affiliatedCommitteeId as aff_id'); 
			$builder->join('committeeType', 'committeeType.committeeTypeId = affiliatedCommittees.committeeTypeId'); 
			$builder->join('committeeName', 'committeeName.committeeNameId = committeeType.committeeNameId'); 
			$builder->where('affiliatedCommittees.IsActive',1); 
			$builder->where('committeeType.committeeTypeName',$committeeTypeName);  
			$builder->whereIn('committeeType.committeeNameId',$committeeNameId);
			return $query = $builder->get()->getResultArray();   
		   //return $this->db->getLastQuery();
		} 

		public function getaffliatedCommitteeById($committeeNameId){
			$builder=$this->db->table('committeeName');
            $builder->select('*'); 
			$builder->join('committeeType', 'committeeType.committeeNameId = committeeName.committeeNameId');
			$builder->join('affiliatedCommittees', 'affiliatedCommittees.committeeTypeId = committeeType.committeeTypeId'); 
			$builder->where('committeeName.IsActive',1);  
			$builder->where('committeeType.IsActive',1);  
			$builder->where('committeeName.committeeNameId',$committeeNameId);
			 return $query = $builder->get()->getResultArray();  
		}

		public function getProfileDetails($u_id){ 
			$builder=$this->db->table('users');
            $builder->select('*'); 
            $builder->join('parliament', 'parliament.ParliamentID = users.ParliamentId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = users.ConstituencyId'); 	
			$builder->join('committeeName', 'committeeName.committeeNameId = users.committeeNameId','left'); 		
			$builder->join('constituencyShares', 'constituencyShares.constituencyId = constituency.ConstituencyID','left'); 
			$builder->join('committeeType', 'committeeType.committeeTypeId = users.committeeTypeId','left'); 
			$builder->join('affiliatedCommittees', 'affiliatedCommittees.affiliatedCommitteeId = users.affiliatedCommitteeId','left'); 
			$builder->join('designation', 'designation.designationId = users.designationId','left');

			$builder->where('users.u_id',$u_id);  
            return $query = $builder->get()->getRowArray(); 
		}

		//public function 
		public function programConductedNotConducted($compain_id){ 
			$query = $this->db->query('SELECT parent_campaign_id,campaign_conducted, COUNT(*) as total FROM child_campaign WHERE parent_campaign_id="'.$compain_id.'" GROUP BY campaign_conducted');
			return $result_data= $query->getResultArray();
		}

		//program Conducted Not Conducted By Compain_id
		public function programConductedNotConductedByCompain_id($compain_id){  
			$query = $this->db->query('SELECT ActivityStatuId,ConstituencyProgramConducted, COUNT(*) as total FROM activitystatus WHERE ActivityId="'.$compain_id.'" and ConstituencyProgramConducted !="" GROUP BY ConstituencyProgramConducted order by ConstituencyProgramConducted desc');
			return $result_data= $query->getResultArray();
		}

		public function constituencySubmitedData($compain_id){  
			$query = $this->db->query('SELECT *,users.*,constituency.ConstituencyName FROM activitystatus JOIN users ON users.u_id=activitystatus.UserId JOIN constituency ON constituency.ConstituencyID=users.ConstituencyId WHERE Activity_status="Completed" and ActivityId="'.$compain_id.'" ORDER BY CompletedDate DESC LIMIT 5');
			return $result_data= $query->getResultArray();
		}

		//get data
		public function inchargeParticipatedNotParticipated($compain_id){
			$query = $this->db->query('SELECT Remarks,Mla_Incharge_Participation, COUNT(*) as total FROM child_campaign WHERE Mla_Incharge_Participation IN("YES","NO") and parent_campaign_id="'.$compain_id.'" GROUP BY Mla_Incharge_Participation');
			return $result_data= $query->getResultArray(); 
		}

		public function inchargeParticipatedNotParticipatedByCompain_id($compain_id){
			$query = $this->db->query('SELECT ActivityStatuId,MlaInchargeParticipation, COUNT(*) as total FROM activitystatus WHERE ActivityId="'.$compain_id.'" and MlaInchargeParticipation !="" GROUP BY MlaInchargeParticipation order by MlaInchargeParticipation DESC');
			return $result_data= $query->getResultArray();
		}

		public function CompaingViwedOrNot($compain_id){
			$query = $this->db->query('SELECT CheckView,COUNT(*) as total FROM activitystatus WHERE ActivityId="'.$compain_id.'"  GROUP BY CheckView');
			return $result_data= $query->getResultArray();
		}

		//get Overall Report
		public function ParticipatedAssemblyConstituencies($compain_id){
			$query = $this->db->query('SELECT ConstituencyProgramConducted,COUNT(ConstituencyProgramConducted) as Ac_count FROM activitystatus WHERE ActivityId="'.$compain_id.'" and ConstituencyProgramConducted="Yes"    GROUP BY ActivityId');
			return $result_data= $query->getRowArray();
		}
		//PP Count
		public function PPCount($compain_id){
			$query = $this->db->query('SELECT SUM(NoOfCadreParticipatedCount) as CPC_count,SUM(NeutralPeopleParticipatedCount) as NPC_count FROM activitystatus WHERE ActivityId="'.$compain_id.'" and ConstituencyProgramConducted="Yes"  GROUP BY ActivityId');
			return $result_data= $query->getRowArray();
		}

		//public function 
		public function GradingCount($compain_id){ 
			$query = $this->db->query('SELECT grade,Count(*) as percentage_count FROM activitystatus WHERE ActivityId="'.$compain_id.'" and ConstituencyProgramConducted="Yes"  GROUP BY grade order by grade asc');
			return $result_data= $query->getResultArray();
			//echo $this->db->getLastQuery(); 
			//exit();
		}

		public function NonPCNames($compain_id){
			$builder=$this->db->table('activitystatus');
            $builder->select('*'); 
            $builder->join('users', 'users.u_id = activitystatus.UserId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = users.ConstituencyId'); 
			$builder->where('activitystatus.ActivityId',$compain_id);  
			$builder->where('activitystatus.ConstituencyProgramConducted','No');  
			$builder->groupBy("constituency.ConstituencyID");
			//$builder->groupBy(["constituency.ConstituencyID", "date"]);
            return $query = $builder->get()->getResultArray(); 
		}

		//mal incharge count

		public function compainOrderbyDesc(){
			$query = $this->db->query('SELECT * FROM activity where IsActive="1" ORDER BY ActivityId DESC LIMIT 1');
			return $result_data= $query->getRowArray();
		}

		//get Polls Last
		public function pollsOrderbyDesc(){
			$query = $this->db->query("SELECT * FROM poll WHERE PollsStatus='Publish' ORDER BY p_id DESC LIMIT 1");
			return $result_data= $query->getRowArray();
		}
		
		public function getOptionParectage($poll_id){  
			$query = $this->db->query("SELECT COUNT(*) as totalSubmit,pr_response FROM poll_responses WHERE pr_p_id='".$poll_id."' GROUP BY pr_response order by totalSubmit desc");
			return $result_data= $query->getResultArray();
			//	echo $this->db->getLastQuery(); 
				//exit();

		}
		public function totalUsers(){
			$query = $this->db->query("SELECT COUNT(*) as totalSubmit,pr_response FROM poll_responses WHERE pr_p_id='".$poll_id."' GROUP BY pr_response order by totalSubmit desc");
			return $result_data= $query->getResultArray();
		}
		public function TotalSubmitedCount($poll_id){
			$query = $this->db->query("SELECT COUNT(*) as allSubmitUsers FROM poll_responses WHERE pr_p_id='".$poll_id."'");
			return $result_data= $query->getRowArray();
		}
		public function getAllPolls(){ 
			$query = $this->db->query("SELECT * FROM poll WHERE PollsStatus='Publish' ORDER BY p_id DESC");
			return $result_data= $query->getResultArray();
		}

		public function getAllUsers(){ 
			$query = $this->db->query("SELECT count(*) as totalUsers FROM users where Status='Approved'");
			return $result_data= $query->getRowArray();
		}

		//geyt Assigned Users Poll Count By Poll Id
		public function getAllUsersByGroups($poll_id){     
			$query = $this->db->query("SELECT count(*) as totalUsers FROM notifications where NotificationType='Polls' and FromId='".$poll_id."'");
			return $result_data= $query->getRowArray();
		}

		public function totalPollsSubmitedUsers($poll_id){
			$query = $this->db->query("SELECT count(*) as totalUsersSubmited FROM poll_responses WHERE pr_p_id='".$poll_id."'");
			return $result_data= $query->getRowArray();
			
		}
			
		//yellow code here to start
		public function getQueryFrom($table,$parameters,$order_by){ 
			$builder = $this->db->table($table);
			$builder->select($parameters);			
			$builder->orderBy($order_by,'desc');
			return $query = $builder->get()->getResultArray();;
		}
		//yellow code here to start
		public function getQueryFromPolls($table,$parameters,$order_by){ 
			$builder = $this->db->table($table);
			$builder->select($parameters);	
			$builder->where('PollsStatus','Publish');		
			$builder->orderBy($order_by,'desc');
			return $query = $builder->get()->getResultArray();;
		}

		//get Grading By Compaing Id($compain_id)
		public function getGradingByCompaingId($compain_id){ 
			$query = $this->db->query("select  grade,SUM(activitystatus.Marks) as ToatalMarks,COUNT(activitystatus.ActivityStatuId) as ToatalRecords,activitystatus.ActivityId from activitystatus where grade!='' and ActivityId='".$compain_id."' group by activitystatus.Grade order by activitystatus.Grade asc");
			return $query->getResultArray(); 
		}

		public function getConstencyParliments($compain_id,$grade){
			$builder=$this->db->table('activitystatus');
            $builder->select('*'); 
            $builder->join('users', 'users.u_id = activitystatus.UserId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = users.ConstituencyId'); 
			$builder->join('parliament', 'parliament.ParliamentID = users.ParliamentId'); 
			$builder->where('activitystatus.ActivityId',$compain_id);  
			$builder->where('activitystatus.Grade',$grade); 
			$builder->groupBy("constituency.ConstituencyID");
			//$builder->groupBy(["constituency.ConstituencyID", "date"]);
            return $query = $builder->get()->getResultArray(); 
		}

		//campaign log by id
		public function campaign_log($compain_status_id){
			$builder=$this->db->table('activitystatus');
            $builder->select('users.FirstName as u_name,users.DisplayName,campaign_log.*');   
            $builder->join('users', 'users.u_id = activitystatus.UserId'); 
			$builder->join('campaign_log', 'campaign_log.ActivityStatuId = activitystatus.ActivityStatuId'); 
			$builder->where('activitystatus.ActivityStatuId',$compain_status_id);   
			$builder->orderBy('campaign_log.campaign_log_id','desc');
			//$builder->where('campaign_log.UserType','user'); 
			//$builder->groupBy(["constituency.ConstituencyID", "date"]);
            return $query = $builder->get()->getResultArray(); 
		}


		public function getConstencyParlimentsForIncharges($compain_id,$incharge){
			$builder=$this->db->table('activitystatus');
            $builder->select('*'); 
            $builder->join('users', 'users.u_id = activitystatus.UserId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = users.ConstituencyId'); 
			$builder->join('parliament', 'parliament.ParliamentID = users.ParliamentId'); 
			$builder->where('activitystatus.ActivityId',$compain_id);  
			$builder->where('activitystatus.MlaInchargeParticipation',$incharge); 
			$builder->groupBy("constituency.ConstituencyID");
			return $query = $builder->get()->getResultArray(); 
		}

		public function getConstencyParlimentsForViewd($compain_id,$checkView){
			$builder=$this->db->table('activitystatus');
            $builder->select('*'); 
            $builder->join('users', 'users.u_id = activitystatus.UserId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = users.ConstituencyId'); 
			$builder->join('parliament', 'parliament.ParliamentID = users.ParliamentId'); 
			$builder->where('activitystatus.ActivityId',$compain_id);  
			$builder->where('activitystatus.CheckView',$checkView); 
			$builder->groupBy("constituency.ConstituencyID");
			return $query = $builder->get()->getResultArray(); 
		}

		public function getConstencyParlimentsForPP($compain_id,$ConstituencyProgramConducted){ 
			$builder=$this->db->table('activitystatus');
            $builder->select('*'); 
            $builder->join('users', 'users.u_id = activitystatus.UserId'); 
			$builder->join('constituency', 'constituency.ConstituencyID = users.ConstituencyId'); 
			$builder->join('parliament', 'parliament.ParliamentID = users.ParliamentId'); 
			$builder->where('activitystatus.ActivityId',$compain_id);  
			$builder->where('activitystatus.ConstituencyProgramConducted',$ConstituencyProgramConducted); 
			$builder->groupBy("constituency.ConstituencyID");
			return $query = $builder->get()->getResultArray(); 
		} 
		//table rows count 
		public function tableRowsCountpoll($table){ 
			$builder=$this->db->table($table);
            $builder->select('*'); 
            $builder->groupBy('pr_u_id');
			return $builder->countAllResults();
		}
		public function pollresponse($id){
			$builder=$this->db->table('poll_responses');
            $builder->select('*'); 
            $builder->join('poll','poll.p_id = poll_responses.pr_p_id');
            $builder->join('users','users.u_id = poll_responses.pr_u_id');  
			$builder->where('poll_responses.pr_p_id',$id);  
            return $query = $builder->get()->getResultArray(); 
		}

		//iInsert Ignore
		public function insertIgnore($table,$table_data){ 
			if($this->tableRowsCount($table,$table_data)){
				//return false;
			}else{
				$builder=$this->db->table($table);
				$builder->ignore(true)->insert($table_data);
				return $this->db->insertID();
			}
		}

		//shared details
		public function insertSharedDetails($table,$table_data,$userId,$total){
			$builder=$this->db->table($table);
			$builder->ignore(true)->insert($table_data);
			$result=$this->db->insertID();
			if($result){
				$table_data=["UserId"=>$userId];
				if($this->tableRowsCount('points',$table_data)){					
					$query=$this->db->query("UPDATE points SET Points=Points+'".$total."' WHERE UserId='".$userId."'"); 
				}else{
					$table_data=["UserId"=>$userId,"Points"=>$total];
					$this->insert_record('points',$table_data);
				}
			}
			return $result; 
		}

		//get Committee Type Grid
		public function getCommitteTypeGrid(){ 
			$builder=$this->db->table('committeeType');
            $builder->select('*'); 
            $builder->join('committeeName','committeeName.committeeNameId = committeeType.committeeNameId');  
			$builder->groupBy("committeeType.committeeTypeId");
            return $query = $builder->get()->getResultArray(); 
		}

		// get Desgniation
		public function getDesignationDeatislGrid(){
			$builder=$this->db->table('designation');
            $builder->select('*,designation.CreatedDate as d_CreatedDate,designation.IsActive d_IsActive');  
            $builder->join('committeeName','committeeName.committeeNameId = designation.committeeNameId');  
			$builder->groupBy("designation.designationId");
            return $query = $builder->get()->getResultArray(); 
		}

		// get Alliated Desgniation
		public function getAffliatedDesignationDetailsGrid(){
			$builder=$this->db->table('designation');
            $builder->select('*,designation.CreatedDate as d_CreatedDate,designation.IsActive as d_IsActive,designation.designationId as d_designationId');  
            $builder->join('committeeName','committeeName.committeeNameId = designation.committeeNameId'); 
			$builder->join('affiliatedCommittees','affiliatedCommittees.affiliatedCommitteeId = designation.affiliatedCommitteeId'); 
			$builder->groupBy("designation.designationId");
            return $query = $builder->get()->getResultArray(); 
		}

		public function getAffcommitteeNameDetails($id){
			$builder=$this->db->table('designation');
            $builder->select('*,affiliatedCommittees.committeeTypeId,affiliatedCommittees.affiliatedCommitteeId,committeeName.committeeNameId,designation.CreatedDate as d_CreatedDate,designation.IsActive as d_IsActive,designation.designationId as d_designationId');  
            $builder->join('committeeName','committeeName.committeeNameId = designation.committeeNameId'); 
			$builder->join('affiliatedCommittees','affiliatedCommittees.affiliatedCommitteeId = designation.affiliatedCommitteeId'); 
			$builder->where('designation.designationId',$id); 
			//$builder->where('designation.affiliatedCommitteeId',1); 
            return $query = $builder->get()->getRowArray(); 
		}

		// get Committe Details By Affiliated
		public function getCommitteDetailsByAffiliated(){
			$builder=$this->db->table('committeeType');
            $builder->select('*'); 
            $builder->join('committeeName','committeeName.committeeNameId = committeeType.committeeNameId');  
			$builder->where('committeeType.committeeTypeName','Affiliated'); 
			$builder->groupBy("committeeType.committeeTypeId"); 
            return $query = $builder->get()->getResultArray(); 
		}

		//Affiliated Committes Grid
		public function getAffiliatedCommittesGrid(){
			$builder=$this->db->table('affiliatedCommittees');
            $builder->select('*'); 
            $builder->join('committeeType','committeeType.committeeTypeId = affiliatedCommittees.committeeTypeId');  
			$builder->join('committeeName','committeeName.committeeNameId = committeeType.committeeNameId'); 
			$builder->groupBy("affiliatedCommittees.affiliatedCommitteeId"); 
            return $query = $builder->get()->getResultArray(); 
		}

		public function getTaskDetailsById($id){
			/* $query=$this->query("SELECT *,Group_concat(DISTINCT assignedTasks.committeeNameId) committeeNameIdS,Group_concat(DISTINCT assigneTasksToAff.affiliatedCommitteeId) affiliatedCommitteeIds,Group_concat(DISTINCT assigneTasksToDesg.designationId) designationIds FROM tasks INNER JOIN assignedTasks ON assignedTasks.taskId=tasks.TaskId LEFT JOIN assigneTasksToAff ON assigneTasksToAff.taskId=tasks.TaskId LEFT JOIN assigneTasksToDesg ON assigneTasksToDesg.taskId=tasks.TaskId WHERE tasks.TaskId='".$id."' GROUP BY tasks.TaskId");
            return $result_data= $query->getRowArray(); */

			$query=$this->query("SELECT *,Group_concat(DISTINCT assignedTasks.committeeNameId) committeeNameIdS,Group_concat(DISTINCT assigneTasksToAff.affiliatedCommitteeId) affiliatedCommitteeIds,Group_concat(DISTINCT assigneTasksToDesg.designationId) designationIds FROM tasks LEFT JOIN assignedTasks ON assignedTasks.taskId=tasks.TaskId LEFT JOIN assigneTasksToAff ON assigneTasksToAff.taskId=tasks.TaskId LEFT JOIN assigneTasksToDesg ON assigneTasksToDesg.taskId=tasks.TaskId WHERE tasks.TaskId='".$id."' GROUP BY tasks.TaskId");
            return $result_data= $query->getRowArray();

		}

		public function getPollsById($id){    
			/* $query=$this->query("SELECT *,Group_concat(DISTINCT assignedPolls.committeeNameId) committeeNameIdS,Group_concat(DISTINCT assignePollsToAff.affiliatedCommitteeId) affiliatedCommitteeIds,Group_concat(DISTINCT assignePollsToDesg.designationId) designationIds FROM poll INNER JOIN assignedPolls ON assignedPolls.poll_id=poll.p_id LEFT JOIN assignePollsToAff ON assignePollsToAff.poll_id=poll.p_id LEFT JOIN assignePollsToDesg ON assignePollsToDesg.poll_id=poll.p_id WHERE poll.p_id='".$id."' GROUP BY poll.p_id");
			return $result_data= $query->getRowArray(); */

			$query=$this->query("SELECT *,Group_concat(DISTINCT assignedPolls.committeeNameId) committeeNameIdS,Group_concat(DISTINCT assignePollsToAff.affiliatedCommitteeId) affiliatedCommitteeIds,Group_concat(DISTINCT assignePollsToDesg.designationId) designationIds FROM poll LEFT JOIN assignedPolls ON assignedPolls.poll_id=poll.p_id LEFT JOIN assignePollsToAff ON assignePollsToAff.poll_id=poll.p_id LEFT JOIN assignePollsToDesg ON assignePollsToDesg.poll_id=poll.p_id WHERE poll.p_id='".$id."' GROUP BY poll.p_id");
			return $result_data= $query->getRowArray();

		}

		//get Activity by Id
		public function getActivityById($id){
			$query=$this->query("SELECT activity.*,assignedCampaigns.committeeNameId as committeeNameId,assignedCampaigns.designatedMember as designatedMember,Group_concat(DISTINCT assignedCampaigns.committeeNameId) committeeNameIdS,assignedCampaigns.committeeTypeId as committeeTypeId,Group_concat(DISTINCT assigneCampaignsToAff.affiliatedCommitteeId) affiliatedCommitteeIds,Group_concat(DISTINCT assigneCampaignsToDesg.designationId) designationIds from activity LEFT JOIN assignedCampaigns ON assignedCampaigns.ActivityId=activity.ActivityId LEFT JOIN assigneCampaignsToAff ON assigneCampaignsToAff.ActivityId=activity.ActivityId LEFT JOIN assigneCampaignsToDesg ON assigneCampaignsToDesg.ActivityId=activity.ActivityId  WHERE activity.ActivityId='".$id."' GROUP BY activity.ActivityId,assigneCampaignsToDesg.ActivityId,assigneCampaignsToAff.ActivityId");
            return $result_data= $query->getRowArray();
		}

		//get Users Desgnation No
		public function getCampaignsByGroupDesgNo($designatedMember,$committeeNameId){
			$query=$this->query("SELECT * FROM users WHERE users.designatedMember='".$designatedMember."' AND users.committeeNameId IN($committeeNameId)");  
            return $result_data= $query->getResultArray();
		}

		public function getCampaignsByGroupDesgYesAff($ActivityId,$designatedMember,$committeeNameId,$committeeTypeId,$affiliatedCommitteeIds,$designationIds){ 
			// $query=$this->query("SELECT * FROM users WHERE users.designatedMember='".$designatedMember."' AND users.committeeNameId='".$committeeNameId."' AND users.committeeTypeId='".$committeeTypeId."' AND users.affiliatedCommitteeId In('".$affiliatedCommitteeIds."') and users.designationId In('".$designationIds."') ");
			if(!empty($affiliatedCommitteeIds) && !empty($designationIds)){
				$query=$this->query("SELECT users.u_id,users.device_token,committeeName.*,affiliatedCommittees.*,designation.* FROM users 
				INNER JOIN committeeName ON committeeName.committeeNameId=users.committeeNameId 
				LEFT JOIN affiliatedCommittees ON affiliatedCommittees.affiliatedCommitteeId=users.affiliatedCommitteeId
				LEFT JOIN designation ON designation.designationId=users.designationId 			
				INNER JOIN assignedCampaigns ON assignedCampaigns.committeeNameId=committeeName.committeeNameId
				LEFT JOIN assigneCampaignsToAff ON assigneCampaignsToAff.affiliatedCommitteeId=affiliatedCommittees.affiliatedCommitteeId
				LEFT JOIN assigneCampaignsToDesg ON assigneCampaignsToDesg.designationId=designation.designationId

				LEFT JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId  

				AND assigneCampaignsToAff.affiliatedCommitteeId IN($affiliatedCommitteeIds)			
				AND assigneCampaignsToDesg.designationId IN($designationIds)
				WHERE
				assignedCampaigns.ActivityId='".$ActivityId."'
				AND assignedCampaigns.committeeNameId IN($committeeNameId) 
				AND assignedCampaigns.designatedMember='".$designatedMember."'
				AND assignedCampaigns.committeeTypeId='".$committeeTypeId."'
				AND assignedCampaigns.committeeTypeId='".$committeeTypeId."'
				GROUP BY u_id");
			}elseif(!empty($affiliatedCommitteeIds)){
				$query=$this->query("SELECT users.u_id,users.device_token,committeeName.*,affiliatedCommittees.*,designation.* FROM users 
				INNER JOIN committeeName ON committeeName.committeeNameId=users.committeeNameId 
				LEFT JOIN affiliatedCommittees ON affiliatedCommittees.affiliatedCommitteeId=users.affiliatedCommitteeId
				LEFT JOIN designation ON designation.designationId=users.designationId 			
				INNER JOIN assignedCampaigns ON assignedCampaigns.committeeNameId=committeeName.committeeNameId
				LEFT JOIN assigneCampaignsToAff ON assigneCampaignsToAff.affiliatedCommitteeId=affiliatedCommittees.affiliatedCommitteeId
				LEFT JOIN assigneCampaignsToDesg ON assigneCampaignsToDesg.designationId=designation.designationId

				LEFT JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId 

				AND assigneCampaignsToAff.affiliatedCommitteeId IN($affiliatedCommitteeIds)			
				/* AND assigneCampaignsToDesg.designationId IN($designationIds) */
				WHERE
				assignedCampaigns.ActivityId='".$ActivityId."'
				AND assignedCampaigns.committeeNameId IN($committeeNameId) 
				AND assignedCampaigns.designatedMember='".$designatedMember."'
				AND assignedCampaigns.committeeTypeId='".$committeeTypeId."'
				GROUP BY u_id");
			}elseif(!empty($designationIds)){
				$query=$this->query("SELECT users.u_id,users.device_token,committeeName.*,affiliatedCommittees.*,designation.* FROM users 
				INNER JOIN committeeName ON committeeName.committeeNameId=users.committeeNameId 
				LEFT JOIN affiliatedCommittees ON affiliatedCommittees.affiliatedCommitteeId=users.affiliatedCommitteeId
				LEFT JOIN designation ON designation.designationId=users.designationId 			
				INNER JOIN assignedCampaigns ON assignedCampaigns.committeeNameId=committeeName.committeeNameId
				LEFT JOIN assigneCampaignsToAff ON assigneCampaignsToAff.affiliatedCommitteeId=affiliatedCommittees.affiliatedCommitteeId
				LEFT JOIN assigneCampaignsToDesg ON assigneCampaignsToDesg.designationId=designation.designationId

				LEFT JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId 

				/*	AND assigneCampaignsToAff.affiliatedCommitteeId IN($affiliatedCommitteeIds)		*/	
				AND assigneCampaignsToDesg.designationId IN($designationIds) 
				WHERE
				assignedCampaigns.ActivityId='".$ActivityId."'
				AND assignedCampaigns.committeeNameId IN($committeeNameId) 
				AND assignedCampaigns.designatedMember='".$designatedMember."'
				AND assignedCampaigns.committeeTypeId='".$committeeTypeId."'
				AND committeeType.committeeTypeName='".$committeeTypeId."'
				GROUP BY u_id");
			}else{

			}
			
            return $result_data= $query->getResultArray();
		}
		public function getCampaignsByGroupDesg($ActivityId,$designatedMember,$committeeNameId,$committeeTypeId,$designationIds){
				if($designationIds){
					$query=$this->query("SELECT users.u_id,users.device_token,committeeName.*,designation.* FROM users 
					INNER JOIN committeeName ON committeeName.committeeNameId=users.committeeNameId 
					LEFT JOIN designation ON designation.designationId=users.designationId 			
					INNER JOIN assignedCampaigns ON assignedCampaigns.committeeNameId=committeeName.committeeNameId
					LEFT JOIN assigneCampaignsToDesg ON assigneCampaignsToDesg.designationId=designation.designationId
					
					LEFT JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId 

					AND assigneCampaignsToDesg.designationId IN($designationIds)
					WHERE
					assignedCampaigns.ActivityId='".$ActivityId."'
					AND assignedCampaigns.committeeNameId IN($committeeNameId) 
					AND assignedCampaigns.designatedMember='".$designatedMember."'
					AND assignedCampaigns.committeeTypeId='".$committeeTypeId."'
					AND committeeType.committeeTypeName='".$committeeTypeId."'
					GROUP BY u_id");
				}else{
					$query=$this->query("SELECT users.u_id,users.device_token,committeeName.*,designation.* FROM users 
					INNER JOIN committeeName ON committeeName.committeeNameId=users.committeeNameId 
					LEFT JOIN designation ON designation.designationId=users.designationId 			
					INNER JOIN assignedCampaigns ON assignedCampaigns.committeeNameId=committeeName.committeeNameId
					LEFT JOIN assigneCampaignsToDesg ON assigneCampaignsToDesg.designationId=designation.designationId
					
					LEFT JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId 					
					WHERE
					assignedCampaigns.ActivityId='".$ActivityId."'
					AND assignedCampaigns.committeeNameId IN($committeeNameId) 
					AND assignedCampaigns.designatedMember='".$designatedMember."'
					AND assignedCampaigns.committeeTypeId='".$committeeTypeId."'
					AND committeeType.committeeTypeName='".$committeeTypeId."'
					GROUP BY u_id");
				}  

			
             $result_data= $query->getResultArray(); 
			return $this->db->getLastQuery(); 
		}

		public function getUsersDesgGroup($designatedMember,$committeeNameId,$committeeTypeId,$designationIds){
			if($designationIds){
				$query=$this->query("SELECT * FROM users JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId WHERE users.designationId IN($designationIds) and committeeType.committeeTypeName='".$committeeTypeId."' and designatedMember='".$designatedMember."'");
				$result_data1= $query->getResultArray(); 
				$dsg=array();
				$committeeNameId_array=explode(",",$committeeNameId);
				foreach($result_data1 as $row){
					$dsg[]=$row['committeeNameId'];
				}
				 $committeeNameId_value=array_diff($committeeNameId_array,$dsg);
				
				$result_data2=array();
				if (!empty($committeeNameId_value)) {
					 $committeeNameId=implode(',',$committeeNameId_value); 
					$query=$this->query("SELECT * FROM users JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId WHERE users.committeeNameId IN($committeeNameId)  and  committeeType.committeeTypeName='".$committeeTypeId."' and designatedMember='".$designatedMember."'");
					$result_data2= $query->getResultArray();  
					
				}
				return array_merge($result_data1,$result_data2);
			}else{
				$query=$this->query("SELECT * FROM users JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId WHERE users.committeeNameId IN($committeeNameId)  and  committeeType.committeeTypeName='".$committeeTypeId."' and designatedMember='".$designatedMember."'");
				return $result_data2= $query->getResultArray();  
			}
			//$result_data= $query->getResultArray(); 
			//return $this->db->getLastQuery();  
		}

		//get Affliated Users
		public function getUsersAffDesgGroup($designatedMember,$committeeNameId,$committeeTypeId,$affiliatedCommitteeIds,$designationIds){
			if(!empty($affiliatedCommitteeIds) && !empty($designationIds)){ 
				$query=$this->query("SELECT * FROM users JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId WHERE users.designationId IN($designationIds) and committeeType.committeeTypeName='".$committeeTypeId."' and designatedMember='".$designatedMember."'");
				$result_data1= $query->getResultArray(); 
				//echo $this->db->getLastQuery();
				//echo '<br/>';
				//print_r($result_data1);
				$aff_ids=array();
				$affiliatedCommitteeId_array=explode(",",$affiliatedCommitteeIds);
				foreach($result_data1 as $row){
					$aff_ids[]=$row['affiliatedCommitteeId'];
				}
				//print_r($aff_ids);
				$aff_unique_value=$affiliatedCommitteeId_array;
				if(!empty($aff_ids)){
					$aff_unique_value=array_diff($affiliatedCommitteeId_array,$aff_ids);
				}
				
				//print_r($aff_unique_value);
			//	echo '<br/>';
				$result_data2=array();
				if (!empty($aff_unique_value)){
					$aff_unique_value_str=implode(',',$aff_unique_value); 
					$query=$this->query("SELECT * FROM users JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId WHERE users.affiliatedCommitteeId IN($aff_unique_value_str) and  committeeType.committeeTypeName='".$committeeTypeId."' and designatedMember='".$designatedMember."'");
					$result_data2= $query->getResultArray(); 
				//	echo $this->db->getLastQuery(); 
				}
				
				$comt_ids=array();
				$committeeNameId_array=explode(",",$committeeNameId); 
				foreach($result_data2 as $row){
					$comt_ids[]=$row['committeeNameId'];
				}
				$commt_unique_value=$committeeNameId_array;
				if(!empty($comt_ids)){
					$commt_unique_value=array_diff($committeeNameId_array,$comt_ids);
				}
				
				$result_data3=array();
				if (!empty($commt_unique_value)){ 
					//print_r($commt_unique_value);
					//	echo '<br/>';
					$commt_unique_value_str=implode(',',$commt_unique_value); 
					$query=$this->query("SELECT * FROM users JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId WHERE users.committeeNameId IN($commt_unique_value_str) and users.designationId NOT IN($designationIds) and committeeType.committeeTypeName='".$committeeTypeId."' and designatedMember='".$designatedMember."'");
					$result_data3= $query->getResultArray(); 
					//echo $this->db->getLastQuery();
				}
				//exit();
				return array_merge($result_data1,$result_data2,$result_data3);
			

			}elseif(!empty($affiliatedCommitteeIds)){
				
				$query=$this->query("SELECT * FROM users JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId WHERE users.affiliatedCommitteeId IN($affiliatedCommitteeIds) and  committeeType.committeeTypeName='".$committeeTypeId."' and designatedMember='".$designatedMember."'");
				$result_data2= $query->getResultArray(); 
				$comt_ids=array();
				$committeeNameId_array=explode(",",$committeeNameId);
				foreach($result_data2 as $row){
					$comt_ids[]=$row['committeeNameId'];
				}
				$commt_unique_value=$committeeNameId_array;
				if (!empty($comt_ids)){  
					$commt_unique_value=array_diff($committeeNameId_array,$comt_ids);
				}
			
				$result_data3=array();
				if (!empty($commt_unique_value)){  
					$commt_unique_value_str=implode(',',$commt_unique_value);  
				
					$query=$this->query("SELECT * FROM users JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId WHERE users.committeeNameId IN($commt_unique_value_str) and users.affiliatedCommitteeId NOT IN($affiliatedCommitteeIds) and committeeType.committeeTypeName='".$committeeTypeId."' and designatedMember='".$designatedMember."'");
					$result_data3= $query->getResultArray(); 
				} 
				return array_merge($result_data2,$result_data3);

			}else{
				$query=$this->query("SELECT * FROM users JOIN committeeType ON committeeType.committeeTypeId=users.committeeTypeId WHERE users.committeeNameId IN($committeeNameId)  and  committeeType.committeeTypeName='".$committeeTypeId."' and designatedMember='".$designatedMember."'");
				return $result_data= $query->getResultArray(); 
				//return $this->db->getLastQuery();  
			}
			
		}

		public function getUserByDOB(){ 
			//date(CreatedDate)
			$query=$this->query("select * from users
			where DAY(DOB) = DAY(CURDATE())
			  and MONTH(DOB) = MONTH(CURDATE())"); 
			return  $result_data= $query->getResultArray(); 
			//echo  $this->db->getLastQuery();  
			


		}


		
		
    }
