<?php

namespace App\Models;

use CodeIgniter\Model;

class ApiModel extends Model
{
    function __construct()
    {
        // Construct the parent class
        parent::__construct();
        $db = \Config\Database::connect();
    } 
    function insert_record($table,$table_data)
    {
        $builder=$this->db->table($table);
        $res=$builder->insert($table_data);
        return $this->db->insertID();
    }
    public function getRowTableByIds($table,$where){ 
        //$db = \Config\Database::connect();
        $builder=$this->db->table($table); 
        $builder->select('*');      
        $builder->where($where);
        return $query = $builder->get()->getRowArray(); 
        // return $db->getLastQuery();
    }
    public function getRowTables($table){  
        //$db = \Config\Database::connect();
        $builder=$this->db->table($table); 
        $builder->select('*');  
        return $query = $builder->get()->getRowArray(); 
        // return $db->getLastQuery();
    }

    function get_activity($u_id){        
        $builder=$this->db->table('activitystatus'); 
        $builder->select('activitystatus.*,activity.ActivityName,activity.ActivityType,activity.Instructions,activity.Links,activity.ActivityStatus,activity.TargetCompletionDate,activity.Points,activity.UploadType,activity.UploadResource'); 
        $builder->join('activity', 'activity.ActivityId = activitystatus.ActivityId');  
        $builder->where('activitystatus.UserId',$u_id);
        $builder->where('activity.IsActive',1);  
        $builder->orderBy('activity.ActivityId','desc');
        return $query = $builder->get()->getResult();
    }
    //comman where query
    public function getWhereQuery($table,$where_parameter){ 
        $builder=$this->db->table($table);
        $builder->where($where_parameter);
        return $query = $builder->get()->getResultArray();
    }
    //get comm table group by
    public function getQueryFromTableAsc($table,$parameters,$where_parameter,$order_by,$order_id){  
        $builder = $this->db->table($table);
        $builder->select($parameters);
        $builder->where($where_parameter);			
        $builder->orderBy($order_by,$order_id); 
        return $query = $builder->get()->getResultArray();
       // return  $this->db->getLastQuery();
    }
    public function get_activityById($ActivityStatuId){   
        $builder=$this->db->table('activitystatus'); 
        $builder->select('activitystatus.*,activity.ActivityName,activity.ActivityType,activity.Instructions,activity.Links,activity.ActivityStatus,activity.TargetCompletionDate,activity.Points,activity.UploadType,activity.UploadResource'); 
        $builder->join('activity', 'activity.ActivityId = activitystatus.ActivityId');  
        $builder->where('activitystatus.ActivityStatuId',$ActivityStatuId);
        $builder->where('activity.IsActive',1);
        return $query = $builder->get()->getResultArray();
    }

    public function getRowTableByMobileId($table,$where_parameter,$where_id){
        $builder=$this->db->table('users');
        $builder->select('*'); 
      //  $builder->join('approles','approles.AppRoleId = users.AppRoleId');  
        $builder->where('users.Mobile',$where_id);  
        return $query = $builder->get()->getRowArray(); 
    }

    public function getTasksByGroupIds($SelectedGroups,$group_ids){
            $builder=$this->db->table('tasks');
            $builder->select('*,tasks.IsActive as idac'); 
           // $builder->join('approles', 'approles.AppRoleId = tasks.PromoterType'); 
            $builder->join('activitygroup', 'activitygroup.ActivityGroupId = tasks.SelectedGroups'); 
            foreach($group_ids as $value)
            {
                $builder->orwhere('find_in_set("'.$value.'", SelectedGroups) <> 0');
                $builder->where('tasks.IsActive',1);    
            }           
			$builder->orderBy('tasks.TaskId','desc');	
            return  $query = $builder->get()->getResultArray();
           // return $this->db->getLastQuery();
    }

    //get all user sm task
    public function getTasksByGroupIdsNew($SelectedGroups,$group_ids){ 
        $builder=$this->db->table('tasks');
        $builder->select('*,tasks.IsActive as idac'); 
       // $builder->join('approles', 'approles.AppRoleId = tasks.PromoterType'); 
        $builder->join('activitygroup', 'activitygroup.ActivityGroupId = tasks.SelectedGroups'); 
        $builder->where('tasks.IsActive',1);  
        foreach($group_ids as $value)
        { 
            $builder->orwhere('find_in_set("'.$value.'", SelectedGroups) <> 0');
           //$builder->orwhere('tasks.IsActive',1);   
        }
    //    $builder->where('tasks.IsActive',1);   
        $builder->orderBy('tasks.TaskId','desc');	
        $query = $builder->get()->getResultArray();
      //  return $this->db->getLastQuery();
        $result_data=array();
        $result_data1=array();
        foreach($group_ids as $value)
        {      
          //  $this->db->query('SELECT  * FROM tasks WHERE FIND_IN_SET("$value",SelectedGroups) and IsActive=1');
            $query=$this->db->query('SELECT  * FROM tasks WHERE FIND_IN_SET("'.$value.'",SelectedGroups) and IsActive="1"');
            $result_datasss= $query->getResultArray();
             
          // $s[]= array_merge($result_data,$result_datasss);
           array_push($result_data1,$result_datasss);
        }       
      
      //  array_merge($a1,$a2)
        return $result_data1;  
        //return 	$result_data; 
    }

    //total count tasks
    public function getCountTasksByGroupIds_old($SelectedGroups,$group_ids){   
        

        $builder=$this->db->table('tasks');
        $builder->select('*,tasks.IsActive as idac'); 
        $builder->join('activitygroup', 'activitygroup.ActivityGroupId = tasks.SelectedGroups'); 
        foreach($group_ids as $value)
        { 
            $builder->orwhere('find_in_set("'.$value.'", SelectedGroups) <> 0');
            $builder->where('tasks.IsActive',1);  
        }
       
        $builder->orderBy('tasks.TaskId','desc');	
         // $query = $builder->get()->getResultArray();
        //return $this->db->getLastQuery();
       return $builder->countAllResults(); 
    }

    public function getCountTasksByGroupIds($designatedMember,$committeeNameId,$committeeTypeId,$designationId,$affiliatedCommitteeId,$UserId){
        if($committeeNameId == '0'){ 
            $query=$this->db->query("SELECT * FROM tasks t1 WHERE NOT EXISTS (SELECT t2.taskId FROM assignedTasks t2 WHERE t1.TaskId = t2.taskId)"); 
           
        }else{
            if($designatedMember == "No"){
            // $query=$this->db->query("SELECT tasks.* FROM tasks JOIN assignedTasks ON assignedTasks.taskId=tasks.TaskId WHERE assignedTasks.designatedMember='No' AND tasks.IsActive='1' AND assignedTasks.committeeNameId='".$committeeNameId."' ORDER BY tasks.TaskId DESC");

            $query=$this->db->query("SELECT * FROM tasks LEFT JOIN assignedTasks as AT ON AT.taskId=tasks.TaskId    WHERE AT.committeeNameId=".$committeeNameId." AND tasks.IsActive='1'  AND NOT EXISTS (SELECT t2.SharedFromId FROM ShareDetails t2 WHERE tasks.TaskId = t2.SharedFromId and t2.SharedFrom='smtasks' and  t2.UserId=".$UserId.") ORDER BY tasks.TaskId DESC");   

            }else{
                if($affiliatedCommitteeId=="0"){   
                // $query=$this->db->query("SELECT tasks.* FROM tasks JOIN assignedTasks ON assignedTasks.taskId=tasks.TaskId JOIN  assigneTasksToDesg ON assigneTasksToDesg.taskId=tasks.TaskId WHERE assignedTasks.designatedMember='Yes'   AND tasks.IsActive='1' AND assignedTasks.committeeNameId='".$committeeNameId."' AND assigneTasksToDesg.designationId='".$designationId."' ORDER BY tasks.TaskId");

                    $query=$this->db->query("SELECT * FROM tasks LEFT JOIN assignedTasks as AT ON AT.taskId=tasks.TaskId 
                    LEFT JOIN assigneTasksToDesg as AD ON AD.taskId=tasks.TaskId 
                    WHERE AT.committeeNameId='".$committeeNameId."' 
                    AND tasks.IsActive='1'
                    AND AT.committeeTypeId='Main' 
                    AND NOT EXISTS (SELECT t2.SharedFromId FROM ShareDetails t2 WHERE tasks.TaskId = t2.SharedFromId and t2.SharedFrom='smtasks' and  t2.UserId=".$UserId.")
                    AND(AD.designationId='".$designationId."' OR AD.designationId is NULL) ORDER BY tasks.TaskId DESC");
                    
                }else{   

                    //  $query=$this->db->query("SELECT tasks.* FROM tasks JOIN assignedTasks ON assignedTasks.taskId=tasks.TaskId JOIN  assigneTasksToDesg ON assigneTasksToDesg.taskId=tasks.TaskId   JOIN  assigneTasksToAff ON assigneTasksToAff.taskId=tasks.TaskId  WHERE assignedTasks.designatedMember='Yes'   AND tasks.IsActive='1' AND assignedTasks.committeeNameId='".$committeeNameId."' AND assigneTasksToAff.affiliatedCommitteeId='".$affiliatedCommitteeId."' AND assigneTasksToDesg.designationId='".$designationId."' ORDER BY tasks.TaskId"); 

                    $query=$this->db->query("SELECT * FROM tasks LEFT JOIN assignedTasks as AT ON AT.taskId=tasks.TaskId 
                    LEFT JOIN assigneTasksToAff AS AFF ON AFF.taskId=tasks.TaskId 
                    LEFT JOIN assigneTasksToDesg as AD ON AD.taskId=tasks.TaskId 
                    WHERE AT.committeeNameId='".$committeeNameId."' 
                    AND tasks.IsActive='1'
                    AND AT.committeeTypeId='Affiliated' 
                    AND NOT EXISTS (SELECT t2.SharedFromId FROM ShareDetails t2 WHERE tasks.TaskId = t2.SharedFromId and t2.SharedFrom='smtasks' and  t2.UserId=".$UserId.")
                    AND(AD.designationId='".$designationId."' OR AD.designationId is NULL)
                    AND( AFF.affiliatedCommitteeId='".$affiliatedCommitteeId."' OR AFF.affiliatedCommitteeId is NULL) ORDER BY tasks.TaskId DESC");

                }
                
            } 
        } 
        return $result_data= Count($query->getResultArray());  
        //echo $this->db->getLastQuery();  
        //exit();
        

    }
    //Old SM Tasks Submitted Count
    public function getOldSmTaskCount($UserId){ 
        $query=$this->db->query("SELECT * FROM tasks t1 INNER JOIN ShareDetails ON ShareDetails.SharedFromId=t1.TaskId WHERE NOT EXISTS (SELECT t2.taskId FROM assignedTasks t2 WHERE t1.TaskId = t2.taskId) AND ShareDetails.SharedFrom='smtasks' and ShareDetails.UserId=".$UserId." GROUP BY ShareDetails.SharedFromId ORDER BY `TaskId` ");
        return $result_data= Count($query->getResultArray());  
    }

    //Old Polls Submitted Count
    public function getOldPollCount($UserId){ 
        $query=$this->db->query("SELECT * FROM poll t1 INNER JOIN poll_responses ON poll_responses.pr_p_id=t1.p_id WHERE NOT EXISTS (SELECT t2.poll_id FROM assignedPolls t2 WHERE t1.p_id = t2.poll_id) AND  poll_responses.pr_u_id=".$UserId." GROUP BY poll_responses.pr_p_id");
        return $result_data= Count($query->getResultArray());  
    }
    
    //delete table record
    public function deleteRecord($table,$where_data){
        $builder=$this->db->table($table);
        $builder->where($where_data);
        return $builder->delete();
    }

    //get sum likes feed 
    public function getNewsFeedLikesCount($NewsFeedId){ 
        $query = $this->db->query('SELECT SUM(NewsFeedId) AS total_likes FROM newsfeedlikes WHERE NewsFeedId="'.$NewsFeedId.'"');
        return $result_data= $query->getRowArray();
    }

    //non constencey cadre listenin bu constency id
    public function getNonConstCadreListeningList($ConstituencyId){
        
        $ConstituencyId = [$ConstituencyId];
        $builder=$this->db->table('cadrelisteningdetails');
        $builder->whereNotIn('ConstituencyId', $ConstituencyId);
        return  $query = $builder->get()->getResultArray();
    }

    //get polls
    public function getPolls($UserId){     
        //$UserId=[$UserId];
        //$db = \Config\Database::connect();
            $builder=$this->db->table('poll');
            $builder->select('*');  
            $builder->join('poll_responses','poll_responses.pr_p_id = poll.p_id','left');    
            $builder->where('poll_responses.pr_u_id',$UserId); 
            $builder->where('poll.PollsStatus',"Publish");  
          //  $builder->groupBy("poll_responses.pr_p_id");  
          return  $query = $builder->get()->getResultArray(); 
     //   return $db->getLastQuery(); 
       // return $UserId;
    }
    public function sqlMode(){  
        //$this->db->query("SET GLOBAL sql_mode=(SELECT CONCAT(@@sql_mode, ',ONLY_FULL_GROUP_BY'))");
    }
    public function getPollsById($p_id){
        
       // $p_id = [$p_id];
        $builder=$this->db->table('poll'); 
        $builder->where('poll.PollsStatus',"Publish");
        $builder->whereNotIn('poll.p_id',$p_id);
        return  $query = $builder->get()->getResultArray();
    } 
    public function getPollsByGroups1($p_id,$designatedMember,$committeeNameId,$committeeTypeId,$designationId,$affiliatedCommitteeId){
        $p_id=implode(',',$p_id);
        if($committeeNameId == '0'){
            $query=$this->db->query("SELECT * FROM poll t1 WHERE NOT EXISTS (SELECT t2.poll_id FROM assignedPolls t2 WHERE t1.p_id = t2.poll_id) AND t1.PollsStatus='Publish' AND t1.p_id NOT IN($p_id)");
        }else{       
        if($designatedMember == "No"){
            // $query=$this->db->query("SELECT tasks.* FROM tasks JOIN assignedTasks ON assignedTasks.taskId=tasks.TaskId WHERE assignedTasks.designatedMember='No' AND tasks.IsActive='1' AND assignedTasks.committeeNameId='".$committeeNameId."' ORDER BY tasks.TaskId DESC");
 
          $query=$this->db->query("SELECT * FROM poll INNER JOIN assignedPolls as AP ON AP.poll_id=poll.p_id    WHERE AP.committeeNameId='".$committeeNameId."' AND poll.PollsStatus='Publish' AND poll.p_id NOT IN($p_id)");
 
         }else{
             if($affiliatedCommitteeId=="0"){ 
                // $query=$this->db->query("SELECT tasks.* FROM tasks JOIN assignedTasks ON assignedTasks.taskId=tasks.TaskId JOIN  assigneTasksToDesg ON assigneTasksToDesg.taskId=tasks.TaskId WHERE assignedTasks.designatedMember='Yes'   AND tasks.IsActive='1' AND assignedTasks.committeeNameId='".$committeeNameId."' AND assigneTasksToDesg.designationId='".$designationId."' ORDER BY tasks.TaskId");
 
                 $query=$this->db->query("SELECT * FROM poll INNER JOIN assignedPolls as AP ON AP.poll_id=poll.p_id 
                 LEFT JOIN assignePollsToDesg as AD ON AD.poll_id=poll.p_id 
                 WHERE AP.committeeNameId='".$committeeNameId."' 
                 AND poll.PollsStatus='Publish'
                 AND AP.committeeTypeId='Main' 
                 AND(AD.designationId='".$designationId."' OR AD.designationId is NULL) AND poll.p_id NOT IN($p_id)");
                 
             }else{   
                
                 $query=$this->db->query("SELECT * FROM poll INNER JOIN assignedPolls as AP ON AP.poll_id=poll.p_id 
                 LEFT JOIN assignePollsToAff AS AFF ON AFF.poll_id=poll.p_id 
                 LEFT JOIN assignePollsToDesg as AD ON AD.poll_id=poll.p_id 
                 WHERE AP.committeeNameId='".$committeeNameId."' 
                 AND poll.PollsStatus='Publish'
                 AND AP.committeeTypeId='Affiliated'   
                 AND(AD.designationId='".$designationId."' OR AD.designationId is NULL)
                 AND( AFF.affiliatedCommitteeId='".$affiliatedCommitteeId."' OR AFF.affiliatedCommitteeId is NULL) AND poll.p_id NOT IN($p_id)");
 
             }
             
             } 
            }
          return $result_data= $query->getResultArray(); 
        // echo $this->db->getLastQuery(); 
         //exit();
    }

    public function getPollsByUsers($UserId){      
        //$UserId=[$UserId];
        //$db = \Config\Database::connect();
            $builder=$this->db->table('poll');
            $builder->select('*');  
            $builder->join('poll_responses','poll_responses.pr_p_id = poll.p_id','left');   
            $builder->orwhere('poll_responses.pr_u_id',$UserId); 
            $builder->where('poll.PollsStatus',"Publish");    
          //  $builder->groupBy("poll_responses.pr_p_id");  
          return  $query = $builder->get()->getResultArray(); 
     //   return $db->getLastQuery(); 
       // return $UserId;
    }

    //get compaign summery b user id
    public function getCompaingCountByUserId($UserId){ 
        $query = $this->db->query('SELECT Activity_status,COUNT(*) as total FROM activitystatus join activity on activity.ActivityId=activitystatus.ActivityId   WHERE UserId="'.$UserId.'" and activity.IsActive="1" GROUP BY activitystatus.Activity_status');   
		return $result_data= $query->getResultArray(); 
        //return $this->db->getLastQuery(); 
    } 

    //get Polls
    public function getPollsTotal($designatedMember,$committeeNameId,$committeeTypeId,$designationId,$affiliatedCommitteeId){
        /*
        $builder=$this->db->table('poll');
        $builder->select('*'); 
        $builder->where('poll.PollsStatus','Publish');
		return $builder->countAllResults(); */
        if($committeeNameId == '0'){ 
            $query=$this->db->query("SELECT * FROM poll t1 WHERE NOT EXISTS (SELECT t2.poll_id FROM assignedPolls t2 WHERE t1.p_id = t2.poll_id) AND t1.PollsStatus='Publish' ORDER BY t1.p_id DESC ");
        }else{
        if($designatedMember == "No"){
            // $query=$this->db->query("SELECT tasks.* FROM tasks JOIN assignedTasks ON assignedTasks.taskId=tasks.TaskId WHERE assignedTasks.designatedMember='No' AND tasks.IsActive='1' AND assignedTasks.committeeNameId='".$committeeNameId."' ORDER BY tasks.TaskId DESC");
 
          $query=$this->db->query("SELECT * FROM poll INNER JOIN assignedPolls as AP ON AP.poll_id=poll.p_id    WHERE AP.committeeNameId='".$committeeNameId."' AND poll.PollsStatus='Publish' AND NOT EXISTS (SELECT t2.poll_id FROM assignedPolls t2 WHERE poll.p_id = t2.poll_id)  ORDER BY poll.p_id DESC"); 
 
         }else{
             if($affiliatedCommitteeId=="0"){  
                // $query=$this->db->query("SELECT tasks.* FROM tasks JOIN assignedTasks ON assignedTasks.taskId=tasks.TaskId JOIN  assigneTasksToDesg ON assigneTasksToDesg.taskId=tasks.TaskId WHERE assignedTasks.designatedMember='Yes'   AND tasks.IsActive='1' AND assignedTasks.committeeNameId='".$committeeNameId."' AND assigneTasksToDesg.designationId='".$designationId."' ORDER BY tasks.TaskId");
 
                 $query=$this->db->query("SELECT * FROM poll INNER JOIN assignedPolls as AP ON AP.poll_id=poll.p_id 
                 LEFT JOIN assignePollsToDesg as AD ON AD.poll_id=poll.p_id 
                 WHERE AP.committeeNameId='".$committeeNameId."' 
                 AND poll.PollsStatus='Publish'
                 AND AP.committeeTypeId='Main' 
                 AND NOT EXISTS (SELECT t2.pr_p_id FROM poll_responses t2 WHERE poll.p_id = t2.pr_p_id)
                 AND(AD.designationId='".$designationId."' OR AD.designationId is NULL) ORDER BY poll.p_id DESC");
                 
             }else{    
                 $query=$this->db->query("SELECT * FROM poll INNER JOIN assignedPolls as AP ON AP.poll_id=poll.p_id 
                 LEFT JOIN assignePollsToAff AS AFF ON AFF.poll_id=poll.p_id 
                 LEFT JOIN assignePollsToDesg as AD ON AD.poll_id=poll.p_id 
                 WHERE AP.committeeNameId='".$committeeNameId."' 
                 AND poll.PollsStatus='Publish'
                 AND AP.committeeTypeId='Affiliated'  
                 AND NOT EXISTS (SELECT t2.pr_p_id FROM poll_responses t2 WHERE poll.p_id = t2.pr_p_id)
                 AND(AD.designationId='".$designationId."' OR AD.designationId is NULL)
                 AND( AFF.affiliatedCommitteeId='".$affiliatedCommitteeId."' OR AFF.affiliatedCommitteeId is NULL) ORDER BY poll.p_id DESC");
 
             }
             
         } 
        }
           return $result_data=count($query->getResultArray());  
         // echo $this->db->getLastQuery(); 
        //  exit();
    }
    //getPollsResponseTotal
    public function getPollsResponseTotal($UserId){         
        $builder=$this->db->table('poll_responses');
        $builder->select('*'); 
        $builder->where('poll_responses.pr_u_id',$UserId);  
        $builder->groupBy('poll_responses.pr_p_id');
		return $builder->countAllResults();
    }
    //get sm task shared count user
    public function getSharedSmTasks($UserId){  
        $builder=$this->db->table('ShareDetails');
        $builder->select('*'); 
        $builder->where('ShareDetails.SharedFrom','smtasks');  
        $builder->where('ShareDetails.UserId',$UserId); 
        $builder->groupBy('SharedFrom');
        $builder->groupBy('SharedFromId');
		return $builder->countAllResults();
    }
    //mobile dashbord 
    public function getSharedSmMobileDashTasks($UserId){   
        $builder=$this->db->table('ShareDetails');
        $builder->select('*'); 
        $builder->where('ShareDetails.SharedFrom','smtasks');  
        $builder->where('ShareDetails.UserId',$UserId); 
        // $builder->groupBy('SharedFrom'); 
        // $builder->groupBy('SharedFromId');
        $builder->groupBy('SharedFromId');    
		return $builder->countAllResults(); 

    }

    public function getConstituencySharedCount($ConstituencyId){
        $builder=$this->db->table('users');
        $builder->select('*'); 
        $builder->join('ShareDetails', 'ShareDetails.UserId = users.u_id'); 
        $builder->where('users.ConstituencyId',$ConstituencyId);  
        return $builder->countAllResults(); 
        
    }

    public function getConstituencySharedCountByUser($u_id){
      //  $query = $this->db->query('SELECT COUNT(*) as total_shares FROM ShareDetails WHERE UserId="'.$u_id.'"  GROUP BY UserId');
		//return $result_data= $query->getResultArray(); 

        $builder=$this->db->table('ShareDetails');
        $builder->select('*'); 
        $builder->where('UserId',$u_id);   
        return $builder->countAllResults(); 
    }

    public function getConstituencyPointsCount($ConstituencyId){
        $query = $this->db->query('SELECT SUM(Points) AS total_points FROM points join users on users.u_id=points.UserId WHERE  users.ConstituencyId="'.$ConstituencyId.'"');
        return $result_data= $query->getRowArray(); 
    }

    public function getRankInsates(){ 
        $query=$this->db->query('SELECT
        UserId,
        Points,
        RANK () OVER ( 
        ) price_rank 
        FROM
        points');
        return $result_data= $query->getRowArray(); 
    }
    public function getRankInsateUser(){
   
       
        $query=$this->db->query('SELECT userId,points, DENSE_RANK() OVER ( ORDER BY points DESC) rank_no, RANK() OVER ( ORDER BY points DESC) my_rank FROM points');   
        return $result_data= $query->getResultArray();   

       // return $this->db->getLastQuery(); 
    }
    public function getRankInsateForLeaderBord(){   
        
      //  $query=$this->db->query('SELECT SUM(points.Points) as p,users.ConstituencyId,points.userId,points.points, DENSE_RANK() OVER ( ORDER BY SUM(points.Points) DESC) rank_no, RANK() OVER ( ORDER BY SUM(points.Points) DESC) my_rank FROM points join users on users.u_id=points.UserId join constituency on constituency.ConstituencyID=  users.ConstituencyId Group by constituency.ConstituencyId');   
       // $query=$this->db->query('SELECT constituency.ConstituencyId,constituency.ConstituencyName,COUNT(*) as totalshares,SUM(points.Points) as p,users.ConstituencyId,points.userId,points.points, DENSE_RANK() OVER ( ORDER BY points.Points DESC) rank_no FROM points join users on users.u_id=points.UserId join constituency on constituency.ConstituencyID= users.ConstituencyId JOIN ShareDetails ON ShareDetails.UserId=points.UserId Group by constituency.ConstituencyId');

        $query=$this->db->query('SELECT constituency.ConstituencyId,constituency.ConstituencyName,points.Points as p,users.ConstituencyId,points.userId,points.points, DENSE_RANK() OVER ( ORDER BY points.Points DESC) rank_no FROM points join users on users.u_id=points.UserId join constituency on constituency.ConstituencyID= users.ConstituencyId JOIN ShareDetails ON ShareDetails.UserId=points.UserId Group by constituency.ConstituencyId'); 

        return $result_data= $query->getResultArray();   

        //echo $this->db->getLastQuery(); 
       //exit();
    }

    //get user by costituency
    public function getUsersByConstituencyIdPoints_old($ConstituencyId){
        $builder=$this->db->table('users');
        $builder->select('*'); 
        $builder->join('constituency','constituency.ConstituencyID = users.ConstituencyId');  
        $builder->join('points','points.UserId = users.u_id','left');  
        $builder->where('users.ConstituencyId',$ConstituencyId);          
        $builder->orderBy('points.Points','desc');
        return $query = $builder->get()->getResultArray(); 
    }

    public function getUsersByConstituencyIdPoints($ConstituencyId,$ParliamentId,$pageNumber,$pageSize){       
        //$query=$this->db->query("SELECT users.*, SUM(points.Points) as p,users.ConstituencyId,points.userId,points.Points,users.FirstName, DENSE_RANK() OVER ( ORDER BY SUM(points.Points) DESC) rank_no, RANK() OVER ( ORDER BY SUM(points.Points) DESC) my_rank FROM points join users on users.u_id=points.UserId join constituency on constituency.ConstituencyID=  users.ConstituencyId where users.ConstituencyId IN($ConstituencyId) Group by users.u_id");     
        //return $result_data= $query->getResultArray();   

        if($ConstituencyId){ 

           // $query=$this->db->query("SELECT users.*,constituency.*,parliament.*, SUM(points.Points) as p,users.ConstituencyId,points.userId,points.Points,users.FirstName, DENSE_RANK() OVER ( ORDER BY SUM(points.Points) DESC) rank_no FROM users  left join points on users.u_id=points.UserId join constituency on constituency.ConstituencyID=  users.ConstituencyId join parliament on parliament.ParliamentID=  users.ParliamentId  where users.ParliamentId IN($ParliamentId) and users.ConstituencyId IN($ConstituencyId) Group by users.u_id");   
             
            $query=$this->db->query("SELECT users.u_id,users.FirstName,users.LastName,users.ProfileImage,constituency.*,parliament.*, points.Points as p,users.ConstituencyId,points.userId,points.Points,users.FirstName, DENSE_RANK() OVER ( ORDER BY points.Points DESC) rank_no FROM users  left join points on users.u_id=points.UserId join constituency on constituency.ConstituencyID=  users.ConstituencyId join parliament on parliament.ParliamentID=  users.ParliamentId  where users.ParliamentId IN($ParliamentId) and users.ConstituencyId IN($ConstituencyId)  LIMIT ".$pageNumber.",".$pageSize."");   

        }else{
           // $query=$this->db->query("SELECT users.*,constituency.*, SUM(points.Points) as p,users.ConstituencyId,points.userId,points.Points,users.FirstName, DENSE_RANK() OVER ( ORDER BY SUM(points.Points) DESC) rank_no FROM users  left join points on users.u_id=points.UserId join constituency on constituency.ConstituencyID=  users.ConstituencyId join parliament on parliament.ParliamentID=  users.ParliamentId where users.ParliamentId IN($ParliamentId) Group by users.u_id");   
            
            $query=$this->db->query("SELECT users.FirstName,users.LastName,users.ProfileImage,constituency.*,points.Points as p,users.ConstituencyId,points.userId,points.Points,users.FirstName, DENSE_RANK() OVER ( ORDER BY points.Points DESC) rank_no FROM users  left join points on users.u_id=points.UserId join constituency on constituency.ConstituencyID=  users.ConstituencyId join parliament on parliament.ParliamentID=  users.ParliamentId where users.ParliamentId IN($ParliamentId)  LIMIT ".$pageNumber.",".$pageSize."");     

        } 
        return $result_data= $query->getResultArray();   
    }

    //get ALl Users
    public function getAllUsersByPoints($pageNumber,$pageSize){  
        $query=$this->db->query("SELECT users.u_id,users.FirstName,users.LastName,users.ProfileImage, points.Points as p,users.ConstituencyId,points.userId,points.Points,users.FirstName, DENSE_RANK() OVER ( ORDER BY points.Points DESC) rank_no FROM users  left join points on users.u_id=points.UserId  Group by users.u_id LIMIT ".$pageNumber.",".$pageSize."");
         return $result_data= $query->getResultArray();  
      // echo $this->db->getLastQuery(); 
       //exit();
    }

    public function getConstituencyIdPointsShares($pageNumber,$pageSize){   
      // $query=$this->db->query("SELECT constituency.ConstituencyId,constituency.ConstituencyName,COUNT(*) as totalshares,points.Points as p,users.ConstituencyId,points.userId,points.points, DENSE_RANK() OVER ( ORDER BY points.Points DESC) rank_id FROM points join users on users.u_id=points.UserId join constituency on constituency.ConstituencyID= users.ConstituencyId Group by constituency.ConstituencyId limit $pageNumber,$pageSize");

      $query=$this->db->query("SELECT constituency.ConstituencyId,constituency.ConstituencyName,COUNT(distinct  ShareDetails.ShareDetailId) as totalshares,points.Points as p,users.ConstituencyId,points.userId,SUM(distinct points.points) as points,  DENSE_RANK() OVER ( ORDER BY points.Points DESC) rank_id FROM points join users on users.u_id=points.UserId join constituency on constituency.ConstituencyID= users.ConstituencyId join ShareDetails ON ShareDetails.UserId=users.u_id Group by constituency.ConstituencyId limit $pageNumber,$pageSize"); 
		return $result_data= $query->getResultArray();   

       // return $this->db->getLastQuery();
    }

    public function getFeedsForApp1($UserId){
       $query=$this->db->query("SELECT newsfeed.*,COUNT(distinct  ShareDetails.ShareDetailId) as ShareCount,COUNT(distinct  nfl2.NewsFeedId) as isLiked,COUNT(distinct  nfl.NewsFeedLikeId) as newdFeedLikesCount,COUNT(distinct  ViewsCheck.VCId) as TotalViews,COUNT(distinct  ViewsCheck_1.VCId) as CheckView FROM newsfeed LEFT JOIN ShareDetails ON ShareDetails.SharedFromId=newsfeed.NewsFeedId AND ShareDetails.SharedFrom='feeds' LEFT JOIN newsfeedlikes as nfl ON  nfl.NewsFeedId=newsfeed.NewsFeedId LEFT JOIN newsfeedlikes as nfl2 ON  nfl2.NewsFeedId=newsfeed.NewsFeedId and nfl2.UserId='".$UserId."'  LEFT JOIN ViewsCheck ON ViewsCheck.ViewFromId=newsfeed.NewsFeedId AND ViewsCheck.ViewFrom='feeds' LEFT JOIN ViewsCheck as ViewsCheck_1 ON ViewsCheck_1.ViewFromId=newsfeed.NewsFeedId AND ViewsCheck_1.ViewFrom='feeds' and ViewsCheck_1.UserId='".$UserId."' WHERE newsfeed.IsActive='1'
       GROUP BY ShareDetails.SharedFromId order by newsfeed.NewsFeedId desc");
       return $result_data= $query->getResultArray();  

    }

    public function getFeedsById($NewsFeedId,$UserId){ 
        $query=$this->db->query("SELECT newsfeed.*,COUNT(distinct  ShareDetails.ShareDetailId) as ShareCount,COUNT(distinct  nfl2.NewsFeedId) as isLiked,COUNT(distinct  nfl.NewsFeedLikeId) as newdFeedLikesCount,COUNT(distinct  ViewsCheck.VCId) as TotalViews,COUNT(distinct  ViewsCheck_1.VCId) as CheckView FROM newsfeed LEFT JOIN ShareDetails ON ShareDetails.SharedFromId=newsfeed.NewsFeedId AND ShareDetails.SharedFrom='feeds' LEFT JOIN newsfeedlikes as nfl ON  nfl.NewsFeedId=newsfeed.NewsFeedId LEFT JOIN newsfeedlikes as nfl2 ON  nfl2.NewsFeedId=newsfeed.NewsFeedId and nfl2.UserId='".$UserId."'  LEFT JOIN ViewsCheck ON ViewsCheck.ViewFromId=newsfeed.NewsFeedId AND ViewsCheck.ViewFrom='feeds' LEFT JOIN ViewsCheck as ViewsCheck_1 ON ViewsCheck_1.ViewFromId=newsfeed.NewsFeedId AND ViewsCheck_1.ViewFrom='feeds' and ViewsCheck_1.UserId='".$UserId."' WHERE newsfeed.IsActive='1'
        and newsfeed.NewsFeedId='".$NewsFeedId."' GROUP BY ShareDetails.SharedFromId order by newsfeed.NewsFeedId desc");
        return $result_data= $query->getRowArray();  

    }

    //get galley for app
    public function getGalleryForApp($UserId){
        $query=$this->db->query("SELECT gallery.*,COUNT(distinct ShareDetails.ShareDetailId) as ShareCount,COUNT(distinct gallerylikes.GallerylikeId) as GalleryLikesCount,COUNT(distinct gl1.GallerylikeId) as isLiked FROM gallery  LEFT JOIN ShareDetails ON ShareDetails.SharedFromId=gallery.GalleryId AND ShareDetails.SharedFrom='gallery' LEFT JOIN gallerylikes ON gallerylikes.GalleryId=gallery.GalleryId LEFT JOIN gallerylikes as gl1 ON gl1.GalleryId=gallery.GalleryId AND gl1.UserId='".$UserId."' WHERE gallery.IsActive='1' GROUP BY gallery.GalleryId ORDER BY gallery.GalleryId DESC ");
        return $result_data= $query->getResultArray();  
    }

    //get sm task by id
    public function getSmTaskByIdApp($TaskId){ 
        $query=$this->db->query("SELECT tasks.*,COUNT(distinct  ShareDetails.ShareDetailId) as ShareCount,COUNT(distinct  ViewsCheck.VCId) as totalviews FROM tasks LEFT JOIN ShareDetails ON ShareDetails.SharedFromId=tasks.TaskId AND ShareDetails.SharedFrom='smtasks' LEFT JOIN ViewsCheck ON ViewsCheck.ViewFromId=tasks.TaskId AND ViewsCheck.ViewFrom='smtasks' WHERE tasks.TaskId='".$TaskId."' GROUP BY tasks.TaskId");
        return $result_data= $query->getRowArray(); 
    }

        //new code 01-03-2022
    public function getResulDataForApp($table,$order_by,$where,$pageNumber,$pageSize){  
        $builder = $this->db->table($table);
        $builder->select('*');
        $builder->where($where);	
        $builder->orderBy($order_by,'desc');
        if($pageNumber == 0){
            $builder->limit(10,0);
        }else{
            $builder->limit($pageSize,$pageNumber);
        }
      
        return $query = $builder->get()->getResultArray();
       // echo $this->db->getLastQuery();  
      //  exit();
    }
    //get share count by id
    public function shareCountById($SharedFrom,$SharedFromId){
        $query=$this->db->query("SELECT COUNT(*) as ShareCount FROM ShareDetails WHERE SharedFrom='".$SharedFrom."' AND SharedFromId='".$SharedFromId."'");
        return $result_data= $query->getRowArray(); 
        
    }

    //Views Count By Task Id 
    public function SmtaskViewsCountById($ViewFrom,$TaskId){
        $query=$this->db->query("SELECT COUNT(*) as totalviews FROM ViewsCheck WHERE ViewFrom='".$ViewFrom."' AND ViewFromId='".$TaskId."'");
        return $result_data= $query->getRowArray();  
        
    }

    //view Count by News Feed
    public function FeedViewsCountById($ViewFrom,$NewsFeedId){
        $query=$this->db->query("SELECT COUNT(*) as TotalViews FROM ViewsCheck WHERE ViewFrom='".$ViewFrom."' AND ViewFromId='".$NewsFeedId."'");
        return $result_data= $query->getRowArray();  
    }


    //News feed likes count by id
    public function likesCountById($NewsFeedId){
        $query=$this->db->query("SELECT COUNT(*) as newdFeedLikesCount FROM newsfeedlikes WHERE NewsFeedId='".$NewsFeedId."'");
        return $result_data= $query->getRowArray(); 
        
    }

   

    //share feeds update the tables
    public function shareCountUpdateFeeds($NewsFeedId,$ShareCount){    
        $query=$this->db->query("UPDATE newsfeed SET ShareCount=ShareCount+'".$ShareCount."' WHERE NewsFeedId='".$NewsFeedId."'"); 
    }

    //likes feeds count update
    public function likesCountUpdateFeeds($NewsFeedId,$LikeCount){    
        $query=$this->db->query("UPDATE newsfeed SET newdFeedLikesCount=newdFeedLikesCount+'".$LikeCount."' WHERE NewsFeedId='".$NewsFeedId."'"); 
    }

     //news feed degrade count
     public function likesCountDegradeUpdateFeeds($NewsFeedId,$LikeCount){
        $query=$this->db->query("UPDATE newsfeed SET newdFeedLikesCount=newdFeedLikesCount-'".$LikeCount."' WHERE NewsFeedId='".$NewsFeedId."'");
    }
    //share count sm task
    public function shareCountUpdateSmTask($TaskId,$ShareCount){
        $query=$this->db->query("UPDATE tasks SET ShareCount=ShareCount+'".$ShareCount."' WHERE TaskId='".$TaskId."'"); 
    }

    //sm task Total Views Update
    public function  viewsCountUpdateSmTask($TaskId,$totalviews){
        $query=$this->db->query("UPDATE tasks SET totalviews=totalviews+'".$totalviews."' WHERE TaskId='".$TaskId."'"); 
    }
    public function viewsCountUpdateNewsFeed($NewsFeedId,$TotalViews){ 
        $query=$this->db->query("UPDATE newsfeed SET TotalViews=TotalViews+'".$TotalViews."' WHERE NewsFeedId='".$NewsFeedId."'"); 
    }
    public function viewsCountUpdateEpaper($EpaperId,$TotalViews){
        $query=$this->db->query("UPDATE epaper SET TotalViews=TotalViews+'".$TotalViews."' WHERE EpaperId='".$EpaperId."'"); 
    }
    //GALLERY
    //============================================
     //likes Gallery count update
    public function likesCountUpdateGallery($GalleryId,$LikeCount){    
        $query=$this->db->query("UPDATE gallery SET GalleryLikesCount=GalleryLikesCount+'".$LikeCount."' WHERE GalleryId='".$GalleryId."'"); 
    }

    //likes Gallery count degrade
    public function likesCountDegradeUpdateGallery($GalleryId,$LikeCount){       
        $query=$this->db->query("UPDATE gallery SET GalleryLikesCount=GalleryLikesCount-'".$LikeCount."' WHERE GalleryId='".$GalleryId."'"); 
    } 
     //share count Gallery'
     public function shareCountUpdateGallery($GalleryId,$ShareCount){
        $query=$this->db->query("UPDATE gallery SET ShareCount=ShareCount+'".$ShareCount."' WHERE GalleryId='".$GalleryId."'"); 
    } 
     //gallerylikes count
     public function GallerylikesCountById($GalleryId){
        $query=$this->db->query("SELECT COUNT(*) as GalleryLikesCount FROM gallerylikes WHERE GalleryId='".$GalleryId."'");
        return $result_data= $query->getRowArray(); 
        
    } 

    //get Groups wise tasks 
    public function getTasksByGroups($designatedMember,$committeeNameId,$committeeTypeId,$designationId,$affiliatedCommitteeId,$pageNumber,$pageSize){ 
        
        if($committeeNameId == '0'){ 
            $query=$this->db->query("SELECT * FROM tasks t1 WHERE NOT EXISTS (SELECT t2.taskId FROM assignedTasks t2 WHERE t1.TaskId = t2.taskId) t1.TaskId DESC LIMIT ".$pageNumber.",".$pageSize.""); 
           
        }else{
        if($designatedMember == "No"){

         $query=$this->db->query("SELECT * FROM tasks INNER JOIN assignedTasks as AT ON AT.taskId=tasks.TaskId    WHERE AT.committeeNameId='".$committeeNameId."' AND tasks.IsActive='1' ORDER BY tasks.TaskId DESC LIMIT ".$pageNumber.",".$pageSize."");

        }else{
            if($affiliatedCommitteeId=="0"){ 

                $query=$this->db->query("SELECT * FROM tasks INNER JOIN assignedTasks as AT ON AT.taskId=tasks.TaskId 
                LEFT JOIN assigneTasksToDesg as AD ON AD.taskId=tasks.TaskId 
                WHERE AT.committeeNameId='".$committeeNameId."' 
                AND tasks.IsActive='1'
                AND AT.committeeTypeId='Main' 
                AND(AD.designationId='".$designationId."' OR AD.designationId is NULL) ORDER BY tasks.TaskId DESC LIMIT $pageNumber,$pageSize");
                 
            }else{   
                $query=$this->db->query("SELECT * FROM tasks INNER JOIN assignedTasks as AT ON AT.taskId=tasks.TaskId 
                LEFT JOIN assigneTasksToAff AS AFF ON AFF.taskId=tasks.TaskId 
                LEFT JOIN assigneTasksToDesg as AD ON AD.taskId=tasks.TaskId 
                WHERE AT.committeeNameId='".$committeeNameId."' 
                AND tasks.IsActive='1'
                AND AT.committeeTypeId='Affiliated' 
                AND(AD.designationId='".$designationId."' OR AD.designationId is NULL)
                AND( AFF.affiliatedCommitteeId='".$affiliatedCommitteeId."' OR AFF.affiliatedCommitteeId is NULL) ORDER BY tasks.TaskId DESC LIMIT ".$pageNumber.",".$pageSize."");

            } 
            
         }
        } 
          return $result_data= $query->getResultArray();

    }
    
    public function getPollsByGroups($designatedMember,$committeeNameId,$committeeTypeId,$designationId,$affiliatedCommitteeId){
        if($committeeNameId == '0'){
            $query=$this->db->query("SELECT * FROM poll t1 WHERE NOT EXISTS (SELECT t2.poll_id FROM assignedPolls t2 WHERE t1.p_id = t2.poll_id) AND t1.PollsStatus='Publish' ORDER BY t1.p_id DESC ");
        }else{
        if($designatedMember == "No"){
            // $query=$this->db->query("SELECT tasks.* FROM tasks JOIN assignedTasks ON assignedTasks.taskId=tasks.TaskId WHERE assignedTasks.designatedMember='No' AND tasks.IsActive='1' AND assignedTasks.committeeNameId='".$committeeNameId."' ORDER BY tasks.TaskId DESC");
 
          $query=$this->db->query("SELECT * FROM poll INNER JOIN assignedPolls as AP ON AP.poll_id=poll.p_id    WHERE AP.committeeNameId='".$committeeNameId."' AND poll.PollsStatus='Publish' ORDER BY poll.p_id DESC"); 
 
         }else{
             if($affiliatedCommitteeId=="0"){ 
                // $query=$this->db->query("SELECT tasks.* FROM tasks JOIN assignedTasks ON assignedTasks.taskId=tasks.TaskId JOIN  assigneTasksToDesg ON assigneTasksToDesg.taskId=tasks.TaskId WHERE assignedTasks.designatedMember='Yes'   AND tasks.IsActive='1' AND assignedTasks.committeeNameId='".$committeeNameId."' AND assigneTasksToDesg.designationId='".$designationId."' ORDER BY tasks.TaskId");
 
                 $query=$this->db->query("SELECT * FROM poll INNER JOIN assignedPolls as AP ON AP.poll_id=poll.p_id 
                 LEFT JOIN assignePollsToDesg as AD ON AD.poll_id=poll.p_id 
                 WHERE AP.committeeNameId='".$committeeNameId."' 
                 AND poll.PollsStatus='Publish'
                 AND AP.committeeTypeId='Main' 
                 AND(AD.designationId='".$designationId."' OR AD.designationId is NULL) ORDER BY poll.p_id DESC");
                 
             }else{   
                 $query=$this->db->query("SELECT * FROM poll INNER JOIN assignedPolls as AP ON AP.poll_id=poll.p_id 
                 LEFT JOIN assignePollsToAff AS AFF ON AFF.poll_id=poll.p_id 
                 LEFT JOIN assignePollsToDesg as AD ON AD.poll_id=poll.p_id 
                 WHERE AP.committeeNameId='".$committeeNameId."' 
                 AND poll.PollsStatus='Publish'
                 AND AP.committeeTypeId='Affiliated'  
                 AND(AD.designationId='".$designationId."' OR AD.designationId is NULL)
                 AND( AFF.affiliatedCommitteeId='".$affiliatedCommitteeId."' OR AFF.affiliatedCommitteeId is NULL) ORDER BY poll.p_id DESC");
 
             }
             
         } 
        }
         return $result_data= $query->getResultArray(); 
        // echo $this->db->getLastQuery(); 
      //   exit();
    }

    public function getNotificationByUserIds($UserId,$todayDate){   
        $query=$this->db->query("SELECT * FROM notifications WHERE date(CreatedDate)='".$todayDate."' and NotificationUserId='".$UserId."' order by NotificationId desc");
        return $result_data= $query->getResultArray();  
    }

    public function getNotificationCountByUserId($UserId,$todayDate){    
        $query=$this->db->query("SELECT * FROM notifications WHERE date(CreatedDate)='".$todayDate."' and NotificationUserId='".$UserId."' and readPoll='0' order by NotificationId desc");
        return $result_data= $query->getResultArray();  
    }

    public function getPointsWiseRanks(){
        $query=$this->db->query("SELECT * FROM `pointsRanks` ORDER BY `pointsRanks`.`Points` DESC");
        return $result_data= $query->getResultArray();  
    }

    //get Epaper List
    public function getEpaperListForApp(){  
        $query=$this->db->query("SELECT * FROM epaper WHERE file_date > NOW() - INTERVAL 30 DAY AND IsActive='1' ORDER BY `epaper`.`file_date` DESC");
        return $result_data= $query->getResultArray();  
    }

    public function getLiveNewsFeed(){
        $query=$this->db->query("SELECT * FROM `newsfeed` WHERE live='Yes' and IsActive='1' ORDER by NewsFeedId desc LIMIT 1 ");
        return $result_data= $query->getRowArray(); 
    }

    public function getUserStateRanking(){
        $query=$this->db->query("SELECT users.u_id,users.FirstName,users.LastName,users.ProfileImage,constituency.*,parliament.*, points.Points as p,users.ConstituencyId,points.userId,points.Points,users.FirstName, DENSE_RANK() OVER ( ORDER BY points.Points DESC) rank_no FROM users  left join points on users.u_id=points.UserId join constituency on constituency.ConstituencyID=  users.ConstituencyId join parliament on parliament.ParliamentID=  users.ParliamentId");   
        return $result_data= $query->getResultArray();  
    }

    


    
}
