<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php')) {
    require SYSTEMPATH . 'Config/Routes.php';
}

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------  
 */

$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Admin'); 
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Admin::index');

$myroutes=[];



$myroutes['login']='Admin::login';
$myroutes['logout']='Admin::logout';
$myroutes['Program-Campaign']='Admin::ProgramActivity'; 
$myroutes['Add-Program-Campaign']='Admin::AddProgramActivity';
$myroutes['Update-Program-Campaining']='Admin::UpdateProgramActivity';
$myroutes['User-Program-Campaining/(:num)']='Admin::AppUserProgramActivity/$1'; 
$routes->get('user-program-campaining-edit/(:num)/(:num)', 'Admin::userProgramActivityEdit/$1/$2'); 
$routes->get('user-program-campaining-view/(:num)/(:num)', 'Admin::userProgramActivityView/$1/$2');
// $routes->get('User-Update-Program-Activity', 'Admin::userUpdateProgramActivity');  
$myroutes['User-Update-Program-Activity']='Admin::userUpdateProgramActivity';

//$myroutes['ExecutiveReports']='Admin::ExecutiveReports';

$myroutes['Reports']='Admin::Reports'; 
$myroutes['Thumb']='Admin::Thumb'; 


$myroutes['Demo']='Admin::demo';
$routes->get('Demo1', 'Admin::demo');
//$routes->get('Tasks', 'Admin::getTasks');
$routes->get('Roles', 'Admin::getRoles');
$routes->get('Permissions', 'Admin::getPermissions');

//Feeds
$myroutes['Feeds']='Admin::Feeds'; 
$myroutes['Add-Feed']='Admin::AddFeed';
$myroutes['UpdateFeed']='Admin::UpdateFeed';
$myroutes['feed-edit/(:num)']='Admin::feedEdit/$1';
$myroutes['feed-view/(:num)']='Admin::feedView/$1';
$routes->get("feed-details-view/(:any)", "Admin::feedDetailsView/$1");  

//E-Paper
$myroutes['E-Paper']='Admin::ePaper'; 
$myroutes['Add-E-Paper']='Admin::addEPaper';
$myroutes['Update-E-Paper']='Admin::updateEPaper';
$myroutes['E-Paper-edit/(:num)']='Admin::ePaperEdit/$1';
$myroutes['E-Paper-DetailsViewiew/(:num)']='Admin::ePaperView/$1';

//DOB-Notifications
$myroutes['DOB-Notifications']='Admin::DOBNotifications'; 

//SM Tasks      
$myroutes['Tasks']='Admin::smTasks';  
$myroutes['Add-Task']='Admin::addSmTask';
$myroutes['Update-Task']='Admin::updateSmTask';
$myroutes['Task-edit/(:num)']='Admin::smTaskEdit/$1';
$myroutes['Task-view/(:num)']='Admin::smTaskView/$1';

//Gallery
$myroutes['Gallery']='Admin::gallery';  
$myroutes['Add-Gallery']='Admin::addGallery';
$myroutes['Update-Gallery']='Admin::updateGallery';
$myroutes['Gallery-edit/(:num)']='Admin::galleryEdit/$1';
$myroutes['Gallery-view/(:num)']='Admin::galleryView/$1';
$routes->get("get-leaders", "Admin::get_leaders"); 

//cadrelistening
$myroutes['Cadre-Listening']='Admin::cadreListening';  
$myroutes['Add-Cadre-Listening']='Admin::addCadreListening';
$myroutes['Update-Cadre-Listening']='Admin::updateCadreListening';
$myroutes['Cadre-Listening-edit/(:num)']='Admin::cadreListeningEdit/$1';
$myroutes['Cadre-Listening-view/(:num)']='Admin::cadreListeningView/$1';

//NPO
$myroutes['NPO']='Admin::NPO';  
$myroutes['Add-NPO']='Admin::addNPO';
$myroutes['Update-Cadre-Listening']='Admin::updateCadreListening';
$myroutes['npo-edit/(:num)']='Admin::npoEdit/$1';
$myroutes['npo-view/(:num)']='Admin::npoView/$1';


//Polls
$myroutes['Polls']='Admin::Polls'; 
$myroutes['Add-Polls']='Admin::AddPolls'; 
$myroutes['UpdatePolls']='Admin::UpdatePolls';
$myroutes['Polls-edit/(:num)']='Admin::pollsEdit/$1';
$myroutes['Polls-resluts/(:num)']='Admin::pollreslut/$1'; 

//Committee
$myroutes['Committee']='Admin::Committee'; 
$myroutes['Add-Committee']='Admin::addCommittee'; 
$myroutes['Update-Committee']='Admin::updateCommittee';
$myroutes['Committee-edit/(:num)']='Admin::committeeEdit/$1';
$myroutes['Committee-view/(:num)']='Admin::committeeView/$1';

//Committee Type 
$myroutes['Committee-Type']='Admin::committeeType'; 
$myroutes['Add-Committee-Type']='Admin::addCommitteeType'; 
$myroutes['Update-Committee-Type']='Admin::updateCommitteeType';
$myroutes['Committee-Type-edit/(:num)']='Admin::committeeTypeEdit/$1';
$myroutes['Committee-Type-view/(:num)']='Admin::committeeTypeView/$1'; 

//Affiliated
$myroutes['Affiliated-Committees']='Admin::affiliatedCommittees'; 
$myroutes['Add-Affiliated-Committee']='Admin::addAffiliatedCommittee'; 
$myroutes['Update-Affiliated-Committee']='Admin::updateAffiliatedCommittee'; 
$myroutes['Affiliated-Committee-edit/(:num)']='Admin::affiliatedCommitteeEdit/$1';
$myroutes['Affiliated-Committee-view/(:num)']='Admin::affiliatedCommitteeView/$1'; 

//Desgniations 
$myroutes['Designations']='Admin::Designation'; 
$myroutes['Add-Designation']='Admin::addDesignation'; 
$myroutes['Update-Designation']='Admin::updateDesignation'; 
$myroutes['Designation-edit/(:num)']='Admin::designationEdit/$1';
$myroutes['Designation-view/(:num)']='Admin::designationView/$1'; 

//Affiliated Designations 
$myroutes['AffDesignations']='Admin::AffDesignations'; 
$myroutes['Add-Aff-Designation']='Admin::addAffDesignations'; 
$myroutes['Update-Aff-Designation']='Admin::updateAffDesignations'; 
$myroutes['Aff-Designation-edit/(:num)']='Admin::AffDesignationEdit/$1';
$myroutes['Aff-Designation-view/(:num)']='Admin::AffDesignationView/$1'; 

//Executive reports '
$myroutes['PerfomanceSummary']='Admin::PerfomanceSummary';
$myroutes['AppHealthReport']='Admin::AppHealthReport';
$myroutes['ComapaignSummary']='Admin::ExecutiveReports';
$myroutes['PollReport']='Admin::PollReport';
 

//Corin Jobs
$routes->get('CronJobs', 'CronJobs::index');


$routes->get('program-campaining-edit/(:num)', 'Admin::programActivityEdit/$1');
$routes->get('program-campaining-view/(:num)', 'Admin::viewProgramActivity/$1'); 
$routes->get("get-app-users", "Admin::getAppUsers"); 
$routes->get("app-user-edit/(:num)/(:num)", "Admin::appUserEdit/$1/$2");  
$routes->get("app-user-edit/(:num)/(:num)/(:any)", "Admin::appUserEdit/$1/$2/$3");
$routes->get("app-user-edit/(:num)", "Admin::appUserEdit/$1"); 
$routes->get("get-ajax-data", "Admin::action");
$routes->get("get-ajax-roles", "Admin::get_roles");  
//$routes->post("get-ajax-roles", "Admin::get_roles");
$routes->get("get_perctage_by_data", "Admin::get_perctage_by_data");

$routes->get("userCampaignApprove", "Admin::userCampaignApprove");  
$routes->get("RecordPublishUnPublish", "Admin::RecordPublishUnPublish"); 
$routes->get("RecordApprovedReject", "Admin::RecordApprovedReject"); 
$routes->post("generateImg", "Admin::generateImg"); 
$routes->post("Update-App-User","Admin::updateAppUser");
$routes->get("get-app-users/(:any)", "Admin::getAppUsers/$1"); 

//get Gallery Response
$routes->get("getGalleryManagemntAjax", "Admin::getGalleryManagemntAjax");
$routes->post("getUserManagemntAjax", "Admin::getUserManagemntAjax"); 
$routes->get("test_ajax", "Admin::test_ajax");  

$routes->get("get_constituency_data", "Admin::get_constituency_data_ajax");
$routes->get("get_constituency_data_for_incharge", "Admin::get_constituency_data_for_incharge");
$routes->get("get_constituency_data_for_Viewd", "Admin::get_constituency_data_for_Viewd");
$routes->get("get_constituencies_for_pp", "Admin::get_constituencies_for_pp"); 

//Compiagn log
$routes->get("get_compaign_log", "Admin::get_compaign_log_ajax");

//Voter Module Urls
$routes->get("Voter-Management", "Voter::index");
$routes->get("Voter-Report", "Voter::voterReport"); //Voter Report
$routes->get("get-ajax-data-voter", "Voter::getAjaxDataVoter");
$routes->get("voter-view/(:any)", "Voter::voterView/$1"); 
//$routes->post("Update-App-User","Admin::updateAppUser");

//FB Pages
//$routes->post("FB-Details", "Admin::FBSharesCount"); 
$myroutes['FB-Details']='Admin::FBSharesCount'; 
$routes->get("FB-Details/(:any)", "Admin::FBSharesCount/$1"); 
$myroutes['FB-Analytics']='Admin::FB_Analytics'; 
$myroutes['FB-Analytics/(:any)']='Admin::FB_Analytics/$1'; 
$myroutes['FB-Analytics-Parent']='Admin::FB_Analytics_Parent'; 
$myroutes['FB-Analytics-Parent/(:any)']='Admin::FB_Analytics_Parent/$1';  


$routes->get("get_const_parli_list", "Admin::get_const_parli_list");



$routes->group("Api", function($routes) {    
   // $routes->post('registers','Api::register');        
    $routes->post('privacyPolicy','Api::privacyPolicy'); 
    $routes->post('login','Api::login');
    $routes->post("profile", "Api::profile");   
    $routes->get("master_data_details", "Api::masterData");
    $routes->post("register", "Api::test");   
    $routes->post("getActivityDetails", "Api::getActivity"); 
    $routes->post("otpLogin", "Api::otpLogin");  
    $routes->post("sendOtp", "Api::sendOtp"); 
    $routes->post("verifiedOtp", "Api::verifiedOtp"); 
    $routes->post("changePassword", "Api::changePassword"); 
    $routes->post("profileUpdate", "Api::userUpdate");
    $routes->post("getActivityDetailsById", "Api::getActivityById"); 
    $routes->post("UpdateActivity", "Api::updateUserActivity");  

    $routes->post("getFeedList", "Api::getFeeds"); 
    $routes->post("getFeedDetailsById", "Api::getFeedById");

    $routes->post("getEPapaerList", "Api::getEpaper");  
    $routes->post("getSmTaskList", "Api::getSmList");
    $routes->post("getSmTaskDetailsById", "Api::getSmTaskDetailsById");

    //Gallery List
    $routes->post("getGalleryList", "Api::getGalleryList"); 
    $routes->post("getGalleryLeaders", "Api::getGalleryLeaders"); 
    $routes->post("getGalleryLeaderById", "Api::getGalleryLeaderById"); 
    $routes->post("getEventsList", "Api::getEventsList");
    $routes->post("getEventsGalleryByType", "Api::getEventsGalleryByType");
    $routes->post("getRecentlyGalleryByType", "Api::getRecentlyGalleryByType"); 
    $routes->post("getTrendingGalleryByType", "Api::getTrendingGalleryByType");
    $routes->post("getGalleryFileById", "Api::getGalleryFileById"); 
    $routes->post("getMediaCornerMoreGallery", "Api::getMediaCornerMoreGallery"); 
    $routes->post("getEventsGalleryMoreByType", "Api::getEventsGalleryMoreByType"); 
    $routes->post("getRecommendedGallery", "Api::getRecommendedGallery"); 
    $routes->post("getEventList", "Api::getEventList"); 
    $routes->post("getEventsCompaignList", "Api::getEventsCompaignList"); 
    $routes->post("getGalleryImagesLeaderById", "Api::getGalleryImagesLeaderById"); 
    $routes->post("getMediaCornerGallery", "Api::getMediaCornerGallery");
    $routes->post("getAllGalleryByType", "Api::getAllGalleryByType"); 
   


   // $routes->post("getSmTaskDetailsById", "Api::getSmTaskDetailsById");
    $routes->post("userActivityFilesUploads", "Api::userActivityFilesUploads");
    $routes->post("getCadreListeningList", "Api::getCadreListeningList");
    $routes->post("userProfileUpdate", "Api::userProfileUpdate"); 

    $routes->post("newsFeedLikesPost", "Api::newsFeedLikesPost"); 
    $routes->post("getNewdFeedLikes", "Api::getNewdFeedLikes"); 
    $routes->post("galleryLikesPost", "Api::galleryLikesPost");
    
    $routes->get("getPolls", "Api::getPolls");
    $routes->post("Pollresponse", "Api::Pollresponse");

    $routes->post("deleteProgramActivityFile", "Api::deleteProgramActivityFile");
    $routes->post("CheckView", "Api::CheckView");
    $routes->post("ShareDetails", "Api::ShareDetails");

    $routes->post("getDashboardDetails", "Api::getDashboardDetails");
    $routes->post("getUsersByConstituencyIdPoints", "Api::getUsersByConstituencyIdPoints");
    $routes->post("getConstituencySharesPoints", "Api::getConstituencySharesPoints"); 
    $routes->post("getNotificationByUserId", "Api::getNotificationByUserId");
    $routes->post("getNotificationsCount", "Api::getNotificationsCount");
    $routes->post("getPointsWiseRanks", "Api::getPointsWiseRanks");
    $routes->post("getAppDetails", "Api::getAppDetails");
    $routes->post("getCommitteNames", "Api::getCommitteNames");
    $routes->post("getCommitteNamesNew", "Api::getCommitteNamesNew");
    $routes->get("testFcm", "Admin::testFcm"); 
    $routes->get("liveNews", "Api::liveNews");  
    $routes->get("getUrls", "Api::getUrls"); 
    $routes->post("userShareCount", "Api::userShareCount"); 
    $routes->post("constituencyShareCount", "Api::constituencyShareCount");
    $routes->post("getUserStateRankingPoints", "Api::getUserStateRankingPoints");
    $routes->post("getUserConstituencyRankingPoints", "Api::getUserConstituencyRankingPoints");

    $routes->post("getGalleryDocumentsList", "Api::getGalleryDocumentsList");
    $routes->post("addNPO", "Api::addNPO"); 
    $routes->post("getNPODetails", "Api::getNPODetails");
    $routes->post("getNPODetailsById", "Api::getNPODetailsById");
    $routes->post("articalStatusUpdate", "Api::articalStatusUpdate");
    $routes->post("userCurentAddressUpdate", "Api::userCurentAddressUpdate");

    $routes->post("userStatusUpdate", "Api::userStatusUpdate");
    
}); 


$routes->map($myroutes);
/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
