<?php
namespace App\Controllers;
use CodeIgniter\Controller;
use Aws\S3\S3Client;


use App\Models\User_model;
use App\Models\Employee_model;
use App\Models\Admin_model;
use App\Models\ApiModel;
use App\Libraries\Hash;
use App\Libraries\excel;

class Admin extends Controller
{
	private $EmpModel;
	private $AdminModel;
	private $ApiModel;
	public function __construct(){
		$db = \Config\Database::connect();
		//$db2 = \Config\Database::connect('voter_db');   
		$session = \CodeIgniter\Config\Services::session();
		date_default_timezone_set("Asia/Calcutta");
		helper(['url','form','Form']);  
		$this->EmpModel=new Employee_model();
		$this->AdminModel=new Admin_model();
		$this->ApiModel=new ApiModel();
		$session = session();
		
	}
    public function index()
    {
		$data=[
			'page_title'=>'Dashboard',
			'page_name'=>'Dashboard',
			'title_active'=>'dashboard-management'
		 ];
			 $where_data=[
				 "Status"=>"Approved"
			 ];
			 $table="users";
			 $data['approved_count']=$this->AdminModel->tableRowsCount($table,$where_data);
			 $where_data=[
				"Status"=>"Pending"
			];
			$data['pending_count']=$this->AdminModel->tableRowsCount($table,$where_data);
			$where_data=[
				"Status"=>"Reject"
			];
			$data['reject_count']=$this->AdminModel->tableRowsCount($table,$where_data);
			$where_data=[
				"Status"=>"Banned"
			];
			$data['banned_count']=$this->AdminModel->tableRowsCount($table,$where_data);

			//compain list
			 $where_data=[
			 	"ActivityStatus"=>"Open"
			 ];
			 $data['Open_Compaign']=$this->AdminModel->tableRowsCount('activity',$where_data);

			 $where_data=[
				"ActivityStatus"=>"Close"
			];
			$data['Open_Compaign']=$this->AdminModel->tableRowsCount('activity',$where_data);

			$parameters=array('IssueTitle','IssueDescription');
			$order_by='CadreListeningId';
			$data['topIssues']=$this->AdminModel->getQueryFromTable('cadrelisteningdetails',$parameters,$order_by); 

			$data['activitydetails']=$this->AdminModel->programActivityGrid();
			return view('dashboard',$data); 

		
		// return view('demo',$data); 
    }
	//test
	public function FBSharesCount($id=null){ 
		$data=[
			'page_title'=>'Shares',
			'page_name'=>'Shares',
			'title_active'=>'Shares'
		 ];
		 // Generated @ codebeautify.org
		 
		 	//echo 'shekahr'; exit;
		// New Code
		$token='EAAOK0yASnb8BALS0sgbumTV2bfDJZCyWeyW98TQjAtvLYGf2sjvF62rmyPYsBBV10711ACE8d0joj9RDh8gT1X8RAuntwb4ypIXrI1bf5ZBFrZBiXUkzrONXB5yk0i8iM4mmEOeSkWhcTJbnt02aVj9cqyEuOvJC0rFFgECSFoDU90e7QCW';
		if($this->request->getVar('page_id') || $id){
			$id='109534081791783'; //Admin Page
		//	$id='107922638623384';  //client page
		if($id){
			$id=$id;
		}else{
			$id=$this->request->getVar('page_id');
		}
			
			$data['id']=$id;
	//	$token='EAAOK0yASnb8BANMZCb3WqkZArsZB9qf3RZB3384PTFviMEkoVsjzYl74FEqTfHbDWPjKIeYDp0MioyZAQK1kxQzqgu2WeKaEEHmBLw9MqUIZCHDvZCRor2tujUmJlDgbbET3nqKLwVaaxTXl0684lZCSfpyJHMpwokYqtkDoAJfus6Ht54kpZBNXTIYaoxEt3C0vMTJyufj2NixeXvatkxoVd';
	//	$token='EAAOK0yASnb8BAPT1jkSMYc8L1rXzvZAaRyPgLaI09IVwePZC3nbfHzANDqinOLzGBExF0ZC4oQ3eCzq76NnvtOFsQ6LML1yyJZCfl8C2qzpaKAnaQVQljF9j17hbcCUcaE15v2WbLBIsMzM8pSdmjweo7Gn1z4UG9VkOZCE1zuZBujOyGX43ZBmSdJuir4rzJmgXowU5qPUJ5ZBXRnZAOf6A0';
			$ch = curl_init();

			//curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/107922638623384?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%7D%2Cfollowers_count&access_token=EAAOK0yASnb8BAOQNLiijoMABEcr9yfE9EZCQSNg0kHfZBRjNAsr11sMjK8G67ggOq1MfLbgfjSOuZC4BgoEYuixIhPJ5oHbJfnmUKhu5Gxhuk9kZBBsZAJtgBZCHTInOalyqhOOrgZBzx2ZCmeqSgPeZAUhatF3WWMKUdXZBXvZAEyu45vYBi8pqYHMH65SAxP6EjH0NN5ZAhbufrAZDZD');

			//curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%7D%2Cfollowers_count&access_token='.$token);
			//curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%7D%2Cfollowers_count&access_token='.$token);

			//curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Ccomments%2Cpermalink_url%7D%2Cfollowers_count%2Cname%2Cabout%2Clikes%7Babout%7D&access_token='.$token);

			//curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%7D%2Cfollowers_count%2Cabout%2Cname&access_token='.$token);

			//curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%7D%2Cfollowers_count%2Cabout%2Cname%2Ccountry_page_likes%2Clink&access_token='.$token);

			//curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%7D%2Cfollowers_count%2Cabout%2Cname%2Ccountry_page_likes%2Clink%2Cpicture&access_token='.$token);

			//curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Cpermalink_url%7D%2Cfollowers_count%2Cabout%2Cname%2Ccountry_page_likes%2Clink%2Cpicture&access_token='.$token);

			curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Cpermalink_url%7D%2Cfollowers_count%2Cabout%2Cname%2Ccountry_page_likes%2Clink%2Cpicture&access_token='.$token);

			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

			$result = curl_exec($ch);
			if (curl_errno($ch)) {
				echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);

			
			$datas = json_decode($result);
			//echo '<pre>';
			//print_r($data);exit;

			$follwers=(isset($datas->followers_count)) ? $datas->followers_count :'';

			$data['follwers']=(isset($datas->followers_count)) ? $datas->followers_count :'';
			$data['page_name']=(isset($datas->name)) ? $datas->name :'';
			$data['page_about']=(isset($datas->about)) ? $datas->about :'';
			$data['page_likes']=(isset($datas->country_page_likes)) ? $datas->country_page_likes :'';
			$data['page_id']=(isset($datas->id)) ? $datas->id :'';
			$data['page_link']=(isset($datas->link)) ? $datas->link :'';
		//	$data['picture']=(isset($datas->picture->url)) ? $datas->picture->url :'';
			$data['picture']=(isset($datas->picture->data->url)) ? $datas->picture->data->url :'';			
			$data['post_link']=(isset($datas->picture->permalink_url)) ? $datas->picture->permalink_url :'';

			$posts=$datas->posts;
		//	echo '<pre>';
			//print_r($posts);
			$t=$posts->data;
			$data['fb_details']=$t;
			//print_r($t); exit;
		}else{
			//$token='EAAOK0yASnb8BANMZCb3WqkZArsZB9qf3RZB3384PTFviMEkoVsjzYl74FEqTfHbDWPjKIeYDp0MioyZAQK1kxQzqgu2WeKaEEHmBLw9MqUIZCHDvZCRor2tujUmJlDgbbET3nqKLwVaaxTXl0684lZCSfpyJHMpwokYqtkDoAJfus6Ht54kpZBNXTIYaoxEt3C0vMTJyufj2NixeXvatkxoVd';
	
			$ch = curl_init();
			$id='107922638623384';
			//$id='109534081791783';
			$data['id']='107922638623384';
			//curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/107922638623384?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%7D%2Cfollowers_count&access_token='.$token);

		//	curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%7D%2Cfollowers_count&access_token='.$token);

		//	curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Ccomments%2Cpermalink_url%7D%2Cfollowers_count%2Cname%2Cabout%2Clikes%7Babout%7D&access_token='.$token);
		//	curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%7D%2Cfollowers_count%2Cabout%2Cname&access_token='.$token);

		//	curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%7D%2Cfollowers_count%2Cabout%2Cname%2Ccountry_page_likes%2Clink&access_token='.$token);
		//	curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%7D%2Cfollowers_count%2Cabout%2Cname%2Ccountry_page_likes%2Clink%2Cpicture&access_token='.$token);
			curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Cpermalink_url%7D%2Cfollowers_count%2Cabout%2Cname%2Ccountry_page_likes%2Clink%2Cpicture&access_token='.$token);


	//	curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/109534081791783?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%7D%2Cfollowers_count&access_token=EAAOK0yASnb8BAOQNLiijoMABEcr9yfE9EZCQSNg0kHfZBRjNAsr11sMjK8G67ggOq1MfLbgfjSOuZC4BgoEYuixIhPJ5oHbJfnmUKhu5Gxhuk9kZBBsZAJtgBZCHTInOalyqhOOrgZBzx2ZCmeqSgPeZAUhatF3WWMKUdXZBXvZAEyu45vYBi8pqYHMH65SAxP6EjH0NN5ZAhbufrAZDZD'); 

			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

			$result = curl_exec($ch);
			if (curl_errno($ch)) {
				echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);

			
			$datas = json_decode($result);
			//echo '<pre>';
			//print_r($data);exit;

			$follwers=(isset($datas->followers_count)) ? $datas->followers_count :'';

			$data['follwers']=(isset($datas->followers_count)) ? $datas->followers_count :'';
			$data['page_name']=(isset($datas->name)) ? $datas->name :'';
			$data['page_about']=(isset($datas->about)) ? $datas->about :'';
			$data['page_likes']=(isset($datas->country_page_likes)) ? $datas->country_page_likes :'0';
			$data['page_id']=(isset($datas->id)) ? $datas->id :'';
			$data['page_link']=(isset($datas->link)) ? $datas->link :'';
			$data['picture']=(isset($datas->picture->data->url)) ? $datas->picture->data->url :'';			
			$data['post_link']=(isset($datas->picture->permalink_url)) ? $datas->picture->permalink_url :'';

			$posts=$datas->posts;
			//echo '<pre>';
			//print_r($posts);
		//	$data['fb_data']=$posts->data;
		//$data['fb_data'] = (array) $posts->data;
		//$data['fb_data'] =(array) json_decode($posts->data);
			$t=$posts->data;
			//print_r($t); exit;

			/* foreach($t as $row){
				if(isset($row->message)){ 
					echo $row->message;
				}
			}
			exit; */
		} 
	//	echo $data['picture']; exit;
		//var_dump($t); exit;
		$data['fb_details']=$t;
		//$data_set = [ 'fb_details'=>$t ];
      //  session()->set($data_set);
		//return view('add_shares',$data); 
		
		return view('FB/facebook',$data);  

		exit;

		// CCode Old 
		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/109534081791783?fields=posts%7Bmessage%2Cshares%2Clikes%7Busername%7D%7D&access_token=EAAOK0yASnb8BAJgbzD9eofDlWhyBSApq4PCAFzSmZBfkoEzvKOZBihZCkIsbDlEHTAZAUv2hDABLTU691bGZAByhYIOBD8BRZAypzqMl1zB5kZBBdSOA5HECkWiX8mnv3ixgvxPf2OPZCsY3GsoZCg0IZB3Uib189tzyTVqJ0GMGdaOuhOlNMsmhmObsUFgLj75AIuYHEZAlrQzRESLymBZCB8JZB');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);


		echo '<pre>';
		//print_r($result);exit;
		$data = json_decode($result);
		//print_r($data); 
		$posts=$data->posts;
		$t=$posts->data;
		//foreach($posts as $row){
		//	print_r($row);
		//	$t[]=$row;

			
		//}
		foreach($t as $rows){ 
				echo $s[]= $rows->message;
		}
			print_r($s);
		//print_r($t);
	//	print_r($data->posts);




		exit;
		curl_close($ch);

		 //return view('add_shares',$data); 
	}
	public function FB_Analytics(){ 
		$data=[
			'page_title'=>'FB_Analytics',
			'page_name'=>'FB-Analytics',
			'title_active'=>'fb_analytics'
		 ];

		 $token='EAAOK0yASnb8BALS0sgbumTV2bfDJZCyWeyW98TQjAtvLYGf2sjvF62rmyPYsBBV10711ACE8d0joj9RDh8gT1X8RAuntwb4ypIXrI1bf5ZBFrZBiXUkzrONXB5yk0i8iM4mmEOeSkWhcTJbnt02aVj9cqyEuOvJC0rFFgECSFoDU90e7QCW';
		 if($this->request->getVar('page_id')){
		
			 $id='109534081791783'; //Admin Page
		 //	$id='107922638623384';  //client page
			 $id=$this->request->getVar('page_id');
			 $data['id']=$id;
	 //	$token='EAAOK0yASnb8BANMZCb3WqkZArsZB9qf3RZB3384PTFviMEkoVsjzYl74FEqTfHbDWPjKIeYDp0MioyZAQK1kxQzqgu2WeKaEEHmBLw9MqUIZCHDvZCRor2tujUmJlDgbbET3nqKLwVaaxTXl0684lZCSfpyJHMpwokYqtkDoAJfus6Ht54kpZBNXTIYaoxEt3C0vMTJyufj2NixeXvatkxoVd';
	 //	$token='EAAOK0yASnb8BAPT1jkSMYc8L1rXzvZAaRyPgLaI09IVwePZC3nbfHzANDqinOLzGBExF0ZC4oQ3eCzq76NnvtOFsQ6LML1yyJZCfl8C2qzpaKAnaQVQljF9j17hbcCUcaE15v2WbLBIsMzM8pSdmjweo7Gn1z4UG9VkOZCE1zuZBujOyGX43ZBmSdJuir4rzJmgXowU5qPUJ5ZBXRnZAOf6A0';
			 $ch = curl_init();
 
			// curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Cpermalink_url%7D%2Cfollowers_count%2Cabout%2Cname%2Ccountry_page_likes%2Clink%2Cpicture&access_token='.$token);

			// curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Clikes.summary(true)%7D%2Cfollowers_count%2Cabout%2Cname&access_token='.$token);

			// curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Cpermalink_url%2Clikes.summary(true)%7D%2Cfollowers_count%2Clink%2Cabout%2Cname&access_token='.$token);
			curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Cpermalink_url%2Clikes.summary(true)%7D%2Cfollowers_count%2Clink%2Cabout%2Cname&access_token='.$token);
 
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

			$result = curl_exec($ch);
			if (curl_errno($ch)) {
				echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);

			
			$datas = json_decode($result);
		//	echo '<pre>';
			//print_r($datas);exit;

			$follwers=(isset($datas->followers_count)) ? $datas->followers_count :'';

			$data['follwers']=(isset($datas->followers_count)) ? $datas->followers_count :'';
			$data['fb_page_name']=(isset($datas->name)) ? $datas->name :'';
			$data['page_about']=(isset($datas->about)) ? $datas->about :'';
			$data['page_likes']=(isset($datas->country_page_likes)) ? $datas->country_page_likes :'0';
			$data['page_id']=(isset($datas->id)) ? $datas->id :'';
			$data['page_link']=(isset($datas->link)) ? $datas->link :'';
			$data['picture']=(isset($datas->picture->data->url)) ? $datas->picture->data->url :'';			
			$data['post_link']=(isset($datas->picture->permalink_url)) ? $datas->picture->permalink_url :'';

			$posts=$datas->posts;
			//echo '<pre>';
			//print_r($posts);
			//	$data['fb_data']=$posts->data;
			//$data['fb_data'] = (array) $posts->data;
			//$data['fb_data'] =(array) json_decode($posts->data);
			$t=$posts->data;
			//print_r($t); exit;
			 
		 }else{
			 //$token='EAAOK0yASnb8BANMZCb3WqkZArsZB9qf3RZB3384PTFviMEkoVsjzYl74FEqTfHbDWPjKIeYDp0MioyZAQK1kxQzqgu2WeKaEEHmBLw9MqUIZCHDvZCRor2tujUmJlDgbbET3nqKLwVaaxTXl0684lZCSfpyJHMpwokYqtkDoAJfus6Ht54kpZBNXTIYaoxEt3C0vMTJyufj2NixeXvatkxoVd';
	 
			 $ch = curl_init();
			 $id='107922638623384';
			 //$id='109534081791783';
			 $data['id']='107922638623384';
			
			// curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Cpermalink_url%7D%2Cfollowers_count%2Cabout%2Cname%2Ccountry_page_likes%2Clink%2Cpicture&access_token='.$token);

			// curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Clikes.summary(true)%7D%2Cfollowers_count%2Cabout%2Cname&access_token='.$token);
			 curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Cpermalink_url%2Clikes.summary(true)%7D%2Cfollowers_count%2Clink%2Cabout%2Cname&access_token='.$token);
 
			 curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
 
			 $result = curl_exec($ch);
			 if (curl_errno($ch)) {
				 echo 'Error:' . curl_error($ch);
			 }
			 curl_close($ch);
 
			 
			 $datas = json_decode($result);
			 //echo '<pre>';
			 //print_r($data);exit;
 
			 $follwers=(isset($datas->followers_count)) ? $datas->followers_count :'';
 
			 $data['follwers']=(isset($datas->followers_count)) ? $datas->followers_count :'';
			 $data['fb_page_name']=(isset($datas->name)) ? $datas->name :'';
			 $data['page_about']=(isset($datas->about)) ? $datas->about :'';
			 $data['page_likes']=(isset($datas->country_page_likes)) ? $datas->country_page_likes :'0';
			 $data['page_id']=(isset($datas->id)) ? $datas->id :'';
			 $data['page_link']=(isset($datas->link)) ? $datas->link :'';
			 $data['picture']=(isset($datas->picture->data->url)) ? $datas->picture->data->url :'';			
			 $data['post_link']=(isset($datas->picture->permalink_url)) ? $datas->picture->permalink_url :'';
 
			 $posts=$datas->posts;
			 //echo '<pre>';
			 //print_r($posts);
			 //	$data['fb_data']=$posts->data;
		 	//$data['fb_data'] = (array) $posts->data;
		 	//$data['fb_data'] =(array) json_decode($posts->data);
			 $t=$posts->data;
			 //print_r($t); exit;
 
			 /* foreach($t as $row){
				 if(isset($row->message)){ 
					 echo $row->message;
				 }
			 }
			 exit; */
		 } 
		//	echo $data['post_link'];exit;
		//	echo $data['picture']; exit;
		//var_dump($t); exit;
		 $data['fb_details']=$t;
		 //$data_set = [ 'fb_details'=>$t ];
	  	 //  session()->set($data_set);
		return view('FB_Analytics',$data);
		
	}

	public function FB_Analytics_Parent($id=null){ 
		$data=[
			'page_title'=>'FB_Analytics',
			'page_name'=>'FB-Analytics',
			'title_active'=>'fb_analytics_parent'
		 ];

		 $token='EAAOK0yASnb8BALS0sgbumTV2bfDJZCyWeyW98TQjAtvLYGf2sjvF62rmyPYsBBV10711ACE8d0joj9RDh8gT1X8RAuntwb4ypIXrI1bf5ZBFrZBiXUkzrONXB5yk0i8iM4mmEOeSkWhcTJbnt02aVj9cqyEuOvJC0rFFgECSFoDU90e7QCW';
		 if($this->request->getVar('page_id') || $id){
		
			 $id='109534081791783'; //Admin Page
		 //	$id='107922638623384';  //client page
		 $id=isset($id)?$id:$this->request->getVar('page_id');
			// $id=$this->request->getVar('page_id');
			 $data['id']=$id;

			 $ch = curl_init();
 
			curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Cpermalink_url%2Clikes.summary(true)%7D%2Cfollowers_count%2Clink%2Cabout%2Cname&access_token='.$token);
 
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

			$result = curl_exec($ch);
			if (curl_errno($ch)) {
				echo 'Error:' . curl_error($ch);
			}
			curl_close($ch);

			
			$datas = json_decode($result);
		//	echo '<pre>';
			//print_r($datas);exit;

			$follwers=(isset($datas->followers_count)) ? $datas->followers_count :'';

			$data['follwers']=(isset($datas->followers_count)) ? $datas->followers_count :'';
			$data['fb_page_name']=(isset($datas->name)) ? $datas->name :'';
			$data['page_about']=(isset($datas->about)) ? $datas->about :'';
			$data['page_likes']=(isset($datas->country_page_likes)) ? $datas->country_page_likes :'0';
			$data['page_id']=(isset($datas->id)) ? $datas->id :'';
			$data['page_link']=(isset($datas->link)) ? $datas->link :'';
			$data['picture']=(isset($datas->picture->data->url)) ? $datas->picture->data->url :'';			
			$data['post_link']=(isset($datas->picture->permalink_url)) ? $datas->picture->permalink_url :'';

			$posts=$datas->posts;
	
			$t=$posts->data;
			//print_r($t); exit;
			 
		 }else{
			
	 
			 $ch = curl_init();
			 $id='107922638623384';
			 //$id='109534081791783';
			 $data['id']='107922638623384';
			 curl_setopt($ch, CURLOPT_URL, 'https://graph.facebook.com/v14.0/'.$id.'?fields=posts%7Bid%2Cmessage%2Ccreated_time%2Cfull_picture%2Cshares%2Cpermalink_url%2Clikes.summary(true)%7D%2Cfollowers_count%2Clink%2Cabout%2Cname&access_token='.$token);
 
			 curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
 
			 $result = curl_exec($ch);
			 if (curl_errno($ch)) {
				 echo 'Error:' . curl_error($ch);
			 }
			 curl_close($ch);
 
			 
			 $datas = json_decode($result);
			// echo '<pre>'; 
			// print_r($datas); exit;

			 $follwers=(isset($datas->followers_count)) ? $datas->followers_count :'';
 
			 $data['follwers']=(isset($datas->followers_count)) ? $datas->followers_count :'';
			 $data['fb_page_name']=(isset($datas->name)) ? $datas->name :'';
			 $data['page_about']=(isset($datas->about)) ? $datas->about :'';
			 $data['page_likes']=(isset($datas->country_page_likes)) ? $datas->country_page_likes :'0';
			 $data['page_id']=(isset($datas->id)) ? $datas->id :'';
			 $data['page_link']=(isset($datas->link)) ? $datas->link :'';
			 $data['picture']=(isset($datas->picture->data->url)) ? $datas->picture->data->url :'';			
			 $data['post_link']=(isset($datas->picture->permalink_url)) ? $datas->picture->permalink_url :'';
 
			 $posts=$datas->posts;
			 $t=$posts->data;
		 } 
		 $data['fb_details']=$t;
		return view('FB_Analytics_Parent',$data);
		
	}

	//web users login
	public function login()
    {

        $data = [];
        if ($this->request->getMethod() == 'post') {
			$session = \CodeIgniter\Config\Services::session();					
			$password = $this->request->getVar('Password');
			$rules=[
				'Email'=>[
					'rules'=>'required',
					'label'=>' Email Address',
					'errors'=>[
						'required'=>'Email Address is Required field',
						'valid_email'=>'oh, man, really?? Pls, add a valid email'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
                return view('login', ["validation" => $this->validator]);
            }else{
                $Emp = $this->EmpModel->where('Email', $this->request->getVar('Email'))->first();
				if($Emp){
					$db_password = $Emp['Password'];
					$check_password=Hash::check($password,$db_password);
					if(!$check_password){
						$session->setFlashdata('error', 'Wrong Password');						
						return redirect()->route('login');
					}else{
						$this->setUserSession($Emp); 
						// Redirecting to dashboard after login
						return redirect()->to(base_url());
					}
				}else{
					$session->setFlashdata('error', 'Invalid Email Id');
					return redirect()->route('login');
				}
                // Stroing session values
            }
        }
        return view('login');
    }

    private function setUserSession($Emp)
    {
        $data = [
			'user_details'=>$Emp,
            'u_id' => $Emp['EmployeeId'],
            'u_name' => $Emp['FirstName'],
            'isLoggedIn' => true,
        ];
        session()->set($data);
        return true;
    }
	public function logout()
    { 
		$session = \CodeIgniter\Config\Services::session();		
		$session->setFlashdata('success', 'Successfully Logout');
        session()->destroy();
		return redirect()->route('login');
    }
	//progrma activity
	public Function ProgramActivity(){ 
		$data=[
			'page_title'=>'Program Activity',
			'page_name'=>'program_activity',
			'title_active'=>'program_activity'
		 ];
		$data['activitydetails']=$this->AdminModel->programActivityGrid(); 
		$activitydetails=$this->AdminModel->programActivityGrid(); 
		$i=0;
		 foreach($activitydetails as $row){
			$where_data=['CheckView'=>1,'ActivityId'=>$row['ActivityId']];  
			$activitydetails[$i]["Views_count"]=$this->AdminModel->tableRowsCount('activitystatus',$where_data);
			$ActivityId=$row['ActivityId'];
			$where_data=['ActivityId'=>$ActivityId,'Activity_status'=>'Completed'];
			$activitydetails[$i]['CompletedCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);
			$ActivityId=$row['ActivityId'];
			$where_data=['ActivityId'=>$ActivityId];
			$activitydetails[$i]['TotalCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);
			$i++;
		 }
		 $data['activitydetails']=$activitydetails;
		return view('program_activity_management',$data);
	}

	public function AddProgramActivity(){
		$session = session();
		$data=[
			'page_title'=>'Add Program Activity',
			'page_name'=>'add_program_activity',
			'title_active'=>'program_activity'
		 ];
		 $parameters=array('ActivityGroupId','GroupName');
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTable('activitygroup',$parameters,$order_by); 
		$where=["IsActive"=>1];
		$data['committeeName']=$this->AdminModel->getQueryReultFromTable('committeeName',$where);
		 if($this->request->getMethod() == 'post'){ 
			$rules=[
				'ActivityName'=>[
					'rules'=>'required',
					'label'=>'Activity Name',
					'errors'=>[
						'required'=>'Activity Name is a required'
					]
				]

			];
			$validation=$this->validate($rules); 
            if (!$validation) {
				$data["validation"]=$this->validator;
                //return view('add_program_activity',$data);
            }else{
				

				$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
				if($file->isValid() && !$file->hasMoved()){ 

					// $file_name=$file->getRandomName();
					// $file->move('uploads/program_activity_files',$file_name);  

					// //s3 uplode code
					// $file_Path = base_url()."/uploads/program_activity_files/". $file_name; 
					// $this->s3Upload('program_activity_files',$file_Path); 
					// $url="./uploads/program_activity_files/".$file_name;
					// unlink($url);

					$getClientExtension=$file->getClientExtension();
					$file_name=uniqid(time()).'.'.$getClientExtension;
					$file->move('uploads/paf',$file_name);  
					//s3 uplode
					$file_Path = base_url()."/uploads/paf/". $file_name; 
					$this->s3Upload('paf',$file_Path); 
					$url="./uploads/paf/".$file_name; 
					unlink($url); 

					//New Roles Assigned
					$designatedMember=$this->request->getVar('designatedMember'); 
                    $committeeTypeId=$this->request->getVar('committeeTypeId'); 
                    $committeeNameId=$this->request->getVar('committeeNameId'); 
                    $affiliatedCommitteeId=$this->request->getVar('affiliatedCommitteeId');
                    $designationId=$this->request->getVar('designationId'); 			

					$UserDetails=array();
					
		
				// end test here
				$table_data=[
						'ActivityName'=>$this->request->getVar('ActivityName',FILTER_SANITIZE_STRING),
						'ActivityType'=>$this->request->getVar('ActivityType',FILTER_SANITIZE_STRING),
						'Instructions'=>$this->request->getVar('Instructions',FILTER_SANITIZE_STRING),
						'Links'=>$this->request->getVar('Links',FILTER_SANITIZE_STRING),
						'ActivityStatus'=>$this->request->getVar('ActivityStatus',FILTER_SANITIZE_STRING),
						'TargetCompletionDate'=>$this->request->getVar('TargetCompletionDate',FILTER_SANITIZE_STRING),
						/* 'designationIds'=implode(",",$this->request->getVar('designationId')),
						'designatedMember'=$this->request->getVar('designatedMember'),
						'committeeNameIdS'=implode(",",$this->request->getVar('committeeNameIdS')),
						'affiliatedCommitteeIds'=implode(",",$this->request->getVar('affiliatedCommitteeIds')),
						'committeeTypeId'=$this->request->getVar('committeeTypeId'),  */
						//'ParticipatedCount'=>$this->request->getVar('ParticipatedCount',FILTER_SANITIZE_STRING),
						//'AssignedGroupsId'=>$AssignedGroupsId,
						'UploadType'=>$this->request->getVar('UploadType',FILTER_SANITIZE_STRING),
						'UploadResource'=>$file_name,
						'MediaCoverage'=>$this->request->getVar('MediaCoverage',FILTER_SANITIZE_STRING),
						'BannerDisplayed'=>$this->request->getVar('BannerDisplayed',FILTER_SANITIZE_STRING),
						'ParliamentPresidentParticipated'=>$this->request->getVar('ParliamentPresidentParticipated',FILTER_SANITIZE_STRING),
						'MlaInchargeParticipation'=>$this->request->getVar('MlaInchargeParticipation',FILTER_SANITIZE_STRING),
						'ConstituencyLeadersParticipated'=>$this->request->getVar('ConstituencyLeadersParticipated',FILTER_SANITIZE_STRING),
						'WhatsappImagesVideos'=>$this->request->getVar('WhatsappImagesVideos',FILTER_SANITIZE_STRING),
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s') 

					];
					$ActivityId=$this->AdminModel->insert_record('activity',$table_data); 
				if($ActivityId === false){ 
					$data=[
						'page_title'=>'Add Program Activity',
						'page_name'=>'add_program_activity',
						'title_active'=>'program_activity'
					]; 
					$session->setFlashdata('error', 'Unable to Added Program Activity');
					return redirect()->route('Program-Campaign');
				}else{
					if($this->request->getVar('name')){
						
						$q_name=$this->request->getVar('name'); 
						$i=1;
						foreach($q_name as $q_val){
							$table_data=[
								"question"=>$q_val,
								"ActivityId"=>$ActivityId,
								'CreatedDate'=>date('Y-m-d H:i:s') 
							];
							$campaign_question_id=$this->AdminModel->insert_record('campaign_questions',$table_data); 
							$variable='option'.$i;
							$option_name=$this->request->getVar($variable); 
							foreach($option_name as $opt_val){
									$table_data=[
										"option_name"=>$opt_val,
										"campaign_question_id"=>$campaign_question_id,
									];
									$reuaslt=$this->AdminModel->insert_record('campaign_option',$table_data); 
							}
							$i++;
						}
					}
				
					//Insert Into Compaing Groups
						//Insert into
						$committeeNameId=$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING);
						foreach($committeeNameId as $key=>$value){ 
							$table_data_assComp[]=[
								'ActivityId'=>$ActivityId,
								'committeeNameId'=>$value,
								'committeeTypeId'=>$this->request->getVar('committeeTypeId',FILTER_SANITIZE_STRING),
								'designatedMember'=>$this->request->getVar('designatedMember',FILTER_SANITIZE_STRING),	
								'CreatedDate'=>date('Y-m-d H:i:s') 
							];
						}
						$assignedActId=$this->AdminModel->InsertImportData('assignedCampaigns',$table_data_assComp);
						//	$assignedActId=1;
						//	$assignedActId=$this->AdminModel->insert_record('assignedCampaigns',$table_data); 
						if($assignedActId){	 						
							if($this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING)){
								$affiliatedCommitteeId=$this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING);			
								foreach($affiliatedCommitteeId as $value){								
									$table_data_Aff[]=[
										'ActivityId'=>$ActivityId,
										'affiliatedCommitteeId'=>$value,					
										'CreatedDate'=>date('Y-m-d H:i:s') 
									];
								}
								//print_r($table_data);
								$this->AdminModel->InsertImportData('assigneCampaignsToAff',$table_data_Aff);
							}
							if($this->request->getVar('designationId',FILTER_SANITIZE_STRING)){
								$designationId=$this->request->getVar('designationId',FILTER_SANITIZE_STRING);
								foreach($designationId as $key=>$value){  
									$table_data_dsg[]=[
										'ActivityId'=>$ActivityId,
										'designationId'=>$value,					
										'CreatedDate'=>date('Y-m-d H:i:s') 
									];
								}
								$this->AdminModel->InsertImportData('assigneCampaignsToDesg',$table_data_dsg);
							}	
						}
						$committeeNameId=implode(",",$committeeNameId); 
						if($designatedMember == "No"){  
							$UserDetails1=$this->AdminModel->getCampaignsByGroupDesgNo($designatedMember,$committeeNameId); 
						}else{
							
							/* New COde Here*/ 
							$UserDetails1=array();
							if(!empty($affiliatedCommitteeId)){
								$affiliatedCommitteeIds='';
								if($affiliatedCommitteeId){
									$affiliatedCommitteeIds=implode(",",$affiliatedCommitteeId);
								}
								$designationIds='';
								if($designationId){ 
									$designationIds=implode(",",$designationId);
								}

								$UserDetails1=$this->AdminModel->getUsersAffDesgGroup($designatedMember,$committeeNameId,$committeeTypeId,$affiliatedCommitteeIds,$designationIds); 
							}
							else{
								$designationIds='';
								if($designationId){
									$designationIds=implode(",",$designationId);
								 }
								$UserDetails1=$this->AdminModel->getUsersDesgGroup($designatedMember,$committeeNameId,$committeeTypeId,$designationIds); 
							}

						} 
						/*
						foreach($UserDetails1 as $row){
							echo $row['u_id'].$row['FirstName'];
							echo "<br/>";
						}
						exit();   */
					//insert into activitystatus table
					if($UserDetails1){   
						$device_token=array();
						foreach($UserDetails1 as $row){ 

							$title="Compaign".'-'.$this->request->getVar('ActivityName',FILTER_SANITIZE_STRING);
							$message="New Compaign Assigned via ManaTDP";
							if($row['device_token']){
								$device_token[]=$row['device_token'];
								
							}

							$table_notification_data[]=[ 
								'NotificationUserId'=>$row['u_id'],
								'NotificationTitle'=>$title,
								'NotificationDescription'=>$message,
								'NotificationType'=>"Compaing",
								'FromId'=>$ActivityId,
								'CreatedDate'=>date('Y-m-d H:i:s')
							];
							$table_data_users_chlid[]=[
								'ActivityId'=>$ActivityId,
								'UserId'=>$row['u_id'],
								'Activity_status'=>'Open'
							];
							//$activity_id=$this->AdminModel->insert_record('activitystatus',$table_data);  
						
						}	
						$this->fcm_notification($device_token,$title,$message);					
						$this->AdminModel->InsertImportData('activitystatus',$table_data_users_chlid);
						$this->AdminModel->InsertImportData('notifications',$table_notification_data);
					}
					$session->setFlashdata('success', 'Successfully Update Program Compaign');
					return redirect()->route('Program-Campaign');
				}
			}else{ 
				$session->setFlashdata('error', 'Unable to file upload file try again');
				return redirect()->route('Program-Campaign');
			}
		  }
		}
		return view('add_program_activity',$data);
	}
	public function programActivityEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'Edit Program Campaign',
			'page_name'=>'add_program_activity',
			'title_active'=>'program_activity'
		 ];
		$parameters=array('ActivityGroupId','GroupName');
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTable('activitygroup',$parameters,$order_by); 
		$table="activity";
		$where_id=$id;
		$where_parameter="ActivityId";
	//	$data['activitydetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);	

		//$data['activitydetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);	
		$data['activitydetails']=$this->AdminModel->getActivityById($id);
		


	//	$data['file_path']=$this->s3GetObjects('program_activity_files',$data['activitydetails']['UploadResource']); 
		$data['file_path']=$this->s3Url()."paf/".$data['activitydetails']['UploadResource'];

	//	$where_parameter = ['designatedMember' =>$data['activitydetails']["designatedMember"]]; 
		$where_parameter = ['designatedMember' =>$data['activitydetails']["designatedMember"]]; 
		$table="committeeName";
		$data['committeeName']=$this->ApiModel->getWhereQuery($table,$where_parameter); 

		if($data['activitydetails']["designatedMember"]=="Yes"){ 
			$committeeTypeName=$data['activitydetails']["committeeTypeId"];
				
			//Get Afflliated Groups
			if($committeeTypeName == "Affiliated"){					

				//Get Afflliated Groups
				$committeeTypeName=$data['activitydetails']["committeeTypeId"];
				$committeeNameId=$data['activitydetails']["committeeNameIdS"];
				$data['affiliatedCommittees']=$this->AdminModel->getSmTaskAffliatedOrMain($committeeTypeName,$committeeNameId); 

				//get Designations
					 $affiliatedCommitteeId=$data['activitydetails']["affiliatedCommitteeIds"];  
					 $data['designation']=$this->AdminModel->getAffDesignationIds($affiliatedCommitteeId);  

			}else{
					//$committeeNameId=$data['activitydetails']["committeeNameIdS"];
					//$data['designation']=$this->AdminModel->getDesignationIds($committeeNameId); 

					$committeeNameId=$data['activitydetails']["committeeNameIdS"];
					$data['designation']=$this->AdminModel->getDesignationIds($committeeNameId); 
			}
		}
		if(isset($data['activitydetails'])){
			return view('add_program_activity',$data);
		}else{
			return redirect()->route('Program-Campaign');
		}
		

}
	public function UpdateProgramActivity(){ 
		$session = \CodeIgniter\Config\Services::session();
		if($this->request->getMethod() == 'post'){
			$rules=[
				'ActivityName'=>[
					'rules'=>'required',
					'label'=>'Activity Name',
					'errors'=>[
						'required'=>'Activity Name is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_program_activity',$data);
            }else{
				$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
				if($file->isValid() && !$file->hasMoved()){
					$old_img=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
					// $file_name=$file->getRandomName();
					// $file->move('uploads/program_activity_files',$file_name); 
					// //s3 uplode code
					// $file_Path = base_url()."/uploads/program_activity_files/". $file_name; 
					// $this->s3Upload('program_activity_files',$file_Path); 
					// $url="./uploads/program_activity_files/".$file_name;
					// unlink($url);

					$getClientExtension=$file->getClientExtension();
					$file_name=uniqid(time()).'.'.$getClientExtension; 
					$file->move('uploads/paf',$file_name);  
					//s3 uplode
					$file_Path = base_url()."/uploads/paf/". $file_name; 
					$this->s3Upload('paf',$file_Path); 
					$url="./uploads/paf/".$file_name; 
					unlink($url); 

					//delete old file
					$this->s3DeleteObjects('paf',$this->request->getVar('old_img',FILTER_SANITIZE_STRING));

				}else{
					$file_name=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
				}

				$array_c=$this->request->getVar('AssignedGroupsId',FILTER_SANITIZE_STRING);
				$AssignedGroupsId=implode(",",$array_c);
				$table_data=[
						'ActivityName'=>$this->request->getVar('ActivityName',FILTER_SANITIZE_STRING),
						'ActivityType'=>$this->request->getVar('ActivityType',FILTER_SANITIZE_STRING),
						'Instructions'=>$this->request->getVar('Instructions',FILTER_SANITIZE_STRING),
						'Links'=>$this->request->getVar('Links',FILTER_SANITIZE_STRING),
						'ActivityStatus'=>$this->request->getVar('ActivityStatus',FILTER_SANITIZE_STRING),
						'TargetCompletionDate'=>$this->request->getVar('TargetCompletionDate',FILTER_SANITIZE_STRING),
						//'Points'=>$this->request->getVar('Points',FILTER_SANITIZE_STRING),
					//	'ParticipatedCount'=>$this->request->getVar('ParticipatedCount',FILTER_SANITIZE_STRING),
						'AssignedGroupsId'=>$AssignedGroupsId,
						'UploadType'=>$this->request->getVar('UploadType',FILTER_SANITIZE_STRING),
						'UploadResource'=>$file_name,
						'MediaCoverage'=>$this->request->getVar('MediaCoverage',FILTER_SANITIZE_STRING),
						'BannerDisplayed'=>$this->request->getVar('BannerDisplayed',FILTER_SANITIZE_STRING),
						'ParliamentPresidentParticipated'=>$this->request->getVar('ParliamentPresidentParticipated',FILTER_SANITIZE_STRING),
						'MlaInchargeParticipation'=>$this->request->getVar('MlaInchargeParticipation',FILTER_SANITIZE_STRING),
						'ConstituencyLeadersParticipated'=>$this->request->getVar('ConstituencyLeadersParticipated',FILTER_SANITIZE_STRING),
						'WhatsappImagesVideos'=>$this->request->getVar('WhatsappImagesVideos',FILTER_SANITIZE_STRING),


					//'MediaCovarage'=>$this->request->getVar('MediaCovarage',FILTER_SANITIZE_STRING),
					//	'InMediaCovarage'=>$this->request->getVar('InMediaCovarage',FILTER_SANITIZE_STRING),
					//	'MaterialUsageFormat'=>$this->request->getVar('MaterialUsageFormat',FILTER_SANITIZE_STRING),
					//	'InMaterialUsageFormat'=>$this->request->getVar('InMaterialUsageFormat',FILTER_SANITIZE_STRING),
					//	'PublicResponse'=>$this->request->getVar('PublicResponse',FILTER_SANITIZE_STRING),
					//	'InPublicResponse'=>$this->request->getVar('InPublicResponse',FILTER_SANITIZE_STRING),
					//	'AnySpecialActivities'=>$this->request->getVar('AnySpecialActivities',FILTER_SANITIZE_STRING),
					//	'InAnySpecialActivities'=>$this->request->getVar('InAnySpecialActivities',FILTER_SANITIZE_STRING),
					//	'SocialMediaCoverage'=>$this->request->getVar('SocialMediaCoverage',FILTER_SANITIZE_STRING),
					//	'LeadORCommittee_Participation'=>$this->request->getVar('LeadORCommittee_Participation',FILTER_SANITIZE_STRING),
					//	'InLeadORComm_Participation'=>$this->request->getVar('InLeadORComm_Participation',FILTER_SANITIZE_STRING),
						'SocialListingFromGround'=>$this->request->getVar('SocialListingFromGround',FILTER_SANITIZE_STRING),
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s')
					];
					$table="activity";
					$where_parameter="ActivityId";
					$where_id=$this->request->getVar('ActivityId',FILTER_SANITIZE_STRING);

				if($this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id) === false){

					$data=[
						'page_title'=>'Add Program Activity',
						'page_name'=>'add_program_activity'
					]; 
					$session->setFlashdata('error', 'Unable to Added Program Campaign');
					return redirect()->route('Program-Campaign');
				}else{
					$session->setFlashdata('success', 'Successfully Added');
					return redirect()->route('Program-Campaign');
				}
		 	}
		}
	} 

	//User Program Activity
	public function userUpdateProgramActivity(){
	//	echo 'Hello test';   
	//	exit();
		$session = \CodeIgniter\Config\Services::session();
			$fields=array();
			if($this->request->getMethod() == 'post'){
				
				$InMediaCovarageFile=$this->request->getFile('InMediaCovarageFile',FILTER_SANITIZE_STRING);
				if($InMediaCovarageFile->isValid() && !$InMediaCovarageFile->hasMoved()){ 
						$getClientExtension=$InMediaCovarageFile->getClientExtension();
						$file_name_InMediaCovarageFile=uniqid(time()).'.'.$getClientExtension; 
						$InMediaCovarageFile->move('uploads/uaf',$file_name_InMediaCovarageFile);  
						//s3 uplode
						$file_Path = base_url()."/uploads/uaf/". $file_name_InMediaCovarageFile; 
						$this->s3Upload('uaf',$file_Path); 
						$url="./uploads/uaf/".$file_name_InMediaCovarageFile; 
						unlink($url); 
						$fields[]="InMediaCovarageFile";
				}else{
					$file_name_InMediaCovarageFile=$this->request->getVar('old_img1',FILTER_SANITIZE_STRING); 
				}

				$InMaterialUsageFormatFile=$this->request->getFile('InMaterialUsageFormatFile',FILTER_SANITIZE_STRING);
				if($InMaterialUsageFormatFile->isValid() && !$InMaterialUsageFormatFile->hasMoved()){     
						$getClientExtension=$InMaterialUsageFormatFile->getClientExtension();
						$file_name_InMaterialUsageFormatFile=uniqid(time()).'.'.$getClientExtension; 
						$InMaterialUsageFormatFile->move('uploads/uaf',$file_name_InMaterialUsageFormatFile);  
						//s3 uplode
						$file_Path = base_url()."/uploads/uaf/". $file_name_InMaterialUsageFormatFile; 
						$this->s3Upload('uaf',$file_Path);  
						$url="./uploads/uaf/".$file_name_InMaterialUsageFormatFile; 
						unlink($url); 
						$fields[]="Whatsapp Images/Videos File";
				}else{
					$file_name_InMaterialUsageFormatFile=$this->request->getVar('old_img2',FILTER_SANITIZE_STRING); 
				}	
				

			//	$ConstituencyProgramConducted=$this->request->getVar('ConstituencyProgramConducted',FILTER_SANITIZE_STRING);
				if($this->request->getVar('ConstituencyProgramConducted',FILTER_SANITIZE_STRING)){
					$ConstituencyProgramConducted='Yes';
				}else{
					$ConstituencyProgramConducted='No';
				}
			//	$BannerDisplayed=$this->request->getVar('BannerDisplayed',FILTER_SANITIZE_STRING);
				if($this->request->getVar('BannerDisplayed',FILTER_SANITIZE_STRING)){
					$BannerDisplayed="Yes";
				}else{
					$BannerDisplayed="No";
				}

				if($this->request->getVar('flyers_distribution',FILTER_SANITIZE_STRING)){
					$flyers_distribution="Yes";
				}else{
					$flyers_distribution="No";
				}

				if($this->request->getVar('ParliamentPresidentParticipated',FILTER_SANITIZE_STRING)){
					$ParliamentPresidentParticipated="Yes";
				}else{
					$ParliamentPresidentParticipated="No";
				}

				if($this->request->getVar('MlaInchargeParticipation',FILTER_SANITIZE_STRING)){
					$MlaInchargeParticipation="Yes";
				}else{
					$MlaInchargeParticipation="No";
				}

				if($this->request->getVar('ConstituencyLeadersParticipated',FILTER_SANITIZE_STRING)){
					$ConstituencyLeadersParticipated="Yes";
				}else{
					$ConstituencyLeadersParticipated="No";
				}

				
				if($this->request->getVar('MediaCovarage',FILTER_SANITIZE_STRING)){
					$MediaCovarage="Yes";
					$InMediaCovarage=$this->request->getVar('InMediaCovarage',FILTER_SANITIZE_STRING);
				}else{
					$MediaCovarage="No";
					$InMediaCovarage="";
				}

				$marks=0;
				if($ConstituencyProgramConducted=="Yes"){
					$marks=4;
				}else{

				}
				if($BannerDisplayed=="Yes"){
					$marks +=1;
				}
				if($ParliamentPresidentParticipated=="Yes"){
					
				}
				if($MlaInchargeParticipation=="Yes"){
					$marks +=2;
				}
				if($ConstituencyLeadersParticipated=="Yes"){
					$marks +=1;
				}
				if($MediaCovarage=="Yes"){
					$marks +=1;
				}
				if(!empty($this->request->getVar('NeutralPeopleParticipatedCount',FILTER_SANITIZE_STRING))){ 
					$marks +=1;
				}
				
				if($marks >8 ){
					$grade="A";
				}elseif(($marks <=8) and ($marks >6)){
					$grade="B";
				}elseif(($marks <=6) and ($marks >5)){
					$grade="C";
				}else{
					$grade="D";
				}

				$total=10;
				$ActivityStatuId=$this->request->getVar('ActivityStatuId',FILTER_SANITIZE_STRING);
				$ActivityIdParent=$this->request->getVar('ActivityId',FILTER_SANITIZE_STRING);
				if($this->request->getVar('Activity_status',FILTER_SANITIZE_STRING) == "Completed"){ 
					$where_parameter="ActivityStatuId";
					$where_id=$ActivityStatuId;
					$resultData=$this->AdminModel->getRowTableById('activitystatus',$where_parameter,$where_id);
					if(!empty($resultData['CompletedDate'])){
						$CompletedDate=$resultData['CompletedDate'];
					}else{
						$CompletedDate=date('Y-m-d H:i:s');
					}
					
				}else{
					$CompletedDate="";
				}
			   
				$percetage=$marks/$total*100;
				$table_data=[ 
					'Activity_status'=>$this->request->getVar('Activity_status',FILTER_SANITIZE_STRING),
					'ConstituencyProgramConducted'=>$ConstituencyProgramConducted,
					'BannerDisplayed'=>$BannerDisplayed,
					'ParliamentPresidentParticipated'=>$ParliamentPresidentParticipated,
					'MlaInchargeParticipation'=>$MlaInchargeParticipation,
					'ConstituencyLeadersParticipated'=>$ConstituencyLeadersParticipated,
					'NoOfCadreParticipatedCount'=>$this->request->getVar('NoOfCadreParticipatedCount',FILTER_SANITIZE_STRING),
					'NeutralPeopleParticipatedCount'=>$this->request->getVar('NeutralPeopleParticipatedCount',FILTER_SANITIZE_STRING),
					'MediaCovarage'=>$MediaCovarage,
					'InMediaCovarage'=>$this->request->getVar('InMediaCovarage',FILTER_SANITIZE_STRING),
				
					'Grade'=>$grade,
					'Marks'=>$marks,
					'CompletedDate'=>$CompletedDate, 
					'Percentage'=>$percetage,
					'InMediaCovarageFile'=>$file_name_InMediaCovarageFile,
					'InMaterialUsageFormatFile'=>$file_name_InMaterialUsageFormatFile,
					'MaterialUsageFormat'=>$this->request->getVar('MaterialUsageFormat',FILTER_SANITIZE_STRING), 	
					'InMaterialUsageFormat'=>$this->request->getVar('InMaterialUsageFormat',FILTER_SANITIZE_STRING),//Whatsapp text
					//'MediaCoverage'=>$this->request->getVar('MediaCoverage',FILTER_SANITIZE_STRING),
					'flyers_distribution'=>$flyers_distribution,
					'number_of_householders'=>$this->request->getVar('number_of_householders',FILTER_SANITIZE_STRING),
					'custom1'=>$this->request->getVar('custom1',FILTER_SANITIZE_STRING),
					'custom2'=>$this->request->getVar('custom2',FILTER_SANITIZE_STRING),
					'custom3'=>$this->request->getVar('custom3',FILTER_SANITIZE_STRING),
					'Remarks'=>$this->request->getVar('Remarks',FILTER_SANITIZE_STRING), 
					'UpdatedDate'=>date('Y-m-d H:i:s') 
				   
				]; 
			   
				$where_parameter="ActivityStatuId";
					$where_id=$ActivityStatuId;
					$resultData=$this->AdminModel->getRowTableById('activitystatus',$where_parameter,$where_id);
					if($resultData['Activity_status'] != $this->request->getVar('Activity_status',FILTER_SANITIZE_STRING)){
						$fields[]="Activity_status";
					}
					if($resultData['NoOfCadreParticipatedCount'] != $this->request->getVar('NoOfCadreParticipatedCount',FILTER_SANITIZE_STRING)){
						$fields[]="NoOfCadreParticipatedCount"; 
						
					}
					if($resultData['NeutralPeopleParticipatedCount'] != $this->request->getVar('NeutralPeopleParticipatedCount',FILTER_SANITIZE_STRING)){
						$fields[]="NeutralPeopleParticipatedCount";
					}
					if($resultData['ConstituencyProgramConducted'] != $this->request->getVar('ConstituencyProgramConducted',FILTER_SANITIZE_STRING)){
						$fields[]="ConstituencyProgramConducted";
					}
					if($resultData['BannerDisplayed'] != $this->request->getVar('BannerDisplayed',FILTER_SANITIZE_STRING)){
						$fields[]="BannerDisplayed";
					}
					if($resultData['ParliamentPresidentParticipated'] != $this->request->getVar('ParliamentPresidentParticipated',FILTER_SANITIZE_STRING)){
						$fields[]="ParliamentPresidentParticipated";
					}
					if($resultData['MlaInchargeParticipation'] != $this->request->getVar('MlaInchargeParticipation',FILTER_SANITIZE_STRING)){
						$fields[]="MlaInchargeParticipation";
					}
					if($resultData['ConstituencyLeadersParticipated'] != $this->request->getVar('ConstituencyLeadersParticipated',FILTER_SANITIZE_STRING)){
						$fields[]="ConstituencyLeadersParticipated";
					}
					if($resultData['MediaCovarage'] != $this->request->getVar('MediaCovarage',FILTER_SANITIZE_STRING)){
						$fields[]="MediaCovarageCheckBox";
					}
					if($resultData['InMediaCovarage'] != $this->request->getVar('InMediaCovarage',FILTER_SANITIZE_STRING)){
						$fields[]="InMediaCovarageText";
					}
					if($resultData['MaterialUsageFormat'] != $this->request->getVar('MaterialUsageFormat',FILTER_SANITIZE_STRING)){
						$fields[]="WhatsappImagesVideosCheckBox";
					}
					if($resultData['InMaterialUsageFormat'] != $this->request->getVar('InMaterialUsageFormat',FILTER_SANITIZE_STRING)){
						$fields[]="WhatsappImagesVideosText";
					}
					if($resultData['Remarks'] != $this->request->getVar('Remarks',FILTER_SANITIZE_STRING)){
						$fields[]="Remarks";
					}

				$table="activitystatus";
				$where_parameter="ActivityStatuId";
				$where_id=$ActivityStatuId;  
				if($this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id) === false){
					$data=[
						'page_title'=>'Add Program Activity',
						'page_name'=>'add_program_activity'
					]; 
					$session->setFlashdata('error', 'Unable to Added Program Campaign');
					//$url="User-Program-Campaining/".$ActivityIdParent;
					return redirect()->route('Program-Campaign');


				}else{
					$where_data=["ActivityStatuId"=>$ActivityStatuId]; 
					$this->ApiModel->deleteRecord('user_custom_question_answers',$where_data);
					$options=$this->request->getVar('option'); 
					foreach($options as $key=>$val) {
						$table_datas=[
							"q_id"=>str_replace("'", "", $key),
							"option_id"=>$val,
							"ActivityStatuId"=>$ActivityStatuId
						];
						$this->AdminModel->insert_record('user_custom_question_answers',$table_datas); 
					}
					$u_id=$session->get('u_id');
					$updated_filed=implode(",",$fields);
					$table_data_log=['ActivityStatuId'=>$ActivityStatuId,'UserId'=>$u_id,'UserType'=>'admin','updated_filed'=>$updated_filed,'CreatedDate'=>date('Y-m-d H:i:s'),'LastUpdatedBy'=>date('Y-m-d H:i:s')];
					$this->ApiModel->insert_record('campaign_log',$table_data_log);   




					$Points=20;
					$where_parameter='ActivityStatuId';
					$where_id=$ActivityStatuId; 
					$getActivitDetails=$this->AdminModel->getRowTableById('activitystatus',$where_parameter,$where_id);

					$user_id=$getActivitDetails['UserId'];

				//	$user_id=$getActivitDetails['UserId'];
				 

					 //MediaCovarage 1
					 $this->actvitiyStatusPointsCount($user_id,$ActivityStatuId,$this->request->getVar('MediaCovarage',FILTER_SANITIZE_STRING),'MediaCovarage',$Points,'Pending');

					//MaterialUsageFormat 2 
					$this->actvitiyStatusPointsCount($user_id,$ActivityStatuId,$this->request->getVar('MaterialUsageFormat',FILTER_SANITIZE_STRING),'MaterialUsageFormat',$Points,'Pending');

					//public reaponse 3 
					$this->actvitiyStatusPointsCount($user_id,$ActivityStatuId,$this->request->getVar('PublicResponse',FILTER_SANITIZE_STRING),'PublicResponse',$Points,'Pending');

					//spacial activity 4
					$this->actvitiyStatusPointsCount($user_id,$ActivityStatuId,$this->request->getVar('AnySpecialActivities',FILTER_SANITIZE_STRING),'AnySpecialActivities',$Points,'Pending');

					//Social media covara     5                     
					$this->actvitiyStatusPointsCount($user_id,$ActivityStatuId,$this->request->getVar('SocialMediaCoverage',FILTER_SANITIZE_STRING),'SocialMediaCoverage',$Points,'Pending');
					
					//LeadORCommittee_Participation 6
					$this->actvitiyStatusPointsCount($user_id,$ActivityStatuId,$this->request->getVar('LeadORCommittee_Participation',FILTER_SANITIZE_STRING),'LeadORCommittee_Participation',$Points,'Pending');

					$session->setFlashdata('success', 'Successfully Added');
					 $url=base_url()."/User-Program-Campaining/".$ActivityIdParent;
					return redirect()->to($url);   
				}
			}else{
				 
			}
	}

	//actvitiy stataus point count
	public function actvitiyStatusPointsCount($user_id,$ActivityStatuId,$PointsFromDesc,$FromName,$Points,$PointStatus){
		if($PointsFromDesc=="1"){
			$where_data=["PointFromId"=>$ActivityStatuId,"PointsFrom"=>"ActivityStatus","PointsFromDesc"=>$FromName,"userId"=>$user_id];
			$getCount=$this->AdminModel->tableRowsCount('pointsdetails',$where_data); 
			if($getCount=="1"){
				
			}else{
				$table_data=["userId"=>$user_id,"PointFromId"=>$ActivityStatuId,"PointsFrom"=>"ActivityStatus","PointsFromDesc"=>$FromName,"Points"=>$Points,"PointStatus"=>$PointStatus];
				$this->ApiModel->insert_record('pointsdetails',$table_data);
			}
		}else{
			$where_data=["userId"=>$user_id,"PointFromId"=>$ActivityStatuId,"PointsFrom"=>"ActivityStatus","PointsFromDesc"=>$FromName];
			$this->ApiModel->deleteRecord('pointsdetails',$where_data);
		}
	}

	public function viewProgramActivity($id=null){
		$data=[
			'page_title'=>'View Program Campaign',
			'page_name'=>'add_program_campaining',
			'title_active'=>'program_activity',
		 ];
		 $data['view']=true;
		 $parameters=array('ActivityGroupId','GroupName');
		 $order_by='ActivityGroupId';
		 $data['activitygroup']=$this->AdminModel->getQueryFromTable('activitygroup',$parameters,$order_by); 
		 $table="activity";
		 $where_id=$id;
		 $where_parameter="ActivityId";

		 $where=["ActivityId"=>$id];
		 $data['compaign_questions']= $this->AdminModel->getQueryReultFromTable('campaign_questions',$where);
		 $x=0;
		 foreach($data['compaign_questions'] as $row){
			 $where=["campaign_question_id"=>$row['campaign_question_id']];
			 $data['compaign_questions'][$x]['options']= $this->AdminModel->getQueryReultFromTable('campaign_option',$where); 
			 $x++;
		 }

		 $data['activitydetails']=$this->AdminModel->getActivityById($id);
		 
 
 
	 //	$data['file_path']=$this->s3GetObjects('program_activity_files',$data['activitydetails']['UploadResource']); 
		 $data['file_path']=$this->s3Url()."paf/".$data['activitydetails']['UploadResource'];
 
	 //	$where_parameter = ['designatedMember' =>$data['activitydetails']["designatedMember"]]; 
		 $where_parameter = ['designatedMember' =>$data['activitydetails']["designatedMember"]]; 
		 $table="committeeName";
		 $data['committeeName']=$this->ApiModel->getWhereQuery($table,$where_parameter); 
 
		 if($data['activitydetails']["designatedMember"]=="Yes"){
			 $committeeTypeName=$data['activitydetails']["committeeTypeId"];
				 
			 //Get Afflliated Groups
			 if($committeeTypeName == "Affiliated"){					
 
				 //Get Afflliated Groups
				 $committeeTypeName=$data['activitydetails']["committeeTypeId"];
				 $committeeNameId=$data['activitydetails']["committeeNameIdS"];
				 $data['affiliatedCommittees']=$this->AdminModel->getSmTaskAffliatedOrMain($committeeTypeName,$committeeNameId); 
 
				 //get Designations
					  $affiliatedCommitteeId=$data['activitydetails']["affiliatedCommitteeIds"];  
					  $data['designation']=$this->AdminModel->getAffDesignationIds($affiliatedCommitteeId);  
 
			 }else{
					 //$committeeNameId=$data['activitydetails']["committeeNameIdS"];
					 //$data['designation']=$this->AdminModel->getDesignationIds($committeeNameId); 
 
					 $committeeNameId=$data['activitydetails']["committeeNameIdS"];
					 $data['designation']=$this->AdminModel->getDesignationIds($committeeNameId); 
			 }
			}
		 if(isset($data['activitydetails'])){
			 return view('add_program_activity',$data);
		 }else{
			 return redirect()->route('Program-Campaign');
		 }
	
}

	public function demo(){
		$data=[
			'page_title'=>'demo',
			'page_name'=>'demo',
			'title_active'=>'demo',
		 ];

		 return view('demo',$data); 
	}

	public function ExecutiveReports(){
	
		$data=[
			'page_title'=>'Executive Reports',
			'page_name'=>'Executive Reports',
			'title_active'=>'ExecutiveReports',
		 ];
	
		 $compain_details=$this->AdminModel->compainOrderbyDesc();
		 $compain_id=$compain_details['ActivityId'];
		// $compain_id=1;
		 $data['compain_id']=$compain_id;
		 //Program Compain Status
		 $where_data=[
			"ActivityStatus"=>"Open"
		];
		$data['Open_Compaign']=$this->AdminModel->tableRowsCount('activity',$where_data);

		$where_data=[
		   "ActivityStatus"=>"Close"
	   ];
	   $data['Close_Compaign']=$this->AdminModel->tableRowsCount('activity',$where_data);

	   //$data['programActivityById']=$this->AdminModel->programActivityByIdGrid($compain_id);

	    //$programActivityById=$this->AdminModel->programActivityByIdGrid($compain_id); 
		$programActivityById=$this->AdminModel->getActivityById($compain_id);
	
	  
	   
		//foreach($programActivityById as $row){ 
		   $where_data=['CheckView'=>1,'ActivityId'=>$programActivityById['ActivityId']];  
		   $programActivityById["Views_count"]=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		   $ActivityId=$programActivityById['ActivityId'];
		   $where_data=['ActivityId'=>$ActivityId,'Activity_status'=>'Completed'];
		   $programActivityById['CompletedCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		   $ActivityId=$programActivityById['ActivityId'];
		   $where_data=['ActivityId'=>$ActivityId];
		   $programActivityById['TotalCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);
		  // $i++;
	//	}
		$data['programActivityByIds']=$programActivityById;
			

	 	$activitydetails=$this->AdminModel->programActivityGrid();	
	
		foreach($activitydetails as $row){
			$activity_id=$row['ActivityId'];
		}
		
		//program compaining
		$data['activitydetails_executive_reports']=$this->AdminModel->userProgramActivityGrid($compain_id); 

		//get percentage
		$where=["campaign_id"=>$compain_id];
		$data['Program_Campaign_Report_ABCD']=$this->AdminModel->getGradingByCompaingId($compain_id);
		
	

		//program conducted or not
		$data['programConductedNotConducted']=$this->AdminModel->programConductedNotConductedByCompain_id($compain_id);

		//Incharge-Participated/Not Participated
		$data['inchargeParticipatedNotParticipated']=$this->AdminModel->inchargeParticipatedNotParticipatedByCompain_id($compain_id);
		
		
		 //Top 5 Issue
		$parameters=array('IssueTitle','IssueDescription');
		$order_by='CadreListeningId';
		$data['topIssues']=$this->AdminModel->getQueryFromTable('cadrelisteningdetails',$parameters,$order_by); 

		//Top 5 Submited Data
		$data['ConstituencySubmitedData']=$this->AdminModel->constituencySubmitedData($compain_id);
		
		//get Compain Viewd or Not
		$data['CompaingViwedOrNot']=$this->AdminModel->CompaingViwedOrNot($compain_id);

		//get Overal Reports Data
		$where_data=["ActivityId"=>$compain_id];
		$data['total_const_count']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$data['ACCount']=$this->AdminModel->ParticipatedAssemblyConstituencies($compain_id);
	
		$where_data=["ActivityId"=>$compain_id,"MlaInchargeParticipation"=>"Yes"];
		$data['IncCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$where_data=["ActivityId"=>$compain_id,"ParliamentPresidentParticipated"=>"Yes"];
		$data['PPCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$where_data=["ActivityId"=>$compain_id,"BannerDisplayed"=>"Yes"];
		$data['BDCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$where_data=["ActivityId"=>$compain_id,"MediaCovarage"=>"Yes"];
		$data['MCCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$where_data=["ActivityId"=>$compain_id,"MediaCovarage"=>"Yes"];
		$data['MCCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$data['PepopleCount']=$this->AdminModel->PPCount($compain_id); 
		
		$data['GradingCount']=$this->AdminModel->GradingCount($compain_id); 
		

		$where_data=["ActivityId"=>$compain_id,"ConstituencyProgramConducted"=>"No"];
		$data['NonPCCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

		$data['NonPCNames']=$this->AdminModel->NonPCNames($compain_id);
		//print_r($data['NonPCNames']);
		$data['activitydetails']=$this->AdminModel->programActivityGrid();
		
	
		$ActivitySummeryResult=$this->AdminModel->programActvityForExecutiveDash();
		$i=0;
		foreach($ActivitySummeryResult as $row){
			$ActivityId=$row['ActivityId'];
			$where_data=['ActivityId'=>$ActivityId,'Activity_status'=>'Completed'];
			$ActivitySummeryResult[$i]['CompletedCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);
			$i++;
		}
		$data['ActivitySummeryResult']=$ActivitySummeryResult;
		//get Compainings
		//$data['campaign_names']=$this->AdminModel->getTable('activity'); 
		$where=['IsActive'=>1];
		$data['campaign_names']=$this->AdminModel-> getQueryReultFromTable('activity',$where);

		 
	

		if($this->request->getMethod() == 'post'){ 
					// $compain_id=$this->request->getVar('compain_id',FILTER_SANITIZE_STRING);
					 $compain_id=$this->request->getVar('compain_ids',FILTER_SANITIZE_STRING);
				//	$programActivityById=$this->AdminModel->programActivityByIdGrid($compain_id); 
					$programActivityById=$this->AdminModel->getActivityByIdgg($compain_id);
					
			 	 // print_r($programActivityById); exit; 
	  
				//echo $programActivityById['ActivityId'];exit;
					//foreach($programActivityById as $row){ 
					  // $where_data=['CheckView'=>1,'ActivityId'=>$programActivityById['ActivityId']];  
					   $where_data=['CheckView'=>1,'ActivityId'=>$compain_id];  
					   $programActivityById["Views_count"]=$this->AdminModel->tableRowsCount('activitystatus',$where_data);
			
					   $ActivityId=$programActivityById['ActivityId'];
					   $where_data=['ActivityId'=>$ActivityId,'Activity_status'=>'Completed'];
					   $programActivityById['CompletedCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);
			
					   $ActivityId=$programActivityById['ActivityId'];
					   $where_data=['ActivityId'=>$ActivityId];
					   $programActivityById['TotalCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);
					  // $i++;
				//	}
					$data['programActivityByIds']=$programActivityById;
					$data['compain_id']=$compain_id;
					$where=["campaign_id"=>$compain_id];
					$data['Program_Campaign_Report_ABCD']=$this->AdminModel->getGradingByCompaingId($compain_id);
					//print_r($data['Program_Campaign_Report_ABCD']);

					//child  compaign records
					//program compaining
					$data['activitydetails_executive_reports']=$this->AdminModel->userProgramActivityGrid($compain_id); 

					//program conducted or not
					$data['programConductedNotConducted']=$this->AdminModel->programConductedNotConductedByCompain_id($compain_id);

					//Incharge-Participated/Not Participated
					$data['inchargeParticipatedNotParticipated']=$this->AdminModel->inchargeParticipatedNotParticipatedByCompain_id($compain_id);

					$data['ConstituencySubmitedData']=$this->AdminModel->constituencySubmitedData($compain_id);

							//get Compain Viewd or Not
				$data['CompaingViwedOrNot']=$this->AdminModel->CompaingViwedOrNot($compain_id);

				//get Overal Reports Data
				$where_data=["ActivityId"=>$compain_id];
				$data['total_const_count']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

				$data['ACCount']=$this->AdminModel->ParticipatedAssemblyConstituencies($compain_id);
			
				$where_data=["ActivityId"=>$compain_id,"MlaInchargeParticipation"=>"Yes"];
				$data['IncCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

				$where_data=["ActivityId"=>$compain_id,"ParliamentPresidentParticipated"=>"Yes"];
				$data['PPCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

				$where_data=["ActivityId"=>$compain_id,"BannerDisplayed"=>"Yes"];
				$data['BDCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

				$where_data=["ActivityId"=>$compain_id,"MediaCovarage"=>"Yes"];
				$data['MCCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

				$where_data=["ActivityId"=>$compain_id,"MediaCovarage"=>"Yes"];
				$data['MCCount']=$this->AdminModel->tableRowsCount('activitystatus',$where_data);

				$data['PepopleCount']=$this->AdminModel->PPCount($compain_id); 
				
				$data['GradingCount']=$this->AdminModel->GradingCount($compain_id); 
					
			}
		//	echo 's11sss';
		 return view('executive_reports',$data); 
	}

	public function Reports(){ 
		$data=[
			'page_title'=>'Poll Reports',
			'page_name'=>'Poll Reports',
			'title_active'=>'Reports',
		 ];
		$polls_details=$this->AdminModel->pollsOrderbyDesc();
		$poll_id=$polls_details['p_id'];
		$data['poll_id']=$polls_details['p_id'];	
		$data['getPollsRepsonse']=$this->AdminModel->getOptionParectage($poll_id);  

		$data["poll_response"]=$this->AdminModel->getLatestSubmittedResponse($poll_id);

		$data['TotalSubmitedCount']=$this->AdminModel->TotalSubmitedCount($poll_id);  	
		$data['getAllPolls']=$this->AdminModel->getAllPolls();
	//	$data['getAllUsers']=$this->AdminModel->getAllUsers();
		$data['getAllUsers']=$this->AdminModel->getAllUsersByGroups($poll_id);  
		$data['totalPollsSubmitedUsers']=$this->AdminModel->totalPollsSubmitedUsers($poll_id);
		if($this->request->getMethod() == 'post'){ 
			 $p_id=$this->request->getVar('p_id',FILTER_SANITIZE_STRING);
			$data['poll_id']=$p_id;	
			 $data['getPollsRepsonse']=$this->AdminModel->getOptionParectage($p_id);  
			 $data["poll_response"]=$this->AdminModel->getLatestSubmittedResponse($p_id);
			$data['TotalSubmitedCount']=$this->AdminModel->TotalSubmitedCount($p_id);  	
			$data['getAllPolls']=$this->AdminModel->getAllPolls();
			$data['totalPollsSubmitedUsers']=$this->AdminModel->totalPollsSubmitedUsers($p_id);

			//	print_r($data['getPollsRepsonse']);
			//	exit();
		}

		//	print_r($data['getPollsRepsonse']);
		//	exit();
		//	print_r($data['GradingCount']); 
		return view('executive_reports_demo',$data);  
	}

	public function getAppUsers($id=null){ 
		$data=[
			'page_title'=>'App Users',
			'page_name'=>'app_users',
			'title_active'=>'app_users'
		 ];		
		// echo $id;
		// exit();
		$parameters=array('u_id','FirstName','LastName','Email','Mobile','Status');
		$parameters=array('*');
		$order_by='u_id';

		$where_data=[
			"Status"=>"Approved"
		];
		$table="users";
		$data['approved_count']=$this->AdminModel->tableRowsCount($table,$where_data);
		//$data['approved_count']=0;

		$where_data=[
		   "Status"=>"Pending"
	   ];
	   $data['pending_count']=$this->AdminModel->tableRowsCount($table,$where_data);
	   //$data['pending_count']=0;
	   $where_data=[
		   "Status"=>"Reject"
	   ];
	 	$data['reject_count']=$this->AdminModel->tableRowsCount($table,$where_data);
	  // $data['reject_count']=0;

	   $where_data=[
		   "Status"=>"Banned"
	   ];
	 	 $data['banned_count']=$this->AdminModel->tableRowsCount($table,$where_data);
	   //$data['banned_count']=0;
	  
	
		//$where=["Status"=>"Approved"];
		//$data['appuserdetails']=$this->AdminModel->getQueryReultFromTables('users',$where); 
		
		if($id){	
		//	echo 'Shekahrss';
		//	exit();
		//	$where=["Status"=>$id];
			//$data['appuserdetails']=$this->AdminModel->getQueryReultFromTables('users',$where);
		}else{
			//$data['appuserdetails']=$this->AdminModel->getQueryData();
			//$where=["Status"=>"Approved"];
			//$data['appuserdetails']=$this->AdminModel->getQueryReultFromTables('users',$where);
		}		

		return view('app_users_management',$data); 
	}

	


	public function appUserEdit($id=null,$c=null,$q=null){  
	
		$session = session();
		$data=['cp'=>$c];
		session()->set($data);

		$data=['q'=>$q];
		session()->set($data); 
		$data=[
			'page_title'=>'Edit App User',
			'page_name'=>'edit_app_users',
			'title_active'=>'app_users'
		 ];		
		 //activity group
		$parameters=array('ActivityGroupId','GroupName'); 
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTable('activitygroup',$parameters,$order_by); 
		 //app roles
		$parameters=array('AppRoleId','AppRoleName');
		$order_by='AppRoleId';
		$data['approles']=$this->AdminModel->getQueryFromTable('approles',$parameters,$order_by); 

		//app roles
		$parameters=array('CommitteeID','CName');
		$order_by='CommitteeID';
		$data['commitee']=$this->AdminModel->getQueryFromTable('committee',$parameters,$order_by);  

		//parliaments
		$parameters=array('ParliamentID','ParliamentName');
		$order_by='ParliamentID';
		$data['parliament']=$this->AdminModel->getQueryFromTable('parliament',$parameters,$order_by); 

		//get commite name
		$where=["IsActive"=>1];
		$data['committeeName']=$this->AdminModel->getQueryReultFromTable('committeeName',$where);

		 //app users 
		$table="users";
		$where_id=$id;
		$where_parameter="u_id";
		$data['userdetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		if(isset($data['userdetails'])){			
			$userdetails=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
			//Roles Module

			//Get Committe Names
			$where_parameter = ['designatedMember' =>$userdetails["designatedMember"]]; 
			$table="committeeName";
			$data['committeeName']=$this->ApiModel->getWhereQuery($table,$where_parameter); 

			if($userdetails["designatedMember"]=="Yes"){

					//Get Committe Type
				$where_parameter = ['committeeNameId' =>$userdetails["committeeNameId"]]; 
				$table="committeeType";
				$data['committeeType']=$this->ApiModel->getWhereQuery($table,$where_parameter); 

				//Get Afflliated Groups
				$where_parameter = ['committeeTypeId' =>$userdetails["committeeTypeId"]]; 
				$table="affiliatedCommittees";  
				$data['affiliatedCommittees']=$this->ApiModel->getWhereQuery($table,$where_parameter); 

				//Get Desgniation 
				//affiliatedCommitteeId
				$affiliatedCommitteeId=$userdetails["affiliatedCommitteeId"];
				if($affiliatedCommitteeId == "0"){
					$where_parameter = ['committeeNameId' =>$userdetails["committeeNameId"],'affiliatedCommitteeId'=>$affiliatedCommitteeId]; 
					$table="designation";  
					$data['designation']=$this->ApiModel->getWhereQuery($table,$where_parameter); 
				}else{
					$where_parameter = ['committeeNameId' =>$userdetails["committeeNameId"],'affiliatedCommitteeId'=>$affiliatedCommitteeId]; 
					$table="designation";  
					$data['designation']=$this->ApiModel->getWhereQuery($table,$where_parameter);  
				}	
				

			}else{

			}
			//get constituency data
			$where_parameter = ['ParliamentID' => $userdetails['ParliamentId']]; 
			$table="constituency";
			$data['constituency']=$this->ApiModel->getWhereQuery($table,$where_parameter); 
			
			//get mandals
			$s=$userdetails['ParliamentId'];
			$data['mandals']=$this->AdminModel->getMandalsByConstituency($s);		

			//get Villages
			$s=$userdetails['ParliamentId'];
			$data['villages']=$this->AdminModel->getMandalsByvillage($s);		
			
			//approle groups
			if(isset($userdetails['AppRoleId'])){
				$where_parameter = ['AppRoleId' => $userdetails['AppRoleId']]; 
				$table="approlegroup";
				$data['approlegroups']=$this->ApiModel->getWhereQuery($table,$where_parameter);
			}
			return view('edit_app_users',$data);
		}else{
			return redirect()->route('get-app-users'); 
		} 
	}
	//get constituncey and mondals and village
	function action()
	{
		if($this->request->getVar('action'))
		{
			$action = $this->request->getVar('action');

			if($action == 'get_constituency')
			{
				$ParliamentId=$this->request->getVar('ParliamentId');
				$where_parameter = ['ParliamentID' => $ParliamentId]; 
				$table="constituency";				
			}
			if($action == 'get_mandals')
			{
				$ConstituencyID=$this->request->getVar('ConstituencyId');
				$where_parameter = ['constituency_id' => $ConstituencyID]; 
				$table="mandals";
			}
			if($action == 'get_villages')
			{
				$MandalId=$this->request->getVar('MandalId');
				$where_parameter = ['mandal_id' => $MandalId]; 
				$table="villages"; 
			}
			if($action == 'get_role_groups'){
				$AppRoleId=$this->request->getVar('AppRoleId');
				$where_parameter = ['AppRoleId' => $AppRoleId]; 
				$table="approlegroup";
			}
			$resultData=$this->ApiModel->getWhereQuery($table,$where_parameter);
			echo json_encode($resultData);
		}
	}
	

	//get roles 
	public function get_roles(){
		$action = $this->request->getVar('action');
		if($action == 'get_committeeTypeId')
		{
			$committeeNameId=$this->request->getVar('committeeNameId');
			$where_parameter = ['committeeNameId'=>$committeeNameId,"IsActive"=>1]; 		
			$table="committeeType";	

			$resultData1=$this->AdminModel->getCommitteeTypes($committeeNameId);  
			echo json_encode($resultData1);   
			//echo json_encode('sss');   

		}elseif($action == 'get_designationId'){
			$committeeNameId=$this->request->getVar('committeeNameId');
			$where_parameter = ['IsActive'=>1,"committeeNameId"=>$committeeNameId];    
			$table="designation";	 

		 	$resultData1=$this->AdminModel->getDesignationIds($committeeNameId);  
			echo json_encode($resultData1); 


		}elseif($action == 'get_affiliatedCommitteeId'){
			$committeeTypeId=$this->request->getVar('committeeTypeId');
			$where_parameter = ['IsActive'=>1,"committeeTypeId"=>$committeeTypeId];   
			$table="affiliatedCommittees";	

			//$resultData=$this->ApiModel->getWhereQuery($table,$where_parameter);   
			//echo json_encode($resultData);   

			$resultData1=$this->AdminModel->getaffiliatedCommitteeIds($committeeTypeId);  
			echo json_encode($resultData1);  

		}elseif($action == 'get_designatedMember'){
			$designatedMember=$this->request->getVar('designatedMember');
			$where_parameter = ['IsActive'=>1,"designatedMember"=>$designatedMember];   
			$table="committeeName";	

			$resultData=$this->ApiModel->getWhereQuery($table,$where_parameter);   
			echo json_encode($resultData);   

		}elseif($action == 'get_affliatedCommitteeById'){

			$committeeNameId=$this->request->getVar('committeeNameId'); 
			$resultData=$this->AdminModel->getaffliatedCommitteeById($committeeNameId);   
			echo json_encode($resultData);   

		}elseif($action == 'get_AffiliateddesignationId'){

			$affiliatedCommitteeId=$this->request->getVar('affiliatedCommitteeId'); 
			//	$resultData=$this->AdminModel->getaffliatedDesignationsById($committeeNameId);   
			$resultData1=$this->AdminModel->getAffDesignationIds($affiliatedCommitteeId);  
			echo json_encode($resultData1);   


		}elseif($action == 'get_affiliatedCommitteeIdForSmTask'){ 
			
			$committeeTypeName=$this->request->getVar('committeeTypeName'); 
			$committeeNameId=$this->request->getVar('committeeNameId');     
			 $resultData1=$this->AdminModel->getSmTaskAffliatedOrMain($committeeTypeName,$committeeNameId);  
			echo json_encode($resultData1); 
		}else{ 

		}
	 
		//echo json_encode('sss');    
	}

	//admin approve user compaining 
	public function userCampaignApprove(){
		if($this->request->getVar('action'))
		{
			 $ActivityId=$this->request->getVar('ActivityId');
			
			$where_parameter=['ActivityId'=>$ActivityId,'Activity_status'=>"Completed"];
			$resultData=$this->ApiModel->getWhereQuery('activitystatus',$where_parameter);
			foreach($resultData as $row){ 
				$result_Data[]=$this->AdminModel->updateQueryPointsDetails($row['ActivityStatuId'],$row['UserId'],$ActivityId);
			}
		} 
		$resultData=$result_Data;
		echo json_encode($resultData);
	}

	//app users upadate
	public function updateAppUser(){ 
		$session = \CodeIgniter\Config\Services::session();
		if($this->request->getMethod() == 'post'){
			$rules = [
				"FirstName" => "required",
				'ParliamentId'=>'required',
				'ConstituencyId'=>'required',
			];   
			$messages = [
				"FirstName" => [
					"required" => "FirstName is required"
				],
				"ParliamentId" => [
					"required" => "Parliament is required"
				],
				"ConstituencyId" => [
					"required" => "Constituency is required"
				]
			];
            if (!$this->validate($rules, $messages)) {
				$data["validation"]=$this->validator;
                return view('app_users_management',$data);
            }else{
				$u_id=$this->request->getVar('u_id',FILTER_SANITIZE_STRING);
				// if($this->request->getVar('ActivityCommitteeGroup',FILTER_SANITIZE_STRING)){
				// 	$ActivityCommitteeGroup=implode(",",$this->request->getVar('ActivityCommitteeGroup',FILTER_SANITIZE_STRING));
				// }else{
				// 	$ActivityCommitteeGroup="";
				// }
				// if($this->request->getVar('AppRoleGroupIds',FILTER_SANITIZE_STRING)){
				// 	$array_AppRoleGroupIds=$this->request->getVar('AppRoleGroupIds',FILTER_SANITIZE_STRING);
				// 	$AppRoleGroupIds=implode(",",$array_AppRoleGroupIds);
				// }else{
				// 	$AppRoleGroupIds="";
				// }

				//Roles Assigmed here committeeNameId
				$designatedMember=$this->request->getVar('designatedMember',FILTER_SANITIZE_STRING);
				$committeeNameId=$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING);
				if($designatedMember == "Yes"){
					if($this->request->getVar('committeeTypeId',FILTER_SANITIZE_STRING)){
						$committeeTypeId=$this->request->getVar('committeeTypeId',FILTER_SANITIZE_STRING);
					}else{
						$committeeTypeId="";
					}

					if(!empty($this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING))){
						$affiliatedCommitteeId=$this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING);
						
					}else{
						$affiliatedCommitteeId="0"; 
						
					}
					if($this->request->getVar('designationId',FILTER_SANITIZE_STRING)){
						$designationId=$this->request->getVar('designationId',FILTER_SANITIZE_STRING);
					}else{
						$designationId="";
					}
				}else{ 
					
					$committeeTypeId="";
					$affiliatedCommitteeId="";
					$designationId="";
				}
				
				$table_data=[
						'FirstName'=>$this->request->getVar('FirstName',FILTER_SANITIZE_STRING),
						'DisplayName'=>$this->request->getVar('DisplayName',FILTER_SANITIZE_STRING),
						'DOB'=>$this->request->getVar('DOB',FILTER_SANITIZE_STRING),
						//'ActivityCommitteeGroup'=>$ActivityCommitteeGroup, 
						'ParliamentId'=>$this->request->getVar('ParliamentId',FILTER_SANITIZE_STRING),
						//'AppRoleId'=>$this->request->getVar('AppRoleId',FILTER_SANITIZE_STRING), 
						'ConstituencyId'=>$this->request->getVar('ConstituencyId',FILTER_SANITIZE_STRING),
						'Status'=>$this->request->getVar('Status',FILTER_SANITIZE_STRING),
						'MandalId'=>$this->request->getVar('MandalId',FILTER_SANITIZE_STRING),
						//'AppRoleGroupIds'=>$AppRoleGroupIds,
						'FBLink'=>$this->request->getVar('FBLink',FILTER_SANITIZE_STRING),
						'TwitterLink'=>$this->request->getVar('TwitterLink',FILTER_SANITIZE_STRING),
						'InstaLink'=>$this->request->getVar('InstaLink',FILTER_SANITIZE_STRING),
						'YouTubeLink'=>$this->request->getVar('YouTubeLink',FILTER_SANITIZE_STRING),
						'AddressLine1'=>$this->request->getVar('AddressLine1',FILTER_SANITIZE_STRING),
						'AddressLine2'=>$this->request->getVar('AddressLine2',FILTER_SANITIZE_STRING),
						'Country'=>$this->request->getVar('Country',FILTER_SANITIZE_STRING),
						'State'=>$this->request->getVar('State',FILTER_SANITIZE_STRING),
						'City'=>$this->request->getVar('City',FILTER_SANITIZE_STRING),
						'PinCode'=>$this->request->getVar('PinCode',FILTER_SANITIZE_STRING),
						'AccountHolderName'=>$this->request->getVar('AccountHolderName',FILTER_SANITIZE_STRING),
						'AccountHolderNumber'=>$this->request->getVar('AccountHolderNumber',FILTER_SANITIZE_STRING),
						'BankName'=>$this->request->getVar('BankName',FILTER_SANITIZE_STRING),
						'BankBranch'=>$this->request->getVar('BankBranch',FILTER_SANITIZE_STRING),
						'IFSCCode'=>$this->request->getVar('IFSCCode',FILTER_SANITIZE_STRING),
						'PANNumber'=>$this->request->getVar('PANNumber',FILTER_SANITIZE_STRING),
						'GSTNumber'=>$this->request->getVar('GSTNumber',FILTER_SANITIZE_STRING),
						'Skill'=>$this->request->getVar('Skill',FILTER_SANITIZE_STRING), 
						'CommitteId'=>$this->request->getVar('CommitteeID',FILTER_SANITIZE_STRING), 
						'LastUpdatedBy'=> $session->get('u_id'), 
						'committeeNameId'=>$committeeNameId,
						'committeeTypeId'=>$committeeTypeId,
						'affiliatedCommitteeId'=>$affiliatedCommitteeId,
						'designatedMember'=>$designatedMember, 
						'designationId'=>$designationId,
						'LastUpdatedDate'=>date('Y-m-d H:i:s')

					];
					$table="users";
					$where_parameter="u_id";
					$where_id=$u_id;

				if($this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id) === false){

					$data=[
						'page_title'=>'Add Program Activity',
						'page_name'=>'add_program_activity'
					]; 
					$session->setFlashdata('error', 'Unable to Update User');
					return redirect()->route('get-app-users'); 
				}else{
					
				  	$session->setFlashdata('success', 'Successfully Updated');
					return redirect()->route('get-app-users'); 
					
				}
			
		 	}
		}
	}

	public function getRoles(){
		$data=[
			'page_title'=>'Roles',
			'page_name'=>'Roles',
			'title_active'=>'roles'
		 ];
		 return view('demo',$data); 
	}
	public function getPermissions(){
		$data=[
			'page_title'=>'Permissions',
			'page_name'=>'Permissions',
			'title_active'=>'permissions'
		 ];
		 return view('demo',$data); 
	}

	//user progrma activity
	public Function AppUserProgramActivity($id=null){    
		$data=[
			'page_title'=>'Program Activity',
			'page_name'=>'program_activity',
			'title_active'=>'user_program_activity'
		 ];
		 $where_parameter="ActivityId";
		 $where_id=$id;
		 $data['parent_activity_data']=$this->AdminModel->getRowTableById('activity',$where_parameter,$where_id);
		$table="activitystatus";
		$where_data='Open';
	//	$data['open']=$this->AdminModel->userProgramActivityCountByStatus($id,$where_data);
		$where=["Activity_status"=>"Open","ActivityId"=>$id];
		$data['open']=count($this->AdminModel->getQueryReultFromTable('activitystatus',$where));
	//	$where_data='Completed';
	//	$data['completed']=$this->AdminModel->userProgramActivityCountByStatus($id,$where_data);

		$where=["Activity_status"=>"completed","ActivityId"=>$id];
		$data['completed']=count($this->AdminModel->getQueryReultFromTable('activitystatus',$where));

		$data['viewed']="0";
		$data['compaign_status']=false; 
		$data['ActivityId']=$id;
		$where_data=['CheckView'=>1,'ActivityId'=>$id];
		$data["Views_count"]=$this->AdminModel->tableRowsCount('activitystatus',$where_data);
		$data['activitydetails']=$this->AdminModel->userProgramActivityGrid($id); 
		return view('users_program_activity_management',$data); 
	}

	//edit user compaining
	public function userProgramActivityEdit($id=null,$activitId=null){
		$session = session();
		$data=[
			'page_title'=>'Edit Campaign Detail Summary',
			'page_name'=>'add_program_activity',
			'title_active'=>'user_program_activity'
		 ];

		 $where=["ActivityId"=>$activitId];
		 $data['compaign_questions']= $this->AdminModel->getQueryReultFromTable('campaign_questions',$where);
		 $x=0; 
		 foreach($data['compaign_questions'] as $row){
			$where=["q_id"=>$row['campaign_question_id'],"ActivityStatuId"=>$id];
			$answer= $this->ApiModel->getRowTableByIds('user_custom_question_answers',$where);
			$data['compaign_questions'][$x]['answer']=isset($answer['option_id']) ? $answer['option_id'] : "";
			//$var = isset($array["key"]) ? $array["key"] : "default-value";

			 $where=["campaign_question_id"=>$row['campaign_question_id']];
			 $data['compaign_questions'][$x]['options']= $this->AdminModel->getQueryReultFromTable('campaign_option',$where); 
			 $x++;
		 }


		$parameters=array('ActivityGroupId','GroupName');
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTableAdmins('activitygroup',$parameters,$order_by); 
		$data['activitydetails']=$this->AdminModel->userProgramCampainingById($id); 
			$data['file_path']=$this->s3Url()."paf/".$data['activitydetails']['UploadResource']; 	
			$where_parameter = ['designatedMember' =>$data['activitydetails']["designatedMember"]]; 
			$table="committeeName";
			$data['committeeName']=$this->ApiModel->getWhereQuery($table,$where_parameter); 

			if($data['activitydetails']["designatedMember"]=="Yes"){ 
				$committeeTypeName=$data['activitydetails']["committeeTypeId"];
					
				//Get Afflliated Groups
				if($committeeTypeName == "Affiliated"){					

					//Get Afflliated Groups
					$committeeTypeName=$data['activitydetails']["committeeTypeId"];
					$committeeNameId=$data['activitydetails']["committeeNameIdS"];
					$data['affiliatedCommittees']=$this->AdminModel->getSmTaskAffliatedOrMain($committeeTypeName,$committeeNameId); 

					//get Designations
						$affiliatedCommitteeId=$data['activitydetails']["affiliatedCommitteeIds"];  
						$data['designation']=$this->AdminModel->getAffDesignationIds($affiliatedCommitteeId);  

				}else{
						//$committeeNameId=$data['activitydetails']["committeeNameIdS"];
						//$data['designation']=$this->AdminModel->getDesignationIds($committeeNameId); 

						$committeeNameId=$data['activitydetails']["committeeNameIdS"];
						$data['designation']=$this->AdminModel->getDesignationIds($committeeNameId); 
				}
			}
		//$data['file_path']=$this->s3GetObjects('program_activity_files',$data['activitydetails']['UploadResource']); 

		if(!empty($data['activitydetails']['InMediaCovarageFile'])){ 
				$data['file_path1']=$this->s3Url()."uaf/".$data['activitydetails']['InMediaCovarageFile']; 
			}else{
				$data['file_path1']="";
			}

			if(!empty($data['activitydetails']['InMaterialUsageFormatFile'])){ 
			//	$data['file_path2']=$this->s3GetObjects('user_uplode_activity_files',$data['activitydetails']['InMaterialUsageFormatFile']);
				$data['file_path2']=$this->s3Url()."uaf/".$data['activitydetails']['InMaterialUsageFormatFile'];  
				}else{
					$data['file_path2']="";
				}
	
		//$data['file_path2']=$this->s3GetObjects('user_uplode_activity_files',$data['activitydetails']['InMaterialUsageFormatFile']); 

		if(isset($data['activitydetails'])){  
			return view('edit_user_program_activity',$data);
		}else{
			return redirect()->route('User-Program-Campaign');
		}
	}

	//view user compaining
	public function userProgramActivityView($id=null,$activitId=null){ 
		$data=[
			'page_title'=>'View Campaign Detail Summary',
			'page_name'=>'add_program_activity',
			'title_active'=>'user_program_activity'
		 ];
		$parameters=array('ActivityGroupId','GroupName');
		$order_by='ActivityGroupId';
		$data['activitygroup']=$this->AdminModel->getQueryFromTableAdmins('activitygroup',$parameters,$order_by); 
		$data['view']=true;

		
		$where=["ActivityId"=>$activitId];
		$data['compaign_questions']= $this->AdminModel->getQueryReultFromTable('campaign_questions',$where);
		$x=0; 
		foreach($data['compaign_questions'] as $row){
		   $where=["q_id"=>$row['campaign_question_id'],"ActivityStatuId"=>$id];
		   $answer= $this->ApiModel->getRowTableByIds('user_custom_question_answers',$where);
		   $data['compaign_questions'][$x]['answer']=isset($answer['option_id']) ? $answer['option_id'] : "";
		   //$var = isset($array["key"]) ? $array["key"] : "default-value";

			$where=["campaign_question_id"=>$row['campaign_question_id']];
			$data['compaign_questions'][$x]['options']= $this->AdminModel->getQueryReultFromTable('campaign_option',$where); 
			$x++;
		}

			//$data['activitydetails']=$this->AdminModel->userProgramCampainingById($id);

			$data['activitydetails']=$this->AdminModel->userProgramCampainingById($id);

		//	$data['file_path']=$this->s3GetObjects('program_activity_files',$data['activitydetails']['UploadResource']); 
			$data['file_path']=$this->s3Url()."paf/".$data['activitydetails']['UploadResource']; 
	
			$where_parameter = ['designatedMember' =>$data['activitydetails']["designatedMember"]]; 
			$table="committeeName";
			$data['committeeName']=$this->ApiModel->getWhereQuery($table,$where_parameter); 

			if($data['activitydetails']["designatedMember"]=="Yes"){ 
				$committeeTypeName=$data['activitydetails']["committeeTypeId"];
					
				//Get Afflliated Groups
				if($committeeTypeName == "Affiliated"){					

					//Get Afflliated Groups
					$committeeTypeName=$data['activitydetails']["committeeTypeId"];
					$committeeNameId=$data['activitydetails']["committeeNameIdS"];
					$data['affiliatedCommittees']=$this->AdminModel->getSmTaskAffliatedOrMain($committeeTypeName,$committeeNameId); 

					//get Designations
						$affiliatedCommitteeId=$data['activitydetails']["affiliatedCommitteeIds"];  
						$data['designation']=$this->AdminModel->getAffDesignationIds($affiliatedCommitteeId);  

				}else{
						//$committeeNameId=$data['activitydetails']["committeeNameIdS"];
						//$data['designation']=$this->AdminModel->getDesignationIds($committeeNameId); 

						$committeeNameId=$data['activitydetails']["committeeNameIdS"];
						$data['designation']=$this->AdminModel->getDesignationIds($committeeNameId); 
				}
			}
	//	$data['file_path']=$this->s3GetObjects('program_activity_files',$data['activitydetails']['UploadResource']); 

		if(!empty($data['activitydetails']['InMediaCovarageFile'])){ 
				$data['file_path1']=$this->s3Url()."uaf/".$data['activitydetails']['InMediaCovarageFile']; 
			}else{
				$data['file_path1']="";
			}

			if(!empty($data['activitydetails']['InMaterialUsageFormatFile'])){ 
				//$data['file_path2']=$this->s3GetObjects('user_uplode_activity_files',$data['activitydetails']['InMaterialUsageFormatFile']);
				$data['file_path2']=$this->s3Url()."uaf/".$data['activitydetails']['InMaterialUsageFormatFile'];  
				}else{
					$data['file_path2']="";
				}
	
	//	$data['file_path2']=$this->s3GetObjects('user_uplode_activity_files',$data['activitydetails']['InMaterialUsageFormatFile']); 

		if(isset($data['activitydetails'])){ 
			return view('edit_user_program_activity',$data);
		}else{
			return redirect()->route('User-Program-Campaign');
		}
	}

	//feeds management
	public Function Feeds(){   
	//	echo $sound = base_url()."/public/fcm_sound/office_bell.mp3"; 
	//	exit();
		$data=[
			'page_title'=>'Feeds',
			'page_name'=>'Feeds',
			'title_active'=>'feeds'
			];
			/* 
		$parameters=array('IsActive','NewsFeedId','Title','Description','FeedType','CreatedDate');
		$order_by='NewsFeedId';
		$data['feeddetails']=$this->AdminModel->getQueryFromTableAdmins('newsfeed',$parameters,$order_by); 

		$i=0;
		foreach($data['feeddetails'] as $row){ 

			$where_data=["ViewFrom"=>"feeds","ViewFromId"=>$row["NewsFeedId"] ]; 
			$ViewData=$this->AdminModel->tableRowsCount('ViewsCheck',$where_data);
			if($ViewData){
				$CheckView=$ViewData;
			}else{
				$CheckView=0;
			} 
			$data['feeddetails'][$i]['CheckView']=$CheckView; 

			$where_data=["SharedFrom"=>"feeds","SharedFromId"=>$row["NewsFeedId"] ]; 
			$ShareCount=$this->AdminModel->tableRowsCount('ShareDetails',$where_data);
			if($ShareCount){
				$ShareCount=$ShareCount;
			}else{
				$ShareCount=0;
			} 
			$data['feeddetails'][$i]['ShareCount']=$ShareCount;

			$where_data=['NewsFeedId'=>$row["NewsFeedId"]];
            $likes=$this->AdminModel->tableRowsCount('newsfeedlikes',$where_data);
			$data['feeddetails'][$i]['likes']=$likes; 
			
			$i++;
		}
		*/
		$parameters=array('*');
		$order_by='NewsFeedId';
		$data['feeddetails']=$this->AdminModel->getQueryFromTableAdmins('newsfeed',$parameters,$order_by); 
		return view('feed_management',$data);
	}

	// add feed
	public function AddFeed(){
		$session = session();
		$data=[
			'page_title'=>'Add Feed',
			'page_name'=>'Add Feed',
			'title_active'=>'feeds'
		 ];
		 if($this->request->getMethod() == 'post'){
			$rules=[
				'Title'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Title is a required'
					]
				],
				'Description'=>[
					'rules'=>'required',
					'label'=>'Description',
					'errors'=>[
						'required'=>'Description is a required'
					]
				],
			];
			$thumb_file_name="";
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_feed',$data);
            }else{
				$FeedType=$this->request->getVar('FeedType',FILTER_SANITIZE_STRING);
				if($FeedType == "Links"){
					$Links=$this->request->getVar('Links',FILTER_SANITIZE_STRING);
					$file_name=""; 
				}else{
					$Links=""; 
				}
			
				$FeedType=$this->request->getVar('FeedType',FILTER_SANITIZE_STRING);
				if($FeedType == "Links"){
					$Links=$this->request->getVar('Links',FILTER_SANITIZE_STRING);
					$file_name=""; 
					$thumb_url="";
				}else{ 
				
					$Links=""; 
					$file=$this->request->getFile('file',FILTER_SANITIZE_STRING); 
					if($file->isValid() && !$file->hasMoved()){
							$getClientExtension=$file->getClientExtension();
								if($getClientExtension == "jpg" || $getClientExtension == "jpeg" ||  $getClientExtension == "png" ){
									$isFile = $this->request->getFile('file');
									$data = getimagesize($isFile);
									$width = $data[0];
									$height = $data[1];
									$xOffset = ($width / 2) - 25;
									$yOffset = ($height / 2) - 25;
									$thumb_file_name=$isFile->getRandomName();
									$image = \Config\Services::image()
										->withFile($isFile)
										->fit(512, 512, 'center')
										->save('uploads/fd/'. $thumb_file_name); 
									$url_thumb=".uploads/fd/".$thumb_file_name;
									$file_Path = base_url()."/uploads/fd/".$thumb_file_name; 
									$this->s3Upload('fd',$file_Path);  
								}else{
									$thumb_file_name="";
								}

							//$file_name=$file->getRandomName();
							$getClientExtension=$file->getClientExtension(); 
							//$file_name=uniqid(time()).'.'.$getClientExtension;
							$file_nam_uniq=uniqid(time());
							$file_name=$file_nam_uniq.'.'.$getClientExtension;
							$file->move('uploads/fd',$file_name); 
							//s3 uplode
							$file_Path = base_url()."/uploads/fd/". $file_name; 
							$this->s3Upload('fd',$file_Path); 
							$url="./uploads/fd/".$file_name;
							unlink($url);
							
							// Generate Html
							$org_file=$this->s3Url().'fd/'.$file_name;
							if($getClientExtension == "jpg" || $getClientExtension == "jpeg" ||  $getClientExtension == "png" ){
								//$thumb_file=$this->s3Url().'fd/'.$file_name;
								//$thumb_file_name=$this->s3Url().'fd/'.$thumb_file_name;
								$thumb_file=$this->s3Url().'fd/'.$thumb_file_name;
							}elseif($getClientExtension == "doc" || $getClientExtension == "pdf" || $getClientExtension == "docx"){
								$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";							
							}elseif($getClientExtension == "mp3"){
								$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
							}elseif($getClientExtension == "mp4"){
								$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
							
							}else{
								$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
							}

							//$html_file=uniqid(time()).'.html';
							$html_file=$file_nam_uniq.'.html';
							$title=$this->request->getVar('Title',FILTER_SANITIZE_STRING);
							$myfile = fopen($html_file, "w") or die("Unable to open file!");
							$txt = '<!DOCTYPE html>
							<html lang="en">
							<head>
								<!-- Primary Meta Tags -->
							<title>Mana Tdp</title>
							<meta name="title" content="'.$title.'">
							<meta name="description" content="">  
							<!-- Twitter -->
							<meta property="twitter:card" content="summary_large_image">
							<meta property="twitter:title" content="'.$title.'">
							<meta property="twitter:description" content="">
							<meta property="twitter:image" content="'.$thumb_file.'">								
							<meta http-equiv = "refresh" content = "0; url = '.$org_file.'" />

							<meta property="og:site_name" content="Mana Tdp">
							<meta property="og:title" content="'.$title.'" />
							<meta property="og:description" content="Via Mana TDP" /> 
							<meta property="og:image" itemprop="image" content="'.$thumb_file.'">
							<meta property="og:type" content="Mana Tdp" />
							<link href="'.$thumb_file.'" rel="image_src">
							</head>
							<body>
															
							</body>
							</html>';
							fwrite($myfile, $txt);

															
							$filePath_thumb = $html_file; 
							$thumb_url=$this->s3Url().'th/fd/'.$html_file;
							$destinationFilePath = 'uploads/thumbnails_html/fd/'.$html_file;
							/* Move File from images to copyImages folder */
							if( !rename($filePath_thumb, $destinationFilePath) ) {  
								//echo "File can't be moved!";  
							}  
							else{  
								//echo "File has been moved!"; 
								$file_Path = base_url()."/uploads/thumbnails_html/fd/".$filePath_thumb;  
								$this->s3UploadThumb('fd',$file_Path);  
								//chmod($file_Path, 0644);
								//unlink($file_Path);    
							}
					}else{
						$session->setFlashdata('error', 'Unable to file upload file try again');
						return redirect()->route('Feeds'); 
					}
				
				}		
				$live=$this->request->getVar('live');
				if(isset($live)){
					$live="Yes";	 
					$live_from=$this->request->getVar('live_from'); 					
					if($live_from=="youtube"){
						$Links=str_replace("watch?v=","embed/",$Links);
					}else{
						 $Links=$this->request->getVar('Links');
					
					}
					
				}else{
					$live="No";
					$live_from="";
				}
				// end test here
				$table_data=[
						'Title'=>$this->request->getVar('Title'), 
						'Description'=>$this->request->getVar('Description',FILTER_SANITIZE_STRING),
						'FeedType'=>$this->request->getVar('FeedType',FILTER_SANITIZE_STRING),
						'FeedFileName'=>$file_name,
						'Links'=>$Links,
						'live'=>$live,
						'live_from'=>$live_from,  
						'thumb_url'=>$thumb_url,       
						'feed_thumb_file'=>$thumb_file_name, 
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s')

					];
					$NewsFeedId=$this->AdminModel->insert_record('newsfeed',$table_data); 
				if($NewsFeedId === false){						
					$data=[
						'page_title'=>'Add Feed',
						'page_name'=>'Add Feed',
						'title_active'=>'feeds'
					]; 
					$session->setFlashdata('error', 'Unable to Added Feed');
					return redirect()->route('Feeds');
				}else{
					if($live == "Yes"){
						$where_user_data=["Status"=>"Approved"];
						$UserDetails1=$this->AdminModel->getQueryReultFromTable('users',$where_user_data); 
				
						$device_token=array();
						//insert into Notification table
						if($UserDetails1){    
							foreach($UserDetails1 as $row){ 
							
								$title="Today Live ";
								$message=$this->request->getVar('Title');
								//
								if($row['device_token']){ 
									$device_token[]=$row['device_token'];
									//$this->fcm_notification($row['device_token'],$title,$message);
								}
								$table_notification_data[]=[ 
									'NotificationUserId'=>$row['u_id'],
									'NotificationTitle'=>$title,
									'NotificationDescription'=>$message,
									'NotificationType'=>"Feeds",
									'FromId'=>$NewsFeedId,
									'CreatedDate'=>date('Y-m-d H:i:s')
								];
							
							}	
							$this->fcm_notification($device_token,$title,$message);	
							//$this->AdminModel->InsertImportData('activitystatus',$table_data_users_chlid);
							$this->AdminModel->InsertImportData('notifications',$table_notification_data);
						}
					}

					$session->setFlashdata('success', 'Successfully Added Feed');
					return redirect()->route('Feeds');
				}
			
		 	}
		 }
		return view('add_feed',$data);
	}

	//edit feed
	public function feedEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'Feed Edit',
			'page_name'=>'Feed Edit',
			'title_active'=>'feeds'
		 ];
		$table="newsfeed";
		$where_id=$id;
		$where_parameter="NewsFeedId";
		$data['feeddetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		if($data['feeddetails']['FeedType']!="Links"){ 
			$data['file_path']=$this->s3Url()."fd/".$data['feeddetails']['FeedFileName'];
		}
	//	$data['file_path']=$this->s3GetObjects('feed_files',$data['feeddetails']['FeedFileName']); 
		if(isset($data['feeddetails'])){
			return view('add_feed',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Feeds');
		}
	}

	//feed view
	public function feedView($id=null){
		$session = session();
		$data=[
			'page_title'=>'Feed View',
			'page_name'=>'Feed View',
			'title_active'=>'feeds'
		 ];
		 $data['view']=true;
		$table="newsfeed";
		$where_id=$id;
		$where_parameter="NewsFeedId";
		$data['feeddetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		if($data['feeddetails']['FeedType']!="Links"){ 
			$data['file_path']=$this->s3Url()."fd/".$data['feeddetails']['FeedFileName'];
		}
		if(isset($data['feeddetails'])){
			return view('add_feed',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Feeds');
		}
	}

	public function feedDetailsView($id=null){
		$table="newsfeed";
		$where_id=$id;
		$where_parameter="NewsFeedId";
		$data['feeddetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		$data['file_path']=$this->s3Url()."fd/".$data['feeddetails']['FeedFileName'];
		if(isset($data['feeddetails'])){
			return view('feed_file',$data);
		}
	}

	public function UpdateFeed(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Feed Edit',
			'page_name'=>'Feed Edit',
			'title_active'=>'feeds'
		 ];
		if($this->request->getMethod() == 'post'){
			$rules=[
				'Title'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Title is a required'
					]
				],
				'Description'=>[
					'rules'=>'required',
					'label'=>'Description',
					'errors'=>[
						'required'=>'Description is a required'
					]
				]

			];
			
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_feed',$data);
            }else{
				$thumb_file_name='';
				$FeedType=$this->request->getVar('FeedType',FILTER_SANITIZE_STRING);
				$from_npo=$this->request->getVar('from_npo',FILTER_SANITIZE_STRING);
				if($FeedType == "Links"){ 
					$Links=$this->request->getVar('Links',FILTER_SANITIZE_STRING);
					if(!empty($this->request->getVar('old_img'))){ 
						// $url="./uploads/feed_files/".$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
						// unlink($url);
						$this->s3DeleteObjects('fd',$this->request->getVar('old_img',FILTER_SANITIZE_STRING));
					} 
					$file_name="";
					$thumb_url="";
				}else{
					$Links="";
					$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
					if($file->isValid() && !$file->hasMoved()){ 

						$getClientExtension=$file->getClientExtension();
						if($getClientExtension == "jpg" || $getClientExtension == "jpeg" ||  $getClientExtension == "png" ){
							$isFile = $this->request->getFile('file');
							$data = getimagesize($isFile);
							$width = $data[0];
							$height = $data[1];
							$xOffset = ($width / 2) - 25;
							$yOffset = ($height / 2) - 25;
							$thumb_file_name=$isFile->getRandomName();
							$image = \Config\Services::image()
								->withFile($isFile)
								->fit(512, 512, 'center')
								->save('uploads/fd/'. $thumb_file_name); 
							$url_thumb=".uploads/fd/".$thumb_file_name;
							$file_Path = base_url()."/uploads/fd/".$thumb_file_name; 
							$this->s3Upload('fd',$file_Path);  
						}else{
							$thumb_file_name=""; 
						}


						//$file_name=uniqid(time()).'.'.$getClientExtension;
						$file_nam_uniq=uniqid(time());
						$file_name=$file_nam_uniq.'.'.$getClientExtension;
						$file->move('uploads/fd',$file_name);   
						//s3 uplode
						$file_Path = base_url()."/uploads/fd/". $file_name; 
						$this->s3Upload('fd',$file_Path); 
						$url="./uploads/fd/".$file_name; 
						unlink($url);

						// Generate Html
						if($from_npo == 0){
							$org_file=$this->s3Url().'fd/'.$file_name;
						}else{
							$org_file= base_url()."/feed-details-view/".$this->request->getVar('NewsFeedId',FILTER_SANITIZE_STRING); 
						}

						
						if($getClientExtension == "jpg" || $getClientExtension == "jpeg" ||  $getClientExtension == "png" ){
							$thumb_file=$this->s3Url().'fd/'.$file_name;
						}elseif($getClientExtension == "doc" || $getClientExtension == "pdf" || $getClientExtension == "docx"){
							$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";							
						}elseif($getClientExtension == "mp3"){
							$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
						}elseif($getClientExtension == "mp4"){
							$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
						
						}else{
							$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
						}

						//$html_file=uniqid(time()).'.html';
						$html_file=$file_nam_uniq.'.html';
						$title=$this->request->getVar('Title',FILTER_SANITIZE_STRING);
						$myfile = fopen($html_file, "w") or die("Unable to open file!");
						$txt = '<!DOCTYPE html>
						<html lang="en">
						<head>
							<!-- Primary Meta Tags -->
						<title>Mana Tdp</title>
						<meta name="title" content="'.$title.'">
						<meta name="description" content="">  
						<!-- Twitter -->
						<meta property="twitter:card" content="summary_large_image">
						<meta property="twitter:title" content="'.$title.'">
						<meta property="twitter:description" content="">
						<meta property="twitter:image" content="'.$thumb_file.'">								
						<meta http-equiv = "refresh" content = "0; url = '.$org_file.'" />

						<meta property="og:site_name" content="Mana Tdp">
						<meta property="og:title" content="'.$title.'" />
						<meta property="og:description" content="Via Mana TDP" /> 
						<meta property="og:image" itemprop="image" content="'.$thumb_file.'">
						<meta property="og:type" content="Mana Tdp" />
						<link href="'.$thumb_file.'" rel="image_src">
						</head>
						<body>
														
						</body>
						</html>';
						fwrite($myfile, $txt);

														
						$filePath_thumb = $html_file; 
						$destinationFilePath = 'uploads/thumbnails_html/fd/'.$html_file;
						/* Move File from images to copyImages folder */
						if( !rename($filePath_thumb, $destinationFilePath) ) {  
							//echo "File can't be moved!";  
						}  
						else{  
							//echo "File has been moved!"; 
							$file_Path = base_url()."/uploads/thumbnails_html/fd/".$filePath_thumb;  
							$this->s3UploadThumb('fd',$file_Path);  
							//chmod($file_Path, 0644);
							//unlink($file_Path);    
						}
						$thumb_url=$this->s3Url().'th/fd/'.$html_file; 

						

						if(!empty($this->request->getVar('old_img'))){ 
							// unlink($url);
							//delete old file
							$this->s3DeleteObjects('fd',$this->request->getVar('old_img',FILTER_SANITIZE_STRING));
						}
					
					}else{
						$thumb_file_name=$this->request->getVar('feed_thumb_file',FILTER_SANITIZE_STRING);
						$thumb_url="";
						$file_name=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
						$html_file1= strstr($file_name, ".", true);
						$thumb_url=$this->s3Url().'th/fd/'.$html_file1.'.html';    
						
					}
				}
				 $live=$this->request->getVar('live');
				if(isset($live)){
					$live="Yes";	 
					$live_from=$this->request->getVar('live_from'); 					
					if($live_from=="youtube"){
						$Links=str_replace("watch?v=","embed/",$Links);
					}else{
						 $Links=$this->request->getVar('Links');
					
					}
					
				}else{
					$live="No";
					$live_from="";
				}

				$table_data=[
						'Title'=>$this->request->getVar('Title',FILTER_SANITIZE_STRING),
						'Description'=>$this->request->getVar('Description',FILTER_SANITIZE_STRING),
						'FeedType'=>$this->request->getVar('FeedType',FILTER_SANITIZE_STRING),
						'FeedFileName'=>$file_name,
						'thumb_url'=>$thumb_url,       
						'feed_thumb_file'=>$thumb_file_name,        
						'Links'=>$Links, 
						'live'=>$live,
						'live_from'=>$live_from,
						'LastUpdatedBy'=>$session->get('u_id'),
						'LastUpdatedDate'=>date('Y-m-d H:i:s')
					];
					$where_parameter="NewsFeedId";
					$where_id=$this->request->getVar('NewsFeedId',FILTER_SANITIZE_STRING);
					$NewsFeedId=$this->AdminModel->updateQuery('newsfeed',$table_data,$where_parameter,$where_id); 
				if($NewsFeedId === false){						
					$data=[
						'page_title'=>'Add Feed',
						'page_name'=>'Add Feed',
						'title_active'=>'feeds'
					]; 
					$session->setFlashdata('error', 'Unable to Added Feed');
					return redirect()->route('Feeds');
				}else{
					$session->setFlashdata('success', 'Successfully Added Feed');
					return redirect()->route('Feeds');
				}
		 	}
		 }
	}

	//feeds management
	public Function ePaper(){ 
		$data=[
			'page_title'=>'E-Paper',
			'page_name'=>'E-Paper',
			'title_active'=>'E-Paper'
			];
			$parameters=array('EpaperId','Title','EpaperFileName','file_date','CreatedDate','IsActive');
			$order_by='EpaperId';
			$data['epaperdetails']=$this->AdminModel->getQueryFromTableAdmins('epaper',$parameters,$order_by); 
			$i=0;
			foreach($data['epaperdetails'] as $row){ 

				$where_data=["ViewFrom"=>"epaper","ViewFromId"=>$row["EpaperId"] ]; 
				$ViewData=$this->AdminModel->tableRowsCount('ViewsCheck',$where_data);
				if($ViewData){
					$CheckView=$ViewData;
				}else{
					$CheckView=0;
				} 
				$data['epaperdetails'][$i]['CheckView']=$CheckView; 
				$i++;
			}
		return view('epaper_management',$data);
	}

	//DOBNotifications
	public function DOBNotifications(){
		$data=[
			'page_title'=>'DOB-Notifications',
			'page_name'=>'DOB-Notifications',
			'title_active'=>'DOB-Notifications'
			];
			$parameters=array('EpaperId','Title','EpaperFileName','file_date','CreatedDate','IsActive');
			$order_by='EpaperId';
			//$data['epaperdetails']=$this->AdminModel->getQueryFromTableAdmins('epaper',$parameters,$order_by); 
			$data['dob_notifications_details']=$this->AdminModel->getDOBNotification(); 
			
		return view('dob_notifications_management',$data);
	}

	//add e paper
	public function addEPaper(){ 
		$session = session();
		$data=[
			'page_title'=>'Add E-Paper',
			'page_name'=>'Add E-Paper',
			'title_active'=>'E-Paper'
		 ];
		 if($this->request->getMethod() == 'post'){
			$rules=[
				'Title'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Title is a required'
					]
				],
				"file" => [
					'uploaded[file]',
					'max_size[file,10240]',

				  ],
				'file_date'=>[
					'rules'=>'required',
					'label'=>'Date',
					'errors'=>[
						'required'=>'Date is a required'
					]
				]
			];
			$validation=$this->validate($rules); 
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_e_paper',$data);
            }else{
				//file upload code
				$file_names="";
				$file=$this->request->getFile('file',FILTER_SANITIZE_STRING); 
			//	print_r($file);
				if($file->isValid() && !$file->hasMoved()){

					//$file_name=$file->getRandomName();
					//new code file uplode
					// $getClientExtension=$file->getClientExtension();
					// $file_name='ep'.$EpaperId.'-'.$EpaperId.'.'.$getClientExtension;
					$getClientExtension=$file->getClientExtension();
					$file_name=uniqid(time()).'.'.$getClientExtension;
					$file->move('uploads/ep',$file_name);   
					//s3 uplode
					$file_Path = base_url()."/uploads/ep/". $file_name; 
					$this->s3Upload('ep',$file_Path); 
					$url="./uploads/ep/".$file_name; 
					unlink($url);
 
					$file_image=$this->request->getFile('file_image',FILTER_SANITIZE_STRING);
				//	print_r($file_image);
				//	exit();
					if($file_image->isValid() && !$file_image->hasMoved()){  
							$getClientExtensions=$file_image->getClientExtension();
							$file_names=uniqid(time()).'.'.$getClientExtensions; 
							$file_image->move('uploads/ep',$file_names);      
							//s3 uplode
							$file_Paths = base_url()."/uploads/ep/". $file_names;  
							//$this->s3Upload('ep',$file_Paths);   
							$url="./uploads/ep/".$file_names;  
					    	 unlink($url); 

					}else{

					}
				}else{
					$session->setFlashdata('error', 'Unable to E-Paper file upload file try again');
					return redirect()->route('E-Paper');
				}

				
				// end test here
				$table_data=[
						'Title'=>$this->request->getVar('Title',FILTER_SANITIZE_STRING),
						'file_date'=>$this->request->getVar('file_date',FILTER_SANITIZE_STRING),
						'EpaperFileName'=>$file_name,
						'epaper_thumbnail'=>$file_names,
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s')
					];
					$EpaperId=$this->AdminModel->insert_record('epaper',$table_data); 
				if($EpaperId === false){						
					$data=[
						'page_title'=>'Add E-Paper',
						'page_name'=>'Add E-Paper',
						'title_active'=>'E-Paper'
					]; 
					$session->setFlashdata('error', 'Unable to Added E-Paper');
					return redirect()->route('E-Paper');
				}else{
					$where_user_data=["Status"=>"Approved"];
					$UserDetails1=$this->AdminModel->getQueryReultFromTable('users',$where_user_data);
					 //insert into Notification table
					 $device_token=array();
					if($UserDetails1){    
						foreach($UserDetails1 as $row){ 
							$title="E-Paper - చైతన్య రధం";
							$message="Today E-Paper via ManaTDP";
						
							if($row['device_token']){ 
								$device_token[]=$row['device_token'];
								//$this->fcm_notification($row['device_token'],$title,$message);
							}
							$table_notification_data[]=[ 
								'NotificationUserId'=>$row['u_id'],
								'NotificationTitle'=>$title,
								'NotificationDescription'=>$message,
								'NotificationType'=>"Epaper",
								'FromId'=>$EpaperId,
								'CreatedDate'=>date('Y-m-d H:i:s')
							];
						
						}	
						$this->fcm_notification($device_token,$title,$message);					
						//$this->AdminModel->InsertImportData('activitystatus',$table_data_users_chlid);
						$this->AdminModel->InsertImportData('notifications',$table_notification_data);
					}
				
					$session->setFlashdata('success', 'Successfully Added E-paper');
					return redirect()->route('E-Paper');
				}
			// }else{
			// 	$session->setFlashdata('error', 'Unable to E-Paper file upload file try again');
			// 	return redirect()->route('E-Paper');
			// }
		 }
		}		
		return view('add_e_paper',$data);
	}

	//edit epaper
	public function ePaperEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'Edit E-Paper',
			'page_name'=>'Edit E-Paper',
			'title_active'=>'E-Paper'
		 ];
		$table="epaper";
		$where_id=$id;
		$where_parameter="EpaperId";
		$data['epaperdetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id); 
		//$data['file_path']=$this->s3GetObjects('e_paper',$data['epaperdetails']['EpaperFileName']); 
		$data['file_path']=$this->s3Url()."ep/".$data['epaperdetails']['EpaperFileName'];
		if(isset($data['epaperdetails'])){
			return view('add_e_paper',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('E-Paper');
		}
	}
  
	public function updateEPaper(){ 
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Edit E-Paper',
			'page_name'=>'Edit E-Paper',
			'title_active'=>'E-Paper'
		 ];
		if($this->request->getMethod() == 'post'){
			$rules=[
				'Title'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Title is a required'
					]
				],
				'file_date'=>[
					'rules'=>'required',
					'label'=>'Date',
					'errors'=>[
						'required'=>'Date is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_feed',$data);
            }else{
				
				$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
				if($file->isValid() && !$file->hasMoved()){
					$getClientExtension=$file->getClientExtension();
					$file_name=uniqid(time()).'.'.$getClientExtension;
					$file->move('uploads/ep',$file_name); 
					// $url="./uploads/e_paper/".$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
					// unlink($url);
					
					//s3 uplode code
					$file_Path = base_url()."/uploads/ep/". $file_name; 
					$this->s3Upload('ep',$file_Path); 
					$url="./uploads/ep/".$file_name;
					unlink($url);

					//delete old file
					//$this->s3DeleteObjects('ep',$this->request->getVar('old_img',FILTER_SANITIZE_STRING));

				}else{
					$file_name=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
				}
				$file_image=$this->request->getFile('file_image',FILTER_SANITIZE_STRING);
				if($file_image->isValid() && !$file_image->hasMoved()){
					$getClientExtension=$file_image->getClientExtension();
					$file_image_name=uniqid(time()).'.'.$getClientExtension;
					 $file_image->move('uploads/ep',$file_image_name); 
					// $url="./uploads/e_paper/".$this->request->getVar('old_img1',FILTER_SANITIZE_STRING);
					// unlink($url);
					
					//update new file
					$file_Path = base_url()."/uploads/ep/". $file_image_name; 
					$this->s3Upload('ep',$file_Path); 
					$url="./uploads/ep/".$file_image_name;
					unlink($url);

					//delete old file
					if($file_image){
						//$this->s3DeleteObjects('ep',$this->request->getVar('old_img1',FILTER_SANITIZE_STRING));
					}	
					

				}else{
					$file_image_name=$this->request->getVar('old_img1',FILTER_SANITIZE_STRING);
				}
				// end test here 
				$table_data=[
						'Title'=>$this->request->getVar('Title',FILTER_SANITIZE_STRING),
						'file_date'=>$this->request->getVar('file_date',FILTER_SANITIZE_STRING),
						'EpaperFileName'=>$file_name,
						'epaper_thumbnail'=>$file_image_name,
						'LastUpdatedBy'=>$session->get('u_id'),
						'LastUpdatedDate'=>date('Y-m-d H:i:s')
					];
					$where_parameter="EpaperId";
					$where_id=$this->request->getVar('EpaperId',FILTER_SANITIZE_STRING);
					$EpaperId=$this->AdminModel->updateQuery('epaper',$table_data,$where_parameter,$where_id); 
				if($EpaperId === false){						
					$data=[
						'page_title'=>'Edit E-Paper',
						'page_name'=>'Edit E-Paper',
						'title_active'=>'E-Paper'
					]; 
					$session->setFlashdata('error', 'Unable to Added E-Paper');
					return redirect()->route('E-Paper');
				}else{
					$session->setFlashdata('success', 'Successfully Added  E-Paper');
					return redirect()->route('E-Paper');
				}
			
		 	}
		 }
	}
	//View epaper
	public function ePaperView($id=null){
		$session = session();
		$data=[
			'page_title'=>'View E-Paper',
			'page_name'=>'View E-Paper',
			'title_active'=>'E-Paper'
			];
		$data['view']=true;
		$table="epaper";
		$where_id=$id;
		$where_parameter="EpaperId";
		$data['epaperdetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		//$data['file_path']=$this->s3GetObjects('e_paper',$data['epaperdetails']['EpaperFileName']);
		$data['file_path']=$this->s3Url()."ep/".$data['epaperdetails']['EpaperFileName'];
		if(isset($data['epaperdetails'])){
			return view('add_e_paper',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('E-Paper');
		}
	}
	//SM Tasks
	public Function smTasks(){ 
		$session = session();
		$data=[
			'page_title'=>'Tasks',
			'page_name'=>'Social Media Tasks',
			'title_active'=>'tasks'
			];
		$data['taskdetails']=$this->AdminModel->getTasks(); 
		/* $data['taskdetails']=$this->AdminModel->getTasks();
		$i=0;
		foreach($data['taskdetails'] as $row){  

			$where_data=["ViewFrom"=>"smtasks","ViewFromId"=>$row["TaskId"] ]; 
			$ViewData=$this->AdminModel->tableRowsCount('ViewsCheck',$where_data);
			if($ViewData){
				$CheckView=$ViewData;
			}else{
				$CheckView=0;
			} 
			$data['taskdetails'][$i]['CheckView']=$CheckView; 


			$where_data=["SharedFrom"=>"smtasks","SharedFromId"=>$row["TaskId"] ]; 
			$ShareCount=$this->AdminModel->tableRowsCount('ShareDetails',$where_data);
			if($ShareCount){
				$ShareCount=$ShareCount;
			}else{
				$ShareCount=0;
			} 
			$data['taskdetails'][$i]['ShareCount']=$ShareCount;

			$i++;
		}
			*/
		return view('task_management',$data); 
	}
	// add feed  
	public function addSmTask(){  
		$session = session();
		$data=[
			'page_title'=>'Add Task',
			'page_name'=>'Add Task',
			'title_active'=>'tasks'
			];

			//$parameters=array('ActivityGroupId','GroupName');
			//$order_by='ActivityGroupId';
			//$data['activitygroup']=$this->AdminModel->getQueryFromTable('activitygroup',$parameters,$order_by); 

			if($this->request->getMethod() == 'post'){   
				$rules=[
					'Title'=>[
						'rules'=>'required',
						'label'=>'Title',
						'errors'=>[
							'required'=>'Title is a required'
						]
					]
				];
				$validation=$this->validate($rules);
				if (!$validation) {
					$data["validation"]=$this->validator;
					return view('add_task',$data);
				}else{	
					//file uplode code
					$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
						if($file->isValid() && !$file->hasMoved()){  
							//$title=$this->request->getVar('Title',FILTER_SANITIZE_STRING);
								$getClientExtension=$file->getClientExtension();
								if($getClientExtension == "jpg" || $getClientExtension == "jpeg" ||  $getClientExtension == "png" ){
									$isFile = $this->request->getFile('file');
									$data = getimagesize($isFile);
									$width = $data[0];
									$height = $data[1];
									$xOffset = ($width / 2) - 25;
									$yOffset = ($height / 2) - 25;
									$thumb_file_name=$isFile->getRandomName();
									$image = \Config\Services::image()
										->withFile($isFile)
										->fit(512, 512, 'center')
										->save('uploads/tk/'. $thumb_file_name); 
									$url_thumb=".uploads/tk/".$thumb_file_name;
									$file_Path = base_url()."/uploads/tk/".$thumb_file_name; 
									$this->s3Upload('tk',$file_Path);  
								}else{
									$thumb_file_name="";
								}

								$getClientExtension=$file->getClientExtension();
								$file_nam_uniq=uniqid(time());
								$file_name=$file_nam_uniq.'.'.$getClientExtension;
								$file->move('uploads/tk',$file_name);  
								//s3 uplode
								$file_Path = base_url()."/uploads/tk/". $file_name; 
								$this->s3Upload('tk',$file_Path); 
								$url="./uploads/tk/".$file_name; 
								unlink($url); 

								
								// Generate Html
								$org_file=$this->s3Url().'tk/'.$file_name;
								if($getClientExtension == "jpg" || $getClientExtension == "jpeg" ||  $getClientExtension == "png" ){
									$thumb_file=$this->s3Url().'tk/'.$thumb_file_name;
									//$thumb_file=$this->s3Url().'tk/'.$file_name;
								}elseif($getClientExtension == "doc" || $getClientExtension == "pdf" || $getClientExtension == "docx"){
									$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";							
								}elseif($getClientExtension == "mp3"){
									$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
								}elseif($getClientExtension == "mp4"){
									$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
								
								}else{
									$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
								}

								//$html_file=uniqid(time()).'.html';
								$html_file=$file_nam_uniq.'.html';
								$title=$this->request->getVar('Title',FILTER_SANITIZE_STRING);
								$myfile = fopen($html_file, "w") or die("Unable to open file!");
								$txt = '<!DOCTYPE html>
								<html lang="en">
								<head>
									<!-- Primary Meta Tags -->
								<title>Mana Tdp</title>
								<meta name="title" content="'.$title.'">
								<meta name="description" content="">  
								<!-- Twitter -->
								<meta property="twitter:card" content="summary_large_image">
								<meta property="twitter:title" content="'.$title.'">
								<meta property="twitter:description" content="">
								<meta property="twitter:image" content="'.$thumb_file.'">								
								<meta http-equiv = "refresh" content = "0; url = '.$org_file.'" />

								<meta property="og:site_name" content="Mana Tdp">
								<meta property="og:title" content="'.$title.'" />
								<meta property="og:description" content="Via Mana TDP" /> 
								<meta property="og:image" itemprop="image" content="'.$thumb_file.'">
								<meta property="og:type" content="Mana Tdp" />
								<link href="'.$thumb_file.'" rel="image_src">
								</head>
								<body>
																
								</body>
								</html>';
								fwrite($myfile, $txt);

																
								$filePath_thumb = $html_file; 
								$destinationFilePath = 'uploads/thumbnails_html/tk/'.$html_file;
								/* Move File from images to copyImages folder */
								if( !rename($filePath_thumb, $destinationFilePath) ) {  
									//echo "File can't be moved!";  
								}  
								else{  
									//echo "File has been moved!"; 
									$file_Path = base_url()."/uploads/thumbnails_html/tk/".$filePath_thumb;  
									$this->s3UploadThumb('tk',$file_Path);  
									//chmod($file_Path, 0644);
									//unlink($file_Path);    
								}
		
						}else{
							$file_name="";
						}
						
						//New Roles Assigned
					$designatedMember=$this->request->getVar('designatedMember'); 
                    $committeeTypeId=$this->request->getVar('committeeTypeId'); 
                    $committeeNameId=$this->request->getVar('committeeNameId'); 
                    $affiliatedCommitteeId=$this->request->getVar('affiliatedCommitteeId');
                    $designationId=$this->request->getVar('designationId'); 

					//$SelectedGroups_array=$this->request->getVar('SelectedGroups',FILTER_SANITIZE_STRING);
					//$SelectedGroups=implode(",",$SelectedGroups_array);
					// end test here
					$table_data=[
							'ContentType'=>$this->request->getVar('ContentType',FILTER_SANITIZE_STRING),
							'Title'=>$this->request->getVar('Title',FILTER_SANITIZE_STRING),
							'Description'=>$this->request->getVar('Description',FILTER_SANITIZE_STRING),
							'Instructions'=>$this->request->getVar('Instructions',FILTER_SANITIZE_STRING),
							'URL'=>$this->request->getVar('URL',FILTER_SANITIZE_STRING),
							'Image'=>$file_name,  
							'thumb_url'=>$this->s3Url().'th/tk/'.$html_file,  							
							'task_thumb_file'=>$thumb_file_name,          
							//'PromoterType'=>$this->request->getVar('PromoterType',FILTER_SANITIZE_STRING),
						//	'SelectedGroups'=>$SelectedGroups,
							'Purpose'=>$this->request->getVar('Purpose',FILTER_SANITIZE_STRING),
							'RewardType'=>$this->request->getVar('RewardType',FILTER_SANITIZE_STRING),
							'Prizevalue'=>$this->request->getVar('Prizevalue',FILTER_SANITIZE_STRING),
							'ViewsForPrize'=>$this->request->getVar('ViewsForPrize',FILTER_SANITIZE_STRING),
							'ExpiryDate'=>$this->request->getVar('ExpiryDate',FILTER_SANITIZE_STRING),
							'CreatedBy'=>$session->get('u_id'),
							'CreatedDate'=>date('Y-m-d H:i:s') 

					];
					$TaskId=$this->AdminModel->insert_record('tasks',$table_data); 
					if($TaskId === false){ 						
						$data=[
							'page_title'=>'Add Task',
							'page_name'=>'Add Task',
							'title_active'=>'tasks'
						]; 
						$session->setFlashdata('error', 'Unable to Added Task');
						return redirect()->route('Tasks');
					}else{
						//Insert into
						$committeeNameId=$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING);
						foreach($committeeNameId as $value){
							$table_data_committee[]=[
								'taskId'=>$TaskId,
								'committeeNameId'=>$value,
								'committeeTypeId'=>$this->request->getVar('committeeTypeId',FILTER_SANITIZE_STRING),
								'designatedMember'=>$this->request->getVar('designatedMember',FILTER_SANITIZE_STRING),						
								'CreatedDate'=>date('Y-m-d H:i:s') 
							];
						}
						
						//$assignedTaskId=$this->AdminModel->insert_record('assignedTasks',$table_data); 
						$this->AdminModel->InsertImportData('assignedTasks',$table_data_committee);

						if($TaskId){							
							if($this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING)){
								$affiliatedCommitteeId=$this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING);
								foreach($affiliatedCommitteeId as $value){								
									$table_data_Aff[]=[
										'taskId'=>$TaskId,
										'affiliatedCommitteeId'=>$value,					
										'CreatedDate'=>date('Y-m-d H:i:s') 
									];
								}
								//print_r($table_data);
								$this->AdminModel->InsertImportData('assigneTasksToAff',$table_data_Aff);
							} 
							if($this->request->getVar('designationId',FILTER_SANITIZE_STRING)){
								$designationId=$this->request->getVar('designationId',FILTER_SANITIZE_STRING);
								foreach($designationId as $key=>$value){ 
									$table_data_dsg[]=[
										'taskId'=>$TaskId,
										'designationId'=>$value,					
										'CreatedDate'=>date('Y-m-d H:i:s') 
									];
								}
								$this->AdminModel->InsertImportData('assigneTasksToDesg',$table_data_dsg);
							}

							$committeeNameId=implode(",",$committeeNameId); 
							if($designatedMember == "No"){  
								$UserDetails1=$this->AdminModel->getCampaignsByGroupDesgNo($designatedMember,$committeeNameId); 
							}else{
							$UserDetails1=array();
							if(!empty($affiliatedCommitteeId)){
								$affiliatedCommitteeIds='';
								if($affiliatedCommitteeId){
									$affiliatedCommitteeIds=implode(",",$affiliatedCommitteeId);
								}
								$designationIds='';
								if($designationId){ 
									$designationIds=implode(",",$designationId);
								}

								$UserDetails1=$this->AdminModel->getUsersAffDesgGroup($designatedMember,$committeeNameId,$committeeTypeId,$affiliatedCommitteeIds,$designationIds);  
							}
							else{
								$designationIds='';
								if($designationId){
									$designationIds=implode(",",$designationId);
								 }
								$UserDetails1=$this->AdminModel->getUsersDesgGroup($designatedMember,$committeeNameId,$committeeTypeId,$designationIds); 
							}

						} 
					//insert into Notification table
					if($UserDetails1){   
						$device_token=array();
						foreach($UserDetails1 as $row){ 

							$title="SM Task".'-'.$this->request->getVar('Title',FILTER_SANITIZE_STRING);
							$message="New Social Media assigned via ManaTDP";
							
						
							if($row['device_token']){ 
								$device_token[]=$row['device_token'];
								//$this->fcm_notification($row['device_token'],$title,$message);
							}
							

							$table_notification_data[]=[ 
								'NotificationUserId'=>$row['u_id'],
								'NotificationTitle'=>$title,
								'NotificationDescription'=>$message,
								'NotificationType'=>"SM Task",
								'FromId'=>$TaskId,
								'CreatedDate'=>date('Y-m-d H:i:s')
							];
							
						
						}
						$this->fcm_notification($device_token,$title,$message);						
						//$this->AdminModel->InsertImportData('activitystatus',$table_data_users_chlid);
						$this->AdminModel->InsertImportData('notifications',$table_notification_data);
					}

						$session->setFlashdata('success', 'Successfully Added Task');
						return redirect()->route('Tasks');
					}			
			   }
		  }
		} 
		
		//get commite name
		$where=["IsActive"=>1];
		$data['committeeName']=$this->AdminModel->getQueryReultFromTable('committeeName',$where);
		return view('add_task',$data);
	}
	
	//teask edit
	public function smTaskEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'Edit Task',
			'page_name'=>'Edit Task',
			'title_active'=>'tasks'
		 ];
		$table="tasks";
		$where_id=$id;
		$where_parameter="TaskId";
		$data['taskdetails']=$this->AdminModel->getTaskDetailsById($id);

			$where_parameter = ['designatedMember' =>$data['taskdetails']["designatedMember"]]; 
			$table="committeeName";
			$data['committeeName']=$this->ApiModel->getWhereQuery($table,$where_parameter); 

			if($data['taskdetails']["designatedMember"]=="Yes"){
				$committeeTypeName=$data['taskdetails']["committeeTypeId"];
					
				//Get Afflliated Groups
				if($committeeTypeName == "Affiliated"){					

					//Get Afflliated Groups
					$committeeTypeName=$data['taskdetails']["committeeTypeId"];
					$committeeNameId=$data['taskdetails']["committeeNameIdS"];
					$data['affiliatedCommittees']=$this->AdminModel->getSmTaskAffliatedOrMain($committeeTypeName,$committeeNameId); 

					//get Designations
					 $affiliatedCommitteeId=$data['taskdetails']["affiliatedCommitteeIds"];  
					 $data['designation']=$this->AdminModel->getAffDesignationIds($affiliatedCommitteeId);  
					//	print_r($data['designation']);
					

				}else{
					 $committeeNameId=$data['taskdetails']["committeeNameIdS"];
						$data['designation']=$this->AdminModel->getDesignationIds($committeeNameId); 
				}
				//echo $committeeNameId;
			//	echo '<pre>';
				//print_r($data['designation']); 
			//	exit();
			}else{

			}
		$data['file_path']=$this->s3Url()."tk/".$data['taskdetails']['Image'];
		$taskdetails=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);

		if(isset($data['taskdetails'])){ 
			//approle groups
			if(isset($taskdetails['TaskId'])){
				$where_parameter = ['AppRoleId' => $taskdetails['PromoterType']]; 
				$table="approlegroup";
				$data['approlegroups']=$this->ApiModel->getWhereQuery($table,$where_parameter);
			}
			return view('add_task',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('add_task');
		}
	}

	//update sm task
	public function updateSmTask(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Task Edit',
			'page_name'=>'Task Edit',
			'title_active'=>'tasks'
		 ];
		
		if($this->request->getMethod() == 'post'){
			$rules=[
				'Title'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Title is a required'
					]
				]
			];
			
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_task',$data);
            }else{
				$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
				if($file->isValid() && !$file->hasMoved()){
					$getClientExtension=$file->getClientExtension();
						if($getClientExtension == "jpg" || $getClientExtension == "jpeg" ||  $getClientExtension == "png" ){
							$isFile = $this->request->getFile('file');
							$data = getimagesize($isFile);
							$width = $data[0];
							$height = $data[1];
							$xOffset = ($width / 2) - 25;
							$yOffset = ($height / 2) - 25;
							$thumb_file_name=$isFile->getRandomName();
							$image = \Config\Services::image()
								->withFile($isFile)
								->fit(512, 512, 'center')
								->save('uploads/fd/'. $thumb_file_name); 
							$url_thumb=".uploads/fd/".$thumb_file_name;
							$file_Path = base_url()."/uploads/fd/".$thumb_file_name; 
							$this->s3Upload('fd',$file_Path);  
						}else{
							$thumb_file_name=""; 
						}
					$this->s3DeleteObjects('tk',$this->request->getVar('old_img',FILTER_SANITIZE_STRING));  
					$getClientExtension=$file->getClientExtension();
					$file_nam_uniq=uniqid(time()); 
					$file_name=$file_nam_uniq.'.'.$getClientExtension;
					//$file_name=uniqid(time()).'.'.$getClientExtension;
					$file->move('uploads/tk',$file_name);   
					//s3 uplode
					$file_Path = base_url()."/uploads/tk/". $file_name; 
					$this->s3Upload('tk',$file_Path); 
					$url="./uploads/tk/".$file_name; 
					unlink($url); 

					// Generate Html
					$title=$this->request->getVar('Title',FILTER_SANITIZE_STRING);
					$org_file=$this->s3Url().'tk/'.$file_name;
					if($getClientExtension == "jpg" || $getClientExtension == "jpeg" ||  $getClientExtension == "png" ){
						$thumb_file=$thumb_file_name;
						//$thumb_file=$this->s3Url().'tk/'.$file_name;
					}elseif($getClientExtension == "doc" || $getClientExtension == "pdf" || $getClientExtension == "docx"){
						$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";							
					}elseif($getClientExtension == "mp3"){
						$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
					}elseif($getClientExtension == "mp4"){
						$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
					
					}else{
						$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
					}

					//$html_file=uniqid(time()).'.html';
					$html_file=$file_nam_uniq.'.html';
					$title=$this->request->getVar('GalleryTitle',FILTER_SANITIZE_STRING);
					$myfile = fopen($html_file, "w") or die("Unable to open file!");
					$txt = '<!DOCTYPE html>
					<html lang="en">
					<head>
						<!-- Primary Meta Tags -->
					<title>Mana Tdp</title>
					<meta name="title" content="'.$title.'">
					<meta name="description" content="">  
					<!-- Twitter -->
					<meta property="twitter:card" content="summary_large_image">
					<meta property="twitter:title" content="'.$title.'">
					<meta property="twitter:description" content="">
					<meta property="twitter:image" content="'.$thumb_file.'">								
					<meta http-equiv = "refresh" content = "0; url = '.$org_file.'" />

					<meta property="og:site_name" content="Mana Tdp">
					<meta property="og:title" content="'.$title.'" />
					<meta property="og:description" content="Via Mana TDP" /> 
					<meta property="og:image" itemprop="image" content="'.$thumb_file.'">
					<meta property="og:type" content="Mana Tdp" />
					<link href="'.$thumb_file.'" rel="image_src">
					</head>
					<body>
													
					</body>
					</html>';
					fwrite($myfile, $txt);

													
					$filePath_thumb = $html_file; 
					$destinationFilePath = 'uploads/thumbnails_html/tk/'.$html_file;
					/* Move File from images to copyImages folder */
					if( !rename($filePath_thumb, $destinationFilePath) ) {  
						//echo "File can't be moved!";  
					}  
					else{  
						//echo "File has been moved!"; 
						$file_Path = base_url()."/uploads/thumbnails_html/tk/".$filePath_thumb;  
						$this->s3UploadThumb('tk',$file_Path);  
						//chmod($file_Path, 0644);
						//unlink($file_Path);    
					}

					// $url="./uploads/task_files/".$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
					// unlink($url);
					$thumb_url=$this->s3Url().'th/tk/'.$html_file; 
				}else{
					$thumb_file_name=$this->request->getVar('task_thumb_file',FILTER_SANITIZE_STRING);
					$file_name=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
					$html_file1= strstr($file_name, ".", true);
					$thumb_url=$this->s3Url().'th/tk/'.$html_file1.'.html'; 
					//'thumb_url'=>$this->s3Url().'th/tk/'.$html_file,  
				}
				
				//$SelectedGroups_array=$this->request->getVar('SelectedGroups',FILTER_SANITIZE_STRING);
				//$SelectedGroups=implode(",",$SelectedGroups_array);
				$table_data=[
					'ContentType'=>$this->request->getVar('ContentType',FILTER_SANITIZE_STRING),
					'Title'=>$this->request->getVar('Title',FILTER_SANITIZE_STRING),
					'Description'=>$this->request->getVar('Description',FILTER_SANITIZE_STRING),
					'Instructions'=>$this->request->getVar('Instructions',FILTER_SANITIZE_STRING),
					'URL'=>$this->request->getVar('URL',FILTER_SANITIZE_STRING),
					'Image'=>$file_name,     
					'thumb_url'=>$thumb_url,
					'task_thumb_file'=>$thumb_file_name,        
					//'PromoterType'=>$this->request->getVar('PromoterType',FILTER_SANITIZE_STRING),
					//'SelectedGroups'=>$SelectedGroups,
					'Purpose'=>$this->request->getVar('Purpose',FILTER_SANITIZE_STRING),
					'RewardType'=>$this->request->getVar('RewardType',FILTER_SANITIZE_STRING),
					'Prizevalue'=>$this->request->getVar('Prizevalue',FILTER_SANITIZE_STRING),
					'ViewsForPrize'=>$this->request->getVar('ViewsForPrize',FILTER_SANITIZE_STRING),
					'ExpiryDate'=>$this->request->getVar('ExpiryDate',FILTER_SANITIZE_STRING),
					'LastUpdatedBy'=>$session->get('u_id'),
					'LastUpdatedDate'=>date('Y-m-d H:i:s')

					];
					$where_parameter="TaskId";
					$where_id=$this->request->getVar('TaskId',FILTER_SANITIZE_STRING);					
					$TaskId=$this->AdminModel->updateQuery('tasks',$table_data,$where_parameter,$where_id); 
				
				if($TaskId === false){						
					$data=[
						'page_title'=>'Task',
						'page_name'=>'Tasks',
						'title_active'=>'tasks'
					]; 
					$session->setFlashdata('error', 'Unable to Update Task');
					return redirect()->route('Tasks');
				}else{

					$where_data=["taskId"=>$this->request->getVar('TaskId',FILTER_SANITIZE_STRING)];
					$assigneTasks=$this->ApiModel->deleteRecord('assignedTasks',$where_data);
					
					//insert Query

				//	if($assignedTasksUpdate){ 
						$where_data=["taskId"=>$this->request->getVar('TaskId',FILTER_SANITIZE_STRING)];
						$assigneTasksToAffDelete=$this->ApiModel->deleteRecord('assigneTasksToAff',$where_data);

						//Delete Deg
						$where_data=["taskId"=>$this->request->getVar('TaskId',FILTER_SANITIZE_STRING)];
						$assigneTasksToAffDelete=$this->ApiModel->deleteRecord('assigneTasksToDesg',$where_data);
						//Insert Asigned Tasks
						$committeeNameId=$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING);
						foreach($committeeNameId as $value){
							$table_data_committee[]=[
								'taskId'=>$this->request->getVar('TaskId',FILTER_SANITIZE_STRING),
								'committeeNameId'=>$value,
								'committeeTypeId'=>$this->request->getVar('committeeTypeId',FILTER_SANITIZE_STRING),
								'designatedMember'=>$this->request->getVar('designatedMember',FILTER_SANITIZE_STRING),						
								'CreatedDate'=>date('Y-m-d H:i:s') 
							];
						}						
						//$assignedTaskId=$this->AdminModel->insert_record('assignedTasks',$table_data); 
						$this->AdminModel->InsertImportData('assignedTasks',$table_data_committee);

						if($this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING)){
							$affiliatedCommitteeId=$this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING);
						
							foreach($affiliatedCommitteeId as $value){
							
								$table_data_Aff[]=[
									'taskId'=>$this->request->getVar('TaskId',FILTER_SANITIZE_STRING),
									'affiliatedCommitteeId'=>$value,					
									'CreatedDate'=>date('Y-m-d H:i:s') 
								];
							}
							//print_r($table_data);
							$this->AdminModel->InsertImportData('assigneTasksToAff',$table_data_Aff);
						}
						if($this->request->getVar('designationId',FILTER_SANITIZE_STRING)){
							$designationId=$this->request->getVar('designationId',FILTER_SANITIZE_STRING);
							foreach($designationId as $key=>$value){ 
								$table_data_dsg[]=[
									'taskId'=>$this->request->getVar('TaskId',FILTER_SANITIZE_STRING),
									'designationId'=>$value,					
									'CreatedDate'=>date('Y-m-d H:i:s') 
								];
							}
							$this->AdminModel->InsertImportData('assigneTasksToDesg',$table_data_dsg);
						}
					//}
					$session->setFlashdata('success', 'Successfully Updated Task');
					return redirect()->route('Tasks');
				}
		 	}
		 }
	}

	//teask edit
	public function smTaskView($id=null){
		$data=[
			'page_title'=>'View Task',
			'page_name'=>'View Task',
			'title_active'=>'tasks'
		 ]; 
		 $data['view']=true;
		 $table="tasks";
		 $where_id=$id;
		 $where_parameter="TaskId";
		 $data['taskdetails']=$this->AdminModel->getTaskDetailsById($id);
 
			 $where_parameter = ['designatedMember' =>$data['taskdetails']["designatedMember"]]; 
			 $table="committeeName";
			 $data['committeeName']=$this->ApiModel->getWhereQuery($table,$where_parameter); 
 
			 if($data['taskdetails']["designatedMember"]=="Yes"){
				 $committeeTypeName=$data['taskdetails']["committeeTypeId"];
					 
				 //Get Afflliated Groups
				 if($committeeTypeName == "Affiliated"){					
 
					 //Get Afflliated Groups
					 $committeeTypeName=$data['taskdetails']["committeeTypeId"];
					 $committeeNameId=$data['taskdetails']["committeeNameIdS"];
					 $data['affiliatedCommittees']=$this->AdminModel->getSmTaskAffliatedOrMain($committeeTypeName,$committeeNameId); 
 
					 //get Designations
					  $affiliatedCommitteeId=$data['taskdetails']["affiliatedCommitteeIds"];  
					 $data['designation']=$this->AdminModel->getAffDesignationIds($affiliatedCommitteeId);  
				 //	print_r($data['designation']);
					 
 
				 }else{
					 $committeeNameId=$data['taskdetails']["committeeNameIdS"];
					 $data['designation']=$this->AdminModel->getDesignationIds($committeeNameId); 
				 }
			 
 
			 }else{
 
			 }
		 $data['file_path']=$this->s3Url()."tk/".$data['taskdetails']['Image'];
		 $taskdetails=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
 
		 if(isset($data['taskdetails'])){ 
			 //approle groups
			 if(isset($taskdetails['TaskId'])){
				 $where_parameter = ['AppRoleId' => $taskdetails['PromoterType']]; 
				 $table="approlegroup";
				 $data['approlegroups']=$this->ApiModel->getWhereQuery($table,$where_parameter);
			 }
			 return view('add_task',$data);
		 }else{
			 $session->setFlashdata('error', 'In valid Id');
			 return redirect()->route('add_task');
		 }
	}

	//feeds management
	public Function gallery(){ 
		$data=[
			'page_title'=>'Gallery',
			'page_name'=>'Gallery',
			'title_active'=>'gallery'
			];
			/*
		$parameters=array('GalleryId','GalaryType','GalleryTitle','GalaryFileName','CreatedDate','IsActive');
		$order_by='GalleryId'; 
		$data['gallerytails']=$this->AdminModel->getQueryFromTableAdmins('gallery',$parameters,$order_by); 
		$i=0;
		foreach($data['gallerytails'] as $row){
			$where_data=['GalleryId'=>$row['GalleryId']]; 
			$Totallikes=$this->AdminModel->tableRowsCount('gallerylikes',$where_data); 
			$data['gallerytails'][$i]['GalleryLikesCount']=$Totallikes;  
			

			$where_data=["SharedFrom"=>"gallery","SharedFromId"=>$row["GalleryId"] ]; 
			$ShareCount=$this->AdminModel->tableRowsCount('ShareDetails',$where_data);
			if($ShareCount){
				$ShareCount=$ShareCount;
			}else{
				$ShareCount=0;
			} 
			$data['gallerytails'][$i]['ShareCount']=$ShareCount; 

			$i++;

		}	*/

		$parameters=array('*');
		$order_by='GalleryId';  
		//$data['gallerytails']=$this->AdminModel->getQueryFromTableAdmins('gallery',$parameters,$order_by); 
		$data['gallerytails']=$this->AdminModel->getGalleryList(); 
		return view('gallery_management',$data);
	}
	//Add Gallery
	public function addGallery(){
		$session = session();
		$data=[
			'page_title'=>'Add Gallery',
			'page_name'=>'Add Gallery',
			'title_active'=>'gallery'
		 ];
		 if($this->request->getMethod() == 'post'){
			$rules=[
				'GalleryTitle'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Gallery Title is a required'
					]
				],
				'GalaryType'=>[
					'rules'=>'required',
					'label'=>'Galary Type',
					'errors'=>[
						'required'=>'Galary Type is a required'
					]
				]
			];
			
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_gallery',$data);
            }else{
					//Old file uplode code					 
					$GalaryType=$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING);

					if($this->request->getVar('leader_id',FILTER_SANITIZE_STRING)){
						$leader_id=$this->request->getVar('leader_id',FILTER_SANITIZE_STRING);
					}else{
						$leader_id="";
					}

					if($this->request->getVar('event_campaign_name',FILTER_SANITIZE_STRING)){
						$event_campaign_name=$this->request->getVar('event_campaign_name',FILTER_SANITIZE_STRING);
						$event_desc=$this->request->getVar('event_desc',FILTER_SANITIZE_STRING);
					}else{
						$event_campaign_name="";
						$event_desc="";
					}
					if($this->request->getVar('Links',FILTER_SANITIZE_STRING)){
						$Links=$this->request->getVar('Links',FILTER_SANITIZE_STRING);
						$table_data=[
							'GalaryType'=>$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING),
							'GalleryTitle'=>$this->request->getVar('GalleryTitle',FILTER_SANITIZE_STRING),
							//'GalaryFileName'=>$file_name,
							'Links'=>$Links,
						//	'thumb_url'=>$this->s3Url().'th/gl/'.$html_file,
						//	'GalleryThumbFile'=>$thumb_file_name,
							'event_desc'=>$event_desc,
							//'primary_file'=>$primary_file,
							//'primary_id'=>$primary_id,
							//'thumb_file'=>$thumb_files,
							//'file_type'=>$getClientExtension,
							'leader_id'=>$leader_id,
							'event_campaign_name'=>$event_campaign_name, 
							'CreatedBy'=>$session->get('u_id'),
							'CreatedDate'=>date('Y-m-d H:i:s') 

						];
						$GalleryId=$this->AdminModel->insert_record('gallery',$table_data); 
					}else{
						$Links="";
					}
					
					$title=$this->request->getVar('GalleryTitle',FILTER_SANITIZE_STRING);
						if($this->request->getFileMultiple('image_files')){ 
							$i=1;
							$g_id='';
					
							foreach($this->request->getFileMultiple('image_files') as $file)
           					{	
								if($file->isValid() && !$file->hasMoved()){
									$isFile = $file;
									$data = getimagesize($isFile);
									$width = $data[0];
									$height = $data[1];
									$xOffset = ($width / 2) - 25;
									$yOffset = ($height / 2) - 25;
									$thumb_file_name=$isFile->getRandomName();
									$thumb_file=$thumb_file_name;
									$thumb_file=$this->s3Url().'gl/'.$thumb_file_name;
									$GalleryThumbFile=$thumb_file_name;
									$image = \Config\Services::image()
										->withFile($isFile)
										->fit(512, 512, 'center')
										->save('uploads/gl/'. $thumb_file_name); 
									$url_thumb=".uploads/gl/".$thumb_file_name;
									$file_Path = base_url()."/uploads/gl/".$thumb_file_name; 
									$this->s3Upload('gl',$file_Path); 
								}

								//Orginal file
								$getClientExtension=$file->getClientExtension();
								$file_nam_uniq=uniqid(time());
								$file_name=$file_nam_uniq.'.'.$getClientExtension;
								$file->move('uploads/gl',$file_name);  

								//s3 uplode
								$file_Path = base_url()."/uploads/gl/". $file_name; 
								$this->s3Upload('gl',$file_Path);  
								$url="./uploads/gl/".$file_name; 
								unlink($url);

								//generate html file for thumbnail
								//$html_file=uniqid(time()).'.html';
								$org_file=$this->s3Url().'gl/'.$file_name;
								$html_file=$file_nam_uniq.'.html';
								$this->generate_html($html_file,$title,$thumb_file,$org_file); 
								$thumb_url=$this->s3Url().'th/gl/'.$html_file;
								$GalaryFileName=$file_name;
							//	$this->insertGalleryFiles($GalleryId,$GalaryFileName,$GalleryThumbFile,$thumb_url,$thumb_file_name,$getClientExtension);
							
								$primary_file = $i > 1 ? 0 : 1;
								$primary_id= $primary_file == 0 ? $g_id:0;
								$table_data=[
									'GalaryType'=>$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING),
									'GalleryTitle'=>$this->request->getVar('GalleryTitle',FILTER_SANITIZE_STRING),
									'GalaryFileName'=>$file_name,
									'Links'=>$Links,
									'thumb_url'=>$this->s3Url().'th/gl/'.$html_file,
									'GalleryThumbFile'=>$thumb_file_name,
									//'thumb_file'=>$thumb_files, 
									'event_desc'=>$event_desc,
									'primary_file'=>$primary_file,
									'primary_id'=>$primary_id,
									'file_type'=>$getClientExtension,
									'leader_id'=>$leader_id,
									'event_campaign_name'=>$event_campaign_name, 
									'CreatedBy'=>$session->get('u_id'),
									'CreatedDate'=>date('Y-m-d H:i:s') 
		
								];
								$GalleryId=$this->AdminModel->insert_record('gallery',$table_data); 	
									
							//	$GalleryId_t=12+$i;
								if($i==1){
									$g_id=$GalleryId;
								}else{
									$g_id=$GalleryId-$i+1;
								}						
								//echo $i;
								$i++;
							}
						
						}
						if($this->request->getFile('file')){
							$file=$this->request->getFile('file',FILTER_SANITIZE_STRING); 
							if($file->isValid() && !$file->hasMoved()){
								try {
									$thumb_file_name='Default_thumbnail.jpg';
									$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";	

									$getClientExtension=$file->getClientExtension();
									$file_nam_uniq=uniqid(time());
									$file_name=$file_nam_uniq.'.'.$getClientExtension; 
									$file->move('uploads/gl',$file_name);  

									//s3 uplode
									$file_Path = base_url()."/uploads/gl/". $file_name; 
									$this->s3Upload('gl',$file_Path);  
									$url="./uploads/gl/".$file_name; 
									unlink($url);

									$org_file=$this->s3Url().'gl/'.$file_name;
									$html_file=$file_nam_uniq.'.html';
									$this->generate_html($html_file,$title,$thumb_file,$org_file);
									$thumb_url=$this->s3Url().'th/gl/'.$html_file;
									$GalaryFileName=$file_name;

									$thumb_file=$thumb_file_name;
									$GalleryThumbFile=$thumb_file_name;

									//$thumb_file=$this->request->getFile('thumb_file',FILTER_SANITIZE_STRING); 
									//print_r($file);
									if($thumb_file=$this->request->getFile('thumb_file',FILTER_SANITIZE_STRING)){
										if($thumb_file->isValid() && !$thumb_file->hasMoved()){
										//	$thumb_file_name=$thumb_file->getRandomName();

											$thumb_files=$thumb_file->getRandomName();
											$thumb_file->move('uploads/gl',$thumb_files);  
											//exit();
											//s3 uplode
											$file_Path = base_url()."/uploads/gl/". $thumb_files; 
											$this->s3Upload('gl',$file_Path);  
											$url="./uploads/gl/".$thumb_files; 
											unlink($url);
										}
									}else{
										$thumb_files=""; 
									}

									//$this->insertGalleryFiles($GalleryId,$GalaryFileName,$GalleryThumbFile,$thumb_url,$thumb_file,$getClientExtension);	
									$table_data=[
										'GalaryType'=>$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING),
										'GalleryTitle'=>$this->request->getVar('GalleryTitle',FILTER_SANITIZE_STRING),
										'GalaryFileName'=>$file_name,
										'Links'=>$Links,
										'thumb_url'=>$this->s3Url().'th/gl/'.$html_file,
										'GalleryThumbFile'=>$thumb_file_name,
										'event_desc'=>$event_desc,
										//'primary_file'=>$primary_file,
										//'primary_id'=>$primary_id,
										'thumb_file'=>$thumb_files,
										'file_type'=>$getClientExtension,
										'leader_id'=>$leader_id,
										'event_campaign_name'=>$event_campaign_name, 
										'CreatedBy'=>$session->get('u_id'),
										'CreatedDate'=>date('Y-m-d H:i:s') 
			
									];
									$GalleryId=$this->AdminModel->insert_record('gallery',$table_data); 

								}catch(S3Exception $e){ 
									echo $e->getAwsErrorMessage(); 
								}
							}
						}
					if($GalleryId === false){						
						$data=[
							'page_title'=>'Add Gallery',
							'page_name'=>'Add Gallery',
							'title_active'=>'gallery'
						]; 
						$session->setFlashdata('error', 'Unable to Added Gallery'); 
						return redirect()->route('Gallery');
					}else{

						//upload files and links						
						

						
						$session->setFlashdata('success', 'Successfully Added Gallery');
						return redirect()->route('Gallery');
					}
				
			} 
		}
		$data['leaders']=$this->AdminModel->getTable('leaders'); 
		$where=["IsActive"=>1];
		$data['campaign_names']=$this->AdminModel->getQueryReultFromTable('activity',$where);
		return view('add_gallery',$data);
	}

	public function generate_html($html_file,$title,$thumb_file,$org_file){
		$myfile = fopen($html_file, "w") or die("Unable to open file!");
		$txt = '<!DOCTYPE html>
		<html lang="en">
		<head>
			<!-- Primary Meta Tags -->
		<title>Mana Tdp</title>
		<meta name="title" content="'.$title.'">
		<meta name="description" content="">  
		<!-- Twitter -->
		<meta property="twitter:card" content="summary_large_image">
		<meta property="twitter:title" content="'.$title.'">
		<meta property="twitter:description" content="">
		<meta property="twitter:image" content="'.$thumb_file.'">								
		<meta http-equiv = "refresh" content = "0; url = '.$org_file.'" />

		<meta property="og:site_name" content="Mana Tdp">
		<meta property="og:title" content="'.$title.'" />
		<meta property="og:description" content="Via Mana TDP" /> 
		<meta property="og:image" itemprop="image" content="'.$thumb_file.'">
		<meta property="og:type" content="Mana Tdp" />
		<link href="'.$thumb_file.'" rel="image_src">
		</head>
		<body>
										
		</body>
		</html>';
		fwrite($myfile, $txt);

										
		$filePath_thumb = $html_file; 
		$destinationFilePath = 'uploads/thumbnails_html/gl/'.$html_file;
		/* Move File from images to copyImages folder */
		if( !rename($filePath_thumb, $destinationFilePath) ) {  
			//echo "File can't be moved!";  
		}  
		else{  
			//echo "File has been moved!"; 
			$file_Path = base_url()."/uploads/thumbnails_html/gl/".$filePath_thumb;  
			$this->s3UploadThumb('gl',$file_Path);  
			//chmod($file_Path, 0644);
			//unlink($file_Path);    
		}
	}

	public function insertGalleryFiles($GalleryId,$GalaryFileName,$GalleryThumbFile,$thumb_url,$thumb_file,$getClientExtension){ 
		$table_data=[ 
			"g_GalleryId"=>$GalleryId,
			"g_GalaryFileName"=>$GalaryFileName,
			"g_GalleryThumbFile"=>$GalleryThumbFile,
			"g_thumb_url"=>$thumb_url,
			"g_thumb_file"=>$thumb_file,
		];
		$GalleryId=$this->AdminModel->insert_record('gallery_files',$table_data); 
	}

	public function s3Upload($bucket,$file_Path){
		$client=$this->s3Details();
		//$file_Path = base_url()."/uploads/gallery/". $file_name; 
		$key = basename($file_Path); 
		$sha256 = hash_file("sha256", $file_Path);
		$result = $client->putObject([
			"Bucket" =>$bucket,
			"Key" => $key,
			"SourceFile" => $file_Path,
		//	"ACL" => "public-read",
			"ContentSHA256" => $sha256,
			"ContentLength"=>'9',
		]);
		return $result['ObjectURL'];
	}

	public function s3UploadThumb($bucket,$file_Path){ 
		$client=$this->s3DetailsThumb();
		//$file_Path = base_url()."/uploads/gallery/". $file_name; 
		$key = basename($file_Path); 
		$sha256 = hash_file("sha256", $file_Path);
		$result = $client->putObject([
			"Bucket" =>$bucket,
			"Key" => $key,
			"SourceFile" => $file_Path,
		//	"ACL" => "public-read",
			"ContentSHA256" => $sha256,
			"ContentLength"=>'9',
		]);
		return $result['ObjectURL'];
	}


	//get s3 object images
	public function s3GetObjects($bucket,$file_name){
		$client=$this->s3Details();
		$file_url = $client->getObjectUrl($bucket, $file_name);
		return $file_url;
	}
	
	//s3 object keys
	private function s3Details(){

		/* Prod S3 Details

		$AWS_KEY="AKIAYPLBKBUCS425MFVL";
		$AWS_SECRET_KEY="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";
		$ENDPOINT = 'https://manatdp.s3.ap-south-1.amazonaws.com/';

		*/

		/* S3 Dev Details */

		/* $AWS_KEY="AKIAYPLBKBUCS425MFVL";
		$AWS_SECRET_KEY="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";
		$ENDPOINT = 'https://manatdp-dev.s3.ap-south-1.amazonaws.com/';  */

		$AWS_KEY=$_ENV['AWS_KEY'];
		$AWS_SECRET_KEY=$_ENV['AWS_SECRET_KEY'];
		$ENDPOINT = $_ENV['ENDPOINT']; 


		return 	$client = new S3Client([
			'region' => 'ap-south-1',
			'version' => 'latest',
			'endpoint' => $ENDPOINT,
			'credentials' => [
			'key' => $AWS_KEY,
			'secret' => $AWS_SECRET_KEY
			],
			'use_path_style_endpoint' => true
		]); 
	}

	public function s3DetailsThumb(){

		/* Prod S3 Details

		$AWS_KEY="AKIAYPLBKBUCS425MFVL";
		$AWS_SECRET_KEY="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";
		$ENDPOINT = 'https://manatdp.s3.ap-south-1.amazonaws.com/th/';

		*/

		/* S3 Details */

		/* $AWS_KEY="AKIAYPLBKBUCS425MFVL";
		$AWS_SECRET_KEY="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";
		$ENDPOINT = 'https://manatdp-dev.s3.ap-south-1.amazonaws.com/th/';  */

		$AWS_KEY=$_ENV['AWS_KEY'];
		$AWS_SECRET_KEY=$_ENV['AWS_SECRET_KEY'];
		$ENDPOINT = $_ENV['THUMB_ENDPOINT']; 


		return 	$client = new S3Client([
			'region' => 'ap-south-1',
			'version' => 'latest',
			'endpoint' => $ENDPOINT,
			'credentials' => [
			'key' => $AWS_KEY,
			'secret' => $AWS_SECRET_KEY
			],
			'use_path_style_endpoint' => true
		]); 
	}

	//S3 delete function 
	public function s3DeleteObjects($bucket,$file_name){  
		$client=$this->s3Details();
		$client->deleteObject(['Bucket' =>$bucket, 'Key' =>$file_name]);
	}

	//a3 Url
	private function s3Url(){
		// Prod URL 
		/*	$url="https://data.manatdp.org/";
			return $url;
		*/

		// Test Url
	//	$url="https://dev.manatdp.org/";
		$url=$_ENV['URL'];
		return $url;
	}
	public function galleryEdit($id=null){ 
		$session = session();
		$data=[
			'page_title'=>'Edit Gallery',
			'page_name'=>'Edit Gallery',
			'title_active'=>'gallery'
		 ];
		 $data['leaders']=$this->AdminModel->getTable('leaders'); 
		// $where=["IsActive"=>1];
	//	 $data['campaign_names']=$this->AdminModel->getQueryReultFromTable('activity',$where);

		$table="gallery";
		$where_id=$id;
		$where_parameter="GalleryId";
		$data['gallerydetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		//$data['file_path']=$this->s3GetObjects('gallery',$data['gallerydetails']['GalaryFileName']);
		 $data['file_path']=$this->s3Url()."gl/".$data['gallerydetails']['GalaryFileName'];
		 $data['thumb_file_path']=$this->s3Url()."gl/".$data['gallerydetails']['thumb_file'];
		 $data['path']=$this->s3Url()."gl/";
		 $gallery_type=$data['gallerydetails']['GalaryType'];
		 if($gallery_type=="Image"){ 
			//$data['gallerydetails']=$this->AdminModel->getRowTableById($id);
			$where=["primary_id"=>$id];
			$data['gallerySubImages']=$this->AdminModel->getQueryReultFromTable('gallery',$where);
		 }
		//exit();
		if(isset($data['gallerydetails'])){
			return view('add_gallery',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Gallery');
		}
	}

	//gallery Update
	public function updateGallery(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Add Gallery',
			'page_name'=>'Add Gallery',
			'title_active'=>'gallery'
		 ];
		if($this->request->getMethod() == 'post'){
			$rules=[
				'GalaryType'=>[
					'rules'=>'required',
					'label'=>'GalaryType',
					'errors'=>[
						'required'=>'GalaryType is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_gallery',$data);
            }else{

				$GalaryType=$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING);
				if($this->request->getVar('event_desc',FILTER_SANITIZE_STRING)){
					$event_desc=$this->request->getVar('event_desc',FILTER_SANITIZE_STRING);
				}else{
					$event_desc="";
				}

				if($this->request->getVar('leader_id',FILTER_SANITIZE_STRING)){
					$leader_id=$this->request->getVar('leader_id',FILTER_SANITIZE_STRING);
				}else{
					$leader_id="";
				}

				if($this->request->getVar('event_campaign_name',FILTER_SANITIZE_STRING)){
					$event_campaign_name=$this->request->getVar('event_campaign_name',FILTER_SANITIZE_STRING);
					$event_desc=$this->request->getVar('event_desc',FILTER_SANITIZE_STRING);
				}else{
					$event_campaign_name="";
					$event_desc="";
				}


					if($GalaryType == "Links"){
						$Links=$this->request->getVar('Links',FILTER_SANITIZE_STRING);
						if(!empty($this->request->getVar('old_img'))){
							$url="./uploads/gallery/".$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
							unlink($url);
						}
						$file_name="";
						$thumb_url="";
						
					}else{
						$Links="";
						$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
						if($this->request->getFile('file',FILTER_SANITIZE_STRING)){ 
							
							if($file->isValid() && !$file->hasMoved()){
							//Crap file
							$getClientExtension=$file->getClientExtension();
							if($getClientExtension == "jpg" || $getClientExtension == "jpeg" ||  $getClientExtension == "png" ){
								$isFile = $this->request->getFile('file');
								$data = getimagesize($isFile);
								$width = $data[0];
								$height = $data[1];
								$xOffset = ($width / 2) - 25;
								$yOffset = ($height / 2) - 25;
								$thumb_file_name=$isFile->getRandomName();
								$GalleryThumbFile=$thumb_file_name;
								$image = \Config\Services::image()
									->withFile($isFile)
									->fit(512, 512, 'center')
									->save('uploads/gl/'. $thumb_file_name); 
								$url_thumb=".uploads/gl/".$thumb_file_name;
								$file_Path = base_url()."/uploads/gl/".$thumb_file_name; 
								$this->s3Upload('gl',$file_Path);  
							}else{
								$GalleryThumbFile="";
							}

							$file_nam_uniq=uniqid(time());
							$getClientExtension=$file->getClientExtension();
							$file_name=$file_nam_uniq.'.'.$getClientExtension;
							$file->move('uploads/gl',$file_name);   
							//s3 uplode
							$file_Path = base_url()."/uploads/gl/". $file_name; 
							$this->s3Upload('gl',$file_Path); 
							$url="./uploads/gl/".$file_name; 
							unlink($url);
							if(!empty($this->request->getVar('old_img'))){    
								//delete old file
								$this->s3DeleteObjects('gl',$this->request->getVar('old_img',FILTER_SANITIZE_STRING));

							}
							//s3 Details Html GENERET
							/*
							$file_Path = base_url()."/uploads/gl/". $file_name; 
							$this->s3Upload('gl',$file_Path);  
							$url="./uploads/gl/".$file_name;
							unlink($url);  */

							// Generate Html
							$org_file=$this->s3Url().'gl/'.$file_name;
							if($getClientExtension == "jpg" || $getClientExtension == "jpeg" ||  $getClientExtension == "png" ){
								$thumb_file=$this->s3Url().'gl/'.$file_name;
							}elseif($getClientExtension == "doc" || $getClientExtension == "pdf" || $getClientExtension == "docx"){
								$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";							
							}elseif($getClientExtension == "mp3"){
								$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
							}elseif($getClientExtension == "mp4"){
								$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
							
							}else{
								$thumb_file=base_url()."/uploads/default_images/Default_thumbnail.jpg";
							}

							//$html_file=uniqid(time()).'.html';
							$html_file=$file_nam_uniq.'.html';
							$title=$this->request->getVar('GalleryTitle',FILTER_SANITIZE_STRING);
							$myfile = fopen($html_file, "w") or die("Unable to open file!");
							$txt = '<!DOCTYPE html>
							<html lang="en">
							<head>
								<!-- Primary Meta Tags -->
							<title>Mana Tdp</title>
							<meta name="title" content="'.$title.'">
							<meta name="description" content="">  
							<!-- Twitter -->
							<meta property="twitter:card" content="summary_large_image">
							<meta property="twitter:title" content="'.$title.'">
							<meta property="twitter:description" content="Via Mana TDP">
							<meta property="twitter:image" content="'.$thumb_file.'">								
							<meta http-equiv = "refresh" content = "0; url = '.$org_file.'" />

							<meta property="og:site_name" content="Mana TDP">
							<meta property="og:title" content="'.$title.'" />
							<meta property="og:description" content="Via Mana TDP" /> 
							<meta property="og:image" itemprop="image" content="'.$thumb_file.'">
							<meta property="og:type" content="Mana Tdp" />
							<link href="'.$thumb_file.'" rel="image_src">
							</head>
							<body>
															
							</body>
							</html>';
							fwrite($myfile, $txt);		
							$filePath_thumb = $html_file; 
							$destinationFilePath = 'uploads/thumbnails_html/gl/'.$html_file;
							/* Move File from images to copyImages folder */
							if( !rename($filePath_thumb, $destinationFilePath) ) {  
								//echo "File can't be moved!";  
							}else{  
								//echo "File has been moved!"; 
								$file_Path = base_url()."/uploads/thumbnails_html/gl/".$filePath_thumb;  
								$this->s3UploadThumb('gl',$file_Path);  
								//chmod($file_Path, 0644);
								//unlink($file_Path);    
							}
														//unlink($dd);
							//	exit();
								$thumb_url=$this->s3Url().'th/gl/'.$html_file; 
							}
								//$getClientExtension=$file->getClientExtension();
							else{ 
								$file_name=$this->request->getVar('old_img',FILTER_SANITIZE_STRING);
						   
							   $GalleryThumbFile=$this->request->getVar('GalleryThumbFile',FILTER_SANITIZE_STRING);						
							   $getClientExtension=$this->request->getVar('file_type',FILTER_SANITIZE_STRING);							
							   $html_file1= strstr($file_name, ".", true);
							   $thumb_url=$this->s3Url().'th/gl/'.$html_file1.'.html'; 
							   //'thumb_url'=>$this->s3Url().'th/gl/'.$html_file,
						   }
						}

						$thumb_file=$this->request->getFile('thumb_file',FILTER_SANITIZE_STRING); 
						//print_r($file);
					
						$GalaryType=$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING);
							if($GalaryType != "Image"){
								if($thumb_file){
									if($thumb_file->isValid() && !$thumb_file->hasMoved()){
									//	$thumb_file_name=$thumb_file->getRandomName();

										$thumb_files=$thumb_file->getRandomName();
										$thumb_file->move('uploads/gl',$thumb_files);  
										//exit();
										//s3 uplode
										$file_Path = base_url()."/uploads/gl/". $thumb_files; 
										$this->s3Upload('gl',$file_Path);  
										$url="./uploads/gl/".$thumb_files; 
										unlink($url);
									}else{
										$thumb_files=$this->request->getVar('thumb_file',FILTER_SANITIZE_STRING);
									}		
								}else{
									//$thumb_files=$this->request->getVar('thumb_file',FILTER_SANITIZE_STRING);
									$thumb_files=$this->request->getVar('thumb_file',FILTER_SANITIZE_STRING);
								}	
							}else{ 
								$thumb_files="";
							}
					
					
						//multiple images uploaded
						$title=$this->request->getVar('GalleryTitle',FILTER_SANITIZE_STRING);
						$galleryId_where_id=$this->request->getVar('GalleryId',FILTER_SANITIZE_STRING);	
						if($this->request->getFileMultiple('image_files')){ 
						$i=1;
						$g_id='';
				
						foreach($this->request->getFileMultiple('image_files') as $file)
						{	
							
							//die('shekhar test ');
							if($file->isValid() && !$file->hasMoved()){
								$isFile = $file;
								$data = getimagesize($isFile);
								$width = $data[0];
								$height = $data[1];
								$xOffset = ($width / 2) - 25;
								$yOffset = ($height / 2) - 25;
								$thumb_file_name=$isFile->getRandomName();
								$thumb_file=$thumb_file_name;
								$thumb_file=$this->s3Url().'gl/'.$thumb_file_name;
								$GalleryThumbFile=$thumb_file_name;
								$image = \Config\Services::image()
									->withFile($isFile)
									->fit(512, 512, 'center')
									->save('uploads/gl/'. $thumb_file_name); 
								$url_thumb=".uploads/gl/".$thumb_file_name;
								$file_Path = base_url()."/uploads/gl/".$thumb_file_name; 
								$this->s3Upload('gl',$file_Path); 
							//}

							//Orginal file
							$getClientExtension=$file->getClientExtension();
							$file_nam_uniq=uniqid(time());
							$file_name=$file_nam_uniq.'.'.$getClientExtension;
							$file->move('uploads/gl',$file_name);  

							//s3 uplode
							$file_Path = base_url()."/uploads/gl/". $file_name; 
							$this->s3Upload('gl',$file_Path);  
							$url="./uploads/gl/".$file_name; 
							unlink($url);

							//generate html file for thumbnail
							//$html_file=uniqid(time()).'.html';
							$org_file=$this->s3Url().'gl/'.$file_name;
							$html_file=$file_nam_uniq.'.html';
							$this->generate_html($html_file,$title,$thumb_file,$org_file); 
							$thumb_url=$this->s3Url().'th/gl/'.$html_file;
							$GalaryFileName=$file_name;
						//	$this->insertGalleryFiles($GalleryId,$GalaryFileName,$GalleryThumbFile,$thumb_url,$thumb_file_name,$getClientExtension);
						
							$primary_file =0;
							$primary_id=$galleryId_where_id;
							$table_data=[
								'GalaryType'=>$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING),
								'GalleryTitle'=>$this->request->getVar('GalleryTitle',FILTER_SANITIZE_STRING),
								'GalaryFileName'=>$file_name,
								'Links'=>$Links,
								'thumb_url'=>$this->s3Url().'th/gl/'.$html_file,
								'GalleryThumbFile'=>$thumb_file_name,
								//'thumb_file'=>$thumb_files, 
								'event_desc'=>$event_desc,
								'primary_file'=>$primary_file,
								'primary_id'=>$primary_id,
								'file_type'=>$getClientExtension,
								'leader_id'=>$leader_id,
								'event_campaign_name'=>$event_campaign_name, 
								'LastUpdatedBy'=>$session->get('u_id'),
								'LastUpdatedDate'=>date('Y-m-d H:i:s')

							];
							$GalleryId=$this->AdminModel->insert_record('gallery',$table_data); 	
							//$GalleryId=$this->AdminModel->updateQuery('gallery',$table_data,$where_parameter,$where_id); 
								
											
							//echo $i;
							$i++;
						 }
						}
					
					}
				}
					if($this->request->getVar('GalaryType',FILTER_SANITIZE_STRING)=="Image"){
						$table_data=[
							'GalaryType'=>$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING),
							'GalleryTitle'=>$this->request->getVar('GalleryTitle',FILTER_SANITIZE_STRING),
							'event_desc'=>$event_desc,
							'leader_id'=>$leader_id,					
							'event_campaign_name'=>$event_campaign_name, 
							'LastUpdatedBy'=>$session->get('u_id'),
							'LastUpdatedDate'=>date('Y-m-d H:i:s')
							];
							$where_parameter="GalleryId";
							$where_id=$this->request->getVar('GalleryId',FILTER_SANITIZE_STRING);					
							$GalleryId=$this->AdminModel->updateQuery('gallery',$table_data,$where_parameter,$where_id); 
					}
					if($this->request->getVar('GalaryType',FILTER_SANITIZE_STRING)!="Image"){
						$table_data=[
							'GalaryType'=>$this->request->getVar('GalaryType',FILTER_SANITIZE_STRING),
							'GalleryTitle'=>$this->request->getVar('GalleryTitle',FILTER_SANITIZE_STRING),
							'GalaryFileName'=>$file_name,
							'Links'=>$Links,
							//'thumb_url'=>$this->s3Url().'th/gl/'.$html_file,
							'thumb_url'=>$thumb_url,
							'file_type'=>$getClientExtension,
							'GalleryThumbFile'=>$GalleryThumbFile,
							'thumb_file'=>$thumb_files, 
							'event_desc'=>$event_desc,
							'leader_id'=>$leader_id,							
							'event_campaign_name'=>$event_campaign_name, 
							'LastUpdatedBy'=>$session->get('u_id'),
							'LastUpdatedDate'=>date('Y-m-d H:i:s')
							];
							$where_parameter="GalleryId";
							$where_id=$this->request->getVar('GalleryId',FILTER_SANITIZE_STRING);					
							$GalleryId=$this->AdminModel->updateQuery('gallery',$table_data,$where_parameter,$where_id); 
					}
				if($GalleryId === false){			 			
					$data=[
						'page_title'=>'Edit Gallery',
						'page_name'=>'Edit Gallery',
						'title_active'=>'gallery'
					]; 
					$session->setFlashdata('error', 'Unable to Added Gallery');
					return redirect()->route('Gallery');
				}else{
					$session->setFlashdata('success', 'Successfully Added  Gallery');
					return redirect()->route('Gallery');
				}			
		 	}
		}
	}

	//View Gallery
	public function galleryView($id=null){ 
		/*
		$session = session();
		$data=[
			'page_title'=>'View Gallery', 
			'page_name'=>'View Gallery',
			'title_active'=>'gallery'
		 ];
		$data["view"]=true;


		$data['leaders']=$this->AdminModel->getTable('leaders'); 
		$where=["IsActive"=>1];
		$data['campaign_names']=$this->AdminModel->getQueryReultFromTable('activity',$where);

	   $table="gallery";
	   $where_id=$id;
	   $where_parameter="GalleryId";
	   $data['gallerydetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
	   //$data['file_path']=$this->s3GetObjects('gallery',$data['gallerydetails']['GalaryFileName']);
		$data['file_path']=$this->s3Url()."gl/".$data['gallerydetails']['GalaryFileName'];
		$data['thumb_file_path']=$this->s3Url()."gl/".$data['gallerydetails']['thumb_file'];    
		if(isset($data['gallerydetails'])){
			return view('add_gallery',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Gallery');
		} */

		$session = session();
		$data=[
			'page_title'=>'Edit Gallery',
			'page_name'=>'Edit Gallery',
			'title_active'=>'gallery'
		 ];

		 $data['leaders']=$this->AdminModel->getTable('leaders'); 
		// $where=["IsActive"=>1];
	//	 $data['campaign_names']=$this->AdminModel->getQueryReultFromTable('activity',$where);
		$data["view"]=true;
		$table="gallery";
		$where_id=$id;
		$where_parameter="GalleryId";
		$data['gallerydetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		//$data['file_path']=$this->s3GetObjects('gallery',$data['gallerydetails']['GalaryFileName']);
		 $data['file_path']=$this->s3Url()."gl/".$data['gallerydetails']['GalaryFileName'];
		 $data['thumb_file_path']=$this->s3Url()."gl/".$data['gallerydetails']['thumb_file'];
		 $data['path']=$this->s3Url()."gl/";
		 $gallery_type=$data['gallerydetails']['GalaryType'];
		 if($gallery_type=="Image"){ 
			//$data['gallerydetails']=$this->AdminModel->getRowTableById($id);
			$where=["primary_id"=>$id];
			$data['gallerySubImages']=$this->AdminModel->getQueryReultFromTable('gallery',$where);
		 }
		//exit();
		if(isset($data['gallerydetails'])){
			return view('add_gallery',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Gallery');
		}
	}

	public function get_leaders(){ 
		$leaders=$this->AdminModel->getTable('leaders'); 
			//echo json_encode($resultData);
			$output='<div class="row" id="leader_rmv"> 
			<div class="col-md-2 align-self-center fw-bolder">
				  Leader
			</div> <div class="col-md-10"><select name="leader_id" id="leader_id" class="col-md-4 p-2">';
			$output .='<option value="">Please Select by Leader</option>';	
			foreach($leaders as $row){
			
				$output .= '<option value="'.$row['leader_id'].'" >'.$row['leader_name'].'</option>';
			}
			$output .='<select></div></div>';	
			echo $output;
	}

	//cadreListening
	public Function cadreListening(){ 
		$data=[
			'page_title'=>'Cadre Listening',
			'page_name'=>'Cadre Listening',
			'title_active'=>'cadrelistening'
			];
		$data['cadrelisteningetails']=$this->AdminModel->getCadreListeningGrid(); 
		return view('cadre_listening_management',$data);
	}
	//cadreListening
	public Function NPO(){ 
		$data=[
			'page_title'=>'NPO',
			'page_name'=>'NPO',
			'title_active'=>'NPO'
			];
		$data['cadrelisteningetails']=$this->AdminModel->getNPODetails();		
		$data['file_path']=$this->s3Url()."npo/";
		return view('npo_management',$data);
	}

	//ad NPO
	public function npoEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'NPO',
			'page_name'=>'NPO',
			'title_active'=>'NPO'
		 ];
		 //echo $id;exit;
		 $data['npoDetails']=$this->AdminModel->getNPODetailsbyId($id);		
		// print_r($data['npoDetails']);exit;
		return view('add_npo',$data);
	}

	public function npoView($id=null){
		$session = session();
		$data=[
			'page_title'=>'NPO View',
			'page_name'=>'NPO',
			'title_active'=>'NPO'
		 ];
		 $data['view']=true;
		 //echo $id;exit;
		 $data['npoDetails']=$this->AdminModel->getNPODetailsbyId($id);		
		 if($data['npoDetails']['npo_file_name']){ 
			$data['file_path']=$this->s3Url()."npo/".$data['npoDetails']['npo_file_name'];
		}
		// print_r($data['npoDetails']);exit;
		return view('add_npo',$data);
	}

	public function generateImg(){
		define('UPLOAD_DIR', 'uploads/');  
		$id=$this->request->getVar('id');
		$img=$this->request->getVar('imgBase64');
		$img = str_replace('data:image/png;base64,', '', $img);  
		$img = str_replace(' ', '+', $img);  
		$data = base64_decode($img);  
		$file = UPLOAD_DIR . uniqid() . '.png'; 
		$success = file_put_contents($file, $data);  
	//	print_r($file);
		//$table=$this->request->getVar('table');
	//	echo json_encode($resultData);
	}

	//ad cadre listening
	public function addcadreListening(){
		$session = session();
		$data=[
			'page_title'=>'Add Cadre Listening',
			'page_name'=>'Add Cadre Listening',
			'title_active'=>'cadrelistening'
		 ];
		 $parameters=array('ParliamentID','ParliamentName');
		 $order_by='ParliamentID';
		 $data['parliament']=$this->AdminModel->getQueryFromTableAdmins('parliament',$parameters,$order_by);
		 if($this->request->getMethod() == 'post'){
			$rules=[
				'IssueTitle'=>[
					'rules'=>'required',
					'label'=>'IssueTitle',
					'errors'=>[
						'required'=>'Issue Title is a required'
					]
				],
				'IssueDescription'=>[
					'rules'=>'required',
					'label'=>'Issue Description',
					'errors'=>[
						'required'=>'Issue Description is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_cadre_listening',$data);
            }else{
				// Form Data
				$table_data=[
						'IssueTitle'=>$this->request->getVar('IssueTitle',FILTER_SANITIZE_STRING),
						'IssueDescription'=>$this->request->getVar('IssueDescription',FILTER_SANITIZE_STRING),
						'ParliamentId'=>$this->request->getVar('ParliamentId',FILTER_SANITIZE_STRING),
						'ConstituencyId'=>$this->request->getVar('ConstituencyId',FILTER_SANITIZE_STRING),
						'UserType'=>"Web",
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s')

					];
					$CadreListeningId=$this->AdminModel->insert_record('cadrelisteningdetails',$table_data); 
				if($CadreListeningId === false){						
						$data=[
							'page_title'=>'Add Cadre Listening',
							'page_name'=>'Add Cadre Listening',
							'title_active'=>'cadreListening'
						]; 
						$session->setFlashdata('error', 'Unable to Added Cadre Listening');
						return redirect()->route('Cadre-Listening');
				}else{
						$session->setFlashdata('success', 'Successfully Added Cadre Listening');
						return redirect()->route('Cadre-Listening');
				}
			
		 	}
		}
		return view('add_cadre_listening',$data);
	}

	//edit cadre listening
	public function cadreListeningEdit($id=null){
		$session = session();
		$data=[
			'page_title'=>'Edit Cadre Listening',
			'page_name'=>'Edit Cadre Listening',
			'title_active'=>'cadrelistening'
			];

		$parameters=array('ParliamentID','ParliamentName');
		$order_by='ParliamentID';
		$data['parliament']=$this->AdminModel->getQueryFromTableAdmins('parliament',$parameters,$order_by);
		$where_parameter="CadreListeningId";
		$where_id=$id;
		$data['cadrelisteningetails']=$this->AdminModel->getRowTableById('cadrelisteningdetails',$where_parameter,$where_id);
		if(isset($data['cadrelisteningetails'])){
			$where_parameter = ['ParliamentID' => $data['cadrelisteningetails']['ParliamentId']]; 
			$table="constituency"; 
			$data['constituency']=$this->ApiModel->getWhereQuery($table,$where_parameter); 
			return view('add_cadre_listening',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Cadre-Listening');
		}
	}
	//update cadre listening
	public function updateCadreListening(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Add Cadre Listening',
			'page_name'=>'Add Cadre Listening',
			'title_active'=>'cadrelistening'
		 ];
		if($this->request->getMethod() == 'post'){
			$rules=[
				'IssueTitle'=>[
					'rules'=>'required',
					'label'=>'IssueTitle',
					'errors'=>[
						'required'=>'Issue Title is a required'
					]
				],
				'IssueDescription'=>[
					'rules'=>'required',
					'label'=>'Issue Description',
					'errors'=>[
						'required'=>'Issue Description is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
				return view('add_cadre_listening',$data);
            }else{
				$table_data=[
						'IssueTitle'=>$this->request->getVar('IssueTitle',FILTER_SANITIZE_STRING),
						'IssueDescription'=>$this->request->getVar('IssueDescription',FILTER_SANITIZE_STRING),
						'ParliamentId'=>$this->request->getVar('ParliamentId',FILTER_SANITIZE_STRING),
						'ConstituencyId'=>$this->request->getVar('ConstituencyId',FILTER_SANITIZE_STRING),
						'UserType'=>"Web",
						'LastUpdatedBy'=>$session->get('u_id'),
						'LastUpdatedDate'=>date('Y-m-d H:i:s')
					];
					$where_parameter="CadreListeningId";
					$where_id=$this->request->getVar('CadreListeningId',FILTER_SANITIZE_STRING);
					$CadreListeningId=$this->AdminModel->updateQuery('cadrelisteningdetails',$table_data,$where_parameter,$where_id); 
				if($CadreListeningId === false){						
					$data=[
						'page_title'=>'Edit Cadre Listening',
						'page_name'=>'Edit Cadre Listening',
						'title_active'=>'cadrelistening'
					]; 
					$session->setFlashdata('error', 'Unable to Added Cadre Listening');
					return redirect()->route('Cadre-Listening');
				}else{
					$session->setFlashdata('success', 'Successfully Added Cadre-Listening');
					return redirect()->route('Cadre-Listening');
				}
		 	}
		 }
	}

	//view cadre listening
	public function cadreListeningView($id=null){
		$session = session();
		$data=[
			'page_title'=>'View Cadre Listening',
			'page_name'=>'View Cadre Listening',
			'title_active'=>'cadrelistening' 
			];
		$data['view']=true;
		$parameters=array('ParliamentID','ParliamentName');
		$order_by='ParliamentID';
		$data['parliament']=$this->AdminModel->getQueryFromTableAdmins('parliament',$parameters,$order_by);
		$where_parameter="CadreListeningId";
		$where_id=$id;
		$data['cadrelisteningetails']=$this->AdminModel->getRowTableById('cadrelisteningdetails',$where_parameter,$where_id);
		if(isset($data['cadrelisteningetails'])){
			$where_parameter = ['ParliamentID' => $data['cadrelisteningetails']['ParliamentId']]; 
			$table="constituency"; 
			$data['constituency']=$this->ApiModel->getWhereQuery($table,$where_parameter); 
			return view('add_cadre_listening',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Cadre-Listening');
		}
	}

	public function ImportExcel(){
		$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
		
		if ($file->isValid() && ! $file->hasMoved()) {
			$newName = $file->getRandomName();
				$file_name = $file->getTempName();
	
				$student = array();
	
				$csv_data = array_map('str_getcsv', file($file_name));
	
				if (count($csv_data) > 0) {
					$index = 0;
					//print_r($csv_data);
					foreach ($csv_data as $data) {
						if ($index > 0) {
							$parliamentName=$data[1];
							$ParliamentID=$this->AdminModel->checkParliament($parliamentName);
							$ConstituencyData[] = array(								
								"ConstituencyName" => $data[2],
								"ParliamentID" => $ParliamentID,
							);
						}
						$index++;
					}
					$this->AdminModel->InsertConstituency($ConstituencyData);
				}
		}
	}

	//import affilliated committe names
	public function ImportAffilliatedCommitte(){
		$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
		
		if ($file->isValid() && ! $file->hasMoved()) { 
			$newName = $file->getRandomName();
				$file_name = $file->getTempName();
	
				$student = array();
	
				$csv_data = array_map('str_getcsv', file($file_name));
	
				if (count($csv_data) > 0) {
					$index = 0;
					//print_r($csv_data);
					foreach ($csv_data as $data) {
						if ($index > 0) {
							//$parliamentName=$data[1];
							//$ParliamentID=$this->AdminModel->checkParliament($parliamentName);
							$InsertData[] = array(								
								"committeeTypeId" => $data[2],
								"affiliatedCommitteeName" => $data[1],
							);
						}
						$index++;
					}
					//$this->AdminModel->InsertConstituency($ConstituencyData);
					//print_r($InsertData);
					$this->AdminModel->InsertImportData('affiliatedCommittees',$InsertData);
				}
		}
	}

	//designation Insert
	public function ImportDesignation(){
		$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
		
		if ($file->isValid() && ! $file->hasMoved()) { 
			$newName = $file->getRandomName();
				$file_name = $file->getTempName();
	
				$student = array();
	
				$csv_data = array_map('str_getcsv', file($file_name));
	
				if (count($csv_data) > 0) {
					$index = 0;
					//print_r($csv_data);
					foreach ($csv_data as $data) {
						if ($index > 0) {
							//$parliamentName=$data[1];
							//$ParliamentID=$this->AdminModel->checkParliament($parliamentName);
							$InsertData[] = array(								
								"designationName" => $data[4],
								"committeeNameId" => $data[1],
								"committeeTypeId"=>$data[2],
								"affiliatedCommitteeId"=>$data[3] 
							);
						}
						$index++;
					}
					//$this->AdminModel->InsertConstituency($ConstituencyData);
					//print_r($InsertData);
					$this->AdminModel->InsertImportData('designation',$InsertData);
				}
		}
	}

	//import Prliaments
	public function ImportParliaments(){
		$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
		
		if ($file->isValid() && ! $file->hasMoved()) { 
			$newName = $file->getRandomName();
				$file_name = $file->getTempName();
	
				$student = array();
	
				$csv_data = array_map('str_getcsv', file($file_name));
	
				if (count($csv_data) > 0) {
					$index = 0;
					//print_r($csv_data);
					foreach ($csv_data as $data) {
						if ($index > 0) {
							//$parliamentName=$data[1];
							//$ParliamentID=$this->AdminModel->checkParliament($parliamentName);
							$InsertData[] = array(								
								"ConstituencyName" => $data[1],
								"ParliamentID" => $data[2]
							);
						}
						$index++;
					}
					//$this->AdminModel->InsertConstituency($ConstituencyData); 
					//print_r($InsertData);
					$this->AdminModel->InsertImportData('constituency',$InsertData); 
				}
		}
	}


	//import nithyavasara dharalu
	public function child_campaign(){
		$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
		if ($file->isValid() && ! $file->hasMoved()) {
				$newName = $file->getRandomName();
				$file_name = $file->getTempName();
				$student = array();
				$csv_data = array_map('str_getcsv', file($file_name));
				if (count($csv_data) > 0) {
					$index = 0;
					//print_r($csv_data);
					foreach ($csv_data as $data) { 
						if ($index > 0) {
							$InsertData[] = array(								
								"parent_campaign_id" =>26,
								"District" => $data[1],
								"Parliament" => $data[2],
								"Constituency" => $data[3],
								"Informed_Mla_Incharge" => $data[4],
								"campaign_conducted" => $data[5],
								"Banner_Displayed" => $data[6],
								"Parliament_President_Participated" => $data[7],
								"Mla_Incharge_Participation" => $data[8],
								"Constituency_Leaders_Participated" => $data[9],
								"No_of_Cadre_Participated_Count" => $data[10],
								"Neutral_People_Participated_Count" => $data[11],
								"Whatsapp_Images_Videos" => $data[12],
								"Media_Coverage" => $data[13],
								"Remarks" => $data[14], 
							);
						}
						$index++; 
					}
					$this->AdminModel->InsertChildData($InsertData);
					
				}
			}
	}

	public function markeImport(){ 
			$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
			if ($file->isValid() && ! $file->hasMoved()){
				$newName = $file->getRandomName();
				$file_name = $file->getTempName();
				$student = array();
				$csv_data = array_map('str_getcsv', file($file_name));
				if (count($csv_data) > 0) {
					$index = 0;
					//print_r($csv_data);
					foreach ($csv_data as $data) { 
						if ($index > 0) {
								$InsertData[] = array(								
									"parent_campaign_id" =>26,
									"Parliament" => $data[0],
									"Constituency" => $data[1],
									"Only_Constituency_Participation"=>$data[2],
									"Only_Constituency_Participation_percentage" => $data[3],
									"Only_Constituency_Grade" =>$data[4],
									"Incharge_Participation_Included"=> $data[5],
									"Incharge_Participation_Included_percentage"=>$data[6],
									"Incharge_Participation_Grade"=>$data[7],
								); 
						}
						$index++; 
						
					}
					//print_r($InsertData);
					$this->AdminModel->InsertMarksData($InsertData);
				}
			}
		}

		public function gradeImport(){
			$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
			if ($file->isValid() && ! $file->hasMoved()){
				$newName = $file->getRandomName();
				$file_name = $file->getTempName();
				$student = array();
				$csv_data = array_map('str_getcsv', file($file_name));
				if (count($csv_data) > 0) {
					$index = 0;
					//print_r($csv_data);
					foreach ($csv_data as $data) { 
						if ($index > 0) {
								$InsertData[] = array(								
									"grade" =>"B",
									"campaign_id"=>"26",
									"Parliament" => $data[1],
									"Constituency" => $data[2]
								); 
						}
						$index++; 
						
					}
					//print_r($InsertData);
					$this->AdminModel->InsertImportData('grading_campaign',$InsertData);
				}
			}
		}

		public function get_perctage_by_data(){  
			$percentage_campaign_id=$this->request->getVar('percentage_campaign_id');
			$where_id=$percentage_campaign_id;
			$where_parameter="percentage_campaign_id";
			$percentage_campaign_data=$this->AdminModel->getRowTableById('percentage_campaign',$where_parameter,$where_id);
			$grade=$percentage_campaign_data['Grade'];
			$campaign_id=$percentage_campaign_data['campaign_id'];
			//get parliments and costituencys
			$where=["grade"=>$grade,"campaign_id"=>$campaign_id];
			$grader_result=$this->AdminModel->getQueryReultFromTable('grading_campaign',$where);

			echo json_encode($grader_result); 
		}

		//public function 
		public function test_ajax(){
		//	$compain_id=$this->request->getVar('compain_id');
			//$grade=$this->request->getVar('grade');
			//$grader_result=$this->AdminModel->getConstencyParliments($compain_id,$grade);
			$grader_result = csrf_token().'-'. csrf_hash();
		
			
			//$grader_result="shekhar123";
			echo json_encode($grader_result);

		}

		//public function 
		public function get_constituency_data_ajax(){
			$compain_id=$this->request->getVar('compain_id');
			$grade=$this->request->getVar('grade');
			$grader_result=$this->AdminModel->getConstencyParliments($compain_id,$grade);
			echo json_encode($grader_result);

		}

		//get_constituency_list
		public function get_const_parli_list(){
			$action=$this->request->getVar('action');
			if($action == "Constituency"){
				$result=$this->AdminModel->AllConstituencyPointsWise();
			}else{
				$result=$this->AdminModel->AllParliamentsPointsWise();
			}			
			echo json_encode($result);
		}


		public function get_compaign_log_ajax(){
			
			$compain_status_id=$this->request->getVar('compain_status_id');
			$campaign_log=$this->AdminModel->campaign_log($compain_status_id); 

		//	$campaign_log_admin=$this->AdminModel->campaign_log_admin($compain_status_id);
			
			$i=0;
			foreach($campaign_log as $row){  
				$campaign_log[$i]['updated_fileds']=rtrim(str_replace(",",", ",$row['updated_filed']), ',');
				$campaign_log[$i]['up_Date']=date('d-m-Y H:i:s',strtotime($row['CreatedDate']));
				//$CreatedDate[$i]['CreatedDate']=
			//	$campaign_log[$i]['updated_fileds']=rtrim($s, ',');
				if($row['UserType']== "admin"){ 
						$where=['EmployeeId'=>$row['UserId']]; 
						$admin_result=$this->ApiModel->getRowTableByIds('employees',$where);
						$campaign_log[$i]['User_FirstName']=$admin_result['FirstName'];
				}else{
						$where=['u_id'=>$row['UserId']]; 
						$admin_result=$this->ApiModel->getRowTableByIds('users',$where); 
						$campaign_log[$i]['User_FirstName']=$admin_result['FirstName'];
				}
			
				$i++;
			}
			
			echo json_encode($campaign_log);

		}
		

		public function get_constituency_data_for_incharge(){
			$compain_id=$this->request->getVar('compain_id');
			$incharge=$this->request->getVar('incharge');
			$incharge_result=$this->AdminModel->getConstencyParlimentsForIncharges($compain_id,$incharge);
			echo json_encode($incharge_result);
		}

		public function get_constituency_data_for_Viewd(){
			$compain_id=$this->request->getVar('compain_id');
			$checkView=$this->request->getVar('checkView');
			$incharge_result=$this->AdminModel->getConstencyParlimentsForViewd($compain_id,$checkView);
			echo json_encode($incharge_result);
		}
		public function get_constituencies_for_pp(){
			$compain_id=$this->request->getVar('compain_id');
			$ConstituencyProgramConducted=$this->request->getVar('ConstituencyProgramConducted');
			$pp_result=$this->AdminModel->getConstencyParlimentsForPP($compain_id,$ConstituencyProgramConducted);
			echo json_encode($pp_result);  
		}

		//insert user mla in charges
		public function importUsers(){
			$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
			if ($file->isValid() && ! $file->hasMoved()){
				$newName = $file->getRandomName();
				$file_name = $file->getTempName();
				$student = array();
				$csv_data = array_map('str_getcsv', file($file_name));
				if (count($csv_data) > 0) { 
					$index = 0;
					//print_r($csv_data);
					
					foreach ($csv_data as $data) { 
						$s[]=$data;
						
					}
					$i=0;
					foreach($s as $d=>$data){
						//echo $v[2];
						//echo $i;
						if ($i > 0) {
						if(!empty($data[2]) && !empty($data[3])){ 
								 $i;
							$InsertData[] = array( 	 
								"ParliamentId" =>$data[3],
								"ConstituencyId" =>$data[5], 
								"FirstName" =>$data[6],
								"DisplayName" =>$data[6],
								"ActivityCommitteeGroup"=>"2",
								"AppRoleId"=>"3",
								"MobileVerified"=>"1",
								"Mobile"=>$data[8],
								"Mobile2"=>$data[9],
								"Gender"=>$data[10],
								"Caste"=>$data[11],
								"SubCast"=>$data[12],
								"DOB"=>date('Y-m-d',strtotime($data[13])),
								"EmailsList"=>$data[14],
								'Password'=>password_hash("Manatdp@123", PASSWORD_DEFAULT)

							); 
							
							}else{
								echo $i;
							}
						}
						//echo $v[3];
					$i++;	
					}
					foreach($InsertData as $row){
						$table_data=[
							"ParliamentId" =>$row["ParliamentId"],
							"ConstituencyId" =>$row["ConstituencyId"], 
							"FirstName" =>$row["FirstName"],
							"DisplayName" =>$row["DisplayName"],
							"ActivityCommitteeGroup"=>"2",
							"AppRoleId"=>"3",
							"MobileVerified"=>"1",
							"Mobile"=>$row["Mobile"],
							"Mobile2"=>$row["Mobile2"],
							"Gender"=>$row["Gender"],
							"Caste"=>$row["Caste"],
							"SubCast"=>$row["SubCast"],
							"DOB"=>$row["DOB"],
							"EmailsList"=>$row["EmailsList"],
							'Password'=>password_hash("Manatdp@123", PASSWORD_DEFAULT),
							"Status"=>"Approved"
						];
						$user_id=$this->AdminModel->insert_record('users',$table_data); 
						$bUIdLength = strlen($user_id);
						switch($bUIdLength)
						{
							case 1: $MembershipId = "MANATDP00000".$user_id;
							break;
							case 2: $MembershipId = "MANATDP0000".$user_id;
							break;
							case 3: $MembershipId = "MANATDP000".$user_id;
							break;
							case 4: $MembershipId = "MANATDP00".$user_id;
							break;
							case 5: $MembershipId = "MANATDP0".$user_id;
							break;
							case 7: $MembershipId = "MANATDP".$user_id;
							break;
							default: 
							echo "Your favorite color is neither red, blue, nor green!";
							
						} 

						//update user tables
						$where_parameter="u_id";
						$table_data=["MembershipId"=>$MembershipId];
						$table="users";
						$where_id=$user_id;
						$updateQuery=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);
					}
					//print_r($InsertData);
					//$this->AdminModel->InsertImportData('users',$InsertData);
				}
			}
		}

		//insert palirment menbers
		public function importUsersParliament(){
			$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
			if ($file->isValid() && ! $file->hasMoved()){
				$newName = $file->getRandomName();
				$file_name = $file->getTempName(); 
				$student = array();
				$csv_data = array_map('str_getcsv', file($file_name));
				if (count($csv_data) > 0) { 
					$index = 0;
					//print_r($csv_data);					
					foreach ($csv_data as $data) { 
						$s[]=$data;
						
					}
					$i=0;
					foreach($s as $d=>$data){
						//echo $v[2];
						//echo $i;
						if ($i > 0) {
						if(!empty($data[4]) && !empty($data[8])){  
								 $i;
								 $where_data=["Mobile"=>$data[7]];
								$count= $this->AdminModel->tableRowsCount('users',$where_data);
								if($count){

								}else{
									$InsertData[] = array( 	 
										"ParliamentId" =>$data[3],
										"ConstituencyId" =>$data[3], 
										"FirstName" =>$data[5],
										"DisplayName" =>$data[5],
										"ActivityCommitteeGroup"=>"2",
										"AppRoleId"=>"4",
										"MobileVerified"=>"1",
										"Mobile"=>$data[7],
										"Gender"=>$data[8],
										"Caste"=>$data[9],
										"SubCast"=>$data[10],
										"DOB"=>date('Y-m-d',strtotime($data[11])),  
										"EmailsList"=>$data[12], 
										'Password'=>password_hash("Manatdp@123", PASSWORD_DEFAULT)
	
									); 
								}
								
							
							}else{
								echo $i;
							}
						}
						//echo $v[3];
						$i++;	
					}
					foreach($InsertData as $row){
						$table_data=[
							"ParliamentId" =>$row["ParliamentId"],
							"ConstituencyId" =>$row["ConstituencyId"], 
							"FirstName" =>$row["FirstName"],
							"DisplayName" =>$row["DisplayName"],
							"ActivityCommitteeGroup"=>"1",
							"AppRoleId"=>"4",
							"MobileVerified"=>"1",
							"Mobile"=>$row["Mobile"],
							"Gender"=>$row["Gender"],
							"Caste"=>$row["Caste"],
							"SubCast"=>$row["SubCast"],
							"DOB"=>$row["DOB"],
							"EmailsList"=>$row["EmailsList"],
							'Password'=>password_hash("Manatdp@123", PASSWORD_DEFAULT),
							"Status"=>"Approved"
						];
						$user_id=$this->AdminModel->insert_record('users',$table_data); 
						$bUIdLength = strlen($user_id);
						switch($bUIdLength)
						{
							case 1: $MembershipId = "MANATDP00000".$user_id;
							break;
							case 2: $MembershipId = "MANATDP0000".$user_id;
							break;
							case 3: $MembershipId = "MANATDP000".$user_id;
							break;
							case 4: $MembershipId = "MANATDP00".$user_id;
							break;
							case 5: $MembershipId = "MANATDP0".$user_id;
							break;
							case 7: $MembershipId = "MANATDP".$user_id;
							break;
							default: 
							echo "Your favorite color is neither red, blue, nor green!";
							
						} 

						//update user tables
						$where_parameter="u_id";
						$table_data=["MembershipId"=>$MembershipId];
						$table="users";
						$where_id=$user_id;
						$updateQuery=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);
					} 
					//print_r($InsertData);
					//$this->AdminModel->InsertImportData('users',$InsertData);
				}
			}
		}
		//import pc users data

		//insert palirment menbers
		public function importUsersParliamentPc(){
			$file=$this->request->getFile('file',FILTER_SANITIZE_STRING);
			if ($file->isValid() && ! $file->hasMoved()){ 
				$newName = $file->getRandomName();
				$file_name = $file->getTempName(); 
				$student = array();
				$csv_data = array_map('str_getcsv', file($file_name));
				if (count($csv_data) > 0) { 
					$index = 0;
					//print_r($csv_data);					
					foreach ($csv_data as $data) { 
						$s[]=$data;
						
					}
					$i=0;
					foreach($s as $d=>$data){
						//echo $v[2];
						//echo $i;
						if ($i > 0) {
						if(!empty($data[1]) && !empty($data[8])){  
									$i;
								$where_data=["Mobile"=>$data[8]];
								$count= $this->AdminModel->tableRowsCount('users',$where_data);
								if($count){

								}else{
									$InsertData[] = array( 	 
										"ParliamentId" =>25,
										"ConstituencyId" =>175, 
										"FirstName" =>$data[1],
										"DisplayName" =>$data[1], 
										"AppRoleId"=>"5",
										"MobileVerified"=>"1",
										"Mobile"=>$data[8],
										"Gender"=>$data[2],
										"Caste"=>$data[7],
										"DOB"=>date('Y-m-d',strtotime($data[3])),  
										'Password'=>password_hash("Manatdp@123", PASSWORD_DEFAULT)
	
									); 
								}
								
							
							}else{
								echo $i;
							}
						}
						//echo $v[3];
						$i++;	
					}
					foreach($InsertData as $row){
						$table_data=[
							"ParliamentId" =>$row["ParliamentId"],
							"ConstituencyId" =>$row["ConstituencyId"], 
							"FirstName" =>$row["FirstName"],
							"DisplayName" =>$row["DisplayName"],
							"AppRoleId"=>"5",
							"MobileVerified"=>"1",
							"Mobile"=>$row["Mobile"],
							"Gender"=>$row["Gender"],
							"Caste"=>$row["Caste"],
							"DOB"=>$row["DOB"],
							'Password'=>password_hash("Manatdp@123", PASSWORD_DEFAULT),
							"Status"=>"Approved"
						];
						$user_id=$this->AdminModel->insert_record('users',$table_data); 
						$bUIdLength = strlen($user_id);
						switch($bUIdLength)
						{
							case 1: $MembershipId = "MANATDP00000".$user_id;
							break;
							case 2: $MembershipId = "MANATDP0000".$user_id;
							break;
							case 3: $MembershipId = "MANATDP000".$user_id;
							break;
							case 4: $MembershipId = "MANATDP00".$user_id;
							break;
							case 5: $MembershipId = "MANATDP0".$user_id;
							break;
							case 7: $MembershipId = "MANATDP".$user_id;
							break;
							default: 
							echo "Your favorite color is neither red, blue, nor green!";
							
						} 

						//update user tables
						$where_parameter="u_id";
						$table_data=["MembershipId"=>$MembershipId];
						$table="users";
						$where_id=$user_id;
						$updateQuery=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);
					} 
					//print_r($InsertData);
					//$this->AdminModel->InsertImportData('users',$InsertData);
				}
			}
		}

	//Polls management
	public Function Polls(){ 
		$data=[
			'page_title'=>'Polls',
			'page_name'=>'Polls',
			'title_active'=>'Polls'
			];
		$parameters=array('p_id','Question','Option1','Option2','Option3','Option4','CreatedDate','PollsStatus');
		$order_by='p_id';
		$data['polldetails']=$this->AdminModel->getQueryFrom('poll',$parameters,$order_by); 
	
       $data['activitydetails']=$this->AdminModel->programActivityGrid();
		return view('poll_management',$data);
	}
	// add Polls
	public function AddPolls(){ 
		$session = session();
		$data=[
			'page_title'=>'Add Polls',
			'page_name'=>'Add Polls',
			'title_active'=>'Polls'
		 ];
		 if($this->request->getMethod() == 'post'){
			$rules=[
				'Question'=>[
					'rules'=>'required',
					'label'=>'Question',
					'errors'=>[
						'required'=>'Question is a required'
					]
				],
				'Option1'=>[
					'rules'=>'required',
					'label'=>'Option1',
					'errors'=>[
						'required'=>'Option1 is a required'
					]
				],
				'Option2'=>[
					'rules'=>'required',
					'label'=>'Option2',
					'errors'=>[
						'required'=>'Option2 is a required'
					]
				],
				'PollsStatus'=>[
					'rules'=>'required',
					'label'=>'PollsStatus',
					'errors'=>[
						'required'=>'PollsStatus is a required'
					]
				],
				
				

			];
			
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_polls',$data);
            }else{
				
				// end test here
				$table_data=[
						'Question'=>$this->request->getVar('Question',FILTER_SANITIZE_STRING),
						'Option1'=>$this->request->getVar('Option1',FILTER_SANITIZE_STRING),
						'Option2'=>$this->request->getVar('Option2',FILTER_SANITIZE_STRING),
						'Option3'=>$this->request->getVar('Option3',FILTER_SANITIZE_STRING),
						'Option4'=>$this->request->getVar('Option4',FILTER_SANITIZE_STRING),
						'PollsStatus'=>$this->request->getVar('PollsStatus',FILTER_SANITIZE_STRING),
						'poll_date'=>$this->request->getVar('poll_date',FILTER_SANITIZE_STRING),
						'CreatedBy'=>$session->get('u_id'),
						'CreatedDate'=>date('Y-m-d H:i:s')

					];
					$poll_id=$this->AdminModel->insert_record('poll',$table_data);
					
				if($poll_id === false){		 				
					$data=[
						'page_title'=>'Add Polls',
						'page_name'=>'Add Polls',
						'title_active'=>'Polls'
					]; 
					$session->setFlashdata('error', 'Unable to Added Polls');
					return redirect()->route('Polls');
				}else{

					//New Roles Assigned
					$designatedMember=$this->request->getVar('designatedMember'); 
                    $committeeTypeId=$this->request->getVar('committeeTypeId'); 
                    $committeeNameId=$this->request->getVar('committeeNameId'); 
                    $affiliatedCommitteeId=$this->request->getVar('affiliatedCommitteeId');
                    $designationId=$this->request->getVar('designationId'); 

					if($poll_id){	
						
							//Insert into
					$committeeNameId=$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING);
					foreach($committeeNameId as $value){
						$table_data_committee[]=[
							'poll_id'=>$poll_id,
							'committeeNameId'=>$value,
							'committeeTypeId'=>$this->request->getVar('committeeTypeId',FILTER_SANITIZE_STRING),
							'designatedMember'=>$this->request->getVar('designatedMember',FILTER_SANITIZE_STRING),						
							'CreatedDate'=>date('Y-m-d H:i:s') 
						];
					} 
					$this->AdminModel->InsertImportData('assignedPolls',$table_data_committee);
						
						if($this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING)){
							$affiliatedCommitteeId=$this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING);
							foreach($affiliatedCommitteeId as $value){								
								$table_data_Aff[]=[
									'poll_id'=>$poll_id,
									'affiliatedCommitteeId'=>$value,					
									'CreatedDate'=>date('Y-m-d H:i:s') 
								];
							}
							//print_r($table_data);
							$this->AdminModel->InsertImportData('assignePollsToAff',$table_data_Aff);
						} 
						if($this->request->getVar('designationId',FILTER_SANITIZE_STRING)){
							$designationId=$this->request->getVar('designationId',FILTER_SANITIZE_STRING);
							foreach($designationId as $key=>$value){ 
								$table_data_dsg[]=[
									'poll_id'=>$poll_id,
									'designationId'=>$value,					
									'CreatedDate'=>date('Y-m-d H:i:s') 
								];
							}
							$this->AdminModel->InsertImportData('assignePollsToDesg',$table_data_dsg);
						}

						$committeeNameId=implode(",",$committeeNameId); 
						if($designatedMember == "No"){  
							$UserDetails1=$this->AdminModel->getCampaignsByGroupDesgNo($designatedMember,$committeeNameId); 
						}else{
						$UserDetails1=array();
						if(!empty($affiliatedCommitteeId)){
							$affiliatedCommitteeIds='';
							if($affiliatedCommitteeId){
								$affiliatedCommitteeIds=implode(",",$affiliatedCommitteeId);
							}
							$designationIds='';
							if($designationId){ 
								$designationIds=implode(",",$designationId);
							}

							$UserDetails1=$this->AdminModel->getUsersAffDesgGroup($designatedMember,$committeeNameId,$committeeTypeId,$affiliatedCommitteeIds,$designationIds);  
						}
						else{
							$designationIds='';
							if($designationId){
								$designationIds=implode(",",$designationId);
							 }
							$UserDetails1=$this->AdminModel->getUsersDesgGroup($designatedMember,$committeeNameId,$committeeTypeId,$designationIds); 
						}

					} 
				//insert into Notification table
				if($UserDetails1){   
									
					$device_token=array(); 
					foreach($UserDetails1 as $row){ 
						$title="Poll - ".$this->request->getVar('Question',FILTER_SANITIZE_STRING);
						$message="New Poll assigned via ManaTDP";		
						if($row['device_token']){ 
							$device_token[]=$row['device_token'];
						}
						$table_notification_data[]=[  
							'NotificationUserId'=>$row['u_id'],
							'NotificationTitle'=>$title,
							'NotificationDescription'=>$message,
							'NotificationType'=>"Polls",
							'FromId'=>$poll_id,
							'CreatedDate'=>date('Y-m-d H:i:s')
						];
					
					} 
					$this->fcm_notification($device_token,$title,$message);						
					//$this->AdminModel->InsertImportData('activitystatus',$table_data_users_chlid);
					$this->AdminModel->InsertImportData('notifications',$table_notification_data);
				}

					$session->setFlashdata('success', 'Successfully Added Polls');
					return redirect()->route('Polls');
				}
			
		 	}
		 }
		}
		//get commite name
		$where=["IsActive"=>1];
		$data['committeeName']=$this->AdminModel->getQueryReultFromTable('committeeName',$where);
		return view('add_polls',$data);
	}

	
//edit Polls
	public function pollsEdit($id=null){
		$data=[
			'page_title'=>'Polls Edit',
			'page_name'=>'Polls Edit',
			'title_active'=>'Polls'
		 ];
		
		 
		$table="poll";
		$where_id=$id;
		$where_parameter="p_id";
	//	$data['polldetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		$data['polldetails']=$this->AdminModel->getPollsById($id);  

		$where_parameter = ['designatedMember' =>$data['polldetails']["designatedMember"]]; 
		$table="committeeName";
		$data['committeeName']=$this->ApiModel->getWhereQuery($table,$where_parameter); 

		if($data['polldetails']["designatedMember"]=="Yes"){
			$committeeTypeName=$data['polldetails']["committeeTypeId"];
				
			//Get Afflliated Groups
			if($committeeTypeName == "Affiliated"){					

				//Get Afflliated Groups
				$committeeTypeName=$data['polldetails']["committeeTypeId"];
				$committeeNameId=$data['polldetails']["committeeNameIdS"];
				$data['affiliatedCommittees']=$this->AdminModel->getSmTaskAffliatedOrMain($committeeTypeName,$committeeNameId); 

				//get Designations
				 $affiliatedCommitteeId=$data['polldetails']["affiliatedCommitteeIds"];  
				 $data['designation']=$this->AdminModel->getAffDesignationIds($affiliatedCommitteeId);  
				//	print_r($data['designation']);
				

			}else{
				 $committeeNameId=$data['polldetails']["committeeNameIdS"];
					$data['designation']=$this->AdminModel->getDesignationIds($committeeNameId); 
			}
			//echo $committeeNameId;
		//	echo '<pre>';
			//print_r($data['designation']); 
		//	exit();
		}else{

		}
		if(isset($data['polldetails'])){
			return view('add_polls',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Polls');
		}
	}
	//update Polls
public function UpdatePolls(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Polls Edit',
			'page_name'=>'Polls Edit',
			'title_active'=>'Polls'
		 ];
		
		if($this->request->getMethod() == 'post'){
			$rules=[
				'Question'=>[
					'rules'=>'required',
					'label'=>'Question',
					'errors'=>[
						'required'=>'Question is a required'
					]
				],
				'Option1'=>[
					'rules'=>'required',
					'label'=>'Option1',
					'errors'=>[
						'required'=>'Option1 is a required'
					]
				],
				'Option2'=>[
					'rules'=>'required',
					'label'=>'Option2',
					'errors'=>[
						'required'=>'Option2 is a required'
					]
				],
				'PollsStatus'=>[
					'rules'=>'required',
					'label'=>'PollsStatus',
					'errors'=>[
						'required'=>'PollsStatus is a required'
					]
				]
				
				

			];
		
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_polls',$data);
            }else{

				// end test here
				$table_data=[
						'Question'=>$this->request->getVar('Question',FILTER_SANITIZE_STRING),
						'Option1'=>$this->request->getVar('Option1',FILTER_SANITIZE_STRING),
						'Option2'=>$this->request->getVar('Option2',FILTER_SANITIZE_STRING),
						'Option3'=>$this->request->getVar('Option3',FILTER_SANITIZE_STRING),
						'Option4'=>$this->request->getVar('Option4',FILTER_SANITIZE_STRING),
						'PollsStatus'=>$this->request->getVar('PollsStatus',FILTER_SANITIZE_STRING),
						'poll_date'=>$this->request->getVar('poll_date',FILTER_SANITIZE_STRING),
						'ConstituencyID'=>$this->request->getVar('ConstituencyID',FILTER_SANITIZE_STRING),
						'LastUpdatedBy'=>$session->get('u_id'),
					    'LastUpdatedDate'=>date('Y-m-d H:i:s')

					];
					$poll_id=$this->request->getVar('p_id',FILTER_SANITIZE_STRING);
					$where_parameter="p_id";
					$where_id=$this->request->getVar('p_id',FILTER_SANITIZE_STRING);
					
					$NewsFeedId=$this->AdminModel->updateQuery('poll',$table_data,$where_parameter,$where_id); 
				
				if($NewsFeedId === false){						
					$data=[
						'page_title'=>'Add Polls',
						'page_name'=>'Add Polls',
						'title_active'=>'Polls'
					]; 
					$session->setFlashdata('error', 'Unable to Added Polls');
					return redirect()->route('Polls');
				}else{
					$where_data=["poll_id"=>$this->request->getVar('p_id',FILTER_SANITIZE_STRING)];
					$assigneTasks=$this->ApiModel->deleteRecord('assignedPolls',$where_data);
					
				//	if($assignedTasksUpdate){ 
					$where_data=["poll_id"=>$this->request->getVar('p_id',FILTER_SANITIZE_STRING)];
					$assigneTasksToAffDelete=$this->ApiModel->deleteRecord('assignePollsToAff',$where_data);

					//Delete Deg
					$where_data=["poll_id"=>$this->request->getVar('p_id',FILTER_SANITIZE_STRING)];
					$assigneTasksToAffDelete=$this->ApiModel->deleteRecord('assignePollsToDesg',$where_data); 

					$committeeNameId=$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING);
					foreach($committeeNameId as $value){
						$table_data_committee[]=[
							'poll_id'=>$poll_id,
							'committeeNameId'=>$value,
							'committeeTypeId'=>$this->request->getVar('committeeTypeId',FILTER_SANITIZE_STRING),
							'designatedMember'=>$this->request->getVar('designatedMember',FILTER_SANITIZE_STRING),						
							'CreatedDate'=>date('Y-m-d H:i:s') 
						];
					} 
					$this->AdminModel->InsertImportData('assignedPolls',$table_data_committee);
						
						if($this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING)){
							$affiliatedCommitteeId=$this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING);
							foreach($affiliatedCommitteeId as $value){								
								$table_data_Aff[]=[
									'poll_id'=>$poll_id,
									'affiliatedCommitteeId'=>$value,					
									'CreatedDate'=>date('Y-m-d H:i:s') 
								];
							}
							//print_r($table_data);
							$this->AdminModel->InsertImportData('assignePollsToAff',$table_data_Aff);
						} 
						if($this->request->getVar('designationId',FILTER_SANITIZE_STRING)){
							$designationId=$this->request->getVar('designationId',FILTER_SANITIZE_STRING);
							foreach($designationId as $key=>$value){ 
								$table_data_dsg[]=[
									'poll_id'=>$poll_id,
									'designationId'=>$value,					
									'CreatedDate'=>date('Y-m-d H:i:s') 
								];
							}
							$this->AdminModel->InsertImportData('assignePollsToDesg',$table_data_dsg);
						}
						/*
						$committeeNameId=implode(",",$committeeNameId); 
						if($designatedMember == "No"){  
							$UserDetails1=$this->AdminModel->getCampaignsByGroupDesgNo($designatedMember,$committeeNameId); 
						}else{
						$UserDetails1=array();
						if(!empty($affiliatedCommitteeId)){
							$affiliatedCommitteeIds='';
							if($affiliatedCommitteeId){
								$affiliatedCommitteeIds=implode(",",$affiliatedCommitteeId);
							}
							$designationIds='';
							if($designationId){ 
								$designationIds=implode(",",$designationId);
							}

							$UserDetails1=$this->AdminModel->getUsersAffDesgGroup($designatedMember,$committeeNameId,$committeeTypeId,$affiliatedCommitteeIds,$designationIds);  
						}
						else{
							$designationIds='';
							if($designationId){
								$designationIds=implode(",",$designationId);
							 }
							$UserDetails1=$this->AdminModel->getUsersDesgGroup($designatedMember,$committeeNameId,$committeeTypeId,$designationIds); 
						}

					} 
					//insert into Notification table
					if($UserDetails1){    
						foreach($UserDetails1 as $row){ 
							$title="Poll";
							$message="New Poll assigned via ManaTDP";
							if($row['device_token']){
								$this->fcm_notification($row['device_token'],$title,$message);
							}
							$table_notification_data[]=[ 
								'NotificationUserId'=>$row['u_id'],
								'NotificationTitle'=>$title,
								'NotificationDescription'=>$message,
								'NotificationType'=>"Polls",
								'FromId'=>$poll_id,
								'CreatedDate'=>date('Y-m-d H:i:s')
							];
						
						}						
						//$this->AdminModel->InsertImportData('activitystatus',$table_data_users_chlid);
						$this->AdminModel->InsertImportData('notifications',$table_notification_data);
					 } */

					$session->setFlashdata('success', 'Successfully Added Polls');
					return redirect()->route('Polls');
				}
			
		 	}
		 }
	}
//poll reslut
	public Function pollreslut($id=null){ 	  
		$data=[
			'page_title'=>'Poll Response',
			'page_name'=>'Poll Response',
			'title_active'=>'Polls'
		 ];
		$where_data=[
				 "Status"=>"Approved"
			 ];
		$table="users";
		$data['Approved']=$this->AdminModel->tableRowsCount($table,$where_data);

		$table="poll_responses";		
		$where_data=["pr_p_id"=>$id];
		$data['completed']=$this->AdminModel->tableRowsCount($table,$where_data);


		$table="notifications";		
		$where_data=["FromId"=>$id,"NotificationType"=>"Polls"];
		$data['assignedUsers']=$this->AdminModel->tableRowsCount($table,$where_data);

		//$data['completed']=$this->AdminModel->tableRowsCountpoll($table);

	
		$data['getLatestRecord']=$this->AdminModel->getLatestRecord('poll','p_id');
		$poll_id=$data['getLatestRecord']['p_id'];
		$data["poll_response"]=$this->AdminModel->getLatestSubmittedResponse($id);
		$poll_response=$this->AdminModel->getLatestSubmittedResponse($id);


		//$data['viewed']=$data['Approved']-$data['completed'];
		$data['viewed']=$data['assignedUsers']-$data['completed'];
			
			 

		$data['compaign_status']=true;
		$data['polldetails']=$this->AdminModel->pollresponse($id);
		return view('poll_response',$data); 
	}
	// table records publish and un publish
	public function RecordPublishUnPublish(){
		$resultData='';
		$id=$this->request->getVar('id');
		$action=$this->request->getVar('action');
		$table=$this->request->getVar('table');
		$where_id=$this->request->getVar('where_id');
		if($action == "Publish"){
			$table_data=["IsActive"=>1];
		}else{
			$table_data=["IsActive"=>0];
		}
		$where_parameter=$where_id;
		$where_id=$id;
		$updateResult=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);
		if($updateResult){			
			$resultData="Successfully ".$action.'ed';
			$resultData=["message"=>$resultData,"respone"=>1];
		}else{
			$resultData="Unable to ". $action.'ed';
			$resultData=["message"=>$resultData,"respone"=>0];
		}
		echo json_encode($resultData);
	}

	//Reject Approved 
	public function RecordApprovedReject(){ 
		$session = session();
		$resultData='';
		$id=$this->request->getVar('id');
		$action=$this->request->getVar('action');
		$table=$this->request->getVar('table');
		$where_id=$this->request->getVar('where_id');
		if($action == "Approved"){
			$table_data=["IsActive"=>1];
		}elseif($action == "Reject"){
			$table_data=["IsActive"=>-1];
		}else{
			$table_data=["IsActive"=>0];
		}
		$where_parameter=$where_id; 
		$where_id=$id;
		$updateResult=$this->AdminModel->updateQuery($table,$table_data,$where_parameter,$where_id);
		if($updateResult){			
			$resultData="Successfully ".$action;
			$resultData=["message"=>$resultData,"respone"=>1];

			$where_parameter='npo_id';
			$where_id=$id;
			$npo_details=$this->AdminModel->getRowTableById('npo_details',$where_parameter,$where_id);
			if($npo_details['type_of_data']=='Article'){
				$table_data=[
					"FeedType"=>"Image",
					"Title"=>$npo_details['title'],
					"Description"=>$npo_details['description'],
					"feed_thumb_file"=>$npo_details['npo_thumb_file'],
					"FeedFileName"=>$npo_details['npo_file_name'],
					"from_npo"=>1,
					'CreatedDate'=>date('Y-m-d H:i:s'),
					'CreatedBy'=>$session->get('u_id'),
					
				];
				$NewsFeedId=$this->AdminModel->insert_record('newsfeed',$table_data); 
				if($NewsFeedId){

					$thumb_file=$this->s3Url().'fd/'.$npo_details['npo_thumb_file'];

					$org_file= base_url()."/feed-details-view/". $NewsFeedId; 
					
					$html_file=uniqid(time()).'.html';
					//$html_file=$file_nam_uniq.'.html';
					$title=$npo_details['title'];
					$myfile = fopen($html_file, "w") or die("Unable to open file!");
					$txt = '<!DOCTYPE html>
					<html lang="en">
					<head>
						<!-- Primary Meta Tags -->
					<title>Mana Tdp</title>
					<meta name="title" content="'.$title.'">
					<meta name="description" content="">  
					<!-- Twitter -->
					<meta property="twitter:card" content="summary_large_image">
					<meta property="twitter:title" content="'.$title.'">
					<meta property="twitter:description" content="">
					<meta property="twitter:image" content="'.$thumb_file.'">								
					<meta http-equiv = "refresh" content = "0; url = '.$org_file.'" />

					<meta property="og:site_name" content="Mana Tdp">
					<meta property="og:title" content="'.$title.'" />
					<meta property="og:description" content="Via Mana TDP" /> 
					<meta property="og:image" itemprop="image" content="'.$thumb_file.'">
					<meta property="og:type" content="Mana Tdp" />
					<link href="'.$thumb_file.'" rel="image_src">
					</head>
					<body>
													
					</body>
					</html>';
					fwrite($myfile, $txt);

													
					$filePath_thumb = $html_file; 
					$thumb_url=$this->s3Url().'th/fd/'.$html_file;
					$destinationFilePath = 'uploads/thumbnails_html/fd/'.$html_file;
					/* Move File from images to copyImages folder */
					if( !rename($filePath_thumb, $destinationFilePath) ) {  
						//echo "File can't be moved!";  
					}  
					else{  
						//echo "File has been moved!"; 
						$file_Path = base_url()."/uploads/thumbnails_html/fd/".$filePath_thumb;  
						$this->s3UploadThumb('fd',$file_Path);  
						//chmod($file_Path, 0644);
						//unlink($file_Path);    

						//update html url
						$where_parameter='NewsFeedId'; 
						$where_id=$NewsFeedId;
						$table_data=['thumb_url'=>$thumb_url];
						$updateResult=$this->AdminModel->updateQuery('newsfeed',$table_data,$where_parameter,$where_id);
					}
				}
			}	

		}else{
			$resultData="Unable to ". $action;
			$resultData=["message"=>$resultData,"respone"=>0];
		}
		echo json_encode($resultData);
	}

	//get Gallary Managmengt Ajax
	public function getGalleryManagemntAjax(){
		$resultData="TestData";
		$limit = '10';
		$page = 1;
		$page=$this->request->getVar('page');
		$query=$this->request->getVar('query');
		if($page > 1)
		{
			$start = (($page - 1) * $limit);
			$page = $page;
		}
		else
		{
			$start = 0;
		}
		$total_data=$this->AdminModel->tableAllRowsCount('gallery');
		

		//$result=$this->AdminModel->tableFilterGalleryRowsCount('gallery',$start,$limit);
		if($query != ''){
			$result=$this->AdminModel->tableSerchFilterGalleryRowsCount('gallery',$start,$limit,$query);
			$total_filter_data=count($result); 
		}else{ 
			$result=$this->AdminModel->tableFilterGalleryRowsCount('gallery',$start,$limit);
			$total_filter_data=count($this->AdminModel->tableFilterGalleryRowsCount('gallery',$start,$limit));
		} 

	$output = '
		<label>Total Records - '.$total_data.'</label> 
		<table class="table table-striped table-bordered">
		<tr>
			<th>S No</th>
			<th>Gallery Title</th>
			<th>Gallery Type</th>
			<th>Likes</th>
			<th>Shares</th>
			<th>Created Date</th>
			<th>Action</th>
		</tr>
		';
		if($total_data > 0)
		{	$i=1;
			$a="Gallery-edit";
			foreach($result as $row)
			{
				$output .= '<tr>
				<td>'.$i .'</td>
				<td class="no-wrap" title='.$row["GalleryTitle"].'>'.$row['GalleryTitle'].'</td>				
				<td>'.$row["GalaryType"].'</td>
				<td>'.$row["GalleryLikesCount"].'</td>
				<td>'.$row["ShareCount"].'</td>
				<td>'.date('d-m-Y',strtotime($row['CreatedDate'])).'</td>
				<td class="d-flex justify-content-center">
				<a class="mx-1 my-1 fa fa-edit fa-lg" href='.base_url().'/Gallery-edit/'.$row["GalleryId"].'></a>
				<a class="mx-1 my-1 fa fa-eye fa-lg" href='.base_url().'/Gallery-edit/'.$row["GalleryId"].'></a>
				</td></tr>';
			$i++; }
		}
		else
		{
			$output .= '
			<tr>
				<td colspan="2" align="center">No Data Found</td>
			</tr>
			';
		}

		$output .= '
		</table>
		<br />
		<div align="center">
		<ul class="pagination">
		';

			$total_links = ceil($total_data/$limit);
			$previous_link = '';
			$next_link = '';
			$page_link = '';

			//echo $total_links;

			if($total_links > 9)
			{
			if($page < 10)
			{
				for($count = 1; $count <= 10; $count++)
				{
				$page_array[] = $count;
				}
				$page_array[] = '...';
				$page_array[] = $total_links;
			}
			else
			{
				$end_limit = $total_links - 10;
				if($page > $end_limit)
				{
				$page_array[] = 1;
				$page_array[] = '...';
				for($count = $end_limit; $count <= $total_links; $count++)
				{
					$page_array[] = $count;
				}
				}
				else
				{
				$page_array[] = 1;
				$page_array[] = '...';
				for($count = $page - 1; $count <= $page + 1; $count++)
				{
					$page_array[] = $count;
				}
				$page_array[] = '...';
				$page_array[] = $total_links;
				}
			}
			}
			else
			{
			for($count = 1; $count <= $total_links; $count++)
			{
				$page_array[] = $count;
			}
			}

			for($count = 0; $count < count($page_array); $count++)
			{
			if($page == $page_array[$count])
			{
				$page_link .= '
				<li class="page-item active">
				<a class="page-link" href="#">'.$page_array[$count].' <span class="sr-only">(current)</span></a>
				</li>
				';

				$previous_id = $page_array[$count] - 1;
				if($previous_id > 0)
				{
				$previous_link = '<li class="page-item"><a class="page-link" href="javascript:void(0)" data-page_number="'.$previous_id.'">Previous</a></li>';
				}
				else
				{
				$previous_link = '
				<li class="page-item disabled">
					<a class="page-link" href="#">Previous</a>
				</li>
				';
				}
				$next_id = $page_array[$count] + 1;
				if($next_id >= $total_links)
				{
				$next_link = '
				<li class="page-item disabled">
					<a class="page-link" href="#">Next</a>
				</li>
					';
				}
				else
				{
				$next_link = '<li class="page-item"><a class="page-link" href="javascript:void(0)" data-page_number="'.$next_id.'">Next</a></li>';
				}
			}
			else
			{
				if($page_array[$count] == '...')
				{
				$page_link .= '
				<li class="page-item disabled">
					<a class="page-link" href="#">...</a>
				</li>
				';
				}
				else
				{
				$page_link .= '
				<li class="page-item"><a class="page-link" href="javascript:void(0)" data-page_number="'.$page_array[$count].'">'.$page_array[$count].'</a></li>
				';
				}
			}
			}

			$output .= $previous_link . $page_link . $next_link;
			$output .= '
			</ul>

			</div>
			';
			echo $output;
	}
	public function getUserManagemntAjax(){   
		$resultData="TestData";
		$limit = '10';
		$page = 1;
		$page=$this->request->getVar('page');
		$query=$this->request->getVar('query');
		if($page > 1)
		{
			$start = (($page - 1) * $limit);
			$page = $page;
		}
		else
		{
			$start = 0;
		}
	
		
		
		//$result=$this->AdminModel->tableFilterGalleryRowsCount('gallery',$start,$limit);
		if($query != ''){ 
			$result=$this->AdminModel->tableSerchFilterUsersRowsCount('users',$start,$limit,$query);
			$resultCount=$this->AdminModel->tableSerchFilterUsersRowsCountOnlyCount('users',$query);
			$total_filter_data=count($result); 
			 $total_data=$resultCount['filterCount'];
			//exit();
		}else{ 
			$result=$this->AdminModel->tableFilterUsersRowsCount('users',$start,$limit);
			$total_filter_data=count($this->AdminModel->tableFilterUsersRowsCount('users',$start,$limit));
			$total_data=$this->AdminModel->tableAllRowsCount('users');
			
		}
		$c_t= '<input type="hidden" name="c_t" id="c_t" value='.csrf_hash().'>';
	$output = '
		<div>
		<label>Total Records - '.$total_data.'</label>
		</div>

		<table class="table table-striped table-bordered mt-3">
		<tr>
			<th>S No</th>
			<th>First Name</th>
			<th>Last Name</th>
			<th>Mobile</th>
			<th>Membership Id</th>
			<th>Signup Date</th>
			<th>Mobile Verified</th>
			<th>Status</th>
			<th>Action</th>
		</tr>
		';
		if($total_data > 0)
		{	
			$page_num=$this->request->getVar('page');
			if($page_num > 1){ 
				$i=$page_num;
				$i=$page_num*10;
				$i=$i-9;
			}else{
				$i=1;
			}
			//$i=1;
			$a="Gallery-edit";
			foreach($result as $row)
			{
		
				if($row['MobileVerified'] == "1"){ 
					$MobileVerified='YES';
				}else{
					$MobileVerified='NO';
				}
                            
				if($query != ''){ 
					$output .= '<tr>
					<td>'.$i .'</td>
					<td class="no-wrap" title='.$row["FirstName"].'>'.$row['FirstName'].'</td>				
					<td>'.$row["LastName"].'</td>
					<td>'.$row["Mobile"].'</td>
					<td>'.$row["MembershipId"].'</td>
					<td>'.date('d-m-Y',strtotime($row['CreatedDate'])).'</td>				
					<td>'.$MobileVerified.'</td>
					<td>'.$row["Status"].'</td>
					<td class="d-flex justify-content-center">
					<a class="mx-1 my-1 fa fa-edit fa-lg" href='.base_url().'/app-user-edit/'.$row["u_id"].'/'.$page_num.'/'.$query.'></a>
					</td></tr>';
				}else{
					$output .= '<tr>
					<td>'.$i .'</td>
					<td class="no-wrap" title='.$row["FirstName"].'>'.$row['FirstName'].'</td>				
					<td>'.$row["LastName"].'</td>
					<td>'.$row["Mobile"].'</td>
					<td>'.$row["MembershipId"].'</td>
					<td>'.date('d-m-Y',strtotime($row['CreatedDate'])).'</td>				
					<td>'.$MobileVerified.'</td>
					<td>'.$row["Status"].'</td>
					<td class="d-flex justify-content-center">
					<a class="mx-1 my-1 fa fa-edit fa-lg" href='.base_url().'/app-user-edit/'.$row["u_id"].'/'.$page_num.'></a>
					</td></tr>';
				}
			
			$i++; }
		}
		else
		{
			$output .= '
			<tr>
				<td colspan="2" align="center">No Data Found</td>
			</tr>
			';
		}

		$output .= '
		</table>
		<br />
		<div align="center" style ="float:right;">
		<ul class="pagination">
		';

			$total_links = ceil($total_data/$limit);
			$previous_link = '';
			$next_link = '';
			$page_link = '';

			//echo $total_links;
		$page_array=array();
			if($total_links > 9)
			{
			if($page < 10)
			{
				for($count = 1; $count <= 10; $count++)
				{
				$page_array[] = $count;
				}
				$page_array[] = '...';
				$page_array[] = $total_links;
			}
			else
			{
				$end_limit = $total_links - 10;
				if($page > $end_limit)
				{
				$page_array[] = 1;
				$page_array[] = '...';
				for($count = $end_limit; $count <= $total_links; $count++)
				{
					$page_array[] = $count;
				}
				}
				else
				{
				$page_array[] = 1;
				$page_array[] = '...';
				for($count = $page - 1; $count <= $page + 1; $count++)
				{
					$page_array[] = $count;
				}
				$page_array[] = '...';
				$page_array[] = $total_links;
				}
			}
			}
			else
			{
			for($count = 1; $count <= $total_links; $count++)
			{
				$page_array[] = $count;
			}
			}

			for($count = 0; $count < count($page_array); $count++)
			{
			if($page == $page_array[$count])
			{
				
				$page_link .= '
				<li class="page-item active">
				<a class="page-link" href="#">'.$page_array[$count].' <span class="sr-only">(current)</span></a>
				</li>
				';

				$previous_id = $page_array[$count] - 1;
				if($previous_id > 0)
				{
					$previous_link = '<li class="page-item"><a class="page-link" href="javascript:void(0)" data-page_number="'.$previous_id.'">Previous</a></li>';
				}
				else
				{
					$previous_link = '
					<li class="page-item disabled">
						<a class="page-link" href="#">Previous</a>
					</li>
					';
				}
					$next_id = $page_array[$count] + 1;
				if($next_id >= $total_links)
				{
					$next_link = '
					<li class="page-item disabled">
						<a class="page-link" href="#">Next</a>
					</li>
						';
				}
				else
				{
					$next_link = '<li class="page-item"><a class="page-link" href="javascript:void(0)" data-page_number="'.$next_id.'">Next</a></li>';
				}
			}
			else
			{
				if($page_array[$count] == '...')
				{
					$page_link .= '
					<li class="page-item disabled">
						<a class="page-link" href="">...</a>
					</li>
					';
				}
				else
				{
					$page_link .= '
					<li class="page-item"><a class="page-link" href="javascript:void(0)" data-page_number="'.$page_array[$count].'">'.$page_array[$count].'</a></li>
					';
				}
			}
		}	
			//$s=$page_array[$count];

			$output .= $previous_link . $page_link . $next_link.$c_t;
			$output .= '
			</ul>

			</div>
			';
			echo $output;
	}


	//Committee management
	public Function Committee(){ 
		$data=[
			'page_title'=>'Committee',
			'page_name'=>'Committee',
			'title_active'=>'Committee'
			];
		$parameters=array('*');
		$order_by='committeeNameId';  
		$data['committeetails']=$this->AdminModel->getQueryFromTableAdmins('committeeName',$parameters,$order_by); 
		return view('committee_management',$data);
	} 
	public function addCommittee(){
		$session = session();
		$data=[
			'page_title'=>'Add Committee',
			'page_name'=>'Add Committee',
			'title_active'=>'Committee'
		]; 
		 if($this->request->getMethod() == 'post'){
			$rules=[
				'committeeName'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Committe is a required'
					]
				],
				'designatedMember'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'designated Member is a required'
					]
				]
			];
			
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_committee',$data);
            }else{

				$table_data=[
					'committeeName'=>$this->request->getVar('committeeName',FILTER_SANITIZE_STRING),
					'committeeDescription'=>$this->request->getVar('committeeDescription',FILTER_SANITIZE_STRING),
					'designatedMember'=>$this->request->getVar('designatedMember',FILTER_SANITIZE_STRING),
					'CreatedBy'=>$session->get('u_id'),
					'CreatedDate'=>date('Y-m-d H:i:s')

				];
				$NewsFeedId=$this->AdminModel->insert_record('committeeName',$table_data);
				
				if($NewsFeedId === false){						
					$data=[
						'page_title'=>'Committee',
						'page_name'=>'Committee',
						'title_active'=>'Committee'
					]; 
					$session->setFlashdata('error', 'Unable to Committee Name');
					return redirect()->route('Committee');
				}else{
					$session->setFlashdata('success', 'Successfully Added Committee Name');
					return redirect()->route('Committee');
				}
			}
		}
		return view('add_committee',$data);

	
	}
	//Edit Polls
	public function committeeEdit($id=null){
		
		$session = session();
		$data=[
			'page_title'=>'Committee Edit',
			'page_name'=>'Committee Edit',
			'title_active'=>'Committee'
		 ];
		
		$table="committeeName";
		$where_id=$id;
		$where_parameter="committeeNameId"; 
		$data['committeedetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		
		if(isset($data['committeedetails'])){
			return view('add_committee',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Committee'); 
		}
	}

	//Edit Polls
	public function committeeView($id=null){
		
		$session = session();
		$data=[
			'page_title'=>'Committee View',
			'page_name'=>'Committee View',
			'title_active'=>'Committee'
		 ];
		$data['view']=false;
		$table="committeeName";
		$where_id=$id;
		$where_parameter="committeeNameId"; 
		$data['committeedetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id);
		
		if(isset($data['committeedetails'])){
			return view('add_committee',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Committee'); 
		}
	}

	public function updateCommittee(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Committee Edit',
			'page_name'=>'Committee Edit',
			'title_active'=>'Committee'
		 ];
		
		if($this->request->getMethod() == 'post'){
			$rules=[
				'committeeName'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Committe is a required'
					]
				],
				'designatedMember'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'designated Member is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_committee',$data);
            }else{

				// end test here
				$table_data=[
					'committeeName'=>$this->request->getVar('committeeName',FILTER_SANITIZE_STRING),
					'committeeDescription'=>$this->request->getVar('committeeDescription',FILTER_SANITIZE_STRING),
					'designatedMember'=>$this->request->getVar('designatedMember',FILTER_SANITIZE_STRING),
					'LastUpdatedBy'=>$session->get('u_id'),
					'LastUpdatedDate'=>date('Y-m-d H:i:s')
				];
				$where_parameter="committeeNameId";
				$where_id=$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING);				
				$committeeNameId=$this->AdminModel->updateQuery('committeeName',$table_data,$where_parameter,$where_id); 
				
				if($committeeNameId === false){						
					$data=[
						'page_title'=>'Committee Edit',
						'page_name'=>'Committee Edit',
						'title_active'=>'Committee'
					]; 
					$session->setFlashdata('error', 'Unable to Update Committee');
					return redirect()->route('Committee');
				}else{
					$session->setFlashdata('success', 'Successfully Added Committee');
					return redirect()->route('Committee');
				}
		 	}
		 }
	}

	//Committee management
	public Function committeeType(){ 
		$data=[
			'page_title'=>'Committee Type',
			'page_name'=>'Committee Type',
			'title_active'=>'CommitteeType'
			];
		$parameters=array('*');
		$order_by='committeeTypeId';  
		$data['committeetypedetails']=$this->AdminModel->getCommitteTypeGrid();  
		return view('committee_type_management',$data);
	} 

	public function addCommitteeType(){ 
		$session = session();
		$data=[
			'page_title'=>'Add Committee Type',
			'page_name'=>'Add Committee Type',
			'title_active'=>'CommitteeType'
		]; 
		
		$where=["IsActive"=>1,"designatedMember"=>"Yes"];
		$data["committeeNameDetails"]=$this->AdminModel->getQueryReultFromTable('committeeName',$where);  
		if($this->request->getMethod() == 'post'){
			$rules=[ 
				'committeeNameId'=>[ 
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Committe Id is a required'
					]
				],
				'committeeTypeName'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Committee Type Name is a required'
					]
				]
			];

			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_committee_type',$data);
            }else{

				$table_data=[
					'committeeNameId'=>$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING),
					'committeeTypeName'=>$this->request->getVar('committeeTypeName',FILTER_SANITIZE_STRING),
					'committeeTypeDesc'=>$this->request->getVar('committeeTypeDesc',FILTER_SANITIZE_STRING),
					'CreatedBy'=>$session->get('u_id'),
					'CreatedDate'=>date('Y-m-d H:i:s')

				];
				$NewsFeedId=$this->AdminModel->insert_record('committeeType',$table_data);				
				if($NewsFeedId === false){						
					$data=[
						'page_title'=>'Add Committee Type',
						'page_name'=>'Add Committee Type',
						'title_active'=>'CommitteeType'
					]; 
					$session->setFlashdata('error', 'Unable to Committee Type');
					return redirect()->route('Add-Committee-Type');
				}else{
					$session->setFlashdata('success', 'Successfully Added Committee Type');
					return redirect()->route('Committee-Type');
				}
			} 
		}
		//print_r($data['committeeNameDetails']);
		return view('add_committee_type',$data); 
	}
	//Edit Committee Type
	public function committeeTypeEdit($id=null){ 
	
		$session = session();
		$data=[
			'page_title'=>'Committee Edit',
			'page_name'=>'Committee Edit',
			'title_active'=>'CommitteeType'
			];
		

		$where=["IsActive"=>1,"designatedMember"=>"Yes"];
		$data["committeeNameDetails"]=$this->AdminModel->getQueryReultFromTable('committeeName',$where);  

		$table="committeeType";
		$where_id=$id;
		$where_parameter="committeeTypeId"; 
		$data['committeeTypeDetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id); 
		
		if(isset($data['committeeTypeDetails'])){
			return view('add_committee_type',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Committee-Type'); 
		}
	}

	public function updateCommitteeType(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Committee Edit',
			'page_name'=>'Committee Edit',
			'title_active'=>'CommitteeType'
		 ];
		
		if($this->request->getMethod() == 'post'){
			$rules=[
				'committeeNameId'=>[ 
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Committe Id is a required'
					]
				],
				'committeeTypeName'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Committee Type Name is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_committee',$data);
            }else{
				// end test here
				$table_data=[
					'committeeNameId'=>$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING),
					'committeeTypeName'=>$this->request->getVar('committeeTypeName',FILTER_SANITIZE_STRING),
					'committeeTypeDesc'=>$this->request->getVar('committeeTypeDesc',FILTER_SANITIZE_STRING),
					'LastUpdatedBy'=>$session->get('u_id'),
					'LastUpdatedDate'=>date('Y-m-d H:i:s')
				];
				$where_parameter="committeeTypeId";
				$where_id=$this->request->getVar('committeeTypeId',FILTER_SANITIZE_STRING);				
				$committeeTypeId=$this->AdminModel->updateQuery('committeeType',$table_data,$where_parameter,$where_id); 
				if($committeeTypeId === false){						
					$data=[
						'page_title'=>'Committee Edit',
						'page_name'=>'Committee Edit',
						'title_active'=>'CommitteeType'
					]; 
					$session->setFlashdata('error', 'Unable to Update Committee');
					return redirect()->route('add_committee_type');
				}else{
					$session->setFlashdata('success', 'Successfully Added Committee');
					return redirect()->route('Committee-Type');
				}
		 	}
		}
	}

	//Edit Committee Type
	public function committeeTypeView($id=null){ 

		$session = session();
		$data=[
			'page_title'=>'Committee View',
			'page_name'=>'Committee View',
			'title_active'=>'CommitteeType'
			];
		

		$where=["IsActive"=>1,"designatedMember"=>"Yes"];
		$data["committeeNameDetails"]=$this->AdminModel->getQueryReultFromTable('committeeName',$where);  

		$table="committeeType";
		$where_id=$id;
		$where_parameter="committeeTypeId"; 
		$data['committeeTypeDetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id); 
		$data['view']=false;
		if(isset($data['committeeTypeDetails'])){
			return view('add_committee_type',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Committee-Type'); 
		}
	}

	//Affilliated
	public Function affiliatedCommittees(){ 
		$data=[
			'page_title'=>'Affiliated Committees',
			'page_name'=>'Affiliated Committees',
			'title_active'=>'AffiliatedCommittees'
			];
		$parameters=array('*');
		$order_by='committeeTypeId';  
		//$data['committeetypedetails']=$this->AdminModel->getCommitteTypeGrid();  
		$data['affiliatedCommitteesDetails']=$this->AdminModel->getAffiliatedCommittesGrid(); 
		return view('affiliated_management',$data);  
	}
	
	public function addAffiliatedCommittee(){
		$session = session();
		$data=[
			'page_title'=>'Add Affiliated Committee',
			'page_name'=>'Add Affiliated Committee',
			'title_active'=>'AffiliatedCommittees'
		]; 
		
		$where=["IsActive"=>1,"designatedMember"=>"Yes"];
		$data["committeeNameTypeDetails"]=$this->AdminModel->getCommitteDetailsByAffiliated();  
		if($this->request->getMethod() == 'post'){
			$rules=[ 
				'committeeTypeId'=>[ 
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'committee Type Id is a required'
					]
				],
				'affiliatedCommitteeName'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Affiliated Committee Name is a required'
					]
				]
			];

			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_affiliated_committee',$data);
            }else{

				$table_data=[
					'committeeTypeId'=>$this->request->getVar('committeeTypeId',FILTER_SANITIZE_STRING),
					'affiliatedCommitteeName'=>$this->request->getVar('affiliatedCommitteeName',FILTER_SANITIZE_STRING),
					'affiliatedCommitteeDesc'=>$this->request->getVar('affiliatedCommitteeDesc',FILTER_SANITIZE_STRING),
					'CreatedBy'=>$session->get('u_id'),
					'CreatedDate'=>date('Y-m-d H:i:s') 

				];
				$affiliatedCommitteeId=$this->AdminModel->insert_record('affiliatedCommittees',$table_data);				
				if($affiliatedCommitteeId === false){						
					$data=[
						'page_title'=>'Add Affiliated Committee',
						'page_name'=>'Add Affiliated Committee',
						'title_active'=>'AffiliatedCommittees'
					]; 
					$session->setFlashdata('error', 'Unable to Committee Type');
					return redirect()->route('Add-Affiliated-Committee');
				}else{
					$session->setFlashdata('success', 'Successfully Added Committee Type');
					return redirect()->route('Affiliated-Committees'); 
				}
			} 
		} 
		//print_r($data['committeeNameDetails']);
		return view('add_affiliated_committee',$data); 
	}

	public function affiliatedCommitteeEdit($id=null){
		$data=[
			'page_title'=>'Affiliated Committee Edit',
			'page_name'=>'Affiliated Committee Edit',
			'title_active'=>'AffiliatedCommittees'
			];
		$where=["IsActive"=>1,"designatedMember"=>"Yes"];
		$data["committeeNameTypeDetails"]=$this->AdminModel->getCommitteDetailsByAffiliated();  

		$table="affiliatedCommittees";
		$where_id=$id;
		$where_parameter="affiliatedCommitteeId"; 
		$data['affiliatedDetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id); 
		if(isset($data['affiliatedDetails'])){
			return view('add_affiliated_committee',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('affiliated-Committees'); 
		}
	}
	// Update Affiliated
	public function updateAffiliatedCommittee(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Affiliated Committee Edit',
			'page_name'=>'Affiliated Committee Edit',
			'title_active'=>'AffiliatedCommittees'
		 ];		
		if($this->request->getMethod() == 'post'){
			$rules=[
				'committeeTypeId'=>[ 
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'committee Type Id is a required'
					]
				],
				'affiliatedCommitteeName'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Affiliated Committee Name is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_committee',$data);
            }else{
				// end test here
				$table_data=[
					'committeeTypeId'=>$this->request->getVar('committeeTypeId',FILTER_SANITIZE_STRING),
					'affiliatedCommitteeName'=>$this->request->getVar('affiliatedCommitteeName',FILTER_SANITIZE_STRING),
					'affiliatedCommitteeDesc'=>$this->request->getVar('affiliatedCommitteeDesc',FILTER_SANITIZE_STRING),
					'LastUpdatedBy'=>$session->get('u_id'),
					'LastUpdatedDate'=>date('Y-m-d H:i:s')
				];
				$where_parameter="affiliatedCommitteeId";
				$where_id=$this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING);				
				$affiliatedCommitteeId=$this->AdminModel->updateQuery('affiliatedCommittees',$table_data,$where_parameter,$where_id); 
				if($affiliatedCommitteeId === false){	 					
					$data=[
						'page_title'=>'Affiliated Committee Edit',
						'page_name'=>'Affiliated Committee Edit',
						'title_active'=>'AffiliatedCommittees'
					]; 
					$session->setFlashdata('error', 'Unable to Update Affiliated Committee');
					return redirect()->route('Affiliated-Committees');
				}else{
					$session->setFlashdata('success', 'Successfully Added Affiliated Committee');
					return redirect()->route('Affiliated-Committees');
				}
		 	}
		}
	}

	//View Affiliated '
	public function affiliatedCommitteeView($id=null){
		$data=[
			'page_title'=>'Affiliated Committee Edit',
			'page_name'=>'Affiliated Committee Edit',
			'title_active'=>'AffiliatedCommittees'
			];
		$where=["IsActive"=>1,"designatedMember"=>"Yes"];
		$data["committeeNameTypeDetails"]=$this->AdminModel->getCommitteDetailsByAffiliated();  
		$data['view']=false;
		$table="affiliatedCommittees";
		$where_id=$id;
		$where_parameter="affiliatedCommitteeId"; 
		$data['affiliatedDetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id); 
		if(isset($data['affiliatedDetails'])){
			return view('add_affiliated_committee',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('affiliated-Committees'); 
		}
	}

	
	//Desgniations
	public Function Designation(){ 
		$data=[
			'page_title'=>'Desgniations',
			'page_name'=>'Desgniations',
			'title_active'=>'Designation'
			];
	//	$data['affiliatedCommitteesDetails']=$this->AdminModel->getAffiliatedCommittesGrid(); 
		$data['designationDetails']=$this->AdminModel->getDesignationDeatislGrid(); 
		return view('designation_management',$data);  
	}

	//Desgniation Add
	public function addDesignation(){ 
		$session = session();
		$data=[
			'page_title'=>'Add Designation',
			'page_name'=>'Add Designation',
			'title_active'=>'Designation'
		]; 
		$where=["IsActive"=>1,"designatedMember"=>"Yes"];
		$data["committeeNameDetails"]=$this->AdminModel->getQueryReultFromTable('committeeName',$where); 
		if($this->request->getMethod() == 'post'){
			$rules=[ 
				'committeeNameId'=>[ 
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'committee Name is a required'
					]
				],
				'designationName'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'designation Name is a required'
					]
				]
			];

			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_designation',$data);
            }else{

				$table_data=[
					'designationName'=>$this->request->getVar('designationName',FILTER_SANITIZE_STRING),
					'committeeNameId'=>$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING),
					'designationDesc'=>$this->request->getVar('designationDesc',FILTER_SANITIZE_STRING),
					'CreatedBy'=>$session->get('u_id'),
					'CreatedDate'=>date('Y-m-d H:i:s') 

				];
				$designationId=$this->AdminModel->insert_record('designation',$table_data);				
				if($designationId === false){	  					
					$data=[
						'page_title'=>'Add Designation',
						'page_name'=>'Add Designation',
						'title_active'=>'Designation'
					]; 
					$session->setFlashdata('error', 'Unable to Designation');
					return redirect()->route('Add-Designation');
				}else{
					$session->setFlashdata('success', 'Successfully Added Designation');
					return redirect()->route('Designations'); 
				}
			} 
		}  
		//print_r($data['committeeNameDetails']);
		return view('add_designation',$data); 
	}
	
	//Edit Desingation
	public function designationEdit($id=null){ 	
		$session = session();
		$data=[
			'page_title'=>'Designation Edit',
			'page_name'=>'Designation Edit',
			'title_active'=>'Designation'
			];
		$where=["IsActive"=>1,"designatedMember"=>"Yes"];
		$data["committeeNameDetails"]=$this->AdminModel->getQueryReultFromTable('committeeName',$where);  

		$table="designation";
		$where_id=$id;
		$where_parameter="designationId"; 
		$data['designationDetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id); 
		
		if(isset($data['designationDetails'])){ 
			return view('add_designation',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Designations'); 
		}
	}

	//View Desgniation
	public function designationView($id=null){ 	
		$session = session();
		$data=[
			'page_title'=>'Designation View',
			'page_name'=>'Designation View',
			'title_active'=>'Designation'
			];
		$where=["IsActive"=>1,"designatedMember"=>"Yes"];
		$data["committeeNameDetails"]=$this->AdminModel->getQueryReultFromTable('committeeName',$where);  
		$data["view"]=false;
		$table="designation";
		$where_id=$id;
		$where_parameter="designationId"; 
		$data['designationDetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id); 
		
		if(isset($data['designationDetails'])){ 
			return view('add_designation',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('Designations'); 
		}
	}

	//Update Committe
	public function updateDesignation(){  
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Designation Edit',
			'page_name'=>'Designation Edit',
			'title_active'=>'Designation'
		 ];
		
		if($this->request->getMethod() == 'post'){
			$rules=[
				'committeeNameId'=>[ 
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'committee Name is a required'
					]
				],
				'designationName'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'designation Name is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_committee',$data);
            }else{
				// end test here
				$table_data=[
					'designationName'=>$this->request->getVar('designationName',FILTER_SANITIZE_STRING),
					'committeeNameId'=>$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING),
					'designationDesc'=>$this->request->getVar('designationDesc',FILTER_SANITIZE_STRING),
					'LastUpdatedBy'=>$session->get('u_id'),
					'LastUpdatedDate'=>date('Y-m-d H:i:s')
				];
				$where_parameter="designationId";
				$where_id=$this->request->getVar('designationId',FILTER_SANITIZE_STRING);				
				$designationId=$this->AdminModel->updateQuery('designation',$table_data,$where_parameter,$where_id); 
				if($designationId === false){						
					$data=[
						'page_title'=>'Designation Edit',
						'page_name'=>'Designation Edit',
						'title_active'=>'Designation'
					]; 
					$session->setFlashdata('error', 'Unable to Update Designation');
					return redirect()->route('Designations');
				}else{
					$session->setFlashdata('success', 'Successfully Update Designation');
					return redirect()->route('Designations');
				}
		 	}
		}
	}

	public function updateAffDesignations(){
		$session = \CodeIgniter\Config\Services::session();
		$data=[
			'page_title'=>'Designation Edit',
			'page_name'=>'Designation Edit',
			'title_active'=>'Designation'
		 ];
		
		if($this->request->getMethod() == 'post'){
			$rules=[
				'committeeNameId'=>[ 
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'committee Name is a required'
					]
				],
				'designationName'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'designation Name is a required'
					]
				],
				'affiliatedCommitteeId'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Affiliated Committee is a required'
					]
				]
			];
			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_aff_designation',$data);
            }else{
				// end test here
					$table_data=[
						'committeeNameId'=>$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING),
						'affiliatedCommitteeId'=>$this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING),
						'designationName'=>$this->request->getVar('designationName',FILTER_SANITIZE_STRING),
						'designationDesc'=>$this->request->getVar('designationDesc',FILTER_SANITIZE_STRING),
						'LastUpdatedBy'=>$session->get('u_id'),
						'LastUpdatedDate'=>date('Y-m-d H:i:s')					
					];
				$where_parameter="designationId";
				$where_id=$this->request->getVar('designationId',FILTER_SANITIZE_STRING);				
				$designationId=$this->AdminModel->updateQuery('designation',$table_data,$where_parameter,$where_id); 
				if($designationId === false){						
					$data=[
						'page_title'=>'Affiliate Designations',
						'page_name'=>'Affiliate Desgniations',
						'title_active'=>'AffDesignations'
					]; 
					$session->setFlashdata('error', 'Unable to Update Aff Designation');
					return redirect()->route('AffDesignations');
				}else{
					$session->setFlashdata('success', 'Successfully Update Aff Designation');
					return redirect()->route('AffDesignations');
				}
		 	}
		}
	}

	//Desgniations
	public Function AffDesignations(){ 
		$data=[
				'page_title'=>'Affiliate Designations',
				'page_name'=>'Affiliate Desgniations',
				'title_active'=>'AffDesignations' 
			];
		//$data['affiliatedCommitteesDetails']=$this->AdminModel->getAffiliatedCommittesGrid(); 
		$data['designationDetails']=$this->AdminModel->getAffliatedDesignationDetailsGrid(); 
		return view('aff_designation_management',$data);  
	}

	public function addAffDesignations(){
		$session = session();
		$data=[
			'page_title'=>'Add Affiliated Designation',
			'page_name'=>'Add Affiliated Designation',
			'title_active'=>'AffDesignations'
		]; 
		$where=["IsActive"=>1,"designatedMember"=>"Yes"]; 
		$data["committeeNameDetails"]=$this->AdminModel->getQueryReultFromTable('committeeName',$where); 
		
		if($this->request->getMethod() == 'post'){
			$rules=[ 
				'committeeNameId'=>[ 
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'committee Name is a required'
					]
				],
				'designationName'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'designation Name is a required'
					]
				],
				'affiliatedCommitteeId'=>[
					'rules'=>'required',
					'label'=>'Title',
					'errors'=>[
						'required'=>'Affiliated Committee is a required'
					]
				]
			];

			$validation=$this->validate($rules);
            if (!$validation) {
				$data["validation"]=$this->validator;
                return view('add_aff_designation',$data);
            }else{

				$table_data=[
					'committeeNameId'=>$this->request->getVar('committeeNameId',FILTER_SANITIZE_STRING),
					'affiliatedCommitteeId'=>$this->request->getVar('affiliatedCommitteeId',FILTER_SANITIZE_STRING),
					'designationName'=>$this->request->getVar('designationName',FILTER_SANITIZE_STRING),
					'designationDesc'=>$this->request->getVar('designationDesc',FILTER_SANITIZE_STRING),
					'CreatedBy'=>$session->get('u_id'),
					'CreatedDate'=>date('Y-m-d H:i:s')  

				];
				$designationId=$this->AdminModel->insert_record('designation',$table_data);				
				if($designationId === false){	  					
					$data=[
						'page_title'=>'Add Affiliated Designation',
						'page_name'=>'Add Affiliated Designation',
						'title_active'=>'AffDesignations' 
					]; 
					$session->setFlashdata('error', 'Unable to Designation');
					return redirect()->route('AffDesignations');
				}else{
					$session->setFlashdata('success', 'Successfully Added Designation');
					return redirect()->route('AffDesignations'); 
				}
			} 
		}  
		//print_r($data['committeeNameDetails']);
		return view('add_aff_designation',$data);  
	}

	//Edit Afflicated Desingation
	public function AffDesignationEdit($id=null){ 	  
		$session = session();
		$data=[
			'page_title'=>'Affiliate Designation Edit',
			'page_name'=>'Affiliate Designation Edit',
			'title_active'=>'AffDesignations'
			];
		$where=["IsActive"=>1,"designatedMember"=>"Yes"];
		$data["committeeNameDetails"]=$this->AdminModel->getQueryReultFromTable('committeeName',$where);  


		$where=["IsActive"=>1,"designatedMember"=>"Yes"];
		$AffcommitteeNameDetails=$this->AdminModel->getAffcommitteeNameDetails($id);  
	//	print_r($data["AffcommitteeNameDetails"]); 
		$commiteeId=$AffcommitteeNameDetails["committeeNameId"];
		 $committeeTypeId=$AffcommitteeNameDetails["committeeTypeId"];

		$where=["committeeTypeId"=>$committeeTypeId];  
		$data['AffcommitteeNameDetails']=$this->AdminModel->getQueryReultFromTable('affiliatedCommittees',$where); 
		//print_r($data['AffcommitteeNameDetails']);
		//exit();

		//Designations
		$table="designation";
		$where_id=$id;
		$where_parameter="designationId"; 
		$data['designationDetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id); 
		
		if(isset($data['designationDetails'])){ 
			return view('add_aff_designation',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('AffDesignations');  
		}
	}

	//Edit Afflicated Desingation
	public function AffDesignationView($id=null){ 	  
		$session = session();
		$data=[
			'page_title'=>'Affiliate Designation Edit',
			'page_name'=>'Affiliate Designation Edit',
			'title_active'=>'AffDesignations'
			];
		$where=["IsActive"=>1,"designatedMember"=>"Yes"];
		$data["committeeNameDetails"]=$this->AdminModel->getQueryReultFromTable('committeeName',$where);  

		$table="designation";
		$where_id=$id;
		$where_parameter="designationId"; 
		$data['designationDetails']=$this->AdminModel->getRowTableById($table,$where_parameter,$where_id); 
		$data["view"]=false;
		if(isset($data['designationDetails'])){ 
			return view('add_aff_designation',$data);
		}else{
			$session->setFlashdata('error', 'In valid Id');
			return redirect()->route('AffDesignations');  
		}
	}

	//Fcm Push Notification
	private function fcm_notification_old($device_id,$title,$message){  
		$API_SERVER_KEY = 'AAAAE2Dsd_A:APA91bGScngiKmnbo4BI7Fje6_uUT0zprY51Plqyj3oTZSMULqGn9Jvk5XG8U0g00buk2GBonCfk7tr1Dz60QEv8lcrgI7dD1UjBQqkxGvE4xxADz2HuMKMgXuXEAhwheO4AzdBwxXPN';
		$path_to_firebase_cm = 'https://fcm.googleapis.com/fcm/send';
		//$sound='buzzer.mp3'; 
		//$sound='bell.mp3'; 
		$sound='bell'; 
	
		//$sound = base_url()."/public/fcm_sound/office_bell.mp3"; 
		$fields = array(
			"registration_ids" =>$device_id,  
			"content_available"=> true,
			'notification' => array('title' => $title,'body' => $message,"sound"=>$sound,
			"click_action"=>"FCM_PLUGIN_ACTIVITY",
			"icon"=>"notification_icon.png") ,
			"priority" => "high",	 
			"android"=> array(
					"notification"=>array(
					"icon"=>"fcm_push_icon",
					"click_action"=> "FCM_PLUGIN_ACTIVITY",
					"sound"=>$sound
					)
				)
			); 
		$headers = array(
			'Authorization:key=' .$API_SERVER_KEY,	
			'Content-Type:application/json'
		);

		// Open connection
		$ch = curl_init();
		// Set the url, number of POST vars, POST data
		curl_setopt($ch, CURLOPT_URL, $path_to_firebase_cm);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4 );
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
		// Execute post
		$result = curl_exec($ch);
		if ($result === FALSE) {
			die('FCM Send Error: ' . curl_error($ch));
		}
		curl_close($ch);
	}
	//Fcm Push Notification
	private function fcm_notification($device_id,$title,$message){  
		$API_SERVER_KEY = 'AAAAE2Dsd_A:APA91bGScngiKmnbo4BI7Fje6_uUT0zprY51Plqyj3oTZSMULqGn9Jvk5XG8U0g00buk2GBonCfk7tr1Dz60QEv8lcrgI7dD1UjBQqkxGvE4xxADz2HuMKMgXuXEAhwheO4AzdBwxXPN';
		$path_to_firebase_cm = 'https://fcm.googleapis.com/fcm/send';
		//$sound='buzzer.mp3'; 
		//$sound='bell.mp3'; 
		$sound='bell.wav'; 
	
		//$sound = base_url()."/public/fcm_sound/office_bell.mp3"; 
		$fields = array(
			"registration_ids" =>$device_id,  
			"content_available"=> true,
			'notification' => array('title' => $title,'body' => $message,"sound"=>$sound,
			"click_action"=>"FCM_PLUGIN_ACTIVITY",
			"icon"=>"notification_icon.png","channelId"=>"my_channel_01") ,
			"priority" => "high",	 
			"android"=> array(
					"message"=>array(
					"icon"=>"fcm_push_icon",
					"click_action"=> "FCM_PLUGIN_ACTIVITY",
					"channelId"=> "my_channel_01",
					"sound"=>$sound
					)
				)
			); 
		$headers = array(
			'Authorization:key=' .$API_SERVER_KEY,	
			'Content-Type:application/json'
		);

		// Open connection
		$ch = curl_init();
		// Set the url, number of POST vars, POST data
		curl_setopt($ch, CURLOPT_URL, $path_to_firebase_cm);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4 );
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
		// Execute post
		$result = curl_exec($ch);
		if ($result === FALSE) {
			die('FCM Send Error: ' . curl_error($ch));
		}
		curl_close($ch);
	}
	public function testFcm(){ 
		

		$device_id='';
		$title='test';
		$message='Test123';
		$API_SERVER_KEY = 'AAAAE2Dsd_A:APA91bGScngiKmnbo4BI7Fje6_uUT0zprY51Plqyj3oTZSMULqGn9Jvk5XG8U0g00buk2GBonCfk7tr1Dz60QEv8lcrgI7dD1UjBQqkxGvE4xxADz2HuMKMgXuXEAhwheO4AzdBwxXPN';
		$path_to_firebase_cm = 'https://fcm.googleapis.com/fcm/send';
		//$sound='buzzer.mp3'; 
		//$sound='buzzer.mp3'; 
		$sound = base_url()."/public/fcm_sound/office_bell.mp3"; 
		$fields = array(
			"registration_ids" =>$device_id,  
			"content_available"=> true,
			'notification' => array('title' => $title,'body' => $message,"sound"=>$sound,
			"click_action"=>"FCM_PLUGIN_ACTIVITY",
			"icon"=>"notification_icon.png") ,
			"priority" => "high",	 
			"android"=> array(
					"notification"=>array(
					"icon"=>"fcm_push_icon",
					"click_action"=> "FCM_PLUGIN_ACTIVITY"
					)
				)
			); 
		$headers = array(
			'Authorization:key=' .$API_SERVER_KEY,	
			'Content-Type:application/json'
		);

		// Open connection
		$ch = curl_init();
		// Set the url, number of POST vars, POST data
		curl_setopt($ch, CURLOPT_URL, $path_to_firebase_cm);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4 );
		curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
		// Execute post
		$result = curl_exec($ch);
		if ($result === FALSE) {
			die('FCM Send Error: ' . curl_error($ch));
		}
		curl_close($ch);
	}

	public function PerfomanceSummary(){
		$data=[
			'page_title'=>'Perfomance Summary',
			'page_name'=>'Perfomance Summary',
			'title_active'=>'PerfomanceSummary',
		 ];
		 $data["topFiveFeedsResult"]=$this->AdminModel->getTopFiveFeeds();  
		 $data["topFiveSmTasks"]=$this->AdminModel->getTopFiveSmTasks(); 
		 $data["topFiveConstituency"]=$this->AdminModel->topFiveConstituency();
		 $data["topFiveParliaments"]=$this->AdminModel->topFiveParliaments();
		 $data["getTopTenActiveMembers"]=$this->AdminModel->getTopTenActiveMembers();

		 $data['getLatestRecord']=$this->AdminModel->getLatestRecord('poll','p_id');
		 $poll_id=$data['getLatestRecord']['p_id'];
		 $data["poll_response"]=$this->AdminModel->getLatestSubmittedResponse($poll_id);
		 $poll_response=$this->AdminModel->getLatestSubmittedResponse($poll_id);
		 
		
		 return view('perfomance_summry',$data); 
	}
	public function AppHealthReport(){
		$data=[
			'page_title'=>'App Health Report',
			'page_name'=>'App Health Report',
			'title_active'=>'AppHealthReport', 
		 ];

		
		$parameters=array('ParliamentID','ParliamentName');
		$order_by='ParliamentID';
		$data['parliament_list']=$this->AdminModel->getQueryFromTable('parliament',$parameters,$order_by);  

		 if($this->request->getMethod() == 'post'){ 
			
			$post_status=true;
			$ParliamentId=$this->request->getVar('ParliamentId',FILTER_SANITIZE_STRING);
			$Constituency=$this->request->getVar('ConstituencyId',FILTER_SANITIZE_STRING);
			$days=$this->request->getVar('days',FILTER_SANITIZE_STRING);

			$data['parliament']=$this->request->getVar('ParliamentId',FILTER_SANITIZE_STRING);
			$data['constituency']=$this->request->getVar('ParliamentId',FILTER_SANITIZE_STRING);
			$data['days']=$this->request->getVar('days',FILTER_SANITIZE_STRING);

			if($ParliamentId == "All"){
				$data['getUserStatus']=$this->AdminModel->getUserStatus();
				$data['getUserDeviceStatus']=$this->AdminModel->getUserDeviceStatus();
				$data['getUserOnlineStatus']=$this->AdminModel->getUserOnlineStatus(); 
			}else{
				
				$data['userApprovedStatus']=$this->AdminModel->getUserApprovedStatus($ParliamentId,$Constituency,$days,'Approved');

				//print_r($data['userApprovedStatus']);exit;

				$data['userPendingStatus']=$this->AdminModel->getUserApprovedStatus($ParliamentId,$Constituency,$days,'Pending');

				$data['userRejectStatus']=$this->AdminModel->getUserApprovedStatus($ParliamentId,$Constituency,$days,'Reject');

				$data['userDownloads']=$this->AdminModel->getUserDownloadStatus($ParliamentId,$Constituency,$days); 

				$data['iosAndroidDownloads']=$this->AdminModel->getIOSAndroidDownloadStatus($ParliamentId,$Constituency,$days); 

				$data['userOnlineOffline']=$this->AdminModel->getUserDownloadStatus($ParliamentId,$Constituency,$days); 


			}

			$data['parliament']=$this->request->getVar('ParliamentId',FILTER_SANITIZE_STRING);
			$data['constituency']=$this->request->getVar('Constituency',FILTER_SANITIZE_STRING);

			
	
			$where_parameter = ['ParliamentID' => $ParliamentId]; 
			$table="constituency";
			$data['constituency_list']=$this->ApiModel->getWhereQuery($table,$where_parameter); 

		 }else{
			$post_status=false;
			$data['parliament']="All";
			$data['constituency']='All'; 
			$data['days']='All';

			//User Status=
			$data['getUserStatus']=$this->AdminModel->getUserStatus();
			$data['getUserDeviceStatus']=$this->AdminModel->getUserDeviceStatus();
			$data['getUserOnlineStatus']=$this->AdminModel->getUserOnlineStatus(); 
		 }
		 
		// print_r($parliament); exit;
		 
		 return view('app_health_report',$data); 
	}

	public function ComapaignSummary(){
		$data=[
			'page_title'=>'Comapaign Summary',
			'page_name'=>'Comapaign Summary',
			'title_active'=>'ComapaignSummary',
		 ];
		 return view('comapaign_summary',$data); 
	}

	public function PollReport(){
		$data=[
			'page_title'=>'Poll Report',
			'page_name'=>'Poll Report',
			'title_active'=>'PollReport',
		 ];
		 return view('poll_report',$data);   
	}
	

	
}
