<?php

namespace App\Models;

use CodeIgniter\Model;

class ApiModel extends Model
{
    function __construct()
    {
        // Construct the parent class
        parent::__construct();
        $db = \Config\Database::connect();
    } 
    function insert_record($table,$table_data)
    {
        $builder=$this->db->table($table);
        $res=$builder->insert($table_data);
        return $this->db->insertID();
    }
   
    function get_activity($u_id){   
        
        $builder=$this->db->table('activitystatus'); 
        $builder->select('activitystatus.*,activity.ActivityName,activity.ActivityType,activity.Instructions,activity.Links,activity.ActivityStatus,activity.TargetCompletionDate,activity.Points,activity.UploadType,activity.UploadResource'); 
        $builder->join('activity', 'activity.ActivityId = activitystatus.ActivityId');  
        $builder->where('activitystatus.UserId',$u_id);
        $builder->where('activity.IsActive',1);  
        $builder->orderBy('activity.ActivityId','desc');
        return $query = $builder->get()->getResult();
    }
    //comman where query
    public function getWhereQuery($table,$where_parameter){ 
        $builder=$this->db->table($table);
        $builder->where($where_parameter);
        return $query = $builder->get()->getResultArray();
    }
    //get comm table group by
    public function getQueryFromTableAsc($table,$parameters,$where_parameter,$order_by,$order_id){  
        $builder = $this->db->table($table);
        $builder->select($parameters);
        $builder->where($where_parameter);			
        $builder->orderBy($order_by,$order_id); 
        return $query = $builder->get()->getResultArray();
       // return  $this->db->getLastQuery();
    }
    public function get_activityById($ActivityStatuId){   
        $builder=$this->db->table('activitystatus'); 
        $builder->select('activitystatus.*,activity.ActivityName,activity.ActivityType,activity.Instructions,activity.Links,activity.ActivityStatus,activity.TargetCompletionDate,activity.Points,activity.UploadType,activity.UploadResource'); 
        $builder->join('activity', 'activity.ActivityId = activitystatus.ActivityId');  
        $builder->where('activitystatus.ActivityStatuId',$ActivityStatuId);
        $builder->where('activity.IsActive',1);
        return $query = $builder->get()->getResultArray();
    }

    public function getRowTableByMobileId($table,$where_parameter,$where_id){
        $builder=$this->db->table('users');
        $builder->select('*'); 
        $builder->join('approles','approles.AppRoleId = users.AppRoleId');  
        $builder->where('users.Mobile',$where_id);  
        return $query = $builder->get()->getRowArray(); 
    }

    public function getTasksByGroupIds($SelectedGroups,$group_ids){
            $builder=$this->db->table('tasks');
            $builder->select('*,tasks.IsActive as idac'); 
           // $builder->join('approles', 'approles.AppRoleId = tasks.PromoterType'); 
            $builder->join('activitygroup', 'activitygroup.ActivityGroupId = tasks.SelectedGroups'); 
            foreach($group_ids as $value)
            {
                $builder->orwhere('find_in_set("'.$value.'", SelectedGroups) <> 0');
                $builder->where('tasks.IsActive',1);  
            }
           
			$builder->orderBy('tasks.TaskId','desc');	
            return  $query = $builder->get()->getResultArray();
           // return $this->db->getLastQuery();
    }
    //get all user sm task
    public function getTasksByGroupIdsNew($SelectedGroups,$group_ids){ 
        $builder=$this->db->table('tasks');
        $builder->select('*,tasks.IsActive as idac'); 
        // $builder->join('approles', 'approles.AppRoleId = tasks.PromoterType'); 
        // $builder->join('activitygroup', 'activitygroup.ActivityGroupId = tasks.SelectedGroups'); 
        // foreach($group_ids as $value)
        // {
        //     $builder->orwhere('find_in_set("'.$value.'", SelectedGroups) <> 0');
        //     $builder->where('tasks.IsActive',1);  
        // }
        $builder->where('tasks.IsActive',1);  
        $builder->orderBy('tasks.TaskId','desc');	
        return  $query = $builder->get()->getResultArray();
        // return $this->db->getLastQuery();
    }

    //total count tasks
    public function getCountTasksByGroupIds($SelectedGroups,$group_ids){ 
        $builder=$this->db->table('tasks');
        $builder->select('*'); 
        $builder->join('approles', 'approles.AppRoleId = tasks.PromoterType'); 
        foreach($group_ids as $value)
        {
            $builder->orwhere('find_in_set("'.$value.'", SelectedGroups) <> 0');
            $builder->where('tasks.IsActive',1);   
        }      
        $builder->orderBy('tasks.TaskId','desc');	
         // $query = $builder->get()->getResultArray();
         //return  $this->db->getLastQuery();
        return $builder->countAllResults();
    }
    
    //delete table record
    public function deleteRecord($table,$where_data){
        $builder=$this->db->table($table);
        $builder->where($where_data);
        return $builder->delete();
    }

    //get sum likes feed 
    public function getNewsFeedLikesCount($NewsFeedId){ 
        $query = $this->db->query('SELECT SUM(NewsFeedId) AS total_likes FROM newsfeedlikes WHERE NewsFeedId="'.$NewsFeedId.'"');
        return $result_data= $query->getRowArray();
    }

    //non constencey cadre listenin bu constency id
    public function getNonConstCadreListeningList($ConstituencyId){
        
        $ConstituencyId = [$ConstituencyId];
        $builder=$this->db->table('cadrelisteningdetails');
        $builder->whereNotIn('ConstituencyId', $ConstituencyId);
        return  $query = $builder->get()->getResultArray();
    }

    //get polls
    public function getPolls($UserId){     
        //$UserId=[$UserId];
        //$db = \Config\Database::connect();
            $builder=$this->db->table('poll');
            $builder->select('*');  
            $builder->join('poll_responses','poll_responses.pr_p_id = poll.p_id','left');   
            $builder->where('poll_responses.pr_u_id',$UserId); 
            $builder->where('poll.PollsStatus',"Publish");  
          //  $builder->groupBy("poll_responses.pr_p_id");  
          return  $query = $builder->get()->getResultArray(); 
     //   return $db->getLastQuery(); 
       // return $UserId;
    }
    public function sqlMode(){  
        //$this->db->query("SET GLOBAL sql_mode=(SELECT CONCAT(@@sql_mode, ',ONLY_FULL_GROUP_BY'))");
    }
    public function getPollsById($p_id){
        
       // $p_id = [$p_id];
        $builder=$this->db->table('poll'); 
        $builder->where('poll.PollsStatus',"Publish");
        $builder->whereNotIn('poll.p_id',$p_id);
        return  $query = $builder->get()->getResultArray();
    }

    public function getPollsByUsers($UserId){      
        //$UserId=[$UserId];
        //$db = \Config\Database::connect();
            $builder=$this->db->table('poll');
            $builder->select('*');  
            $builder->join('poll_responses','poll_responses.pr_p_id = poll.p_id','left');   
            $builder->orwhere('poll_responses.pr_u_id',$UserId); 
            $builder->where('poll.PollsStatus',"Publish");    
          //  $builder->groupBy("poll_responses.pr_p_id");  
          return  $query = $builder->get()->getResultArray(); 
     //   return $db->getLastQuery(); 
       // return $UserId;
    }
    //get compaign summery b user id
    public function getCompaingCountByUserId($UserId){
        $query = $this->db->query('SELECT Activity_status,COUNT(*) as total FROM activitystatus join activity on activity.ActivityId=activitystatus.ActivityId   WHERE UserId="'.$UserId.'" and activity.IsActive="1"');   
		return $result_data= $query->getResultArray(); 
    } 

    //get Polls
    public function getPollsTotal(){
        $builder=$this->db->table('poll');
        $builder->select('*'); 
        $builder->where('poll.PollsStatus','Publish');
		return $builder->countAllResults();
    }
    //getPollsResponseTotal 
    public function getPollsResponseTotal($UserId){        
        $builder=$this->db->table('poll_responses');
        $builder->select('*'); 
        $builder->where('poll_responses.pr_u_id',$UserId);  
		return $builder->countAllResults();
    }
    //get sm task shared count user
    public function getSharedSmTasks($UserId){  
        $builder=$this->db->table('ShareDetails');
        $builder->select('*'); 
        $builder->where('ShareDetails.SharedFrom','smtasks');  
        $builder->where('ShareDetails.UserId',$UserId); 
        $builder->groupBy('SharedFrom');
        $builder->groupBy('SharedFromId');
		return $builder->countAllResults();
    }
    //mobile dashbord 
    public function getSharedSmMobileDashTasks($UserId){   
        $builder=$this->db->table('ShareDetails');
        $builder->select('*'); 
        $builder->where('ShareDetails.SharedFrom','smtasks');  
        $builder->where('ShareDetails.UserId',$UserId); 
       // $builder->groupBy('SharedFrom');
      //  $builder->groupBy('SharedFromId');
        $builder->groupBy('UserId');
		return $builder->countAllResults();
    }

    public function getConstituencySharedCount($ConstituencyId){
        $builder=$this->db->table('users');
        $builder->select('*'); 
        $builder->join('ShareDetails', 'ShareDetails.UserId = users.u_id'); 
        $builder->where('users.ConstituencyId',$ConstituencyId);  
        return $builder->countAllResults(); 
    }

    public function getConstituencySharedCountByUser($u_id){
      //  $query = $this->db->query('SELECT COUNT(*) as total_shares FROM ShareDetails WHERE UserId="'.$u_id.'"  GROUP BY UserId');
		//return $result_data= $query->getResultArray(); 

        $builder=$this->db->table('ShareDetails');
        $builder->select('*'); 
        $builder->where('UserId',$u_id);  
        return $builder->countAllResults(); 
    }

    public function getConstituencyPointsCount($ConstituencyId){
        $query = $this->db->query('SELECT SUM(Points) AS total_points FROM points join users on users.u_id=points.UserId WHERE  users.ConstituencyId="'.$ConstituencyId.'"');
        return $result_data= $query->getRowArray(); 
    }

    public function getRankInsates(){
        $query=$this->db->query('SELECT
        UserId,
        Points,
        RANK () OVER ( 
        ) price_rank 
        FROM
        points');
        return $result_data= $query->getRowArray(); 
    }
    public function getRankInsate(){
        $query=$this->db->query('SELECT
        userId,points,
        RANK () OVER ( 
             ORDER BY points DESC
        ) rank_no 
     FROM
        points'); 
    
          return $result_data= $query->getResultArray(); 
    }

    //get user by costituency
    public function getUsersByConstituencyIdPoints($ConstituencyId){
        $builder=$this->db->table('users');
        $builder->select('*'); 
        $builder->join('constituency','constituency.ConstituencyID = users.ConstituencyId');  
        $builder->join('points','points.UserId = users.u_id','left');  
        $builder->where('users.ConstituencyId',$ConstituencyId);          
        $builder->orderBy('points.Points','desc');
        return $query = $builder->get()->getResultArray(); 
    }

    public function getConstituencyIdPointsShares(){
        $query = $this->db->query('SELECT ConstituencyName,COUNT(*) as totalshares,SUM(Points) as totalpoints FROM ShareDetails join users on users.u_id=ShareDetails.UserId join constituency on constituency.ConstituencyID= users.ConstituencyId  GROUP BY constituency.ConstituencyID ORDER BY totalpoints DESC');
		return $result_data= $query->getResultArray(); 
    }

    //new queries 01-03-2022
    public function getFeedsForApp1($UserId){
        $query=$this->db->query("SELECT newsfeed.*,COUNT(distinct  ShareDetails.ShareDetailId) as ShareCount,COUNT(distinct  nfl2.NewsFeedId) as isLiked,COUNT(distinct  nfl.NewsFeedLikeId) as newdFeedLikesCount,COUNT(distinct  ViewsCheck.VCId) as TotalViews,COUNT(distinct  ViewsCheck_1.VCId) as CheckView FROM newsfeed LEFT JOIN ShareDetails ON ShareDetails.SharedFromId=newsfeed.NewsFeedId AND ShareDetails.SharedFrom='feeds' LEFT JOIN newsfeedlikes as nfl ON  nfl.NewsFeedId=newsfeed.NewsFeedId LEFT JOIN newsfeedlikes as nfl2 ON  nfl2.NewsFeedId=newsfeed.NewsFeedId and nfl2.UserId='".$UserId."'  LEFT JOIN ViewsCheck ON ViewsCheck.ViewFromId=newsfeed.NewsFeedId AND ViewsCheck.ViewFrom='feeds' LEFT JOIN ViewsCheck as ViewsCheck_1 ON ViewsCheck_1.ViewFromId=newsfeed.NewsFeedId AND ViewsCheck_1.ViewFrom='feeds' and ViewsCheck_1.UserId='".$UserId."' WHERE newsfeed.IsActive='1'
        GROUP BY ShareDetails.SharedFromId order by newsfeed.NewsFeedId desc");
        return $result_data= $query->getResultArray();  
 
     }
 
     public function getFeedsById($NewsFeedId,$UserId){ 
         $query=$this->db->query("SELECT newsfeed.*,COUNT(distinct  ShareDetails.ShareDetailId) as ShareCount,COUNT(distinct  nfl2.NewsFeedId) as isLiked,COUNT(distinct  nfl.NewsFeedLikeId) as newdFeedLikesCount,COUNT(distinct  ViewsCheck.VCId) as TotalViews,COUNT(distinct  ViewsCheck_1.VCId) as CheckView FROM newsfeed LEFT JOIN ShareDetails ON ShareDetails.SharedFromId=newsfeed.NewsFeedId AND ShareDetails.SharedFrom='feeds' LEFT JOIN newsfeedlikes as nfl ON  nfl.NewsFeedId=newsfeed.NewsFeedId LEFT JOIN newsfeedlikes as nfl2 ON  nfl2.NewsFeedId=newsfeed.NewsFeedId and nfl2.UserId='".$UserId."'  LEFT JOIN ViewsCheck ON ViewsCheck.ViewFromId=newsfeed.NewsFeedId AND ViewsCheck.ViewFrom='feeds' LEFT JOIN ViewsCheck as ViewsCheck_1 ON ViewsCheck_1.ViewFromId=newsfeed.NewsFeedId AND ViewsCheck_1.ViewFrom='feeds' and ViewsCheck_1.UserId='".$UserId."' WHERE newsfeed.IsActive='1'
         and newsfeed.NewsFeedId='".$NewsFeedId."' GROUP BY ShareDetails.SharedFromId order by newsfeed.NewsFeedId desc");
         return $result_data= $query->getRowArray();  
 
     }
 
     //get galley for app
     public function getGalleryForApp($UserId){ 
         $query=$this->db->query("SELECT gallery.*,COUNT(distinct ShareDetails.ShareDetailId) as ShareCount,COUNT(distinct gallerylikes.GallerylikeId) as GalleryLikesCount,COUNT(distinct gl1.GallerylikeId) as isLiked FROM gallery  LEFT JOIN ShareDetails ON ShareDetails.SharedFromId=gallery.GalleryId AND ShareDetails.SharedFrom='gallery' LEFT JOIN gallerylikes ON gallerylikes.GalleryId=gallery.GalleryId LEFT JOIN gallerylikes as gl1 ON gl1.GalleryId=gallery.GalleryId AND gl1.UserId='".$UserId."' WHERE gallery.IsActive='1' GROUP BY gallery.GalleryId ORDER BY gallery.GalleryId DESC ");
         return $result_data= $query->getResultArray();  
     }
 
     //get sm task by id
     public function getSmTaskByIdApp($TaskId){ 
         $query=$this->db->query("SELECT tasks.*,COUNT(distinct  ShareDetails.ShareDetailId) as ShareCount,COUNT(distinct  ViewsCheck.VCId) as totalviews FROM tasks LEFT JOIN ShareDetails ON ShareDetails.SharedFromId=tasks.TaskId AND ShareDetails.SharedFrom='smtasks' LEFT JOIN ViewsCheck ON ViewsCheck.ViewFromId=tasks.TaskId AND ViewsCheck.ViewFrom='smtasks' WHERE tasks.TaskId='".$TaskId."' GROUP BY tasks.TaskId");
         return $result_data= $query->getRowArray(); 
     }


}
